/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.vdb.defn;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBArchive;
import com.metamatrix.common.vdb.api.VDBStream;
import com.metamatrix.common.vdb.api.VDBStreamImpl;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.metadata.runtime.RuntimeMetadataCatalog;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.vdb.runtime.BasicModelInfo;
import com.metamatrix.vdb.runtime.BasicVDBDefn;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;

public class VDBDefnFactory {
    private static BasicVDBDefn createDEF(VirtualDatabase vdb, byte[] archive) throws Exception {
        BasicVDBDefn vdbDefn = new BasicVDBDefn(vdb.getName());
        vdbDefn.setUUID(vdb.getGUID());
        vdbDefn.setDescription(vdb.getDescription() == null ? "" : vdb.getDescription());
        vdbDefn.setFileName(vdb.getFileName());
        vdbDefn.setVDBStream((VDBStream)new VDBStreamImpl(archive));
        vdbDefn.setCreatedBy(vdb.getVersionBy());
        vdbDefn.setDateCreated(vdb.getVersionDate());
        vdbDefn.setStatus(vdb.getStatus());
        vdbDefn.setVersion(vdb.getVirtualDatabaseID().getVersion());
        return vdbDefn;
    }

    public static VDBArchive createVDBArchive(String vdbName, String vdbVersion) throws Exception {
        VirtualDatabaseID vdbID;
        if (vdbName == null) {
            Assertion.isNotNull((Object)vdbName, (String)RuntimeMetadataPlugin.Util.getString("VDBCreation.Invalid_VDB_name"));
        }
        if ((vdbID = VDBDefnFactory.getVirtualDatabaseID(vdbName, vdbVersion)) == null) {
            String msg = RuntimeMetadataPlugin.Util.getString("VDBDefnFactory.VDB_version_not_found", new Object[]{vdbName, vdbVersion});
            throw new MetaMatrixException(msg);
        }
        VirtualDatabase vdb = VDBDefnFactory.getVirtualDatabase(vdbID);
        Collection models = VDBDefnFactory.getModels(vdbID);
        byte[] vdbContents = RuntimeMetadataCatalog.getInstance().getVDBArchive(vdbID);
        BasicVDBDefn defn = VDBDefnFactory.createDEF(vdb, vdbContents);
        VDBDefnFactory.loadRuntimeModelFiles(models, defn);
        VDBArchive baseVDB = new VDBArchive((InputStream)new ByteArrayInputStream(vdbContents));
        baseVDB.updateConfigurationDef(defn);
        return baseVDB;
    }

    private static VirtualDatabaseID getVirtualDatabaseID(String vdbName, String vdbVersion) throws Exception {
        return RuntimeMetadataCatalog.getInstance().getVirtualDatabaseID(vdbName, vdbVersion);
    }

    private static VirtualDatabase getVirtualDatabase(VirtualDatabaseID vdbID) throws Exception {
        return RuntimeMetadataCatalog.getInstance().getVirtualDatabase(vdbID);
    }

    protected static Collection getModels(VirtualDatabaseID vdbID) throws Exception {
        return RuntimeMetadataCatalog.getInstance().getModels(vdbID);
    }

    private static void loadRuntimeModelFiles(Collection models, BasicVDBDefn defn) throws Exception {
        if (models != null) {
            for (Model m : models) {
                BasicModelInfo modelDef = VDBDefnFactory.create(m);
                defn.addModelInfo((ModelInfo)modelDef);
                List bindings = m.getConnectorBindingNames();
                for (String name : bindings) {
                    ConnectorBinding cb = VDBDefnFactory.getConnectorBinding(name);
                    Assertion.isNotNull((Object)cb, (String)RuntimeMetadataPlugin.Util.getString("VDBDefnFactory.No_connector_binding_found", new Object[]{name}));
                    ComponentType type = VDBDefnFactory.getComponentType(cb.getComponentTypeID());
                    defn.addConnectorType(type);
                    defn.addConnectorBinding(modelDef.getName(), cb);
                }
            }
        }
    }

    private static BasicModelInfo create(Model model) {
        BasicModelInfo md = new BasicModelInfo(model.getName());
        md.setModelType(model.getModelType());
        md.setModelURI(model.getModelURI());
        md.setVersion(model.getVersion());
        md.setUuid(model.getGUID());
        md.setIsVisible(model.isVisible());
        md.enableMutliSourceBindings(model.isMultiSourceBindingEnabled());
        md.setVersionDate(model.getDateVersioned());
        md.setVersionedBy(model.getVersionedBy());
        md.setDescription(model.getDescription());
        return md;
    }

    private static ConnectorBinding getConnectorBinding(String routing) throws Exception {
        ConnectorBinding cb = CurrentConfiguration.getInstance().getConfiguration().getConnectorBindingByRoutingID(routing);
        if (cb == null) {
            Collection b = CurrentConfiguration.getInstance().getConfiguration().getConnectorBindings();
            for (ConnectorBinding cb2 : b) {
                if (!cb2.getRoutingUUID().equals(routing)) continue;
                return cb2;
            }
        }
        return cb;
    }

    private static ComponentType getComponentType(ComponentTypeID typeID) throws Exception {
        return CurrentConfiguration.getInstance().getConfigurationModel().getComponentType(typeID.getFullName());
    }
}

