/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.admin.api.runtime;

import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefnID;
import com.metamatrix.platform.admin.api.runtime.HostData;
import com.metamatrix.platform.admin.api.runtime.PSCData;
import com.metamatrix.platform.admin.api.runtime.ProcessData;
import com.metamatrix.platform.admin.api.runtime.ServiceData;
import com.metamatrix.platform.admin.api.runtime.SystemState;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.registry.HostControllerRegistryBinding;
import com.metamatrix.platform.registry.ProcessRegistryBinding;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.server.HostManagement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class SystemStateBuilder {
    private Collection deployedComponents;
    private Configuration config;
    ClusteredRegistryState registry;
    HostManagement hostManagement;

    public SystemStateBuilder(ClusteredRegistryState registry, HostManagement hostManagement) throws Exception {
        this.registry = registry;
        this.hostManagement = hostManagement;
        this.config = CurrentConfiguration.getInstance().getConfiguration();
        this.deployedComponents = this.config.getDeployedComponents();
        Collection vms = this.config.getVMComponentDefns();
        this.deployedComponents.addAll(vms);
    }

    public SystemState getSystemState() throws Exception {
        List<HostControllerRegistryBinding> allHosts = this.registry.getHosts();
        ArrayList<HostData> hosts = new ArrayList<HostData>();
        ArrayList<HostID> hostIDs = new ArrayList<HostID>();
        for (HostControllerRegistryBinding host : allHosts) {
            hosts.add(this.createHostData(host));
            hostIDs.add(new HostID(host.getHostName()));
        }
        Collection deployedHosts = this.config.getHostIDs();
        deployedHosts.removeAll(hostIDs);
        for (HostID hostID : deployedHosts) {
            hosts.add(this.createHostData(hostID));
        }
        return new SystemState(hosts);
    }

    private HostData createHostData(HostControllerRegistryBinding host) throws Exception {
        String hostName = host.getHostName();
        List<ProcessRegistryBinding> vmBindings = this.registry.getVMs(hostName);
        ArrayList<ProcessData> processes = new ArrayList<ProcessData>();
        ArrayList deployedVMs = null;
        try {
            deployedVMs = this.config.getVMsForHost(hostName);
        }
        catch (Exception e) {
            deployedVMs = new ArrayList();
        }
        for (ProcessRegistryBinding vmBinding : vmBindings) {
            processes.add(this.createProcessData(vmBinding));
            deployedVMs.remove(vmBinding.getDeployedComponent());
        }
        for (VMComponentDefn dCmp : deployedVMs) {
            processes.add(this.createProcessData(dCmp));
        }
        HostID hostID = new HostID(hostName);
        boolean deployed = this.config.getHostIDs().contains(hostID);
        boolean running = this.hostManagement.ping(hostName);
        return new HostData(hostName, processes, deployed, running, host.getProperties());
    }

    private HostData createHostData(HostID hostID) throws Exception {
        ArrayList deployedVMs = null;
        try {
            deployedVMs = this.config.getVMsForHost(hostID);
        }
        catch (Exception e) {
            deployedVMs = new ArrayList();
        }
        ArrayList<ProcessData> processes = new ArrayList<ProcessData>();
        for (VMComponentDefn deployedComponent : deployedVMs) {
            processes.add(this.createProcessData(deployedComponent));
        }
        boolean running = this.hostManagement.ping(hostID.getFullName());
        return new HostData(hostID.getFullName(), processes, true, running, new Properties());
    }

    private ProcessData createProcessData(ProcessRegistryBinding vmBinding) {
        if (vmBinding.getDeployedComponent() == null) {
            return new ProcessData(vmBinding.getHostName(), vmBinding.getProcessName(), String.valueOf(vmBinding.getPort()), null, new ArrayList(), false, true);
        }
        List<ServiceRegistryBinding> bindings = this.registry.getServiceBindings(vmBinding.getHostName(), vmBinding.getProcessName());
        HashMap pscMap = new HashMap();
        for (ServiceRegistryBinding svcBinding : bindings) {
            ArrayList<ServiceData> list;
            ProductServiceConfigID id = svcBinding.getPscID();
            if (id == null) {
                id = new ProductServiceConfigID("Default PSC");
            }
            if ((list = (ArrayList<ServiceData>)pscMap.get(id)) == null) {
                list = new ArrayList<ServiceData>();
                pscMap.put(id, list);
            }
            list.add(this.createServiceData(svcBinding));
        }
        ArrayList cmpList = new ArrayList(this.deployedComponents);
        for (ServiceRegistryBinding o : cmpList) {
            ArrayList<ServiceData> list;
            if (!(o instanceof DeployedComponent)) continue;
            DeployedComponent dCmp = (DeployedComponent)o;
            if (!vmBinding.getDeployedComponent().getID().equals((Object)dCmp.getVMComponentDefnID()) || dCmp.getServiceComponentDefnID() == null) continue;
            ProductServiceConfigID id = dCmp.getProductServiceConfigID();
            if (id == null) {
                id = new ProductServiceConfigID("Default PSC");
            }
            if ((list = (ArrayList<ServiceData>)pscMap.get(id)) == null) {
                list = new ArrayList<ServiceData>();
                pscMap.put(id, list);
            }
            String essentialStr = dCmp.getProperty("metamatrix.service.essentialservice");
            boolean essential = false;
            if (essentialStr != null && essentialStr.trim().length() != 0) {
                essential = Boolean.valueOf(essentialStr);
            }
            list.add(new ServiceData(null, dCmp.getComponentTypeID().getFullName(), null, (ComponentDefnID)dCmp.getServiceComponentDefnID(), dCmp, null, 5, new Date(), essential, true, false, null));
            this.deployedComponents.remove(dCmp);
        }
        ArrayList<PSCData> pscList = new ArrayList<PSCData>();
        Iterator pscIter = pscMap.keySet().iterator();
        String processName = vmBinding.getProcessName();
        while (pscIter.hasNext()) {
            ProductServiceConfigID pId = (ProductServiceConfigID)pscIter.next();
            List sList = (List)pscMap.get(pId);
            pscList.add(this.createPSCData(pId, sList, processName));
        }
        VMComponentDefn dc = vmBinding.getDeployedComponent();
        boolean deployed = this.deployedComponents.contains(dc);
        if (deployed) {
            this.deployedComponents.remove(dc);
        }
        return new ProcessData(vmBinding.getHostName(), vmBinding.getProcessName(), vmBinding.getPort(), (ComponentDefnID)((VMComponentDefnID)vmBinding.getDeployedComponent().getID()), pscList, deployed, true);
    }

    private ProcessData createProcessData(VMComponentDefn deployedVM) {
        ArrayList deployedServices = null;
        try {
            deployedServices = this.config.getDeployedServicesForVM(deployedVM);
        }
        catch (Exception e) {
            deployedServices = new ArrayList();
        }
        HashMap pscMap = new HashMap();
        for (DeployedComponent dCmp : deployedServices) {
            ArrayList<ServiceData> list;
            ProductServiceConfigID id = dCmp.getProductServiceConfigID();
            if (id == null) {
                id = new ProductServiceConfigID("Default PSC");
            }
            if ((list = (ArrayList<ServiceData>)pscMap.get(id)) == null) {
                list = new ArrayList<ServiceData>();
                pscMap.put(id, list);
            }
            String essentialStr = dCmp.getProperty("metamatrix.service.essentialservice");
            boolean essential = false;
            if (essentialStr != null && essentialStr.trim().length() != 0) {
                essential = Boolean.valueOf(essentialStr);
            }
            list.add(new ServiceData(null, dCmp.getComponentTypeID().getName(), null, (ComponentDefnID)dCmp.getServiceComponentDefnID(), dCmp, null, 5, new Date(), essential, true, false, null));
        }
        ArrayList<PSCData> pscList = new ArrayList<PSCData>();
        Iterator pscIter = pscMap.keySet().iterator();
        String processName = deployedVM.getName();
        while (pscIter.hasNext()) {
            ProductServiceConfigID pId = (ProductServiceConfigID)pscIter.next();
            List sList = (List)pscMap.get(pId);
            pscList.add(this.createPSCData(pId, sList, processName));
        }
        this.deployedComponents.remove(deployedVM);
        String hostName = deployedVM.getHostID().getName();
        return new ProcessData(hostName, deployedVM.getName(), deployedVM.getPort(), (ComponentDefnID)((VMComponentDefnID)deployedVM.getID()), pscList, true, false);
    }

    private PSCData createPSCData(ProductServiceConfigID pscID, List services, String processName) {
        return new PSCData(pscID, (Collection)services, processName);
    }

    private ServiceData createServiceData(ServiceRegistryBinding serviceBinding) {
        ServiceID id = serviceBinding.getServiceID();
        String serviceName = serviceBinding.getServiceType();
        String instanceName = serviceBinding.getInstanceName();
        ServiceComponentDefnID defnID = serviceBinding.getDeployedComponent().getServiceComponentDefnID();
        DeployedComponent deployedComponent = serviceBinding.getDeployedComponent();
        int state = serviceBinding.getCurrentState();
        Date stateDate = serviceBinding.getStateChangeTime();
        boolean essential = serviceBinding.isEssential();
        Collection queues = serviceBinding.getQueueNames();
        boolean deployed = this.deployedComponents.contains(deployedComponent);
        if (deployed) {
            this.deployedComponents.remove(deployedComponent);
        }
        return new ServiceData(id, serviceName, instanceName, (ComponentDefnID)defnID, deployedComponent, queues, state, stateDate, essential, deployed, true, serviceBinding.getInitException());
    }
}

