/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.admin.apiimpl;

import com.metamatrix.admin.AdminPlugin;
import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.platform.admin.apiimpl.AdminHelper;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;

public class AdminAPIHelper {
    private static AdminHelper adminHelper;

    private static synchronized AdminHelper getAdminHelper() {
        if (adminHelper == null) {
            AdminAPIHelper.initialize();
        }
        return adminHelper;
    }

    private static synchronized void initialize() {
        adminHelper = new AdminHelper();
    }

    public static void checkForRequiredRole(SessionToken adminToken, String roleName, String methodSignature) throws AuthorizationException, ComponentNotFoundException {
        Object[] msgParts = null;
        boolean msgWillBeRecorded = LogManager.isMessageToBeRecorded((String)"AUDIT_ADMIN", (int)4);
        if (msgWillBeRecorded) {
            if (methodSignature != null) {
                methodSignature = methodSignature.split("\\(")[0];
            }
            msgParts = new Object[]{adminToken.getUsername(), adminToken.getSessionID().toString(), roleName, methodSignature};
            LogManager.logInfo((String)"AUDIT_ADMIN", (String)AdminPlugin.Util.getString("Admin_Audit_request", msgParts));
        }
        AdminAPIHelper.getAdminHelper().checkForRequiredRole(adminToken, roleName);
        if (msgWillBeRecorded) {
            LogManager.logInfo((String)"AUDIT_ADMIN", (String)AdminPlugin.Util.getString("Admin_Audit_granted", msgParts));
        }
    }

    public static SessionToken validateSession(MetaMatrixSessionID sessionID) throws InvalidSessionException, ComponentNotFoundException {
        return AdminAPIHelper.getAdminHelper().validateSession(sessionID);
    }
}

