/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.admin.apiimpl;

import com.metamatrix.admin.AdminPlugin;
import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.admin.api.exception.security.MetaMatrixSecurityException;
import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.SessionServiceException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.platform.admin.apiimpl.IAdminHelper;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.service.AuthorizationServiceInterface;
import com.metamatrix.platform.security.api.service.SessionServiceInterface;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.util.PlatformProxyHelper;

public class AdminHelper
implements IAdminHelper {
    private static final String SESSION_SERVICE_DOWN_MSG = AdminPlugin.Util.getString("ERR.014.001.0010");
    private AuthorizationServiceInterface authAdmin = PlatformProxyHelper.getAuthorizationServiceProxy("ROUND_ROBIN_LOCAL");
    private SessionServiceInterface sessionAdmin = PlatformProxyHelper.getSessionServiceProxy("ROUND_ROBIN_LOCAL");

    @Override
    public void checkForRequiredRole(SessionToken adminToken, String roleName) throws AuthorizationException, ComponentNotFoundException {
        if (LogManager.isMessageToBeRecorded((String)"ADMIN_API", (int)6)) {
            LogManager.logTrace((String)"ADMIN_API", (Object[])new Object[]{"Checking owner of session token " + adminToken + " for membership in role: " + roleName});
        }
        boolean isAuthorized = false;
        try {
            isAuthorized = this.authAdmin.isCallerInRole(adminToken, roleName);
        }
        catch (MetaMatrixSecurityException e) {
            String msg = AdminPlugin.Util.getString("ERR.014.001.0009", new Object[]{adminToken});
            throw new ComponentNotFoundException((Throwable)e, "ERR.014.001.0009", msg);
        }
        catch (ServiceException e) {
            String msg = AdminPlugin.Util.getString("ERR.014.001.0009", new Object[]{adminToken});
            throw new ComponentNotFoundException((Throwable)((Object)e), "ERR.014.001.0009", msg);
        }
        catch (Exception e) {
            String msg = AdminPlugin.Util.getString("ERR.014.001.0009", new Object[]{adminToken});
            throw new ComponentNotFoundException((Throwable)e, "ERR.014.001.0009", msg);
        }
        if (!isAuthorized) {
            String msg = AdminPlugin.Util.getString("ERR.014.001.0008", new Object[]{adminToken, roleName.toString()});
            throw new AuthorizationException("ERR.014.001.0008", msg);
        }
        if (LogManager.isMessageToBeRecorded((String)"ADMIN_API", (int)6)) {
            LogManager.logTrace((String)"ADMIN_API", (Object[])new Object[]{"Verified owner of session token " + adminToken + " is in role: " + roleName});
        }
    }

    @Override
    public SessionToken validateSession(MetaMatrixSessionID sessionID) throws InvalidSessionException, ComponentNotFoundException {
        if (LogManager.isMessageToBeRecorded((String)"ADMIN_API", (int)6)) {
            LogManager.logTrace((String)"ADMIN_API", (Object[])new Object[]{"Validating user session with session ID \"" + sessionID + "\""});
        }
        SessionToken token = null;
        try {
            token = this.sessionAdmin.validateSession(sessionID).getSessionToken();
        }
        catch (InvalidSessionException e) {
            throw e;
        }
        catch (SessionServiceException e) {
            throw new ComponentNotFoundException((Throwable)e, "ERR.014.001.0010", SESSION_SERVICE_DOWN_MSG);
        }
        catch (ServiceException e) {
            String msg = AdminPlugin.Util.getString("ERR.014.001.0013");
            throw new ComponentNotFoundException((Throwable)((Object)e), msg);
        }
        if (LogManager.isMessageToBeRecorded((String)"ADMIN_API", (int)6)) {
            LogManager.logTrace((String)"ADMIN_API", (Object[])new Object[]{"Validated user session with session ID \"" + sessionID + "\""});
        }
        return token;
    }
}

