/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.admin.apiimpl;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.AuthorizationMgmtException;
import com.metamatrix.api.exception.security.MembershipServiceException;
import com.metamatrix.common.actions.ModificationActionQueue;
import com.metamatrix.platform.admin.api.AuthorizationAdminAPI;
import com.metamatrix.platform.admin.api.AuthorizationEditor;
import com.metamatrix.platform.admin.apiimpl.AdminAPIHelper;
import com.metamatrix.platform.admin.apiimpl.SubSystemAdminAPIImpl;
import com.metamatrix.platform.security.api.AuthorizationObjectEditor;
import com.metamatrix.platform.security.api.AuthorizationPolicy;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.service.AuthorizationServiceInterface;
import com.metamatrix.platform.security.api.service.MembershipServiceInterface;
import com.metamatrix.platform.security.util.RolePermissionFactory;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.util.PlatformProxyHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AuthorizationAdminAPIImpl
extends SubSystemAdminAPIImpl
implements AuthorizationAdminAPI {
    AuthorizationRealm roleRealm = RolePermissionFactory.getRealm();
    private AuthorizationServiceInterface authAdmin = PlatformProxyHelper.getAuthorizationServiceProxy("ROUND_ROBIN_LOCAL");
    private static AuthorizationAdminAPI authAdminAPI;

    private AuthorizationAdminAPIImpl() {
    }

    public static synchronized AuthorizationAdminAPI getInstance() {
        if (authAdminAPI == null) {
            authAdminAPI = new AuthorizationAdminAPIImpl();
        }
        return authAdminAPI;
    }

    public synchronized AuthorizationEditor createEditor() throws InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "AuthorizationAdminAPIImpl.createEditor()");
        return new AuthorizationObjectEditor(true);
    }

    public synchronized Collection getRealmNames() throws InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        return this.authAdmin.getRealmNames(token);
    }

    public synchronized Map getRoleDescriptions() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        return this.authAdmin.getRoleDescriptions(token);
    }

    public synchronized Collection getPrincipalsForRole(String roleName) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        return this.authAdmin.getPrincipalsForRole(token, roleName);
    }

    public synchronized Collection getRoleNamesForPrincipal(MetaMatrixPrincipalName principal) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        return this.authAdmin.getRoleNamesForPrincipal(token, principal);
    }

    public synchronized void addPrincipalsToRole(Set principals, String roleName) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "AuthorizationAdminAPIImpl.addPrincipalsToRole(" + principals + ", " + roleName + ")");
        AuthorizationPolicy role = this.authAdmin.getPolicy(token, new AuthorizationPolicyID(roleName, null, RolePermissionFactory.getRealm()));
        AuthorizationObjectEditor editor = new AuthorizationObjectEditor();
        role = editor.addAllPrincipals(role, principals);
        ModificationActionQueue queue = editor.getDestination();
        this.authAdmin.executeTransaction(token, queue.popActions());
    }

    public synchronized void addPrincipalToRoles(MetaMatrixPrincipalName principal, Collection roleNames) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "AuthorizationAdminAPIImpl.addPrincipalToRoles(" + principal + ", " + roleNames + ")");
        AuthorizationObjectEditor editor = new AuthorizationObjectEditor();
        for (String roleName : roleNames) {
            AuthorizationPolicy role = this.authAdmin.getPolicy(token, new AuthorizationPolicyID(roleName, null, RolePermissionFactory.getRealm()));
            role = editor.addPrincipal(role, principal);
        }
        ModificationActionQueue queue = editor.getDestination();
        this.authAdmin.executeTransaction(token, queue.popActions());
    }

    public synchronized void removePrincipalsFromRole(Set principals, String roleName) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "AuthorizationAdminAPIImpl.removePrincipalsFromRole(" + principals + ", " + roleName + ")");
        AuthorizationPolicy role = this.authAdmin.getPolicy(token, new AuthorizationPolicyID(roleName, null, RolePermissionFactory.getRealm()));
        AuthorizationObjectEditor editor = new AuthorizationObjectEditor();
        role = editor.removePrincipals(role, principals);
        ModificationActionQueue queue = editor.getDestination();
        this.authAdmin.executeTransaction(token, queue.popActions());
    }

    public synchronized void removePolicy(AuthorizationPolicyID policyID) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "AuthorizationAdminAPIImpl.removePolicy(" + policyID + ")");
        AuthorizationObjectEditor aoe = new AuthorizationObjectEditor(true);
        aoe.remove(policyID);
        ModificationActionQueue queue = aoe.getDestination();
        this.authAdmin.executeTransaction(token, queue.popActions());
    }

    public synchronized Collection findAllPolicyIDs() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        Collection allPolicyIDs = this.authAdmin.findAllPolicyIDs(token);
        HashSet<AuthorizationPolicyID> filteredPolicyIDs = new HashSet<AuthorizationPolicyID>();
        for (AuthorizationPolicyID aPolicyID : allPolicyIDs) {
            AuthorizationRealm theRealm = aPolicyID.getRealm();
            if (theRealm.equals((Object)this.roleRealm)) continue;
            filteredPolicyIDs.add(aPolicyID);
        }
        return filteredPolicyIDs;
    }

    public synchronized Collection findPolicyIDs(Collection principals) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        return this.authAdmin.findPolicyIDs(token, principals);
    }

    public synchronized Collection getPolicies(Collection policyIDs) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        return this.authAdmin.getPolicies(token, policyIDs);
    }

    public synchronized Boolean containsPolicy(AuthorizationPolicyID policyID) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        return new Boolean(this.authAdmin.containsPolicy(token, policyID));
    }

    public synchronized AuthorizationPolicy getPolicy(AuthorizationPolicyID policyID) throws AuthorizationException, AuthorizationMgmtException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        return this.authAdmin.getPolicy(token, policyID);
    }

    public synchronized Set executeTransaction(List actions) throws AuthorizationException, AuthorizationMgmtException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "AuthorizationAdminAPIImpl.executeTransaction(" + actions + ")");
        return this.authAdmin.executeTransaction(token, actions);
    }

    public synchronized Boolean removePrincipalFromAllPolicies(MetaMatrixPrincipalName principal) throws AuthorizationException, AuthorizationMgmtException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "AuthorizationAdminAPIImpl.removePrincipalFromAllPolicies(" + principal + ")");
        return new Boolean(this.authAdmin.removePrincipalFromAllPolicies(token, principal));
    }

    public synchronized Collection getPolicyIDsWithPermissionsInRealm(AuthorizationRealm realm) throws AuthorizationException, AuthorizationMgmtException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        return this.authAdmin.getPolicyIDsWithPermissionsInRealm(token, realm);
    }

    public synchronized Collection getPolicyIDsInRealm(AuthorizationRealm realm) throws AuthorizationException, AuthorizationMgmtException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        return this.authAdmin.getPolicyIDsInRealm(token, realm);
    }

    public synchronized Collection getPolicyIDsInPartialRealm(AuthorizationRealm realm) throws AuthorizationException, AuthorizationMgmtException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        return this.authAdmin.getPolicyIDsInPartialRealm(token, realm);
    }

    public synchronized Collection getPolicyIDsForResourceInRealm(AuthorizationRealm realm, String resourceName) throws AuthorizationException, AuthorizationMgmtException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        return this.authAdmin.getPolicIDsForResourceInRealm(token, realm, resourceName);
    }

    public synchronized boolean isCallerInRole(SessionToken caller, String roleName) throws AuthorizationException, AuthorizationMgmtException, InvalidSessionException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(caller.getSessionID());
        return this.authAdmin.isCallerInRole(caller, roleName);
    }

    public boolean isSuperUser(String username) throws ServiceException, MembershipServiceException, MetaMatrixComponentException {
        MembershipServiceInterface membershipService = PlatformProxyHelper.getMembershipServiceProxy("ROUND_ROBIN_LOCAL");
        return membershipService.isSuperUser(username);
    }

    public synchronized List getGroupEntitlements(AuthorizationRealm realm, String fullyQualifiedGroupName) throws AuthorizationException, AuthorizationMgmtException, InvalidSessionException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.authAdmin.getGroupEntitlements(realm, fullyQualifiedGroupName);
    }

    public synchronized List getElementEntitlements(AuthorizationRealm realm, String elementNamePattern) throws AuthorizationException, AuthorizationMgmtException, InvalidSessionException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.authAdmin.getElementEntitlements(realm, elementNamePattern);
    }
}

