/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.admin.apiimpl;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.ComponentCommunicationException;
import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.actions.ActionDefinition;
import com.metamatrix.common.actions.ModificationException;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.api.exceptions.ConfigurationLockException;
import com.metamatrix.common.config.api.exceptions.InvalidConfigurationException;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.admin.api.ConfigurationAdminAPI;
import com.metamatrix.platform.admin.apiimpl.AdminAPIHelper;
import com.metamatrix.platform.admin.apiimpl.SubSystemAdminAPIImpl;
import com.metamatrix.platform.config.api.service.ConfigurationServiceInterface;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.util.PlatformProxyHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ConfigurationAdminAPIImpl
extends SubSystemAdminAPIImpl
implements ConfigurationAdminAPI {
    private ConfigurationServiceInterface configAdmin = PlatformProxyHelper.getConfigurationServiceProxy("ROUND_ROBIN_LOCAL");
    private static ConfigurationAdminAPI configAdminAPI;

    private ConfigurationAdminAPIImpl(ClusteredRegistryState registry) throws MetaMatrixComponentException {
    }

    public static synchronized ConfigurationAdminAPI getInstance(ClusteredRegistryState registry) throws MetaMatrixComponentException {
        if (configAdminAPI == null) {
            configAdminAPI = new ConfigurationAdminAPIImpl(registry);
        }
        return configAdminAPI;
    }

    public synchronized ConfigurationObjectEditor createEditor() throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.createEditor();
    }

    public synchronized ConfigurationID getCurrentConfigurationID() throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.getCurrentConfigurationID();
    }

    public synchronized ConfigurationID getNextStartupConfigurationID() throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.getNextStartupConfigurationID();
    }

    public synchronized ConfigurationID getStartupConfigurationID() throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.getStartupConfigurationID();
    }

    public synchronized Configuration getCurrentConfiguration() throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.getCurrentConfiguration();
    }

    public synchronized Configuration getNextStartupConfiguration() throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.getNextStartupConfiguration();
    }

    public synchronized Configuration getStartupConfiguration() throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.getStartupConfiguration();
    }

    public synchronized Configuration getConfiguration(String configName) throws InvalidConfigurationException, ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.getConfiguration(configName);
    }

    public synchronized ConfigurationModelContainer getConfigurationModel(String configName) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.getConfigurationModel(configName);
    }

    public synchronized Collection getConfigurationAndDependents(ConfigurationID configID) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.getConfigurationAndDependents(configID);
    }

    public synchronized Collection getAllGlobalConfigObjects() throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.getAllGlobalConfigObjects();
    }

    public synchronized void baselineCurrentConfiguration() throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "ConfigurationAdminAPIImpl.baselineCurrentConfiguration()");
        this.configAdmin.baselineCurrentConfiguration(token.getUsername());
    }

    public synchronized Map getComponentTypeDefinitions(Collection componentIDs) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.getComponentTypeDefinitions(componentIDs);
    }

    public synchronized Collection getComponentTypeDefinitions(ComponentTypeID componentTypeID) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.getComponentTypeDefinitions(componentTypeID);
    }

    public synchronized Collection getAllComponentTypeDefinitions(ComponentTypeID componentTypeID) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.getAllComponentTypeDefinitions(componentTypeID);
    }

    public synchronized Collection getMonitoredComponentTypes(boolean includeDeprecated) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.getMonitoredComponentTypes(includeDeprecated);
    }

    public synchronized ComponentType getComponentType(ComponentTypeID id) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.getComponentType(id);
    }

    public synchronized Collection getAllComponentTypes(boolean includeDeprecated) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.getAllComponentTypes(includeDeprecated);
    }

    public Collection getAllProductTypes(boolean includeDeprecated) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        Iterator allTypes = this.getAllComponentTypes(includeDeprecated).iterator();
        ArrayList<Object> productTypes = new ArrayList<Object>();
        Object aType = null;
        while (allTypes.hasNext()) {
            aType = allTypes.next();
            if (!(aType instanceof ProductType)) continue;
            productTypes.add(aType);
        }
        return productTypes;
    }

    public synchronized Host getHost(HostID hostID) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.getHost(hostID);
    }

    public synchronized Collection getHosts() throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.getHosts();
    }

    public synchronized Collection getComponentDefns(Collection componentDefnIDs, ConfigurationID configurationID) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.getComponentDefns(componentDefnIDs, configurationID);
    }

    public synchronized ComponentDefn getComponentDefn(ConfigurationID configurationID, ComponentDefnID componentDefnID) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.getComponentDefn(configurationID, componentDefnID);
    }

    public synchronized Collection getResources() throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.getResources();
    }

    public synchronized Collection getResources(ComponentTypeID componentTypeID) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.configAdmin.getResources(componentTypeID);
    }

    public synchronized void saveResources(Collection resourceDescriptors) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        this.configAdmin.saveResources(resourceDescriptors, token.getUsername());
    }

    public synchronized Set executeTransaction(ActionDefinition action) throws ModificationException, ConfigurationLockException, ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "ConfigurationAdminAPIImpl.executeTransaction(" + action + ")");
        return this.configAdmin.executeTransaction(action, token.getUsername());
    }

    public synchronized Set executeTransaction(List actions) throws ModificationException, ConfigurationLockException, ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "ConfigurationAdminAPIImpl.executeTransaction(" + actions + ")");
        return this.configAdmin.executeTransaction(actions, token.getUsername());
    }

    public synchronized Set executeInsertTransaction(ConfigurationID assignConfigurationID, List actions) throws ModificationException, ConfigurationLockException, ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "ConfigurationAdminAPIImpl.executeInsertTransaction(" + assignConfigurationID + ", " + actions + ")");
        return this.configAdmin.executeInsertTransaction(assignConfigurationID, actions, token.getUsername());
    }

    public synchronized Set undoActionsAsTransaction(int numberOfActions) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "ConfigurationAdminAPIImpl.undoActionsAsTransaction(" + numberOfActions + ")");
        return this.configAdmin.undoActionsAsTransaction(numberOfActions, token.getUsername());
    }

    public synchronized List getHistory() throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "ConfigurationAdminAPIImpl.getHistory()");
        return this.configAdmin.getHistory();
    }

    public synchronized void clearHistory() throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "ConfigurationAdminAPIImpl.clearHistory()");
        this.configAdmin.clearHistory();
    }

    public synchronized int getHistorySize() throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "ConfigurationAdminAPIImpl.getHistorySize()");
        return this.configAdmin.getHistorySize();
    }

    public synchronized int getHistoryLimit() throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "ConfigurationAdminAPIImpl.getHistoryLimit()");
        return this.configAdmin.getHistoryLimit();
    }

    public synchronized void setHistoryLimit(int maximumHistoryCount) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "ConfigurationAdminAPIImpl.setHistoryLimit(" + maximumHistoryCount + ")");
        this.configAdmin.setHistoryLimit(maximumHistoryCount);
    }

    public synchronized Host addHost(String hostName, Properties properties) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "ConfigurationAdminAPIImpl.addHost(" + hostName + ", " + properties + ")");
        return this.configAdmin.addHost(hostName, token.getUsername(), properties);
    }

    public synchronized List checkPropertiesDecryptable(List defns) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "ConfigurationAdminAPIImpl.checkPropertiesDecryptable(" + defns + ")");
        return this.configAdmin.checkPropertiesDecryptable(defns);
    }

    public Collection getProducts() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        Collection result = null;
        try {
            result = this.configAdmin.getProductReleaseInfos();
        }
        catch (ServiceException e) {
            throw new ComponentNotFoundException((Throwable)((Object)e), PlatformPlugin.Util.getString("ConfigurationAdminAPIImpl.Problem_getting_Product_Release_Infos", new Object[]{e.getMessage()}));
        }
        catch (ConfigurationException e) {
            throw new ComponentCommunicationException((Throwable)e, PlatformPlugin.Util.getString("ConfigurationAdminAPIImpl.Problem_getting_Product_Release_Infos", new Object[]{e.getMessage()}));
        }
        return result;
    }
}

