/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.admin.apiimpl;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.common.extensionmodule.ExtensionModuleManager;
import com.metamatrix.common.extensionmodule.exception.DuplicateExtensionModuleException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleOrderingException;
import com.metamatrix.common.extensionmodule.exception.InvalidExtensionModuleTypeException;
import com.metamatrix.platform.admin.api.ExtensionSourceAdminAPI;
import com.metamatrix.platform.admin.apiimpl.AdminAPIHelper;
import com.metamatrix.platform.admin.apiimpl.SubSystemAdminAPIImpl;
import com.metamatrix.platform.security.api.SessionToken;
import java.util.Collection;
import java.util.List;

public class ExtensionSourceAdminAPIImpl
extends SubSystemAdminAPIImpl
implements ExtensionSourceAdminAPI {
    private ExtensionModuleManager extensionSourceManager;
    private static ExtensionSourceAdminAPI extensionSourceAdminAPI;

    private ExtensionSourceAdminAPIImpl() throws MetaMatrixComponentException {
    }

    public static synchronized ExtensionSourceAdminAPI getInstance() throws MetaMatrixComponentException {
        if (extensionSourceAdminAPI == null) {
            extensionSourceAdminAPI = new ExtensionSourceAdminAPIImpl();
        }
        return extensionSourceAdminAPI;
    }

    private ExtensionModuleManager getExtensionSourceManager() {
        if (this.extensionSourceManager == null) {
            this.extensionSourceManager = ExtensionModuleManager.getInstance();
        }
        return this.extensionSourceManager;
    }

    public synchronized ExtensionModuleDescriptor addSource(String type, String sourceName, byte[] source, String description, boolean enabled) throws InvalidSessionException, AuthorizationException, DuplicateExtensionModuleException, InvalidExtensionModuleTypeException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "ExtensionSourceAdminAPIImpl.addSource(" + type + ", " + sourceName + ", " + source + ", " + description + ", " + enabled + ")");
        return this.getExtensionSourceManager().addSource(token.getUsername(), type, sourceName, source, description, enabled);
    }

    public synchronized void removeSource(String sourceName) throws InvalidSessionException, AuthorizationException, ExtensionModuleNotFoundException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "ExtensionSourceAdminAPIImpl.removeSource(" + sourceName + ")");
        this.getExtensionSourceManager().removeSource(token.getUsername(), sourceName);
    }

    public synchronized Collection getSourceTypes() throws InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.getExtensionSourceManager().getSourceTypes();
    }

    public synchronized List getSourceNames() throws InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.getExtensionSourceManager().getSourceNames();
    }

    public synchronized List getSourceDescriptors() throws InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.getExtensionSourceManager().getSourceDescriptors();
    }

    public synchronized List getSourceDescriptors(String type) throws InvalidSessionException, AuthorizationException, InvalidExtensionModuleTypeException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.getExtensionSourceManager().getSourceDescriptors(type);
    }

    public synchronized ExtensionModuleDescriptor getSourceDescriptor(String sourceName) throws InvalidSessionException, AuthorizationException, ExtensionModuleNotFoundException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.getExtensionSourceManager().getSourceDescriptor(sourceName);
    }

    public synchronized List setSearchOrder(List sourceNames) throws InvalidSessionException, AuthorizationException, ExtensionModuleOrderingException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "ExtensionSourceAdminAPIImpl.setSearchOrder(" + sourceNames + ")");
        return this.getExtensionSourceManager().setSearchOrder(token.getUsername(), sourceNames);
    }

    public synchronized List setEnabled(Collection sourceNames, boolean enabled) throws InvalidSessionException, AuthorizationException, ExtensionModuleNotFoundException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "ExtensionSourceAdminAPIImpl.setEnabled(" + sourceNames + ", " + enabled + ")");
        return this.getExtensionSourceManager().setEnabled(token.getUsername(), sourceNames, enabled);
    }

    public synchronized byte[] getSource(String sourceName) throws InvalidSessionException, AuthorizationException, ExtensionModuleNotFoundException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.getExtensionSourceManager().getSource(sourceName);
    }

    public synchronized ExtensionModuleDescriptor setSource(String sourceName, byte[] source) throws InvalidSessionException, AuthorizationException, ExtensionModuleNotFoundException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "ExtensionSourceAdminAPIImpl.setSource(" + sourceName + ", " + source + ")");
        return this.getExtensionSourceManager().setSource(token.getUsername(), sourceName, source);
    }

    public synchronized ExtensionModuleDescriptor setSourceName(String sourceName, String newName) throws InvalidSessionException, AuthorizationException, ExtensionModuleNotFoundException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "ExtensionSourceAdminAPIImpl.setSourceName(" + sourceName + ", " + newName + ")");
        return this.getExtensionSourceManager().setSourceName(token.getUsername(), sourceName, newName);
    }

    public synchronized ExtensionModuleDescriptor setSourceDescription(String sourceName, String description) throws InvalidSessionException, AuthorizationException, ExtensionModuleNotFoundException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "ExtensionSourceAdminAPIImpl.setSourceDescription(" + sourceName + ", " + description + ")");
        return this.getExtensionSourceManager().setSourceDescription(token.getUsername(), sourceName, description);
    }

    public boolean isSourceExists(String sourceName) throws InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        try {
            this.getSourceDescriptor(sourceName);
            return true;
        }
        catch (ExtensionModuleNotFoundException extensionModuleNotFoundException) {
            return false;
        }
    }
}

