/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.admin.apiimpl;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.admin.api.exception.security.MetaMatrixSecurityException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.InvalidUserException;
import com.metamatrix.api.exception.security.MembershipServiceException;
import com.metamatrix.common.util.MultipleRequestConfirmation;
import com.metamatrix.platform.admin.api.MembershipAdminAPI;
import com.metamatrix.platform.admin.apiimpl.AdminAPIHelper;
import com.metamatrix.platform.admin.apiimpl.SubSystemAdminAPIImpl;
import com.metamatrix.platform.security.api.Credentials;
import com.metamatrix.platform.security.api.MetaMatrixPrincipal;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.api.service.MembershipServiceInterface;
import com.metamatrix.platform.util.PlatformProxyHelper;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MembershipAdminAPIImpl
extends SubSystemAdminAPIImpl
implements MembershipAdminAPI {
    private MembershipServiceInterface membAdmin = PlatformProxyHelper.getMembershipServiceProxy("ROUND_ROBIN_LOCAL");
    private static MembershipAdminAPI membershipAdminAPI;

    private MembershipAdminAPIImpl() throws MetaMatrixComponentException {
    }

    public static synchronized MembershipAdminAPI getInstance() throws MetaMatrixComponentException {
        if (membershipAdminAPI == null) {
            membershipAdminAPI = new MembershipAdminAPIImpl();
        }
        return membershipAdminAPI;
    }

    public synchronized List getDomainNames() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, MetaMatrixSecurityException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.membAdmin.getDomainNames();
    }

    public synchronized Set getGroupsForDomain(String domainName) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, MetaMatrixSecurityException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.membAdmin.getGroupsForDomain(domainName);
    }

    public boolean authenticateUser(String username, Credentials credential, Serializable trustePayload, String applicationName) throws MetaMatrixComponentException, MembershipServiceException {
        return this.membAdmin.authenticateUser(username, credential, trustePayload, applicationName).isAuthenticated();
    }

    public synchronized MetaMatrixPrincipal getUserPrincipal(String principalName) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, MetaMatrixSecurityException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.membAdmin.getPrincipal(new MetaMatrixPrincipalName(principalName, 0));
    }

    public synchronized MultipleRequestConfirmation getUserPrincipals(Collection userNames) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, MetaMatrixSecurityException {
        AdminAPIHelper.validateSession(this.getSessionID());
        MultipleRequestConfirmation result = new MultipleRequestConfirmation();
        HashSet<MetaMatrixPrincipal> principals = new HashSet<MetaMatrixPrincipal>(userNames.size());
        Iterator iter = userNames.iterator();
        String userName = null;
        MetaMatrixPrincipal principal = null;
        while (iter.hasNext()) {
            userName = (String)iter.next();
            try {
                principal = this.membAdmin.getPrincipal(new MetaMatrixPrincipalName(userName, 0));
                principals.add(principal);
            }
            catch (InvalidUserException e) {
                result.addFailure((Object)userName, (Throwable)e);
            }
            catch (MetaMatrixSecurityException e) {
                result.addFailure((Object)userName, (Throwable)e);
            }
        }
        result.setResult(principals);
        return result;
    }

    public synchronized MultipleRequestConfirmation getGroupPrincipals(Collection groupNames) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, MetaMatrixSecurityException {
        AdminAPIHelper.validateSession(this.getSessionID());
        MultipleRequestConfirmation result = new MultipleRequestConfirmation();
        HashSet<MetaMatrixPrincipal> principals = new HashSet<MetaMatrixPrincipal>(groupNames.size());
        Iterator iter = groupNames.iterator();
        String groupName = null;
        MetaMatrixPrincipal principal = null;
        while (iter.hasNext()) {
            groupName = (String)iter.next();
            try {
                principal = this.membAdmin.getPrincipal(new MetaMatrixPrincipalName(groupName, 1));
                principals.add(principal);
            }
            catch (InvalidUserException e) {
                result.addFailure((Object)groupName, (Throwable)e);
            }
            catch (MetaMatrixSecurityException e) {
                result.addFailure((Object)groupName, (Throwable)e);
            }
        }
        result.setResult(principals);
        return result;
    }

    public synchronized Collection getGroupPrincipalNames() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, MetaMatrixSecurityException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.membAdmin.getGroupNames();
    }
}

