/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.admin.apiimpl;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MultipleException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.actions.ModificationException;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.api.exceptions.ConfigurationLockException;
import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.util.MetaMatrixExceptionUtil;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.admin.api.runtime.HostData;
import com.metamatrix.platform.admin.api.runtime.PSCData;
import com.metamatrix.platform.admin.api.runtime.ProcessData;
import com.metamatrix.platform.admin.api.runtime.ServiceData;
import com.metamatrix.platform.admin.api.runtime.SystemState;
import com.metamatrix.platform.admin.api.runtime.SystemStateBuilder;
import com.metamatrix.platform.config.api.service.ConfigurationServiceInterface;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.registry.HostControllerRegistryBinding;
import com.metamatrix.platform.registry.ProcessRegistryBinding;
import com.metamatrix.platform.registry.ResourceNotBoundException;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.service.api.ServiceInterface;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.util.PlatformProxyHelper;
import com.metamatrix.platform.vm.api.controller.ProcessManagement;
import com.metamatrix.platform.vm.controller.ProcessStatistics;
import com.metamatrix.server.HostManagement;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class RuntimeStateAdminAPIHelper {
    private static RuntimeStateAdminAPIHelper instance;
    private ClusteredRegistryState registry;
    HostManagement hostManagement;

    protected RuntimeStateAdminAPIHelper(ClusteredRegistryState registry, HostManagement hostManagement) {
        this.registry = registry;
        this.hostManagement = hostManagement;
    }

    public static synchronized RuntimeStateAdminAPIHelper getInstance(ClusteredRegistryState registry, HostManagement hostManagement) {
        if (instance == null) {
            instance = new RuntimeStateAdminAPIHelper(registry, hostManagement);
        }
        return instance;
    }

    public synchronized SystemState getSystemState() throws MetaMatrixComponentException {
        try {
            SystemStateBuilder ssm = new SystemStateBuilder(this.registry, this.hostManagement);
            return ssm.getSystemState();
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e, "ERR.014.001.0051", PlatformPlugin.Util.getString("ERR.014.001.0051"));
        }
    }

    public boolean isSystemStarted() throws MetaMatrixComponentException {
        boolean systemStarted = false;
        List<ServiceRegistryBinding> authServices = this.registry.getServiceBindings("AuthorizationService");
        List<ServiceRegistryBinding> sessionServices = this.registry.getServiceBindings("SessionService");
        List<ServiceRegistryBinding> membershipServices = this.registry.getServiceBindings("MembershipService");
        List<ServiceRegistryBinding> configurationServices = this.registry.getServiceBindings("ConfigurationService");
        if (authServices.size() > 0 && sessionServices.size() > 0 && membershipServices.size() > 0 && configurationServices.size() > 0) {
            systemStarted = true;
        }
        return systemStarted;
    }

    public List<String> getHosts() throws MetaMatrixComponentException {
        ArrayList<String> list = new ArrayList<String>();
        List<HostControllerRegistryBinding> allHosts = this.registry.getHosts();
        for (HostControllerRegistryBinding host : allHosts) {
            list.add(host.getHostName());
        }
        return list;
    }

    public ProcessStatistics getVMStatistics(String hostName, String processName) throws MetaMatrixComponentException {
        ProcessRegistryBinding vm = this.registry.getProcessBinding(hostName, processName);
        return vm.getProcessController().getVMStatistics();
    }

    public InetAddress getVMHostName(String hostName, String processName) throws MetaMatrixComponentException {
        ProcessRegistryBinding vm = this.registry.getProcessBinding(hostName, processName);
        return vm.getProcessController().getAddress();
    }

    public Collection getServiceQueueStatistics(ServiceRegistryBinding binding) throws MetaMatrixComponentException {
        ServiceInterface service = binding.getService();
        if (service != null) {
            return service.getQueueStatistics();
        }
        return Collections.EMPTY_LIST;
    }

    public ServiceRegistryBinding getServiceBinding(ServiceID serviceID) throws ResourceNotBoundException {
        return this.registry.getServiceBinding(serviceID.getHostName(), serviceID.getProcessName(), serviceID);
    }

    public List<ServiceRegistryBinding> getServices() throws MetaMatrixComponentException {
        return this.registry.getServiceBindings(null, null);
    }

    public List<ServiceRegistryBinding> getActiveServices(String serviceType) throws MetaMatrixComponentException {
        ArrayList<ServiceRegistryBinding> list = new ArrayList<ServiceRegistryBinding>();
        List<ServiceRegistryBinding> bindings = this.registry.getServiceBindings(null, null);
        for (ServiceRegistryBinding binding : bindings) {
            int currentState = binding.getCurrentState();
            if (!binding.getServiceType().equals(serviceType) || currentState != 1 && currentState != 6) continue;
            list.add(binding);
        }
        return list;
    }

    public synchronized void shutdownServer() throws MetaMatrixComponentException {
        this.hostManagement.killAllServersInCluster();
    }

    public synchronized void bounceServer() throws MetaMatrixComponentException {
        this.hostManagement.bounceAllServersInCluster();
    }

    public synchronized void synchronizeServer() throws MetaMatrixComponentException, MultipleException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        StringBuffer errorMsg = new StringBuffer();
        SystemState state = this.getSystemState();
        Collection hosts = state.getHosts();
        ArrayList<HostData> newHosts = new ArrayList<HostData>();
        for (HostData hData : hosts) {
            if (!hData.isDeployed() || hData.isRegistered()) continue;
            try {
                this.hostManagement.startServers(hData.getName());
            }
            catch (Exception e) {
                exceptions.add(e);
            }
            newHosts.add(hData);
        }
        hosts.removeAll(newHosts);
        Iterator hostIter = hosts.iterator();
        HashMap<String, Collection> processes = new HashMap<String, Collection>();
        while (hostIter.hasNext()) {
            HostData hData = (HostData)hostIter.next();
            processes.put(hData.getName(), hData.getProcesses());
        }
        block18: for (String hostName : processes.keySet()) {
            List procList = (List)processes.get(hostName);
            for (ProcessData pData : procList) {
                ProcessManagement vmController = null;
                if (pData.isRegistered()) {
                    try {
                        ProcessRegistryBinding vmBinding = this.registry.getProcessBinding(pData.getHostName(), pData.getName());
                        vmController = vmBinding.getProcessController();
                    }
                    catch (Exception e) {
                        exceptions.add(e);
                        continue block18;
                    }
                }
                if (pData.isDeployed() && !pData.isRegistered()) {
                    try {
                        this.hostManagement.startServer(hostName, pData.getName());
                    }
                    catch (Exception e) {
                        exceptions.add(e);
                    }
                    continue;
                }
                if (!pData.isDeployed() && pData.isRegistered()) {
                    this.hostManagement.killServer(hostName, pData.getName(), true);
                    continue;
                }
                Collection pscList = pData.getPSCs();
                for (PSCData pscData : pscList) {
                    Collection services = pscData.getServices();
                    for (ServiceData sData : services) {
                        if (!sData.isDeployed() && sData.isRegistered()) {
                            try {
                                vmController.stopService(sData.getServiceID(), false, true);
                            }
                            catch (Exception e) {
                                exceptions.add(e);
                            }
                            continue;
                        }
                        if (sData.isDeployed() && !sData.isRegistered()) {
                            try {
                                vmController.startDeployedService((ServiceComponentDefnID)sData.getComponentDefnID());
                            }
                            catch (Exception e) {
                                exceptions.add(e);
                            }
                            continue;
                        }
                        if (!sData.isDeployed() || !sData.isRegistered()) continue;
                        ServiceID serviceID = sData.getServiceID();
                        try {
                            switch (sData.getCurrentState()) {
                                case 2: 
                                case 3: 
                                case 4: {
                                    vmController.startService(serviceID);
                                    break;
                                }
                                case 6: {
                                    vmController.checkService(serviceID);
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            exceptions.add(e);
                        }
                    }
                }
            }
        }
        if (!exceptions.isEmpty()) {
            throw new MultipleException(exceptions, "ERR.014.001.0054", PlatformPlugin.Util.getString("ERR.014.001.0054", new Object[]{errorMsg}));
        }
    }

    public ProcessManagement getVMControllerInterface(String hostName, String processName) throws ResourceNotBoundException {
        return this.registry.getProcessBinding(hostName, processName).getProcessController();
    }

    public void restartService(ServiceID serviceID) throws MetaMatrixComponentException {
        ProcessRegistryBinding vmBinding = this.registry.getProcessBinding(serviceID.getHostName(), serviceID.getProcessName());
        ProcessManagement vmController = vmBinding.getProcessController();
        try {
            vmController.stopService(serviceID, false, false);
        }
        catch (ServiceException se) {
            LogManager.logDetail((String)"RUNTIME_ADMIN", (Throwable)((Object)se), (String)"Service exception stopping service during restart");
        }
        try {
            vmController.startService(serviceID);
        }
        catch (ServiceException se) {
            throw new MetaMatrixComponentException((Throwable)((Object)se), MetaMatrixExceptionUtil.getLinkedMessages((Throwable)((Object)se)));
        }
    }

    public void setLogConfiguration(Configuration config, LogConfiguration logConfig, List actions, String principalName) throws ConfigurationLockException, ConfigurationException, ServiceException, MetaMatrixComponentException {
        ConfigurationServiceInterface configAdmin = PlatformProxyHelper.getConfigurationServiceProxy("ROUND_ROBIN_LOCAL");
        try {
            configAdmin.executeTransaction(actions, principalName);
        }
        catch (ModificationException e) {
            throw new MetaMatrixComponentException((Throwable)e, "ERR.014.001.0084", PlatformPlugin.Util.getString("ERR.014.001.0084", new Object[]{config.getID()}));
        }
        StringBuffer msgs = null;
        ConfigurationID currentConfigID = (ConfigurationID)config.getID();
        ConfigurationID operationalConfigID = configAdmin.getCurrentConfigurationID();
        if (currentConfigID.equals((Object)operationalConfigID)) {
            LogManager.logInfo((String)"RUNTIME_ADMIN", (String)PlatformPlugin.Util.getString("MSG.014.001.0028"));
            LogManager.setLogConfiguration((LogConfiguration)logConfig);
            for (ProcessRegistryBinding vmBinding : this.registry.getVMs(null)) {
                ProcessManagement vm = vmBinding.getProcessController();
                vm.setCurrentLogConfiguration(logConfig);
            }
            if (msgs != null && msgs.length() > 0) {
                throw new MetaMatrixComponentException("ERR.014.001.0086", PlatformPlugin.Util.getString("ERR.014.001.0086", new Object[]{msgs.toString()}));
            }
        }
    }

    public void stopService(ServiceID serviceID, boolean stopNow) throws MetaMatrixComponentException {
        ProcessRegistryBinding binding = this.registry.getProcessBinding(serviceID.getHostName(), serviceID.getProcessName());
        ProcessManagement vmController = binding.getProcessController();
        try {
            vmController.stopService(serviceID, stopNow, false);
        }
        catch (ServiceException se) {
            throw new MetaMatrixComponentException((Throwable)((Object)se));
        }
    }

    public void startHost(String host) throws MetaMatrixComponentException {
        this.hostManagement.startServers(host);
    }

    public void startProcess(String host, String process) throws MetaMatrixComponentException {
        boolean hostFound = false;
        boolean processFound = false;
        SystemState state = this.getSystemState();
        Collection hosts = state.getHosts();
        for (HostData hData : hosts) {
            if (!hData.getName().equalsIgnoreCase(host)) continue;
            hostFound = true;
            if (!hData.isRegistered()) {
                throw new MetaMatrixComponentException("ERR.014.001.0056", PlatformPlugin.Util.getString("ERR.014.001.0056", new Object[]{host}));
            }
            Collection processes = hData.getProcesses();
            for (ProcessData pData : processes) {
                if (!pData.getName().equalsIgnoreCase(process)) continue;
                processFound = true;
                if (pData.isRegistered()) {
                    throw new MetaMatrixComponentException("ERR.014.001.0067", PlatformPlugin.Util.getString("ERR.014.001.0067", new Object[]{process}));
                }
                this.hostManagement.startServer(host, process);
            }
        }
        if (!hostFound) {
            throw new MetaMatrixComponentException(PlatformPlugin.Util.getString("RuntimeStateAdminAPIImple.Component_not_found", new Object[]{"Host", host}));
        }
        if (!processFound) {
            throw new MetaMatrixComponentException(PlatformPlugin.Util.getString("RuntimeStateAdminAPIImple.Component_not_found", new Object[]{"Process", process}));
        }
    }

    public void stopHost(String host, boolean stopNow) throws MetaMatrixComponentException, MultipleException {
        this.hostManagement.killServers(host, stopNow);
    }

    public void stopProcess(String hostName, String processName, boolean stopNow) throws AuthorizationException, MetaMatrixComponentException {
        this.hostManagement.killServer(hostName, processName, stopNow);
    }

    public byte[] exportLogs(String hostName, String processName) throws MetaMatrixComponentException {
        ProcessRegistryBinding processBinding = this.registry.getProcessBinding(hostName, processName);
        ProcessManagement vmController = processBinding.getProcessController();
        return vmController.exportLogs();
    }
}

