/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.admin.apiimpl;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.MultipleException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.log.reader.DBLogReader;
import com.metamatrix.common.log.reader.LogReader;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.core.CorePlugin;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.admin.api.RuntimeStateAdminAPI;
import com.metamatrix.platform.admin.api.runtime.HostData;
import com.metamatrix.platform.admin.api.runtime.PSCData;
import com.metamatrix.platform.admin.api.runtime.ProcessData;
import com.metamatrix.platform.admin.api.runtime.PscID;
import com.metamatrix.platform.admin.api.runtime.ServiceData;
import com.metamatrix.platform.admin.api.runtime.SystemState;
import com.metamatrix.platform.admin.apiimpl.AdminAPIHelper;
import com.metamatrix.platform.admin.apiimpl.RuntimeStateAdminAPIHelper;
import com.metamatrix.platform.admin.apiimpl.SubSystemAdminAPIImpl;
import com.metamatrix.platform.config.api.service.ConfigurationServiceInterface;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.registry.ProcessRegistryBinding;
import com.metamatrix.platform.registry.ResourceNotBoundException;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.service.ServicePlugin;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.service.api.ServiceInterface;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.util.PlatformProxyHelper;
import com.metamatrix.platform.vm.api.controller.ProcessManagement;
import com.metamatrix.platform.vm.controller.ProcessStatistics;
import com.metamatrix.server.HostManagement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RuntimeStateAdminAPIImpl
extends SubSystemAdminAPIImpl
implements RuntimeStateAdminAPI {
    private ConfigurationServiceInterface configAdmin;
    protected Set listeners = new HashSet();
    private RuntimeStateAdminAPIHelper helper;
    private LogReader logReader;
    private ClusteredRegistryState registry;
    private static RuntimeStateAdminAPIImpl runtimeStateAdminAPI;

    private RuntimeStateAdminAPIImpl(ClusteredRegistryState registry, HostManagement hostManagement) throws MetaMatrixComponentException {
        this.registry = registry;
        this.configAdmin = PlatformProxyHelper.getConfigurationServiceProxy("ROUND_ROBIN_LOCAL");
        this.helper = RuntimeStateAdminAPIHelper.getInstance(registry, hostManagement);
    }

    public static synchronized RuntimeStateAdminAPIImpl getInstance(ClusteredRegistryState registry, HostManagement hostManagement) throws MetaMatrixComponentException {
        if (runtimeStateAdminAPI == null) {
            runtimeStateAdminAPI = new RuntimeStateAdminAPIImpl(registry, hostManagement);
        }
        return runtimeStateAdminAPI;
    }

    public synchronized boolean isSystemStarted() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        return this.helper.isSystemStarted();
    }

    public synchronized List<ServiceRegistryBinding> getServices() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.helper.getServices();
    }

    public synchronized List<String> getHosts() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.helper.getHosts();
    }

    public synchronized void stopService(ServiceID serviceID) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        LogManager.logInfo((String)"RUNTIME_ADMIN", (String)ServicePlugin.Util.getString("MSG.014.001.0003", new Object[]{serviceID, token.getUsername()}));
        AdminAPIHelper.checkForRequiredRole(token, "Admin.ProductAdmin", "RuntimeStateAdminAPIImpl.stopService(" + serviceID + ")");
        this.helper.stopService(serviceID, false);
    }

    public synchronized void stopServiceNow(ServiceID serviceID) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        LogManager.logInfo((String)"RUNTIME_ADMIN", (String)ServicePlugin.Util.getString("MSG.014.001.0004", new Object[]{serviceID, token.getUsername()}));
        AdminAPIHelper.checkForRequiredRole(token, "Admin.ProductAdmin", "RuntimeStateAdminAPIImpl.stopServiceNow(" + serviceID + ")");
        this.helper.stopService(serviceID, true);
    }

    public synchronized void stopHost(String host) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, MultipleException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        LogManager.logInfo((String)"RUNTIME_ADMIN", (String)ServicePlugin.Util.getString("MSG.014.001.0005", new Object[]{host, token.getUsername()}));
        AdminAPIHelper.checkForRequiredRole(token, "Admin.ProductAdmin", "RuntimeStateAdminAPIImpl.stopHost(" + host + ")");
        this.helper.stopHost(host, false);
    }

    public synchronized void stopHostNow(String host) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, MultipleException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        LogManager.logInfo((String)"RUNTIME_ADMIN", (String)ServicePlugin.Util.getString("MSG.014.001.0006", new Object[]{host, token.getUsername()}));
        AdminAPIHelper.checkForRequiredRole(token, "Admin.ProductAdmin", "RuntimeStateAdminAPIImpl.stopHostNow(" + host + ")");
        this.helper.stopHost(host, true);
    }

    public synchronized void stopProcess(String hostName, String processName, boolean now) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        LogManager.logInfo((String)"RUNTIME_ADMIN", (String)ServicePlugin.Util.getString("MSG.014.001.0009", new Object[]{hostName + "." + processName, token.getUsername()}));
        AdminAPIHelper.checkForRequiredRole(token, "Admin.ProductAdmin", "RuntimeStateAdminAPIImpl.stopProcess(" + hostName + "," + processName + ")");
        this.helper.stopProcess(hostName, processName, now);
    }

    public synchronized void shutdownServer() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        LogManager.logInfo((String)"RUNTIME_ADMIN", (String)ServicePlugin.Util.getString("MSG.014.001.0015", new Object[]{token.getUsername()}));
        AdminAPIHelper.checkForRequiredRole(token, "Admin.ProductAdmin", "RuntimeStateAdminAPIImpl.shutdownServer()");
        this.helper.shutdownServer();
    }

    public synchronized void bounceServer() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        LogManager.logCritical((String)"RUNTIME_ADMIN", (String)CorePlugin.Util.getString("MSG.014.001.0016", new Object[]{token.getUsername()}));
        AdminAPIHelper.checkForRequiredRole(token, "Admin.ProductAdmin", "RuntimeStateAdminAPIImpl.bounceServer()");
        this.helper.bounceServer();
    }

    public synchronized void restartService(ServiceID serviceID) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        LogManager.logInfo((String)"RUNTIME_ADMIN", (String)ServicePlugin.Util.getString("MSG.014.001.0019", new Object[]{serviceID}));
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.ProductAdmin", "RuntimeStateAdminAPIImpl.restartService(" + serviceID + ")");
        this.helper.restartService(serviceID);
    }

    public synchronized void startHost(String host) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        LogManager.logInfo((String)"RUNTIME_ADMIN", (String)ServicePlugin.Util.getString("MSG.014.001.0020", new Object[]{host, token.getUsername()}));
        AdminAPIHelper.checkForRequiredRole(token, "Admin.ProductAdmin", "RuntimeStateAdminAPIImpl.startHost(" + host + ")");
        this.helper.startHost(host);
    }

    public synchronized void startProcess(String host, String process) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        LogManager.logInfo((String)"RUNTIME_ADMIN", (String)ServicePlugin.Util.getString("MSG.014.001.0021", new Object[]{process, token.getUsername()}));
        AdminAPIHelper.checkForRequiredRole(token, "Admin.ProductAdmin", "RuntimeStateAdminAPIImpl.startProcess(" + host + ", " + process + ")");
        this.helper.startProcess(host, process);
    }

    public synchronized void startPSC(PscID pscID) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, MultipleException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        LogManager.logInfo((String)"RUNTIME_ADMIN", (String)ServicePlugin.Util.getString("MSG.014.001.0022", new Object[]{pscID, token.getUsername()}));
        AdminAPIHelper.checkForRequiredRole(token, "Admin.ProductAdmin", "RuntimeStateAdminAPIImpl.startPSC(" + pscID + ")");
        SystemState state = this.helper.getSystemState();
        for (HostData hostData : state.getHosts()) {
            for (ProcessData processData : hostData.getProcesses()) {
                for (PSCData pscData : processData.getPSCs()) {
                    if (!pscData.getPscID().equals((Object)pscID)) continue;
                    this.startPSCServices(processData, pscData);
                    return;
                }
            }
        }
    }

    private void startPSCServices(ProcessData processData, PSCData pscData) throws MetaMatrixComponentException, MultipleException {
        if (!processData.isRegistered()) {
            throw new MetaMatrixComponentException("ERR.014.001.0069", PlatformPlugin.Util.getString("ERR.014.001.0069", new Object[]{pscData.getName(), processData.getName()}));
        }
        ProcessManagement vm = null;
        try {
            vm = this.helper.getVMControllerInterface(processData.getHostName(), processData.getName());
        }
        catch (ResourceNotBoundException e) {
            throw new MetaMatrixComponentException("ERR.014.001.0070", PlatformPlugin.Util.getString("ERR.014.001.0070", new Object[]{pscData.getName(), processData.getName()}));
        }
        ArrayList<Object> exceptions = new ArrayList<Object>();
        for (ServiceData serviceData : pscData.getServices()) {
            if (serviceData.isRegistered()) {
                ServiceID serviceID = serviceData.getServiceID();
                try {
                    switch (serviceData.getCurrentState()) {
                        case 2: 
                        case 3: 
                        case 4: {
                            vm.startService(serviceID);
                            break;
                        }
                        case 6: {
                            vm.checkService(serviceID);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
                continue;
            }
            try {
                vm.startDeployedService((ServiceComponentDefnID)serviceData.getComponentDefnID());
            }
            catch (ServiceException se) {
                exceptions.add((Object)se);
            }
        }
        if (!exceptions.isEmpty()) {
            throw new MultipleException(exceptions, "ERR.014.001.0073", PlatformPlugin.Util.getString("ERR.014.001.0073", new Object[]{pscData.getName()}));
        }
    }

    public void stopPSCNow(PscID pscID) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, MultipleException {
    }

    public synchronized void stopPSC(PscID pscID) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, MultipleException {
        this.stopPSC(pscID, false);
    }

    private synchronized void stopPSC(PscID pscID, boolean now) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, MultipleException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        LogManager.logInfo((String)"RUNTIME_ADMIN", (String)ServicePlugin.Util.getString("MSG.014.001.0023", new Object[]{pscID, token.getUsername()}));
        AdminAPIHelper.checkForRequiredRole(token, "Admin.ProductAdmin", "RuntimeStateAdminAPIImpl.stopPSC(" + pscID + ", " + now + ")");
        SystemState state = this.getSystemState();
        for (HostData hostData : state.getHosts()) {
            for (ProcessData processData : hostData.getProcesses()) {
                for (PSCData pscData : processData.getPSCs()) {
                    if (!pscData.getPscID().equals((Object)pscID)) continue;
                    this.stopPSCServices(processData, pscData, now);
                    return;
                }
            }
        }
    }

    private void stopPSCServices(ProcessData processData, PSCData pscData, boolean now) throws MetaMatrixComponentException, MultipleException {
        if (!pscData.isRegistered()) {
            throw new MetaMatrixComponentException("ERR.014.001.0056", PlatformPlugin.Util.getString("ERR.014.001.0056", new Object[]{pscData.getName()}));
        }
        ProcessManagement vm = null;
        try {
            vm = this.helper.getVMControllerInterface(processData.getHostName(), processData.getName());
        }
        catch (ResourceNotBoundException e) {
            throw new MetaMatrixComponentException("ERR.014.001.0074", PlatformPlugin.Util.getString("ERR.014.001.0074", new Object[]{pscData.getName(), processData.getName()}));
        }
        ArrayList<ServiceException> exceptions = new ArrayList<ServiceException>();
        for (ServiceData serviceData : pscData.getServices()) {
            try {
                ServiceID serviceID = serviceData.getServiceID();
                if (serviceID == null) continue;
                vm.stopService(serviceID, now, false);
            }
            catch (ServiceException se) {
                exceptions.add(se);
            }
        }
        if (!exceptions.isEmpty()) {
            throw new MultipleException(exceptions, "ERR.014.001.0076", PlatformPlugin.Util.getString("ERR.014.001.0076", new Object[]{pscData.getName()}));
        }
    }

    public synchronized void synchronizeServer() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, MultipleException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        LogManager.logInfo((String)"RUNTIME_ADMIN", (String)ServicePlugin.Util.getString("MSG.014.001.0026", new Object[]{token.getUsername()}));
        AdminAPIHelper.checkForRequiredRole(token, "Admin.ProductAdmin", "RuntimeStateAdminAPIImpl.synchronizeServer()");
        this.helper.synchronizeServer();
    }

    public synchronized Date getServerStartTime() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        try {
            return this.configAdmin.getServerStartupTime();
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e, "ERR.014.001.0083", PlatformPlugin.Util.getString("ERR.014.001.0083"));
        }
    }

    public synchronized void setLoggingConfiguration(Configuration config, LogConfiguration logConfig, List actions) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        LogManager.logInfo((String)"RUNTIME_ADMIN", (String)CorePlugin.Util.getString("MSG.014.001.0027"));
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.ProductAdmin", "RuntimeStateAdminAPIImpl.setLoggingConfiguration(" + config + ", " + logConfig + ", " + actions + ")");
        this.helper.setLogConfiguration(config, logConfig, actions, token.getUsername());
    }

    private static String buildProcessId(String host, String process) {
        return host + "." + process;
    }

    public synchronized void setLoggingConfiguration(LogConfiguration logConfig, String hostName, String processName) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        LogManager.logInfo((String)"RUNTIME_ADMIN", (String)CorePlugin.Util.getString("MSG.014.001.0029", new Object[]{RuntimeStateAdminAPIImpl.buildProcessId(hostName, processName)}));
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.ProductAdmin", "RuntimeStateAdminAPIImpl.setLoggingConfiguration(" + logConfig + ", " + RuntimeStateAdminAPIImpl.buildProcessId(hostName, processName) + ")");
        ProcessManagement vm = this.helper.getVMControllerInterface(hostName, processName);
        vm.setCurrentLogConfiguration(logConfig);
    }

    public synchronized Collection getServiceQueueStatistics(ServiceID serviceID) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        LogManager.logDetail((String)"RUNTIME_ADMIN", (Object[])new Object[]{"Getting queue statistics for: " + serviceID});
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.helper.getServiceQueueStatistics(this.helper.getServiceBinding(serviceID));
    }

    public synchronized WorkerPoolStats getServiceQueueStatistics(ServiceID serviceID, String queueName) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        LogManager.logDetail((String)"RUNTIME_ADMIN", (Object[])new Object[]{"Getting queue statistics for " + queueName + " for service: " + serviceID});
        AdminAPIHelper.validateSession(this.getSessionID());
        ServiceInterface service = this.helper.getServiceBinding(serviceID).getService();
        return service.getQueueStatistics(queueName);
    }

    public synchronized ProcessStatistics getProcessStatistics(String hostName, String processName) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        LogManager.logDetail((String)"RUNTIME_ADMIN", (Object[])new Object[]{"Getting vm statistics for " + RuntimeStateAdminAPIImpl.buildProcessId(hostName, processName)});
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.helper.getVMStatistics(hostName, processName);
    }

    public ServiceID getServiceIDByName(String hostName, String processName, String serviceName) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        ServiceID result = null;
        Iterator<ProcessRegistryBinding> vmIter = this.registry.getVMs(hostName).iterator();
        if (!vmIter.hasNext()) {
            return result;
        }
        while (result == null && vmIter.hasNext()) {
            ProcessRegistryBinding processBinding = vmIter.next();
            if (!processBinding.getHostName().equalsIgnoreCase(hostName) || !processBinding.getProcessName().equalsIgnoreCase(processName)) continue;
            Iterator<ServiceRegistryBinding> serviceIter = this.registry.getServiceBindings(hostName, processBinding.getProcessName()).iterator();
            while (result == null && serviceIter.hasNext()) {
                ServiceRegistryBinding binding = serviceIter.next();
                if (!binding.getHostName().equalsIgnoreCase(hostName) || !binding.getInstanceName().trim().equalsIgnoreCase(serviceName)) continue;
                result = binding.getServiceID();
            }
        }
        return result;
    }

    public PscID getPscIDByName(String hostName, String processName, String pscName) throws ResourceNotBoundException, AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        PscID result = null;
        Iterator<ProcessRegistryBinding> vmIter = this.registry.getVMs(hostName).iterator();
        if (!vmIter.hasNext()) {
            return result;
        }
        while (result == null && vmIter.hasNext()) {
            ProcessRegistryBinding processBinding = vmIter.next();
            if (!processBinding.getHostName().equalsIgnoreCase(hostName) || !processBinding.getProcessName().equalsIgnoreCase(processName)) continue;
            Iterator<ServiceRegistryBinding> serviceIter = this.registry.getServiceBindings(hostName, processBinding.getProcessName()).iterator();
            while (result == null && serviceIter.hasNext()) {
                ServiceRegistryBinding binding = serviceIter.next();
                if (!binding.getHostName().equalsIgnoreCase(hostName) || !binding.getPscID().getName().equalsIgnoreCase(pscName)) continue;
                result = new PscID(binding.getPscID(), processName);
            }
        }
        return result;
    }

    public List<ProcessRegistryBinding> getVMControllerBindings() throws InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.registry.getVMs(null);
    }

    public List getLogEntries(Date startTime, Date endTime, List levels, List contexts, int maxRows) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.getLogReader().getLogEntries(startTime, endTime, levels, contexts, maxRows);
    }

    private synchronized LogReader getLogReader() throws MetaMatrixComponentException {
        if (this.logReader == null) {
            try {
                this.logReader = new DBLogReader();
            }
            catch (MetaMatrixException e) {
                throw new MetaMatrixComponentException((Throwable)e);
            }
        }
        return this.logReader;
    }

    public SystemState getSystemState() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return this.helper.getSystemState();
    }
}

