/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.admin.apiimpl;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.SessionServiceException;
import com.metamatrix.platform.admin.api.SessionAdminAPI;
import com.metamatrix.platform.admin.apiimpl.AdminAPIHelper;
import com.metamatrix.platform.admin.apiimpl.SubSystemAdminAPIImpl;
import com.metamatrix.platform.security.api.MetaMatrixPrincipal;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.service.SessionServiceInterface;
import com.metamatrix.platform.util.PlatformProxyHelper;
import java.util.Collection;
import org.teiid.dqp.internal.process.DQPWorkContext;

public class SessionAdminAPIImpl
extends SubSystemAdminAPIImpl
implements SessionAdminAPI {
    private SessionServiceInterface sessAdmin = PlatformProxyHelper.getSessionServiceProxy("ROUND_ROBIN_LOCAL");
    private static SessionAdminAPI sessionAdminAPI;

    private SessionAdminAPIImpl() {
    }

    public static synchronized SessionAdminAPI getInstance() {
        if (sessionAdminAPI == null) {
            sessionAdminAPI = new SessionAdminAPIImpl();
        }
        return sessionAdminAPI;
    }

    public synchronized MetaMatrixPrincipal getPrincipal(MetaMatrixSessionID userSessionID) throws InvalidSessionException, AuthorizationException, MetaMatrixComponentException, SessionServiceException {
        return this.sessAdmin.getPrincipal(userSessionID);
    }

    public synchronized Collection getActiveSessions() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, SessionServiceException {
        return this.sessAdmin.getActiveSessions();
    }

    public synchronized void terminateSession(MetaMatrixSessionID userSessionID) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, SessionServiceException {
        SessionToken token = DQPWorkContext.getWorkContext().getSessionToken();
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "SessionAdminAPIImpl.terminateSession(" + userSessionID + ")");
        this.sessAdmin.terminateSession(userSessionID, this.getSessionID());
    }

    public synchronized Boolean isSessionValid(MetaMatrixSessionID userSessionID) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, SessionServiceException {
        try {
            this.sessAdmin.validateSession(userSessionID);
            return Boolean.TRUE;
        }
        catch (InvalidSessionException invalidSessionException) {
            return Boolean.FALSE;
        }
    }

    public synchronized int getActiveSessionsCount() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, SessionServiceException {
        return this.sessAdmin.getActiveSessionsCount();
    }

    public synchronized int getActiveConnectionsCountForProduct(String product) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException, SessionServiceException {
        return this.sessAdmin.getActiveConnectionsCountForProduct(product);
    }
}

