/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.api.service;

import com.metamatrix.common.actions.ActionDefinition;
import com.metamatrix.common.actions.ModificationException;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.api.exceptions.ConfigurationLockException;
import com.metamatrix.common.config.api.exceptions.InvalidConfigurationException;
import com.metamatrix.platform.service.api.ServiceInterface;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public interface ConfigurationServiceInterface
extends ServiceInterface {
    public static final String NAME = "ConfigurationService";

    public ConfigurationObjectEditor createEditor() throws ConfigurationException;

    public ConfigurationID getCurrentConfigurationID() throws ConfigurationException;

    public ConfigurationID getNextStartupConfigurationID() throws ConfigurationException;

    public ConfigurationID getStartupConfigurationID() throws ConfigurationException;

    public void baselineCurrentConfiguration(String var1) throws ConfigurationException;

    public Configuration getCurrentConfiguration() throws ConfigurationException;

    public Configuration getNextStartupConfiguration() throws ConfigurationException;

    public Configuration getStartupConfiguration() throws ConfigurationException;

    public Configuration getConfiguration(String var1) throws InvalidConfigurationException, ConfigurationException;

    public ConfigurationModelContainer getConfigurationModel(String var1) throws InvalidConfigurationException, ConfigurationException;

    public Collection getConfigurationAndDependents(ConfigurationID var1) throws ConfigurationException;

    public Collection getAllGlobalConfigObjects() throws ConfigurationException;

    public Map getComponentTypeDefinitions(Collection var1) throws ConfigurationException;

    public Collection getComponentTypeDefinitions(ComponentTypeID var1) throws ConfigurationException;

    public Collection getAllComponentTypeDefinitions(ComponentTypeID var1) throws ConfigurationException;

    public Map getDependentComponentTypeDefinitions(Collection var1) throws ConfigurationException;

    public Collection getDependentComponentTypeDefinitions(ComponentTypeID var1) throws ConfigurationException;

    public Collection getMonitoredComponentTypes(boolean var1) throws ConfigurationException;

    public ComponentType getComponentType(ComponentTypeID var1) throws ConfigurationException;

    public Collection getAllComponentTypes(boolean var1) throws ConfigurationException;

    public Host getHost(HostID var1) throws ConfigurationException;

    public Collection getHosts() throws ConfigurationException;

    public ComponentDefn getComponentDefn(ConfigurationID var1, ComponentDefnID var2) throws ConfigurationException;

    public Collection getComponentDefns(Collection var1, ConfigurationID var2) throws ConfigurationException;

    public Collection getResources() throws ConfigurationException;

    public Collection getResources(ComponentTypeID var1) throws ConfigurationException;

    public void saveResources(Collection var1, String var2) throws ConfigurationException;

    public Collection getProductReleaseInfos() throws ConfigurationException;

    public Set executeTransaction(ActionDefinition var1, String var2) throws ModificationException, ConfigurationLockException, ConfigurationException;

    public Set executeTransaction(List var1, String var2) throws ModificationException, ConfigurationLockException, ConfigurationException;

    public Set executeInsertTransaction(ConfigurationID var1, List var2, String var3) throws ModificationException, ConfigurationLockException, ConfigurationException;

    public Set undoActionsAsTransaction(int var1, String var2) throws ConfigurationException;

    public List getHistory() throws ConfigurationException;

    public void clearHistory() throws ConfigurationException;

    public int getHistorySize() throws ConfigurationException;

    public int getHistoryLimit() throws ConfigurationException;

    public void setHistoryLimit(int var1) throws ConfigurationException;

    public Date getServerStartupTime() throws ConfigurationException;

    public Host addHost(String var1, String var2, Properties var3) throws ConfigurationException;

    public VMComponentDefn addProcess(String var1, String var2, String var3, Properties var4) throws ConfigurationException;

    public void setSystemPropertyValue(String var1, String var2, String var3) throws ConfigurationException;

    public void updateSystemPropertyValues(Properties var1, String var2) throws ConfigurationException;

    public ConnectorBinding createConnectorBinding(String var1, String var2, String var3, String var4, Properties var5) throws ConfigurationException;

    public Object modify(ComponentObject var1, Properties var2, String var3) throws ConfigurationException, ModificationException;

    public ComponentType importConnectorType(InputStream var1, String var2, String var3) throws ConfigurationException;

    public ConnectorBinding importConnectorBinding(InputStream var1, String var2, String var3, String var4) throws ConfigurationException;

    public void delete(ComponentObject var1, boolean var2, String var3) throws ConfigurationException, ModificationException;

    public void delete(ComponentType var1, String var2) throws ConfigurationException, ModificationException;

    public Collection deployPSC(Host var1, VMComponentDefn var2, String var3, String var4) throws ConfigurationException, ModificationException;

    public List checkPropertiesDecryptable(List var1) throws ConfigurationException;

    public boolean checkPropertiesDecryptable(Properties var1, String var2) throws ConfigurationException;
}

