/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.event;

import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ConnectorBindingID;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.namedobject.BaseID;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.platform.config.ConfigPlugin;
import java.util.Collection;
import java.util.EventObject;

public class ConfigurationChangeEvent
extends EventObject {
    public static final int CONFIG_REFRESH = 0;
    public static final int CONFIG_CHANGE = 1;
    private Collection ids = null;
    private BaseID id = null;
    private int action;

    public ConfigurationChangeEvent(Object source, Collection baseIDs, int action) {
        super(source);
        if (baseIDs == null) {
            Assertion.isNotNull((Object)baseIDs, (String)ConfigPlugin.Util.getString("ERR.014.002.0007"));
        }
        this.action = action;
        this.ids = baseIDs;
        this.id = null;
    }

    public ConfigurationChangeEvent(Object source, int action) {
        super(source);
        this.action = action;
        this.id = null;
        this.ids = null;
    }

    public ConfigurationChangeEvent(Object source, BaseID baseID, int action) {
        super(source);
        if (baseID == null) {
            Assertion.isNotNull((Object)baseID, (String)ConfigPlugin.Util.getString("ERR.014.002.0008"));
        }
        this.action = action;
        this.id = baseID;
        this.ids = null;
    }

    public boolean refreshConfig() {
        return this.action == 0;
    }

    public boolean configChange() {
        return this.action == 1;
    }

    public Collection getChangedIDs() {
        return this.ids;
    }

    public boolean isConnectorBindingChange() {
        if (this.ids == null && this.id == null) {
            return false;
        }
        if (this.id != null) {
            return this.id instanceof ConnectorBindingID;
        }
        for (BaseID bid : this.ids) {
            if (!(bid instanceof ConnectorBindingID)) continue;
            return true;
        }
        return false;
    }

    public boolean isComponentTypeChange() {
        if (this.ids == null && this.id == null) {
            return false;
        }
        if (this.id != null) {
            return this.id instanceof ConnectorBindingID;
        }
        for (BaseID bid : this.ids) {
            if (!(bid instanceof ComponentTypeID)) continue;
            return true;
        }
        return false;
    }

    public boolean isHostChange() {
        if (this.ids == null && this.id == null) {
            return false;
        }
        if (this.id != null) {
            return this.id instanceof ConnectorBindingID;
        }
        for (BaseID bid : this.ids) {
            if (!(bid instanceof HostID)) continue;
            return true;
        }
        return false;
    }

    public boolean isServiceChange() {
        if (this.ids == null && this.id == null) {
            return false;
        }
        if (this.id != null) {
            return this.id instanceof ConnectorBindingID;
        }
        for (BaseID bid : this.ids) {
            if (!(bid instanceof ServiceComponentDefnID)) continue;
            return true;
        }
        return false;
    }
}

