/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.persistence.api;

import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.util.ReflectionHelper;
import com.metamatrix.platform.config.ConfigPlugin;
import com.metamatrix.platform.config.persistence.api.PersistentConnection;
import com.metamatrix.platform.config.persistence.impl.file.FilePersistentConnectionFactory;
import com.metamatrix.platform.config.persistence.impl.jdbc.JDBCPersistentConnectionFactory;
import java.util.Arrays;
import java.util.Properties;

public abstract class PersistentConnectionFactory {
    public static final String PERSISTENT_FACTORY_NAME = "metamatrix.config.persistent.factory";
    public static final String FILE_FACTORY_NAME = FilePersistentConnectionFactory.class.getName();
    public static final String JDBC_FACTORY_NAME = JDBCPersistentConnectionFactory.class.getName();
    private Properties properties;

    public PersistentConnectionFactory(Properties factoryProperties) {
        this.properties = factoryProperties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static final PersistentConnectionFactory createPersistentConnectionFactory(Properties props) throws ConfigurationException {
        Properties properties = PropertiesUtils.clone((Properties)props, (boolean)false);
        String factoryName = properties.getProperty(PERSISTENT_FACTORY_NAME);
        if (factoryName == null || factoryName.trim().length() == 0) {
            if (PersistentConnectionFactory.isFileFactory(properties)) {
                return new FilePersistentConnectionFactory(properties);
            }
            if (PersistentConnectionFactory.isJDBCFactory(properties)) {
                return new JDBCPersistentConnectionFactory(properties);
            }
            throw new ConfigurationException("ERR.014.002.0009", ConfigPlugin.Util.getString("ERR.014.002.0009", new Object[]{PERSISTENT_FACTORY_NAME}));
        }
        try {
            return (PersistentConnectionFactory)ReflectionHelper.create((String)factoryName, Arrays.asList(properties), (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (MetaMatrixCoreException err) {
            throw new ConfigurationException((Throwable)err, "ERR.014.002.0013", ConfigPlugin.Util.getString("ERR.014.002.0013", new Object[]{factoryName}));
        }
    }

    public abstract PersistentConnection createPersistentConnection() throws ConfigurationException;

    private static boolean isFileFactory(Properties props) {
        String configFileName = props.getProperty("metamatrix.config.ns.filename");
        return configFileName != null && configFileName.length() > 0;
    }

    private static boolean isJDBCFactory(Properties props) {
        String driver = props.getProperty("metamatrix.config.jdbc.persistent.readerDriver");
        return driver != null && driver.length() > 0;
    }
}

