/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.persistence.impl.file;

import com.metamatrix.common.config.StartupStateException;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.model.ConfigurationModelContainerAdapter;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.config.persistence.api.PersistentConnection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;

public class FilePersistentConnection
implements PersistentConnection {
    public static final String CONFIG_NS_FILE_NAME_PROPERTY = "metamatrix.config.ns.filename";
    public static final String CONFIG_FILE_PATH_PROPERTY = "metamatrix.config.modelsDir";
    public static final String NEXT_STARTUP_FILE_NAME = "config_ns.xml";
    private int state = 0;
    private Date startupTime = null;
    private String path;
    private String ns_full_path;
    private String ns_override;
    private ConfigurationModelContainerAdapter adapter;
    private boolean closed = true;

    public FilePersistentConnection(Properties props, ConfigurationModelContainerAdapter adapter) {
        String file;
        this.adapter = adapter;
        this.path = props.getProperty(CONFIG_FILE_PATH_PROPERTY, "");
        if (props.getProperty(CONFIG_NS_FILE_NAME_PROPERTY, null) != null && !(file = props.getProperty(CONFIG_NS_FILE_NAME_PROPERTY)).equals(NEXT_STARTUP_FILE_NAME)) {
            this.ns_override = this.getFullPath(this.path, file);
        }
        this.ns_full_path = this.getFullPath(this.path, NEXT_STARTUP_FILE_NAME);
    }

    private void init() throws ConfigurationException {
        File configFile = new File(this.ns_full_path);
        if (this.ns_override != null && !configFile.exists()) {
            this.copyFile(this.ns_override, this.ns_full_path);
        }
        this.closed = false;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized ConfigurationModelContainer read(ConfigurationID configID) throws ConfigurationException {
        if (configID == null) {
            Assertion.isNotNull((Object)configID, (String)PlatformPlugin.Util.getString("ERR.014.002.0018"));
        }
        this.init();
        InputStream is = this.readConfigurationFromFile(this.getFileName(configID));
        ConfigurationModelContainer model = this.adapter.readConfigurationModel(is, configID);
        try {
            is.close();
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e, "ERR.014.002.0018", PlatformPlugin.Util.getString("ERR.014.002.0018", new Object[]{configID}));
        }
        return model;
    }

    @Override
    public synchronized void setServerStarting() throws StartupStateException, ConfigurationException {
        if (this.state != 0) {
            throw new StartupStateException(1, this.state);
        }
        this.state = 1;
    }

    @Override
    public synchronized void setServerStarting(boolean force) throws StartupStateException, ConfigurationException {
        this.state = 1;
    }

    @Override
    public synchronized void setServerStarted() throws StartupStateException, ConfigurationException {
        if (this.state != 1) {
            throw new StartupStateException(2, this.state);
        }
        this.state = 2;
        this.startupTime = new Date();
    }

    @Override
    public synchronized void setServerStopped() throws StartupStateException, ConfigurationException {
        this.state = 0;
    }

    @Override
    public int getServerState() throws ConfigurationException {
        return this.state;
    }

    @Override
    public Date getStartupTime() throws ConfigurationException {
        if (this.getServerState() == 2) {
            return this.startupTime;
        }
        return new Date();
    }

    private InputStream readConfigurationFromFile(String fileName) throws ConfigurationException {
        InputStream inputStream = null;
        File configFile = new File(fileName);
        try {
            if (configFile.exists()) {
                inputStream = new FileInputStream(configFile);
                BufferedInputStream bis = new BufferedInputStream(inputStream);
                return bis;
            }
        }
        catch (IOException io) {
            throw new ConfigurationException((Throwable)io, "ERR.014.002.0021", PlatformPlugin.Util.getString("ERR.014.002.0021", new Object[]{fileName}));
        }
        try {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(configFile.getName());
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e, "Unable to access the configuration file \"" + fileName + "\"");
        }
        if (inputStream == null) {
            throw new ConfigurationException("ERR.014.002.0020", PlatformPlugin.Util.getString("ERR.014.002.0020", new Object[]{fileName}));
        }
        return inputStream;
    }

    @Override
    public synchronized void write(ConfigurationModelContainer model, String principal) throws ConfigurationException {
        if (model == null) {
            Assertion.isNotNull((Object)model, (String)PlatformPlugin.Util.getString("ERR.014.002.0022"));
        }
        if (principal == null) {
            Assertion.isNotNull((Object)principal, (String)PlatformPlugin.Util.getString("ERR.014.002.0023"));
        }
        this.init();
        String fileName = "NotDefined";
        ConfigurationID id = (ConfigurationID)model.getConfiguration().getID();
        fileName = this.getFileName(id);
        this.write(model, fileName, principal);
    }

    public synchronized void write(ConfigurationModelContainer model, String fileName, String principal) throws ConfigurationException {
        try {
            File configFile = new File(fileName);
            FileOutputStream stream = new FileOutputStream(configFile);
            BufferedOutputStream bos = new BufferedOutputStream(stream);
            this.adapter.writeConfigurationModel((OutputStream)bos, model, principal);
            bos.flush();
            bos.close();
            stream.close();
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            throw new ConfigurationException((Throwable)ioe, "ERR.014.002.0024", PlatformPlugin.Util.getString("ERR.014.002.0024", new Object[]{fileName}));
        }
    }

    @Override
    public synchronized void delete(ConfigurationID configID, String principal) throws ConfigurationException {
        String fileName = "NotDefined";
        try {
            fileName = this.getFileName(configID);
            this.deleteFile(fileName);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            throw new ConfigurationException((Throwable)ioe, "ERR.014.002.0025", PlatformPlugin.Util.getString("ERR.014.002.0025", new Object[]{fileName}));
        }
    }

    private String getFileName(ConfigurationID id) throws ConfigurationException {
        if (id.equals((Object)Configuration.NEXT_STARTUP_ID)) {
            return this.ns_full_path;
        }
        if (id.equals((Object)Configuration.STARTUP_ID)) {
            return this.ns_full_path;
        }
        throw new ConfigurationException("ERR.014.002.0026", PlatformPlugin.Util.getString("ERR.014.002.0026", new Object[]{id}));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyFile(String fromFileName, String toFileName) throws ConfigurationException {
        InputStream in = null;
        try {
            in = this.readConfigurationFromFile(fromFileName);
            this.deleteFile(toFileName);
            FileUtils.write((InputStream)in, (String)toFileName);
            if (in == null) return;
        }
        catch (Exception e) {
            try {
                throw new ConfigurationException((Throwable)e, "ERR.014.002.0027", PlatformPlugin.Util.getString("ERR.014.002.0027", new Object[]{fromFileName, toFileName}));
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new ConfigurationException((Throwable)ioe, "ERR.014.002.0027", PlatformPlugin.Util.getString("ERR.014.002.0027", new Object[]{fromFileName, toFileName}));
                }
            }
        }
        try {
            in.close();
            return;
        }
        catch (IOException ioe) {
            throw new ConfigurationException((Throwable)ioe, "ERR.014.002.0027", PlatformPlugin.Util.getString("ERR.014.002.0027", new Object[]{fromFileName, toFileName}));
        }
    }

    private void deleteFile(String fileToDelete) throws ConfigurationException {
        try {
            File configFile = new File(fileToDelete);
            if (configFile.exists()) {
                configFile.delete();
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            throw new ConfigurationException((Throwable)ioe, "ERR.014.002.0028", PlatformPlugin.Util.getString("ERR.014.002.0028", new Object[]{fileToDelete}));
        }
    }

    private String getFullPath(String path, String fileName) {
        if (path == null || path.trim().length() == 0) {
            return fileName;
        }
        File configFile = new File(path, fileName);
        return configFile.getPath();
    }

    @Override
    public void beginTransaction() throws ConfigurationException {
    }

    @Override
    public void commit() throws ConfigurationException {
    }

    @Override
    public void rollback() throws ConfigurationException {
    }
}

