/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.persistence.impl.file;

import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.model.ConfigurationModelContainerAdapter;
import com.metamatrix.platform.config.persistence.api.PersistentConnection;
import com.metamatrix.platform.config.persistence.api.PersistentConnectionFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;

public class FilePersistentUtil {
    public static ConfigurationModelContainer readModel(String fileName, String filePath, ConfigurationID configID) throws Exception {
        Properties props = FilePersistentUtil.createProperties(fileName, filePath);
        return FilePersistentUtil.readModel(props, configID);
    }

    public static ConfigurationModelContainer readModel(Properties props, ConfigurationID configID) throws Exception {
        PersistentConnectionFactory pf = PersistentConnectionFactory.createPersistentConnectionFactory(props);
        PersistentConnection readin = pf.createPersistentConnection();
        ConfigurationModelContainer model = readin.read(configID);
        return model;
    }

    private static Properties createProperties(String fileName, String filePath) {
        Properties props = new Properties();
        props.setProperty("metamatrix.config.ns.filename", fileName);
        if (filePath != null) {
            props.setProperty("metamatrix.config.modelsDir", filePath);
        }
        return props;
    }

    public static void writeModel(String fileName, String filePath, ConfigurationModelContainer model, String principal) throws ConfigurationException {
        String loc;
        if (filePath == null || filePath.length() == 0) {
            loc = fileName;
        } else {
            if (!filePath.endsWith(File.separator)) {
                filePath = filePath + File.separator;
            }
            loc = filePath + fileName;
        }
        ConfigurationModelContainerAdapter adapter = new ConfigurationModelContainerAdapter();
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(loc);
            adapter.writeConfigurationModel((OutputStream)os, model, principal);
            os.flush();
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e1) {}
            }
        }
    }
}

