/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.persistence.impl.jdbc;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.config.StartupStateException;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.model.ConfigurationModelContainerAdapter;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.extensionmodule.spi.jdbc.JDBCExtensionModuleReader;
import com.metamatrix.common.extensionmodule.spi.jdbc.JDBCExtensionModuleWriter;
import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.jdbc.JDBCPlatformFactory;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.config.persistence.api.PersistentConnection;
import com.metamatrix.platform.config.persistence.impl.jdbc.SQL_Translator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public class JDBCPersistentConnection
implements PersistentConnection {
    private Connection connection;
    private ConfigurationModelContainerAdapter adapter;
    private JDBCPlatform platform;

    public JDBCPersistentConnection(Connection conn, ConfigurationModelContainerAdapter adapter, Properties props) {
        Assertion.isNotNull((Object)conn, (String)PlatformPlugin.Util.getString("ERR.014.002.0146"));
        Assertion.isNotNull((Object)adapter, (String)PlatformPlugin.Util.getString("ERR.014.002.0147"));
        this.connection = conn;
        this.adapter = adapter;
        try {
            this.platform = JDBCPlatformFactory.getPlatform(conn);
        }
        catch (MetaMatrixException e) {
            this.platform = null;
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.connection = null;
    }

    @Override
    public boolean isClosed() {
        if (this.connection != null) {
            try {
                if (this.platform != null) {
                    return this.platform.isClosed(this.connection);
                }
                return this.connection.isClosed();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public synchronized void setServerStarting() throws StartupStateException, ConfigurationException {
        int state = this.getServerState();
        if (state != 0) {
            throw new StartupStateException(0, state);
        }
        this.updateStartupState(0, 1);
    }

    @Override
    public synchronized void setServerStarting(boolean force) throws StartupStateException, ConfigurationException {
        this.forceUpdateStartupState(1);
    }

    @Override
    public synchronized void setServerStarted() throws StartupStateException, ConfigurationException {
        int state = this.getServerState();
        if (state != 1) {
            throw new StartupStateException(1, state);
        }
        this.updateStartupState(1, 2);
    }

    @Override
    public synchronized void setServerStopped() throws StartupStateException, ConfigurationException {
        this.forceUpdateStartupState(0);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized int getServerState() throws ConfigurationException {
        int state = -1;
        String sql = null;
        PreparedStatement statement = null;
        try {
            sql = "SELECT STATE, LASTCHANGED FROM CFG_STARTUP_STATE";
            statement = this.connection.prepareStatement(sql);
            if (!statement.execute()) {
                throw new ConfigurationException("ERR.014.002.0148", PlatformPlugin.Util.getString("ERR.014.002.0148", new Object[]{sql}));
            }
            ResultSet results = statement.getResultSet();
            if (!results.next()) throw new ConfigurationException("ERR.014.002.0149", PlatformPlugin.Util.getString("ERR.014.002.0149"));
            state = SQL_Translator.getStartupState(results);
            results.close();
            if (statement == null) return state;
        }
        catch (SQLException e) {
            try {
                throw new ConfigurationException((Throwable)e, "ERR.014.002.0150", PlatformPlugin.Util.getString("ERR.014.002.0150", new Object[]{sql}));
                catch (Exception e2) {
                    if (!(e2 instanceof ConfigurationException)) throw new ConfigurationException((Throwable)e2);
                    throw (ConfigurationException)((Object)e2);
                }
            }
            catch (Throwable throwable) {
                if (statement == null) throw throwable;
                try {
                    statement.close();
                    throw throwable;
                }
                catch (SQLException e3) {
                    e3.printStackTrace();
                    System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", new Object[]{sql}));
                }
                throw throwable;
            }
        }
        try {
            statement.close();
            return state;
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", new Object[]{sql}));
            return state;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized Date getStartupTime() throws ConfigurationException {
        Date timestamp = null;
        String sql = null;
        PreparedStatement statement = null;
        try {
            sql = "SELECT STATE, LASTCHANGED FROM CFG_STARTUP_STATE";
            statement = this.connection.prepareStatement(sql);
            if (!statement.execute()) {
                throw new ConfigurationException("ERR.014.002.0148", PlatformPlugin.Util.getString("ERR.014.002.0148", new Object[]{sql}));
            }
            ResultSet results = statement.getResultSet();
            timestamp = SQL_Translator.getServerStartupTime(results);
            if (statement == null) return timestamp;
        }
        catch (SQLException e) {
            try {
                throw new ConfigurationException((Throwable)e, "ERR.014.002.0150", PlatformPlugin.Util.getString("ERR.014.002.0150", new Object[]{sql}));
                catch (Exception e2) {
                    if (!(e2 instanceof ConfigurationException)) throw new ConfigurationException((Throwable)e2);
                    throw (ConfigurationException)((Object)e2);
                }
            }
            catch (Throwable throwable) {
                if (statement == null) throw throwable;
                try {
                    statement.close();
                    throw throwable;
                }
                catch (SQLException e3) {
                    e3.printStackTrace();
                    System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", new Object[]{sql}));
                }
                throw throwable;
            }
        }
        try {
            statement.close();
            return timestamp;
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", new Object[]{sql}));
            return timestamp;
        }
    }

    @Override
    public synchronized ConfigurationModelContainer read(ConfigurationID configID) throws ConfigurationException {
        return this.readExtensionConfiguration(configID, true);
    }

    @Override
    public synchronized void write(ConfigurationModelContainer config, String principalName) throws ConfigurationException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(out);
            this.adapter.writeConfigurationModel((OutputStream)bos, config, principalName);
            bos.close();
            out.close();
            byte[] data = out.toByteArray();
            if (data == null || data.length == 0) {
                throw new ConfigurationException("ERR.014.002.0156", PlatformPlugin.Util.getString("ERR.014.002.0156"));
            }
            boolean inUse = JDBCExtensionModuleReader.isNameInUse(config.getConfigurationID().getFullName(), this.connection);
            if (inUse) {
                JDBCExtensionModuleWriter.setSource(principalName, config.getConfigurationID().getFullName(), data, data.length, this.connection);
            } else {
                JDBCExtensionModuleWriter.addSource(principalName, "Configuration Model", config.getConfigurationID().getFullName(), data, data.length, config.getConfigurationID().getFullName() + " Configuration Model", true, this.connection);
            }
            if (config.getConfigurationID().getFullName().equals("Startup")) {
                this.cleanSystemPropertiesTable();
                ComponentTypeID id = (ComponentTypeID)config.getComponentType("Configuration").getID();
                Properties allprops = new Properties();
                allprops.putAll((Map<?, ?>)config.getDefaultPropertyValues(id));
                allprops.putAll((Map<?, ?>)config.getConfiguration().getProperties());
                this.insertSystemProperties(allprops);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e, "ERR.014.002.0157", PlatformPlugin.Util.getString("ERR.014.002.0157", new Object[]{config.getConfigurationID()}));
        }
    }

    @Override
    public synchronized void delete(ConfigurationID configID, String principal) throws ConfigurationException {
        try {
            boolean inUse = JDBCExtensionModuleReader.isNameInUse(configID.getFullName(), this.connection);
            if (inUse) {
                JDBCExtensionModuleWriter.removeSource(principal, configID.getFullName(), this.connection);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e, "ERR.014.002.0153", PlatformPlugin.Util.getString("ERR.014.002.0153", new Object[]{configID}));
        }
    }

    private ConfigurationModelContainer readExtensionConfiguration(ConfigurationID configID, boolean errorOnNotFound) throws ConfigurationException {
        try {
            byte[] data;
            if (this.connection == null) {
                Assertion.isNotNull((Object)this.connection, (String)PlatformPlugin.Util.getString("ERR.014.002.0152"));
            }
            if ((data = JDBCExtensionModuleReader.getSource(configID.getFullName(), this.connection)) == null) {
                throw new ConfigurationException("ERR.014.002.0154", PlatformPlugin.Util.getString("ERR.014.002.0154", new Object[]{configID}));
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            BufferedInputStream isContent = new BufferedInputStream(bais);
            ConfigurationModelContainer model = this.adapter.readConfigurationModel((InputStream)isContent, configID);
            return model;
        }
        catch (ExtensionModuleNotFoundException notFound) {
            if (errorOnNotFound) {
                throw new ConfigurationException((Throwable)notFound, "ERR.014.002.0154", PlatformPlugin.Util.getString("ERR.014.002.0154", new Object[]{configID}));
            }
            return null;
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e, "ERR.014.002.0155", PlatformPlugin.Util.getString("ERR.014.002.0155", new Object[]{configID}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void cleanSystemPropertiesTable() throws SQLException {
        String sql = null;
        Statement statement = null;
        try {
            sql = "DELETE  FROM CS_SYSTEM_PROPS";
            statement = this.connection.createStatement();
            statement.execute(sql);
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", new Object[]{sql}));
            }
            throw throwable;
        }
        try {
            statement.close();
            return;
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", new Object[]{sql}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void insertSystemProperties(Properties props) throws SQLException {
        String sql = null;
        PreparedStatement statement = null;
        try {
            sql = "INSERT  INTO CS_SYSTEM_PROPS(PROPERTY_NAME,Property_VALUE) VALUES (?,?)";
            statement = this.connection.prepareStatement(sql);
            for (String string : props.keySet()) {
                String value = ((String)props.get(string)).trim();
                statement.setString(1, string);
                if (value.length() > 255) {
                    value = value.substring(0, 255);
                }
                statement.setString(2, value);
                if (!statement.execute()) {
                    // empty if block
                }
                statement.clearParameters();
            }
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", new Object[]{sql}));
            }
            throw throwable;
        }
        try {
            statement.close();
            return;
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", new Object[]{sql}));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void updateStartupState(int from, int to) throws StartupStateException, ConfigurationException {
        String sql = null;
        PreparedStatement statement = null;
        try {
            sql = "UPDATE CFG_STARTUP_STATE  SET STATE= ?, LASTCHANGED= ? WHERE STATE= ? ";
            statement = this.connection.prepareStatement(sql);
            statement.setInt(1, to);
            statement.setString(2, DateUtil.getCurrentDateAsString());
            statement.setInt(3, from);
            statement.execute();
            int updateCount = statement.getUpdateCount();
            if (updateCount == 0) {
                int startupState = this.getServerState();
                throw new StartupStateException(2, startupState);
            }
            if (updateCount < 0) {
                throw new ConfigurationException("ERR.014.002.0158", PlatformPlugin.Util.getString("ERR.014.002.0158", new Object[]{sql}));
            }
            if (statement == null) return;
        }
        catch (SQLException e) {
            try {
                throw new ConfigurationException((Throwable)e, "ERR.014.002.0150", PlatformPlugin.Util.getString("ERR.014.002.0150", new Object[]{sql}));
                catch (Exception e2) {
                    if (e2 instanceof ConfigurationException) {
                        throw (ConfigurationException)((Object)e2);
                    }
                    if (!(e2 instanceof StartupStateException)) throw new ConfigurationException((Throwable)e2);
                    throw (StartupStateException)((Object)e2);
                }
            }
            catch (Throwable throwable) {
                if (statement == null) throw throwable;
                try {
                    statement.close();
                    throw throwable;
                }
                catch (SQLException e3) {
                    e3.printStackTrace();
                    System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", new Object[]{sql}));
                }
                throw throwable;
            }
        }
        try {
            statement.close();
            return;
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", new Object[]{sql}));
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void forceUpdateStartupState(int state) throws ConfigurationException {
        String sql = null;
        PreparedStatement statement = null;
        try {
            sql = "UPDATE CFG_STARTUP_STATE  SET STATE= ?, LASTCHANGED= ?";
            statement = this.connection.prepareStatement(sql);
            statement.setInt(1, state);
            statement.setString(2, DateUtil.getCurrentDateAsString());
            statement.execute();
            int updateCount = statement.getUpdateCount();
            if (updateCount <= 0) {
                throw new ConfigurationException("ERR.014.002.0158", PlatformPlugin.Util.getString("ERR.014.002.0158", new Object[]{sql}));
            }
            if (statement == null) return;
        }
        catch (SQLException e) {
            try {
                throw new ConfigurationException((Throwable)e, "ERR.014.002.0150", PlatformPlugin.Util.getString("ERR.014.002.0150", new Object[]{sql}));
                catch (Exception e2) {
                    if (!(e2 instanceof ConfigurationException)) throw new ConfigurationException((Throwable)e2);
                    throw (ConfigurationException)((Object)e2);
                }
            }
            catch (Throwable throwable) {
                if (statement == null) throw throwable;
                try {
                    statement.close();
                    throw throwable;
                }
                catch (SQLException e3) {
                    e3.printStackTrace();
                    System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", new Object[]{sql}));
                }
                throw throwable;
            }
        }
        try {
            statement.close();
            return;
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", new Object[]{sql}));
            return;
        }
    }

    @Override
    public void beginTransaction() throws ConfigurationException {
        try {
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    @Override
    public void commit() throws ConfigurationException {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            throw new ConfigurationException((Throwable)e);
        }
        finally {
            try {
                this.connection.setAutoCommit(true);
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public void rollback() throws ConfigurationException {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw new ConfigurationException((Throwable)e);
        }
        finally {
            try {
                this.connection.setAutoCommit(true);
            }
            catch (SQLException sQLException) {}
        }
    }
}

