/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.persistence.impl.jdbc;

import com.metamatrix.common.config.JDBCConnectionPoolHelper;
import com.metamatrix.common.config.api.exceptions.ConfigurationConnectionException;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.model.ConfigurationModelContainerAdapter;
import com.metamatrix.platform.config.persistence.api.PersistentConnection;
import com.metamatrix.platform.config.persistence.api.PersistentConnectionFactory;
import com.metamatrix.platform.config.persistence.impl.jdbc.JDBCPersistentConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class JDBCPersistentConnectionFactory
extends PersistentConnectionFactory {
    public static final String DRIVER = "metamatrix.config.jdbc.persistent.readerDriver";
    public static final String PROTOCOL = "metamatrix.config.jdbc.persistent.readerProtocol";
    public static final String DATABASE = "metamatrix.config.jdbc.persistent.readerDatabase";
    public static final String USERNAME = "metamatrix.config.jdbc.persistent.readerPrincipal";
    public static final String PASSWORD = "metamatrix.config.jdbc.persistent.readerPassword";

    public JDBCPersistentConnectionFactory(Properties factoryProperties) {
        super(factoryProperties);
    }

    @Override
    public PersistentConnection createPersistentConnection() throws ConfigurationException {
        Connection conn;
        try {
            conn = JDBCConnectionPoolHelper.getInstance().getConnection();
        }
        catch (SQLException e) {
            throw new ConfigurationConnectionException((Throwable)e);
        }
        ConfigurationModelContainerAdapter adapter = new ConfigurationModelContainerAdapter();
        JDBCPersistentConnection fps = new JDBCPersistentConnection(conn, adapter, this.getProperties());
        return fps;
    }
}

