/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.service;

import com.metamatrix.platform.PlatformPlugin;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ActionHistory {
    public static final int DEFAULT_ACTION_COUNT_LIMIT = 100;
    private LinkedList actions = new LinkedList();
    private LinkedList actionCountInTransactions = new LinkedList();
    private int actionCountLimit = 100;

    public synchronized void addActionsForTransaction(List newActions) {
        if (newActions == null || newActions.isEmpty()) {
            return;
        }
        Iterator iter = newActions.iterator();
        while (iter.hasNext()) {
            this.actions.addFirst(iter.next());
        }
        this.actionCountInTransactions.addFirst(new Integer(newActions.size()));
        this.pruneIfRequired();
    }

    public synchronized int getHistorySize() {
        return this.actions.size();
    }

    public synchronized List getHistory() {
        return this.actions;
    }

    public synchronized List pop(int count) {
        LinkedList result = new LinkedList();
        if (count > 0) {
            int actualCount = count;
            if (actualCount > this.actions.size()) {
                actualCount = this.actions.size();
            }
            for (int i = 0; i != actualCount; ++i) {
                result.add(this.actions.removeFirst());
            }
        }
        return result;
    }

    public int getHistoryLimit() {
        return this.actionCountLimit;
    }

    public synchronized void clearHistory() {
        this.actions.clear();
        this.actionCountInTransactions.clear();
    }

    public synchronized void setHistoryLimit(int newLimit) {
        if (newLimit < 0) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.002.0037"));
        }
        this.actionCountLimit = newLimit;
        this.pruneIfRequired();
    }

    protected void pruneIfRequired() {
        Integer countInEarliestTransaction;
        int numberToBeRemoved;
        int newSize = this.actions.size();
        if (newSize > this.actionCountLimit && newSize - (numberToBeRemoved = (countInEarliestTransaction = (Integer)this.actionCountInTransactions.getLast()).intValue()) > this.actionCountLimit) {
            for (int i = 0; i != numberToBeRemoved; ++i) {
                this.actions.removeLast();
            }
            this.actionCountInTransactions.removeLast();
        }
    }
}

