/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.service;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.actions.ActionDefinition;
import com.metamatrix.common.actions.AddObject;
import com.metamatrix.common.actions.CreateObject;
import com.metamatrix.common.actions.ModificationException;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ReleaseInfo;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefnID;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.api.exceptions.ConfigurationLockException;
import com.metamatrix.common.config.api.exceptions.InvalidArgumentException;
import com.metamatrix.common.config.api.exceptions.InvalidConfigurationException;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.config.model.ComponentCryptoUtil;
import com.metamatrix.common.config.xml.XMLConfigurationImportExportUtility;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.connection.TransactionMgr;
import com.metamatrix.common.log.I18nLogManager;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.util.ApplicationInfo;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.config.api.service.ConfigurationServiceInterface;
import com.metamatrix.platform.config.service.ActionHistory;
import com.metamatrix.platform.config.spi.ConfigurationTransaction;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.service.controller.AbstractService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ConfigurationServiceImpl
extends AbstractService
implements ConfigurationServiceInterface {
    private TransactionMgr transMgr;
    private ActionHistory actionHistory = new ActionHistory();
    private static final String CONTEXT = "CONFIG";
    private static BasicConfigurationObjectEditor editor = new BasicConfigurationObjectEditor(false);

    public void initializeForTesting(Properties env) throws Exception {
        this.initService(env);
    }

    @Override
    protected void initService(Properties env) throws Exception {
        try {
            if (env.getProperty("metamatrix.config.connection.Factory") == null) {
                env.setProperty("metamatrix.config.connection.Factory", "com.metamatrix.platform.config.spi.xml.XMLConfigurationConnectorFactory");
            }
            env.setProperty("metamatrix.common.connection.transaction.factory", env.getProperty("metamatrix.config.connection.Factory"));
            this.transMgr = new TransactionMgr(env, this.getInstanceName());
            I18nLogManager.logInfo(CONTEXT, "MSG.014.002.0002", new Object[]{this.getInstanceName()});
        }
        catch (ManagedConnectionException e) {
            throw new ConfigurationException((Throwable)((Object)e));
        }
    }

    @Override
    protected void closeService() throws Exception {
        String instanceName = this.getInstanceName().toString();
        LogManager.logDetail((String)CONTEXT, (Object[])new Object[]{instanceName + ": closing"});
        I18nLogManager.logInfo(CONTEXT, "MSG.014.002.0003", new Object[]{instanceName});
    }

    @Override
    protected void waitForServiceToClear() throws Exception {
    }

    @Override
    protected void killService() {
    }

    @Override
    public ConfigurationObjectEditor createEditor() throws ConfigurationException {
        return new BasicConfigurationObjectEditor(true);
    }

    @Override
    public ConfigurationID getCurrentConfigurationID() throws ConfigurationException {
        return this.getDesignatedConfigurationID("Next Startup");
    }

    @Override
    public ConfigurationID getNextStartupConfigurationID() throws ConfigurationException {
        return this.getDesignatedConfigurationID("Next Startup");
    }

    @Override
    public void baselineCurrentConfiguration(String principalName) throws ConfigurationException {
        throw new UnsupportedOperationException(PlatformPlugin.Util.getString("ERR.014.002.0049"));
    }

    @Override
    public ConfigurationID getStartupConfigurationID() throws ConfigurationException {
        return this.getDesignatedConfigurationID("Startup");
    }

    @Override
    public Configuration getCurrentConfiguration() throws ConfigurationException {
        return this.getDesignatedConfiguration("Next Startup");
    }

    @Override
    public Configuration getNextStartupConfiguration() throws ConfigurationException {
        return this.getDesignatedConfiguration("Next Startup");
    }

    @Override
    public Configuration getStartupConfiguration() throws ConfigurationException {
        return this.getDesignatedConfiguration("Startup");
    }

    private Configuration getDesignatedConfiguration(String designation) throws ConfigurationException {
        Configuration config;
        block11: {
            config = null;
            ConfigurationTransaction transaction = null;
            try {
                transaction = this.getReadTransaction();
                config = transaction.getDesignatedConfiguration(designation);
                if (config != null) {
                    LogManager.logDetail((String)CONTEXT, (Object[])new Object[]{"Found " + designation + " configuration " + config.getName()});
                    break block11;
                }
                LogManager.logDetail((String)CONTEXT, (Object[])new Object[]{"No " + designation + " configuration found "});
                throw new ConfigurationException("No " + designation + " configuration was found");
            }
            catch (ManagedConnectionException e) {
                throw new ConfigurationException((Throwable)((Object)e), "ERR.014.002.0040", PlatformPlugin.Util.getString("ERR.014.002.0040", new Object[]{designation}));
            }
            finally {
                if (transaction != null) {
                    try {
                        transaction.close();
                    }
                    catch (Exception txne) {
                        I18nLogManager.logError(CONTEXT, "ERR.014.002.0041", txne);
                    }
                    transaction = null;
                }
            }
        }
        return config;
    }

    private ConfigurationID getDesignatedConfigurationID(String designation) throws ConfigurationException {
        ConfigurationID configID;
        block11: {
            configID = null;
            ConfigurationTransaction transaction = null;
            try {
                transaction = this.getReadTransaction();
                configID = transaction.getDesignatedConfigurationID(designation);
                if (configID != null) {
                    LogManager.logTrace((String)CONTEXT, (Object[])new Object[]{"Found " + designation + " configuration id " + configID});
                    break block11;
                }
                throw new ConfigurationException("ERR.014.002.0042", PlatformPlugin.Util.getString("ERR.014.002.0042"));
            }
            catch (ManagedConnectionException e) {
                throw new ConfigurationException((Throwable)((Object)e), "ERR.014.002.0042", PlatformPlugin.Util.getString("ERR.014.002.0042"));
            }
            finally {
                if (transaction != null) {
                    try {
                        transaction.close();
                    }
                    catch (Exception txne) {
                        I18nLogManager.logError(CONTEXT, "ERR.014.002.0041", txne);
                    }
                    transaction = null;
                }
            }
        }
        return configID;
    }

    @Override
    public ConfigurationModelContainer getConfigurationModel(String configName) throws InvalidConfigurationException, ConfigurationException {
        ConfigurationModelContainer config = null;
        ConfigurationTransaction transaction = null;
        try {
            transaction = this.getReadTransaction();
            config = transaction.getConfigurationModel(configName);
            if (config != null) {
            } else {
                LogManager.logTrace((String)CONTEXT, (Object[])new Object[]{"No configuration model found"});
            }
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e, "ERR.014.002.0043", PlatformPlugin.Util.getString("ERR.014.002.0043"));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    I18nLogManager.logError(CONTEXT, "ERR.014.002.0041", txne);
                }
                transaction = null;
            }
        }
        return config;
    }

    @Override
    public Configuration getConfiguration(String configName) throws InvalidConfigurationException, ConfigurationException {
        if (configName == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.002.0045", new Object[]{"configName"}));
        }
        Configuration config = null;
        ConfigurationTransaction transaction = null;
        try {
            transaction = this.getReadTransaction();
            config = transaction.getConfiguration(configName);
            if (config != null) {
                LogManager.logDetail((String)CONTEXT, (Object[])new Object[]{"Found current configuration " + configName});
            } else {
                LogManager.logTrace((String)CONTEXT, (Object[])new Object[]{"No current configuration found for " + configName});
            }
        }
        catch (ManagedConnectionException e) {
            throw new ConfigurationException((Throwable)((Object)e), "ERR.014.002.0044", PlatformPlugin.Util.getString("ERR.014.002.0044", new Object[]{configName}));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    I18nLogManager.logError(CONTEXT, "ERR.014.002.0041", txne);
                }
                transaction = null;
            }
        }
        return config;
    }

    @Override
    public Collection getConfigurationAndDependents(ConfigurationID configID) throws ConfigurationException {
        if (configID == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.002.0045", new Object[]{"configID"}));
        }
        Collection result = null;
        ConfigurationTransaction transaction = null;
        try {
            transaction = this.getReadTransaction();
            Collection collection = result = transaction.getAllObjectsForConfigurationModel(configID);
            return collection;
        }
        catch (ManagedConnectionException e) {
            throw new ConfigurationException((Throwable)((Object)e), "ERR.014.002.0046", PlatformPlugin.Util.getString("ERR.014.002.0046", new Object[]{configID}));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    I18nLogManager.logError(CONTEXT, "ERR.014.002.0041", txne);
                }
                transaction = null;
            }
        }
    }

    @Override
    public Collection getAllGlobalConfigObjects() throws ConfigurationException {
        ArrayList allObjects = new ArrayList();
        ConfigurationTransaction transaction = null;
        try {
            transaction = this.getReadTransaction();
            allObjects.addAll(transaction.getAllComponentTypes(true));
            allObjects.addAll(transaction.getProductTypes(true));
            allObjects.addAll(transaction.getHosts());
        }
        catch (ManagedConnectionException e) {
            throw new ConfigurationException((Throwable)((Object)e), "ERR.014.002.0047", PlatformPlugin.Util.getString("ERR.014.002.0047"));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    I18nLogManager.logError(CONTEXT, "ERR.014.002.0041", txne);
                }
                transaction = null;
            }
        }
        return allObjects;
    }

    @Override
    public ComponentType getComponentType(ComponentTypeID id) throws ConfigurationException {
        if (id == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.002.0045", new Object[]{"id"}));
        }
        ComponentType type = null;
        ConfigurationTransaction transaction = null;
        try {
            transaction = this.getReadTransaction();
            type = transaction.getComponentType(id);
            if (type != null) {
                LogManager.logDetail((String)CONTEXT, (Object[])new Object[]{"Found component type " + id});
            } else {
                LogManager.logDetail((String)CONTEXT, (Object[])new Object[]{"No component type found for " + id});
            }
        }
        catch (ManagedConnectionException e) {
            throw new ConfigurationException((Throwable)((Object)e), "ERR.014.002.0048", PlatformPlugin.Util.getString("ERR.014.002.0048", new Object[]{"id"}));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    I18nLogManager.logError(CONTEXT, "ERR.014.002.0041", txne);
                }
                transaction = null;
            }
        }
        return type;
    }

    @Override
    public Collection getAllComponentTypes(boolean includeDeprecated) throws ConfigurationException {
        Collection result;
        block11: {
            ConfigurationTransaction transaction = null;
            result = new LinkedList();
            try {
                transaction = this.getReadTransaction();
                result = transaction.getAllComponentTypes(includeDeprecated);
                if (result != null && result.size() > 0) {
                    LogManager.logDetail((String)CONTEXT, (Object[])new Object[]{"Found all component types"});
                    break block11;
                }
                throw new ConfigurationException("ERR.014.002.0049", PlatformPlugin.Util.getString("ERR.014.002.0049"));
            }
            catch (ManagedConnectionException e) {
                throw new ConfigurationException((Throwable)((Object)e), "ERR.014.002.0049", PlatformPlugin.Util.getString("ERR.014.002.0049"));
            }
            finally {
                if (transaction != null) {
                    try {
                        transaction.close();
                    }
                    catch (Exception txne) {
                        I18nLogManager.logError(CONTEXT, "ERR.014.002.0041", txne);
                    }
                    transaction = null;
                }
            }
        }
        return result;
    }

    @Override
    public Collection getMonitoredComponentTypes(boolean includeDeprecated) throws ConfigurationException {
        ConfigurationTransaction transaction = null;
        ArrayList result = null;
        try {
            transaction = this.getReadTransaction();
            result = transaction.getMonitoredComponentTypes(includeDeprecated);
            if (result != null && result.size() > 0) {
                LogManager.logDetail((String)CONTEXT, (Object[])new Object[]{"Found monitored component types"});
            } else {
                LogManager.logTrace((String)CONTEXT, (Object[])new Object[]{"No monitored component types found"});
                result = new ArrayList(1);
            }
        }
        catch (ManagedConnectionException e) {
            throw new ConfigurationException((Throwable)((Object)e), "ERR.014.002.0050", PlatformPlugin.Util.getString("ERR.014.002.0050"));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    I18nLogManager.logError(CONTEXT, "ERR.014.002.0041", txne);
                }
                transaction = null;
            }
        }
        return result;
    }

    @Override
    public Collection getComponentTypeDefinitions(ComponentTypeID componentTypeID) throws ConfigurationException {
        ConfigurationTransaction transaction = null;
        ArrayList result = null;
        try {
            transaction = this.getReadTransaction();
            result = transaction.getComponentTypeDefinitions(componentTypeID);
            if (result != null && result.size() > 0) {
                LogManager.logDetail((String)CONTEXT, (Object[])new Object[]{"Found component type definitions for ", componentTypeID});
            } else {
                LogManager.logTrace((String)CONTEXT, (Object[])new Object[]{"Couldn't find component type definitions for ", componentTypeID});
            }
        }
        catch (ManagedConnectionException e) {
            throw new ConfigurationException((Throwable)((Object)e), "ERR.014.002.0051", PlatformPlugin.Util.getString("ERR.014.002.0051", new Object[]{componentTypeID}));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    I18nLogManager.logError(CONTEXT, "ERR.014.002.0041", txne);
                }
                transaction = null;
            }
        }
        if (result == null) {
            result = new ArrayList(1);
        }
        return result;
    }

    @Override
    public Map getComponentTypeDefinitions(Collection componentIDs) throws ConfigurationException {
        HashMap<ComponentTypeID, Collection> map = new HashMap<ComponentTypeID, Collection>();
        ComponentTypeID id = null;
        for (Object obj : componentIDs) {
            if (obj instanceof ComponentTypeID) {
                id = (ComponentTypeID)obj;
            } else {
                if (!(obj instanceof ComponentType)) continue;
                ComponentType type = (ComponentType)obj;
                id = type.getID();
            }
            Collection defns = this.getComponentTypeDefinitions(id);
            map.put(id, defns);
        }
        return map;
    }

    @Override
    public Map getDependentComponentTypeDefinitions(Collection componentIDs) throws ConfigurationException {
        ConfigurationTransaction transaction = null;
        HashMap<ComponentTypeID, Collection> map = new HashMap<ComponentTypeID, Collection>(componentIDs.size());
        ComponentTypeID id = null;
        try {
            transaction = this.getReadTransaction();
            for (Object obj : componentIDs) {
                if (obj instanceof ComponentTypeID) {
                    id = (ComponentTypeID)obj;
                } else {
                    if (!(obj instanceof ComponentType)) continue;
                    ComponentType type = (ComponentType)obj;
                    id = type.getID();
                }
                Collection defns = this.getDependentComponentTypeDefinitions(transaction, id);
                map.put(id, defns);
            }
        }
        catch (ManagedConnectionException e) {
            throw new ConfigurationException((Throwable)((Object)e), "ERR.014.002.0052", PlatformPlugin.Util.getString("ERR.014.002.0052"));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    I18nLogManager.logError(CONTEXT, "ERR.014.002.0041", txne);
                }
                transaction = null;
            }
        }
        return map;
    }

    @Override
    public Collection getDependentComponentTypeDefinitions(ComponentTypeID componentTypeID) throws ConfigurationException {
        ConfigurationTransaction transaction = null;
        try {
            Collection defns;
            transaction = this.getReadTransaction();
            Collection collection = defns = this.getDependentComponentTypeDefinitions(transaction, componentTypeID);
            return collection;
        }
        catch (ManagedConnectionException e) {
            throw new ConfigurationException((Throwable)((Object)e), "ERR.014.002.0052", PlatformPlugin.Util.getString("ERR.014.002.0052"));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    I18nLogManager.logError(CONTEXT, "ERR.014.002.0041", txne);
                }
                transaction = null;
            }
        }
    }

    private Collection getDependentComponentTypeDefinitions(ConfigurationTransaction transaction, ComponentTypeID componentTypeID) throws ConfigurationException {
        ArrayList result = null;
        Collection types = transaction.getAllComponentTypes(false);
        result = this.getSuperComponentTypeDefinitions(null, null, types, componentTypeID, transaction);
        if (result != null && result.size() > 0) {
            LogManager.logDetail((String)CONTEXT, (Object[])new Object[]{"Found dependent component type definitions for ", componentTypeID});
        } else {
            result = new ArrayList(1);
        }
        return result;
    }

    private Collection getSuperComponentTypeDefinitions(Map defnMap, Collection defns, Collection componentTypes, ComponentTypeID componentTypeID, ConfigurationTransaction transaction) throws ConfigurationException {
        if (defnMap == null) {
            defnMap = new HashMap<PropertyDefinition, ComponentTypeDefn>();
        }
        if (defns == null) {
            defns = new ArrayList<ComponentTypeDefn>();
        }
        ComponentType type = null;
        for (ComponentType ct : componentTypes) {
            if (!componentTypeID.equals((Object)ct.getID())) continue;
            type = ct;
        }
        if (type == null) {
            throw new ConfigurationException("ERR.014.002.0053", PlatformPlugin.Util.getString("ERR.014.002.0053", new Object[]{componentTypeID}));
        }
        if (type.getSuperComponentTypeID() == null) {
            return defns;
        }
        Collection superDefns = transaction.getComponentTypeDefinitions(type.getSuperComponentTypeID());
        if (superDefns != null && superDefns.size() > 0) {
            for (ComponentTypeDefn sDefn : superDefns) {
                if (defnMap.containsKey(sDefn.getPropertyDefinition())) continue;
                defnMap.put(sDefn.getPropertyDefinition(), sDefn);
                defns.add(sDefn);
            }
        }
        return this.getSuperComponentTypeDefinitions(defnMap, defns, componentTypes, type.getSuperComponentTypeID(), transaction);
    }

    @Override
    public Collection getAllComponentTypeDefinitions(ComponentTypeID typeID) throws ConfigurationException {
        Collection defns = this.getComponentTypeDefinitions(typeID);
        Collection inheritedDefns = this.getDependentComponentTypeDefinitions(typeID);
        Iterator inheritedIter = inheritedDefns.iterator();
        Iterator localIter = defns.iterator();
        ComponentTypeDefn inheritedDefn = null;
        ComponentTypeDefn localDefn = null;
        while (localIter.hasNext()) {
            localDefn = (ComponentTypeDefn)localIter.next();
            while (inheritedIter.hasNext()) {
                inheritedDefn = (ComponentTypeDefn)inheritedIter.next();
                if (!localDefn.getPropertyDefinition().equals(inheritedDefn.getPropertyDefinition())) continue;
                inheritedIter.remove();
            }
            inheritedIter = inheritedDefns.iterator();
        }
        defns.addAll(inheritedDefns);
        return defns;
    }

    @Override
    public Host getHost(HostID hostID) throws ConfigurationException {
        if (hostID == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.002.0045", new Object[]{"hostID"}));
        }
        Collection hosts = this.getHosts();
        for (Host h : hosts) {
            if (!h.getID().equals((Object)hostID)) continue;
            return h;
        }
        return null;
    }

    @Override
    public Collection getHosts() throws ConfigurationException {
        Collection hosts = null;
        ConfigurationTransaction transaction = null;
        try {
            transaction = this.getReadTransaction();
            hosts = transaction.getHosts();
        }
        catch (ManagedConnectionException e) {
            throw new ConfigurationException((Throwable)((Object)e), "ERR.014.002.0055", PlatformPlugin.Util.getString("ERR.014.002.0055"));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    I18nLogManager.logError(CONTEXT, "ERR.014.002.0041", txne);
                }
                transaction = null;
            }
        }
        if (hosts == null) {
            hosts = Collections.EMPTY_LIST;
        }
        return hosts;
    }

    @Override
    public Collection getComponentDefns(Collection componentDefnIDs, ConfigurationID configurationID) throws ConfigurationException {
        if (componentDefnIDs == null || componentDefnIDs.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ComponentDefn> defns = new ArrayList<ComponentDefn>(componentDefnIDs.size());
        ConfigurationTransaction transaction = null;
        try {
            transaction = this.getReadTransaction();
            ComponentDefn defn = null;
            for (ComponentDefnID id : componentDefnIDs) {
                defn = transaction.getComponentDefinition(id, configurationID);
                if (defn == null) continue;
                defns.add(defn);
            }
        }
        catch (ManagedConnectionException e) {
            throw new ConfigurationException((Throwable)((Object)e), "ERR.014.002.0056", PlatformPlugin.Util.getString("ERR.014.002.0056"));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    I18nLogManager.logError(CONTEXT, "ERR.014.002.0057", txne);
                }
                transaction = null;
            }
        }
        return defns;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ComponentDefn getComponentDefn(ConfigurationID configurationID, ComponentDefnID componentDefnID) throws ConfigurationException {
        ConfigurationTransaction transaction = null;
        ComponentDefn defn = null;
        try {
            transaction = this.getReadTransaction();
            defn = transaction.getComponentDefinition(componentDefnID, configurationID);
            if (transaction == null) return defn;
        }
        catch (ManagedConnectionException e) {
            try {
                throw new ConfigurationException((Throwable)((Object)e), "ERR.014.002.0058", PlatformPlugin.Util.getString("ERR.014.002.0058", new Object[]{componentDefnID.getName()}));
            }
            catch (Throwable throwable) {
                if (transaction == null) throw throwable;
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    I18nLogManager.logError(CONTEXT, "ERR.014.002.0059", (Throwable)txne, new Object[]{componentDefnID.getName()});
                }
                transaction = null;
                throw throwable;
            }
        }
        try {
            transaction.close();
        }
        catch (Exception txne) {
            I18nLogManager.logError(CONTEXT, "ERR.014.002.0059", (Throwable)txne, new Object[]{componentDefnID.getName()});
        }
        transaction = null;
        return defn;
    }

    @Override
    public Collection getResources() throws ConfigurationException {
        ConfigurationTransaction transaction = null;
        try {
            transaction = this.getReadTransaction();
            Collection collection = transaction.getResources();
            return collection;
        }
        catch (ManagedConnectionException e) {
            throw new ConfigurationException((Throwable)((Object)e), "ERR.014.002.0060", PlatformPlugin.Util.getString("ERR.014.002.0060"));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    I18nLogManager.logError(CONTEXT, "ERR.014.002.0061", txne);
                }
                transaction = null;
            }
        }
    }

    @Override
    public Collection getResources(ComponentTypeID componentTypeID) throws ConfigurationException {
        ConfigurationTransaction transaction = null;
        try {
            transaction = this.getReadTransaction();
            Collection collection = transaction.getResources(componentTypeID);
            return collection;
        }
        catch (ManagedConnectionException e) {
            throw new ConfigurationException((Throwable)((Object)e), "ERR.014.002.0060", PlatformPlugin.Util.getString("ERR.014.002.0060"));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    I18nLogManager.logError(CONTEXT, "ERR.014.002.0061", txne);
                }
                transaction = null;
            }
        }
    }

    @Override
    public void saveResources(Collection resourceDescriptors, String principalName) throws ConfigurationException {
        ConfigurationTransaction transaction = null;
        boolean success = false;
        try {
            transaction = this.getWriteTransaction();
            transaction.saveResources(resourceDescriptors, principalName);
            transaction.commit();
            success = true;
        }
        catch (ManagedConnectionException e) {
            throw new ConfigurationException((Throwable)((Object)e));
        }
        finally {
            if (transaction != null) {
                if (!success) {
                    try {
                        transaction.rollback();
                    }
                    catch (Exception e2) {
                        I18nLogManager.logError(CONTEXT, "ERR.014.002.0063", e2);
                    }
                }
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    I18nLogManager.logError(CONTEXT, "ERR.014.002.0041", txne);
                }
            }
        }
    }

    @Override
    public Collection getProductReleaseInfos() throws ConfigurationException {
        ApplicationInfo build = ApplicationInfo.getInstance();
        ReleaseInfo info = new ReleaseInfo("Server", build.getReleaseNumber(), build.getBuildDate(), build.getBuildNumber());
        ArrayList<ReleaseInfo> l = new ArrayList<ReleaseInfo>();
        l.add(info);
        return l;
    }

    @Override
    public Set executeTransaction(ActionDefinition action, String principalName) throws ModificationException, ConfigurationLockException, ConfigurationException {
        if (action == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.002.0045", new Object[]{"action"}));
        }
        ArrayList<ActionDefinition> actions = new ArrayList<ActionDefinition>(1);
        actions.add(action);
        return this.executeTransaction(actions, principalName);
    }

    @Override
    public Set executeTransaction(List actions, String principalName) throws ModificationException, ConfigurationLockException, ConfigurationException {
        if (actions == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.002.0045", new Object[]{"actions"}));
        }
        LogManager.logDetail((String)CONTEXT, (Object[])new Object[]{"Executing transaction for user ", principalName, " with ", new Integer(actions.size()), " action(s)"});
        Set result = new HashSet();
        if (actions.isEmpty()) {
            return result;
        }
        ConfigurationTransaction transaction = null;
        try {
            transaction = this.getWriteTransaction();
            result = transaction.executeActions(actions, principalName);
            transaction.commit();
            this.actionHistory.addActionsForTransaction(actions);
        }
        catch (ConfigurationLockException e) {
            try {
                if (transaction != null) {
                    transaction.rollback();
                }
            }
            catch (Exception e2) {
                I18nLogManager.logError(CONTEXT, "ERR.014.002.0065", (Throwable)e, new Object[]{principalName, this.printActions(actions)});
            }
            throw e;
        }
        catch (ConfigurationException e) {
            try {
                if (transaction != null) {
                    transaction.rollback();
                }
            }
            catch (Exception e2) {
                I18nLogManager.logError(CONTEXT, "ERR.014.002.0065", (Throwable)e, new Object[]{principalName, this.printActions(actions)});
            }
            throw e;
        }
        catch (Exception e) {
            try {
                if (transaction != null) {
                    transaction.rollback();
                }
            }
            catch (Exception e2) {
                I18nLogManager.logError(CONTEXT, "ERR.014.002.0065", (Throwable)e, new Object[]{principalName, this.printActions(actions)});
            }
            throw new ConfigurationException((Throwable)e);
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    I18nLogManager.logError(CONTEXT, "ERR.014.002.0041", txne);
                }
                transaction = null;
            }
        }
        return result;
    }

    @Override
    public Set executeInsertTransaction(ConfigurationID assignConfigurationID, List actions, String principalName) throws ModificationException, ConfigurationLockException, ConfigurationException {
        if (actions == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.002.0045", new Object[]{"actions"}));
        }
        ActionDefinition currentAction = null;
        Iterator iter = actions.iterator();
        boolean chk = false;
        while (iter.hasNext()) {
            currentAction = (ActionDefinition)iter.next();
            if (currentAction instanceof CreateObject) {
                chk = true;
            } else if (currentAction instanceof AddObject) {
                chk = false;
            } else {
                throw new ModificationException("ERR.014.002.0066", PlatformPlugin.Util.getString("ERR.014.002.0066"));
            }
            if (!chk || assignConfigurationID == null) continue;
            Object[] args = currentAction.getArguments();
            Object argObj = args[0];
            editor.assignConfigurationID(argObj, assignConfigurationID);
        }
        return this.executeTransaction(actions, principalName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set undoActionsAsTransaction(int numberOfActions, String principalName) throws ConfigurationException {
        if (numberOfActions < 0) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.002.0068", new Object[]{numberOfActions}));
        }
        LogManager.logDetail((String)CONTEXT, (Object[])new Object[]{"Undoing ", new Integer(numberOfActions), " action(s)"});
        Set result = null;
        ActionHistory actionHistory = this.actionHistory;
        synchronized (actionHistory) {
            List actions = this.actionHistory.pop(numberOfActions);
            ArrayList<ActionDefinition> undoActions = new ArrayList<ActionDefinition>();
            for (ActionDefinition action : actions) {
                undoActions.add(action.getUndoActionDefinition());
            }
            try {
                result = this.executeTransaction(undoActions, principalName);
                I18nLogManager.logInfo(CONTEXT, "MSG.014.002.0004", new Object[]{new Integer(numberOfActions)});
            }
            catch (ConfigurationException e) {
                this.actionHistory.addActionsForTransaction(actions);
                throw e;
            }
            catch (ModificationException e) {
                ConfigurationException me = new ConfigurationException((Throwable)e, "ERR.014.002.0069", PlatformPlugin.Util.getString("ERR.014.002.0069"));
                this.actionHistory.addActionsForTransaction(actions);
                throw me;
            }
        }
        return result;
    }

    @Override
    public List getHistory() throws ConfigurationException {
        return this.actionHistory.getHistory();
    }

    @Override
    public void clearHistory() throws ConfigurationException {
        this.actionHistory.clearHistory();
    }

    @Override
    public int getHistorySize() throws ConfigurationException {
        return this.actionHistory.getHistorySize();
    }

    @Override
    public int getHistoryLimit() throws ConfigurationException {
        return this.actionHistory.getHistoryLimit();
    }

    @Override
    public void setHistoryLimit(int maximumHistoryCount) throws ConfigurationException {
        this.actionHistory.setHistoryLimit(maximumHistoryCount);
    }

    @Override
    public Date getServerStartupTime() throws ConfigurationException {
        ConfigurationTransaction transaction = null;
        Date timestamp = null;
        try {
            transaction = this.getReadTransaction();
            timestamp = transaction.getServerStartupTime();
        }
        catch (ManagedConnectionException e) {
            throw new ConfigurationException((Throwable)((Object)e), "ERR.014.002.0070", PlatformPlugin.Util.getString("ERR.014.002.0070"));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    I18nLogManager.logError(CONTEXT, "ERR.014.002.0041", txne);
                }
                transaction = null;
            }
        }
        return timestamp;
    }

    protected void addProperty(Properties source, String sourceName, Properties props, String propName) {
        String value = source.getProperty(sourceName);
        if (value != null) {
            props.setProperty(propName, value);
        }
    }

    protected String printActions(List actions) {
        StringBuffer sb = new StringBuffer();
        Iterator iter = actions.iterator();
        if (iter.hasNext()) {
            sb.append(iter.next().toString());
        }
        while (iter.hasNext()) {
            sb.append("; ");
            sb.append(iter.next().toString());
        }
        return sb.toString();
    }

    protected ConfigurationTransaction getReadTransaction() throws ManagedConnectionException {
        return (ConfigurationTransaction)this.transMgr.getReadTransaction();
    }

    protected ConfigurationTransaction getWriteTransaction() throws ManagedConnectionException {
        return (ConfigurationTransaction)this.transMgr.getWriteTransaction();
    }

    @Override
    public Host addHost(String hostName, String principalName, Properties properties) throws ConfigurationException {
        Host host = null;
        ConfigurationObjectEditor editor = null;
        try {
            editor = this.createEditor();
            ConfigurationModelContainer config = this.getConfigurationModel("Next Startup");
            Properties defaultProps = config.getDefaultPropertyValues(Host.HOST_COMPONENT_TYPE_ID);
            Properties allProps = PropertiesUtils.clone((Properties)defaultProps, (boolean)false);
            allProps.putAll((Map<?, ?>)properties);
            host = editor.createHost(hostName);
            host = (Host)editor.modifyProperties((ComponentObject)host, allProps, 0);
            this.executeTransaction(editor.getDestination().popActions(), principalName);
        }
        catch (Exception theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            Object[] params = new Object[]{hostName};
            String msg = PlatformPlugin.Util.getString("ConfigurationServiceImpl.Error_creating_New_Host", params);
            throw new ConfigurationException((Throwable)theException, msg);
        }
        return host;
    }

    @Override
    public VMComponentDefn addProcess(String processName, String hostName, String principalName, Properties properties) throws ConfigurationException {
        VMComponentDefn processDefn = null;
        ConfigurationObjectEditor editor = null;
        try {
            ConfigurationModelContainer config = this.getConfigurationModel("Next Startup");
            editor = this.createEditor();
            Host host = this.getHost(new HostID(hostName));
            if (host == null) {
                Object[] params = new Object[]{hostName};
                String msg = PlatformPlugin.Util.getString("ConfigurationServiceImpl.Host_not_found", params);
                throw new ConfigurationException(msg);
            }
            Properties defaultProps = config.getDefaultPropertyValues(VMComponentDefn.VM_COMPONENT_TYPE_ID);
            processDefn = editor.createVMComponentDefn(config.getConfiguration(), (HostID)host.getID(), VMComponentDefn.VM_COMPONENT_TYPE_ID, processName);
            Properties allProps = PropertiesUtils.clone((Properties)defaultProps, (boolean)false);
            allProps.putAll((Map<?, ?>)properties);
            if (processDefn != null) {
                processDefn = (VMComponentDefn)editor.modifyProperties((ComponentObject)processDefn, allProps, 0);
                this.executeTransaction(editor.getDestination().popActions(), principalName);
            }
        }
        catch (Exception theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            Object[] params = new Object[]{processName, hostName};
            String msg = PlatformPlugin.Util.getString("ConfigurationServiceImpl.Error_creating_Process", params);
            throw new ConfigurationException((Throwable)theException, msg);
        }
        return processDefn;
    }

    @Override
    public void setSystemPropertyValue(String propertyName, String propertyValue, String principalName) throws ConfigurationException {
        ConfigurationObjectEditor editor = null;
        try {
            editor = this.createEditor();
            Configuration nextStartupConfig = this.getNextStartupConfiguration();
            editor.setProperty((ComponentObject)nextStartupConfig, propertyName, propertyValue);
            this.executeTransaction(editor.getDestination().popActions(), principalName);
        }
        catch (Exception theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            Object[] params = new Object[]{propertyName, theException.getMessage()};
            String msg = PlatformPlugin.Util.getString("ConfigurationServiceImpl.Error_setting_Property", params);
            throw new ConfigurationException((Throwable)theException, msg);
        }
    }

    @Override
    public void updateSystemPropertyValues(Properties properties, String principalName) throws ConfigurationException {
        ConfigurationObjectEditor editor = null;
        try {
            editor = this.createEditor();
            Configuration nextStartupConfig = this.getNextStartupConfiguration();
            for (String string : properties.keySet()) {
                String value = properties.getProperty(string);
                editor.setProperty((ComponentObject)nextStartupConfig, string, value);
            }
            this.executeTransaction(editor.getDestination().popActions(), principalName);
        }
        catch (Exception theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            Object[] params = new Object[]{theException.getMessage(), properties};
            String string = PlatformPlugin.Util.getString("ConfigurationServiceImpl.Error_updating_Properties", params);
            throw new ConfigurationException((Throwable)theException, string);
        }
    }

    @Override
    public ConnectorBinding createConnectorBinding(String connectorBindingName, String connectorType, String pscName, String principalName, Properties properties) throws ConfigurationException {
        ConnectorBinding binding = null;
        ConfigurationObjectEditor editor = null;
        Configuration config = null;
        try {
            ComponentType ctConnector = this.getComponentType(connectorType, false);
            if (ctConnector == null) {
                Object[] params = new Object[]{connectorType};
                String msg = PlatformPlugin.Util.getString("ConfigurationServiceImpl.Connector_Type_not_found", params);
                throw new MetaMatrixComponentException(msg);
            }
            editor = this.createEditor();
            config = this.getNextStartupConfiguration();
            editor.createServiceComponentDefn((ConfigurationID)config.getID(), (ComponentTypeID)ctConnector.getID(), connectorBindingName);
            binding = this.createConnectorBinding(ctConnector, editor, connectorBindingName);
            binding = (ConnectorBinding)editor.modifyProperties((ComponentObject)binding, properties, 0);
            if (pscName != null && !pscName.equals("")) {
                ProductServiceConfig psc = this.getPSCByName(config, pscName);
                ServiceComponentDefnID bindingID = (ServiceComponentDefnID)binding.getID();
                editor.addServiceComponentDefn(psc, bindingID);
                editor.deployServiceDefn(config, (ServiceComponentDefn)binding, (ProductServiceConfigID)psc.getID());
            }
            this.executeTransaction(editor.getDestination().popActions(), principalName);
        }
        catch (Exception theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            Object[] params = new Object[]{this.getClass().getName(), theException.getMessage()};
            throw new ConfigurationException((Throwable)theException, PlatformPlugin.Util.getString("ConfigurationServiceImpl.Error_creating_Connector_Binding", params));
        }
        return binding;
    }

    private ComponentType getComponentType(String connectorName, boolean deprecated) throws InvalidSessionException, AuthorizationException, ConfigurationException, MetaMatrixComponentException {
        Collection arylConnectors = this.getAllComponentTypes(deprecated);
        for (ComponentType ctConnector : arylConnectors) {
            if (!ctConnector.getName().equals(connectorName)) continue;
            return ctConnector;
        }
        return null;
    }

    private ProductServiceConfig getPSCByName(Configuration config, String pscName) throws InvalidArgumentException {
        ProductServiceConfig result = null;
        if (config != null) {
            ProductServiceConfigID pscID = new ProductServiceConfigID((ConfigurationID)config.getID(), pscName);
            result = config.getPSC((ComponentDefnID)pscID);
        }
        return result;
    }

    private ConnectorBinding createConnectorBinding(ComponentType ctConnector, ConfigurationObjectEditor coe, String sConnBindName) throws Exception {
        ConnectorBinding connectorBinding = coe.createConnectorComponent(Configuration.NEXT_STARTUP_ID, (ComponentTypeID)ctConnector.getID(), sConnBindName, null);
        return connectorBinding;
    }

    @Override
    public Object modify(ComponentObject theObject, Properties theProperties, String principalName) throws ModificationException, ConfigurationLockException, ConfigurationException {
        ConfigurationObjectEditor editor = null;
        try {
            editor = this.createEditor();
            ComponentObject obj = editor.modifyProperties(theObject, theProperties, 0);
            this.executeTransaction(editor.getDestination().popActions(), principalName);
            return obj;
        }
        catch (Exception theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            throw new ConfigurationException((Throwable)theException);
        }
    }

    @Override
    public ComponentType importConnectorType(InputStream inputStream, String name, String principalName) throws ConfigurationException {
        ComponentType newType = null;
        ConfigurationObjectEditor editor = this.createEditor();
        try {
            XMLConfigurationImportExportUtility util = new XMLConfigurationImportExportUtility();
            newType = util.importComponentType(inputStream, editor, name);
            this.executeTransaction(editor.getDestination().popActions(), principalName);
        }
        catch (Exception theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            Object[] params = new Object[]{name, theException.getMessage()};
            String msg = PlatformPlugin.Util.getString("ConfigurationServiceImpl.Error_importing_connector_type", params);
            throw new ConfigurationException((Throwable)theException, msg);
        }
        return newType;
    }

    @Override
    public ConnectorBinding importConnectorBinding(InputStream inputStream, String name, String pscName, String principalName) throws ConfigurationException {
        ConnectorBinding newBinding = null;
        ConfigurationObjectEditor editor = this.createEditor();
        try {
            XMLConfigurationImportExportUtility util = new XMLConfigurationImportExportUtility();
            newBinding = util.importConnectorBinding(inputStream, editor, name);
            Configuration config = this.getNextStartupConfiguration();
            if (pscName != null && !pscName.equals("")) {
                ProductServiceConfig psc = this.getPSCByName(config, pscName);
                ServiceComponentDefnID bindingID = (ServiceComponentDefnID)newBinding.getID();
                editor.addServiceComponentDefn(psc, bindingID);
                editor.deployServiceDefn(config, (ServiceComponentDefn)newBinding, (ProductServiceConfigID)psc.getID());
            }
            this.executeTransaction(editor.getDestination().popActions(), principalName);
        }
        catch (Exception theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            Object[] params = new Object[]{name, theException.getMessage()};
            String msg = PlatformPlugin.Util.getString("ConfigurationServiceImpl.Error_importing_connector_binding", params);
            throw new ConfigurationException((Throwable)theException, msg);
        }
        return newBinding;
    }

    @Override
    public void delete(ComponentObject theObject, boolean theDeleteDependenciesFlag, String principalName) throws ConfigurationException, ModificationException {
        ConfigurationObjectEditor editor = null;
        try {
            editor = this.createEditor();
            Configuration config = this.getNextStartupConfiguration();
            editor.delete(theObject, config, theDeleteDependenciesFlag);
            if (editor.getDestination().getActionCount() != 0) {
                this.executeTransaction(editor.getDestination().popActions(), principalName);
            }
        }
        catch (ConfigurationException theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            throw theException;
        }
        catch (ServiceException err) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            throw err;
        }
        catch (ModificationException mex) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            throw mex;
        }
    }

    @Override
    public void delete(ComponentType componentType, String principalName) throws ConfigurationException, ModificationException {
        ConfigurationObjectEditor editor = null;
        try {
            editor = this.createEditor();
            editor.delete(componentType);
            this.executeTransaction(editor.getDestination().popActions(), principalName);
        }
        catch (ConfigurationException theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            throw theException;
        }
    }

    @Override
    public Collection deployPSC(Host theHost, VMComponentDefn theProcess, String pscName, String principalName) throws ConfigurationException, ModificationException {
        Collection deployComponentList = null;
        ConfigurationObjectEditor editor = null;
        try {
            editor = this.createEditor();
            Configuration config = this.getNextStartupConfiguration();
            ProductServiceConfig thePSC = this.getPSCByName(config, pscName);
            deployComponentList = editor.deployProductServiceConfig(config, thePSC, (HostID)theHost.getID(), (VMComponentDefnID)theProcess.getID());
            this.executeTransaction(editor.getDestination().popActions(), principalName);
        }
        catch (ConfigurationException theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            throw theException;
        }
        return deployComponentList;
    }

    @Override
    public List checkPropertiesDecryptable(List defns) throws ConfigurationException {
        ArrayList<Boolean> results = new ArrayList<Boolean>(defns.size());
        for (ComponentDefn defn : defns) {
            Collection componentTypeDefns = this.getComponentTypeDefinitions(defn.getComponentTypeID());
            boolean result = ComponentCryptoUtil.checkPropertiesDecryptable((ComponentDefn)defn, (Collection)componentTypeDefns);
            results.add(new Boolean(result));
        }
        return results;
    }

    @Override
    public boolean checkPropertiesDecryptable(Properties props, String componentTypeIdentifier) throws ConfigurationException {
        Collection componentTypes = this.getAllComponentTypes(false);
        ComponentType actualType = null;
        for (ComponentType aType : componentTypes) {
            if (!aType.getName().equals(componentTypeIdentifier)) continue;
            actualType = aType;
            break;
        }
        if (actualType == null) {
            throw new ConfigurationException(PlatformPlugin.Util.getString("ConfigurationServiceImpl.ConnectorType_not_found", new Object[]{componentTypeIdentifier}));
        }
        Collection maskedPropertyNames = actualType.getMaskedPropertyNames();
        return ComponentCryptoUtil.checkPropertiesDecryptable((Properties)props, (Collection)maskedPropertyNames);
    }
}

