/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.spi.xml;

import com.metamatrix.common.id.TransactionID;
import com.metamatrix.common.transaction.TransactionException;
import com.metamatrix.platform.config.ConfigPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ConfigTransaction {
    public static final int SERVER_INITIALIZATION = 1;
    public static final int SERVER_SHUTDOWN = 2;
    public static final int SERVER_FORCE_INITIALIZATION = 3;
    public static final int SERVER_STARTED = 4;
    public static final int NO_SERVER_INITIALIZATION_ACTION = -1;
    private TransactionID txnID;
    private int status;
    private long beginTime;
    private boolean isReadOnly;
    private String principal;
    private Map configurationObjects = new HashMap(3);
    private int action = -1;

    protected ConfigTransaction(TransactionID txnID, long defaultTimeoutSeconds) {
        this.txnID = txnID;
        this.status = 0;
        this.isReadOnly = true;
        this.beginTime = System.currentTimeMillis();
    }

    public int getStatus() {
        return this.status;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public void begin(String principal, int reason, boolean readOnly) throws TransactionException {
        this.setReadOnly(readOnly);
        this.principal = principal;
    }

    public String getLockAcquiredBy() {
        return this.principal;
    }

    public TransactionID getTransactionID() {
        return this.txnID;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int actionPerformed) {
        if (this.action == -1) {
            this.action = actionPerformed;
        }
    }

    void setReadOnly(boolean readTxn) {
        this.isReadOnly = readTxn;
    }

    public void setRollbackOnly() throws TransactionException {
        this.status = 1;
    }

    public void commit() throws TransactionException {
        if (this.status == 1) {
            throw new TransactionException("ERR.014.002.0160", ConfigPlugin.Util.getString("ERR.014.002.0160"));
        }
        if (this.status != 0) {
            throw new TransactionException("ERR.014.002.0161", ConfigPlugin.Util.getString("ERR.014.002.0161"));
        }
        this.status = 8;
        if (this.isReadOnly()) {
            this.status = 3;
            return;
        }
        this.status = 3;
    }

    public void rollback() throws TransactionException {
        if (this.isReadOnly()) {
            return;
        }
        this.status = 4;
    }

    public Collection getObjects() {
        ArrayList objs = new ArrayList();
        for (Object key : this.configurationObjects.keySet()) {
            objs.add(this.configurationObjects.get(key));
        }
        return objs;
    }

    public void addObjects(Object key, Object value) {
        this.configurationObjects.put(key, value);
    }

    public Object getObject(Object key) {
        return this.configurationObjects.get(key);
    }

    public boolean contains(Object key) {
        return this.configurationObjects.containsKey(key);
    }
}

