/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.spi.xml;

import com.metamatrix.common.id.TransactionID;
import com.metamatrix.common.transaction.TransactionException;
import com.metamatrix.core.id.ObjectIDFactory;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.platform.config.ConfigPlugin;
import com.metamatrix.platform.config.spi.xml.ConfigTransaction;
import com.metamatrix.platform.config.spi.xml.XMLConfigurationMgr;
import com.metamatrix.platform.config.spi.xml.XMLConfigurationTransaction;

public class ConfigUserTransaction {
    private static final int DEFAULT_TIMEOUT = 300000;
    public static final int LOCK_SERVER_STARTING = 1;
    public static final int LOCK_CONFIG_CHANGING = 2;
    private ConfigTransaction txn;
    private int status;
    private boolean readTxn;
    private boolean alreadyBegun;
    private String name;
    private ObjectIDFactory idFactory;

    ConfigUserTransaction(boolean isReadOnly, ObjectIDFactory idFactory, String name) {
        ArgCheck.isNotNull((Object)idFactory);
        this.readTxn = isReadOnly;
        this.status = 5;
        this.idFactory = idFactory;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() throws TransactionException {
        if (this.alreadyBegun) {
            throw new IllegalStateException("already begun");
        }
        if (this.status != 5) {
            throw new TransactionException("ERR.014.002.0073", ConfigPlugin.Util.getString("ERR.014.002.0073"));
        }
        TransactionID id = null;
        ObjectIDFactory objectIDFactory = this.idFactory;
        synchronized (objectIDFactory) {
            id = (TransactionID)this.idFactory.create();
        }
        this.txn = new XMLConfigurationTransaction(XMLConfigurationMgr.getInstance(), id, 300000L);
        this.txn.begin(this.name, 2, this.readTxn);
        this.alreadyBegun = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws TransactionException {
        if (!this.alreadyBegun) {
            throw new TransactionException("ERR.014.002.0075", ConfigPlugin.Util.getString("ERR.014.002.0075"));
        }
        if (this.txn == null) {
            throw new TransactionException("ERR.014.002.0076", ConfigPlugin.Util.getString("ERR.014.002.0076"));
        }
        try {
            this.txn.commit();
        }
        finally {
            this.status = this.txn.getStatus();
            this.txn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws TransactionException {
        if (!this.alreadyBegun) {
            return;
        }
        if (this.txn == null) {
            throw new TransactionException("ERR.014.002.0076", ConfigPlugin.Util.getString("ERR.014.002.0076"));
        }
        try {
            this.txn.rollback();
        }
        finally {
            this.status = this.txn.getStatus();
            this.txn = null;
        }
    }

    public boolean isReadTransaction() {
        return this.readTxn;
    }

    public ConfigTransaction getTransaction() {
        return this.txn;
    }
}

