/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.spi.xml;

import com.metamatrix.common.actions.ActionDefinition;
import com.metamatrix.common.actions.AddNamedObject;
import com.metamatrix.common.actions.AddObject;
import com.metamatrix.common.actions.CreateObject;
import com.metamatrix.common.actions.DestroyObject;
import com.metamatrix.common.actions.ExchangeBoolean;
import com.metamatrix.common.actions.ExchangeNamedObject;
import com.metamatrix.common.actions.ExchangeObject;
import com.metamatrix.common.actions.RemoveNamedObject;
import com.metamatrix.common.actions.RemoveObject;
import com.metamatrix.common.config.api.AuthenticationProvider;
import com.metamatrix.common.config.api.AuthenticationProviderID;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentObjectID;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ComponentTypeDefnID;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingID;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.DeployedComponentID;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ProductTypeID;
import com.metamatrix.common.config.api.PropDefnAllowedValueID;
import com.metamatrix.common.config.api.ResourceModel;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.config.api.SharedResourceID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefnID;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.api.exceptions.DuplicateComponentException;
import com.metamatrix.common.config.api.exceptions.InvalidArgumentException;
import com.metamatrix.common.config.api.exceptions.InvalidComponentException;
import com.metamatrix.common.config.api.exceptions.InvalidConfigurationException;
import com.metamatrix.common.config.api.exceptions.InvalidDeployedComponentException;
import com.metamatrix.common.config.api.exceptions.InvalidPropertyValueException;
import com.metamatrix.common.config.model.BasicComponentType;
import com.metamatrix.common.config.model.BasicComponentTypeDefn;
import com.metamatrix.common.config.model.BasicConfiguration;
import com.metamatrix.common.config.model.BasicDeployedComponent;
import com.metamatrix.common.config.model.BasicHost;
import com.metamatrix.common.config.model.BasicProductType;
import com.metamatrix.common.config.model.BasicSharedResource;
import com.metamatrix.common.config.model.ConfigurationModel;
import com.metamatrix.common.config.model.ConfigurationModelContainerImpl;
import com.metamatrix.common.config.model.ConfigurationObjectEditorHelper;
import com.metamatrix.common.config.model.PropertyValidations;
import com.metamatrix.common.namedobject.BaseID;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.platform.config.ConfigPlugin;
import com.metamatrix.platform.config.spi.xml.ConfigTransaction;
import com.metamatrix.platform.config.spi.xml.ConfigTransactionException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class XMLActionUpdateStrategy {
    public PropertyValidations validateProperty = new PropertyValidations();
    private static final int INITIAL_TREE_PATH = -1;
    private static final int PARENT_TREE_PATH = 1;
    private static final int SUPER_TREE_PATH = 2;

    public Set executeActionsOnTarget(Object target, List actions, ConfigTransaction transaction) throws ConfigTransactionException, ConfigurationException {
        HashSet affectedIDs = new HashSet();
        if (actions.isEmpty()) {
            return affectedIDs;
        }
        ConfigurationModelContainerImpl model2 = null;
        if (target instanceof ConfigurationID) {
            ConfigurationID id = (ConfigurationID)target;
            this.executeActions(id, actions, transaction);
        } else if (target instanceof HostID) {
            HostID id = (HostID)target;
            Collection trans = transaction.getObjects();
            for (ConfigurationModelContainerImpl m : trans) {
                this.executeActions(m, id, actions, transaction);
            }
        } else if (target instanceof SharedResourceID) {
            SharedResourceID id = (SharedResourceID)target;
            Collection trans = transaction.getObjects();
            for (ConfigurationModelContainerImpl m : trans) {
                this.executeActions(m, id, actions, transaction);
            }
        } else if (target instanceof AuthenticationProviderID) {
            AuthenticationProviderID id = (AuthenticationProviderID)target;
            Collection trans = transaction.getObjects();
            for (ConfigurationModelContainerImpl m : trans) {
                this.executeActions(m, id, actions, transaction);
            }
        } else if (target instanceof ProductTypeID) {
            ProductTypeID id = (ProductTypeID)target;
            Collection trans = transaction.getObjects();
            for (ConfigurationModelContainerImpl m : trans) {
                this.executeActions(m, id, actions, transaction);
            }
        } else if (target instanceof ComponentTypeID) {
            ComponentTypeID id = (ComponentTypeID)target;
            Collection trans = transaction.getObjects();
            for (ConfigurationModelContainerImpl m : trans) {
                this.executeActions(m, id, actions, transaction);
            }
        } else if (target instanceof ComponentTypeDefnID) {
            ComponentTypeDefnID id = (ComponentTypeDefnID)target;
            Collection trans = transaction.getObjects();
            for (ConfigurationModelContainerImpl m : trans) {
                this.executeActions(m, id, actions, transaction);
            }
        } else if (target instanceof ConnectorBindingID) {
            ConnectorBindingID id = (ConnectorBindingID)target;
            Collection trans = transaction.getObjects();
            for (ConfigurationModelContainerImpl m : trans) {
                this.executeActions(m, id, actions, transaction);
            }
        } else if (target instanceof DeployedComponentID) {
            DeployedComponentID id = (DeployedComponentID)target;
            Collection trans = transaction.getObjects();
            for (ConfigurationModelContainerImpl m : trans) {
                this.executeActions(m, id, actions, transaction);
            }
        } else if (target instanceof ProductServiceConfigID) {
            ProductServiceConfigID id = (ProductServiceConfigID)target;
            Collection trans = transaction.getObjects();
            for (ConfigurationModelContainerImpl m : trans) {
                this.executeActions(m, id, actions, transaction);
            }
        } else if (target instanceof VMComponentDefnID) {
            VMComponentDefnID id = (VMComponentDefnID)target;
            Collection trans = transaction.getObjects();
            for (ConfigurationModelContainerImpl m : trans) {
                this.executeActions(m, id, actions, transaction);
            }
        } else if (target instanceof ServiceComponentDefnID) {
            ServiceComponentDefnID id = (ServiceComponentDefnID)target;
            Collection trans = transaction.getObjects();
            for (ConfigurationModelContainerImpl m : trans) {
                this.executeActions(m, id, actions, transaction);
            }
        } else if (target instanceof PropDefnAllowedValueID) {
            PropDefnAllowedValueID id = (PropDefnAllowedValueID)target;
            Collection trans = transaction.getObjects();
            for (ConfigurationModelContainerImpl model2 : trans) {
                this.executeActions(model2, id, actions, transaction);
            }
        } else {
            throw new ConfigTransactionException("ERR.014.002.0071", ConfigPlugin.Util.getString("ERR.014.002.0071", new Object[]{target}));
        }
        return affectedIDs;
    }

    private ConfigurationModelContainerImpl getConfigModel(BaseID id, ConfigTransaction transaction) throws ConfigurationException {
        String name = id instanceof ConfigurationID ? id.getFullName() : id.getParentFullName();
        ConfigurationModelContainerImpl container = (ConfigurationModelContainerImpl)transaction.getObject(name);
        if (!(id instanceof ConfigurationID) && container == null) {
            throw new ConfigurationException("ERR.014.002.0072", ConfigPlugin.Util.getString("ERR.014.002.0072", new Object[]{name}));
        }
        return container;
    }

    private ComponentType getComponentType(ConfigurationModelContainer config, ComponentTypeID id, BaseID targetID) throws ConfigurationException {
        ComponentType type = config.getComponentType(id.getFullName());
        if (type == null && (type = config.getProductType(id.getFullName())) == null) {
            throw new InvalidComponentException(ConfigPlugin.Util.getString("XMLActionUpdateStrategy.Unable_to_add_component_type_not_found", new Object[]{targetID, id}));
        }
        return type;
    }

    public Set executeActions(ConfigurationModelContainerImpl config, AuthenticationProviderID targetID, List actions, ConfigTransaction transaction) throws InvalidConfigurationException, ConfigurationException {
        HashSet<AuthenticationProviderID> affectedIDs = new HashSet<AuthenticationProviderID>();
        if (actions.isEmpty()) {
            return affectedIDs;
        }
        int actionIndex = -1;
        affectedIDs.add(targetID);
        Configuration cfg = config.getConfiguration();
        try {
            Iterator iter = actions.iterator();
            AuthenticationProvider rd = null;
            while (iter.hasNext()) {
                ComponentType type;
                ActionDefinition action = (ActionDefinition)iter.next();
                ++actionIndex;
                Object[] args = action.getArguments();
                rd = cfg.getAuthenticationProvider((ComponentDefnID)targetID);
                if (action instanceof CreateObject) {
                    if (rd != null) {
                        DuplicateComponentException e = new DuplicateComponentException("ERR.014.002.0189", ConfigPlugin.Util.getString("ERR.014.002.0189", new Object[]{targetID}));
                        e.setActionIndex(actionIndex);
                        throw e;
                    }
                    rd = (AuthenticationProvider)args[0];
                    rd = (AuthenticationProvider)this.setCreationDate((ComponentObject)rd, transaction.getLockAcquiredBy());
                    type = this.getComponentType((ConfigurationModelContainer)config, rd.getComponentTypeID(), (BaseID)targetID);
                    this.processPropertyForNewObject((ComponentObject)rd, type, config, transaction.getLockAcquiredBy());
                    ConfigurationObjectEditorHelper.addConfigurationComponentDefn((Configuration)cfg, (ComponentDefn)rd);
                    continue;
                }
                if (action instanceof AddObject || action instanceof RemoveObject || action instanceof ExchangeObject) {
                    if (rd == null) {
                        throw new InvalidComponentException("ERR.014.002.0190", ConfigPlugin.Util.getString("ERR.014.002.0190", new Object[]{targetID}));
                    }
                    type = this.getComponentType((ConfigurationModelContainer)config, rd.getComponentTypeID(), (BaseID)targetID);
                    rd = (AuthenticationProvider)this.setLastChangedDate((ComponentObject)rd, transaction.getLockAcquiredBy());
                    this.processPropertyChanges(action, (ComponentObject)rd, type, config, transaction.getLockAcquiredBy());
                    continue;
                }
                if (action instanceof DestroyObject) {
                    if (rd == null) continue;
                    ConfigurationObjectEditorHelper.delete((ComponentObjectID)targetID, (Configuration)cfg);
                    this.setLastChangedDate((ComponentObject)config.getConfiguration(), transaction.getLockAcquiredBy());
                    continue;
                }
                throw new InvalidArgumentException("ERR.014.002.0075", ConfigPlugin.Util.getString("ERR.014.002.0191", new Object[]{action.getActionDescription()}));
            }
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            ConfigurationException e2 = new ConfigurationException((Throwable)e);
            e2.setActionIndex(actionIndex);
            throw e2;
        }
        return affectedIDs;
    }

    public Set executeActions(ConfigurationModelContainerImpl config, DeployedComponentID targetID, List actions, ConfigTransaction transaction) throws InvalidDeployedComponentException, ConfigurationException {
        HashSet<DeployedComponentID> affectedIDs = new HashSet<DeployedComponentID>();
        if (actions.isEmpty()) {
            return affectedIDs;
        }
        int actionIndex = -1;
        affectedIDs.add(targetID);
        Configuration cfg = config.getConfiguration();
        try {
            for (ActionDefinition action : actions) {
                ComponentType type;
                ++actionIndex;
                Object[] args = action.getArguments();
                DeployedComponent dc = cfg.getDeployedComponent(targetID);
                if (action instanceof CreateObject) {
                    if (dc != null) {
                        DuplicateComponentException e = new DuplicateComponentException("ERR.014.002.0076", ConfigPlugin.Util.getString("ERR.014.002.0076", new Object[]{targetID}));
                        e.setActionIndex(actionIndex);
                        throw e;
                    }
                    dc = (BasicDeployedComponent)args[0];
                    type = this.getComponentType((ConfigurationModelContainer)config, (dc = (BasicDeployedComponent)this.setCreationDate((ComponentObject)dc, transaction.getLockAcquiredBy())).getComponentTypeID(), (BaseID)targetID);
                    boolean isDeployable = type.isDeployable();
                    if (!isDeployable) {
                        throw new InvalidDeployedComponentException("ERR.014.002.0077", ConfigPlugin.Util.getString("ERR.014.002.0077", new Object[]{targetID.getName()}));
                    }
                    ConfigurationObjectEditorHelper.addDeployedComponent((Configuration)cfg, (DeployedComponent)dc);
                    continue;
                }
                if (action instanceof AddObject || action instanceof RemoveObject || action instanceof ExchangeObject) {
                    if (dc == null) {
                        throw new InvalidComponentException("ERR.014.002.0078", ConfigPlugin.Util.getString("ERR.014.002.0078", new Object[]{targetID}));
                    }
                    type = this.getComponentType((ConfigurationModelContainer)config, dc.getComponentTypeID(), (BaseID)targetID);
                    dc = (BasicDeployedComponent)this.setLastChangedDate((ComponentObject)dc, transaction.getLockAcquiredBy());
                    this.processPropertyChanges(action, (ComponentObject)dc, type, config, transaction.getLockAcquiredBy());
                    continue;
                }
                if (action instanceof DestroyObject) {
                    if (dc == null) continue;
                    ConfigurationObjectEditorHelper.delete((ComponentObjectID)targetID, (Configuration)config.getConfiguration());
                    this.setLastChangedDate((ComponentObject)config.getConfiguration(), transaction.getLockAcquiredBy());
                    continue;
                }
                throw new InvalidArgumentException("ERR.014.002.0079", ConfigPlugin.Util.getString("ERR.014.002.0079", new Object[]{action.getActionDescription()}));
            }
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            ConfigurationException e2 = new ConfigurationException((Throwable)e);
            e2.setActionIndex(actionIndex);
            throw e2;
        }
        return affectedIDs;
    }

    public Set executeActions(ConfigurationModelContainerImpl config, ProductServiceConfigID targetID, List actions, ConfigTransaction transaction) throws InvalidDeployedComponentException, ConfigurationException {
        HashSet<ProductServiceConfigID> affectedIDs = new HashSet<ProductServiceConfigID>();
        if (actions.isEmpty()) {
            return affectedIDs;
        }
        int actionIndex = -1;
        affectedIDs.add(targetID);
        Configuration cfg = config.getConfiguration();
        try {
            for (ActionDefinition action : actions) {
                ++actionIndex;
                Object[] args = action.getArguments();
                ProductServiceConfig cd = cfg.getPSC((ComponentDefnID)targetID);
                if (action instanceof CreateObject) {
                    if (cd != null) {
                        DuplicateComponentException e = new DuplicateComponentException("ERR.014.002.0080", ConfigPlugin.Util.getString("ERR.014.002.0080", new Object[]{targetID}));
                        e.setActionIndex(actionIndex);
                        throw e;
                    }
                    cd = (ComponentDefn)args[0];
                    cd = (ComponentDefn)this.setCreationDate((ComponentObject)cd, transaction.getLockAcquiredBy());
                    ConfigurationObjectEditorHelper.addConfigurationComponentDefn((Configuration)cfg, (ComponentDefn)cd);
                    continue;
                }
                if (action instanceof AddObject || action instanceof RemoveObject) {
                    if (cd == null) {
                        throw new InvalidComponentException("ERR.014.002.0081", ConfigPlugin.Util.getString("ERR.014.002.0081", new Object[]{targetID}));
                    }
                    ComponentType type = this.getComponentType((ConfigurationModelContainer)config, cd.getComponentTypeID(), (BaseID)targetID);
                    cd = (ComponentDefn)this.setLastChangedDate((ComponentObject)cd, transaction.getLockAcquiredBy());
                    this.processPropertyChanges(action, (ComponentObject)cd, type, config, transaction.getLockAcquiredBy());
                    continue;
                }
                if (action instanceof ExchangeObject) {
                    Boolean enabled;
                    ProductServiceConfig psc;
                    ExchangeObject anAction = (ExchangeObject)action;
                    if (cd == null) {
                        throw new InvalidComponentException("ERR.014.002.0081", ConfigPlugin.Util.getString("ERR.014.002.0081", new Object[]{targetID}));
                    }
                    ComponentType type = this.getComponentType((ConfigurationModelContainer)config, cd.getComponentTypeID(), (BaseID)targetID);
                    if (anAction.hasAttributeCode() && (anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.PROPERTY.getCode() || anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.PROPERTIES.getCode())) {
                        cd = (ComponentDefn)this.setLastChangedDate((ComponentObject)cd, transaction.getLockAcquiredBy());
                        this.processPropertyChanges(action, (ComponentObject)cd, type, config, transaction.getLockAcquiredBy());
                        continue;
                    }
                    if (anAction.hasAttributeCode() && anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.UPDATE_PSC.getCode()) {
                        psc = cd;
                        psc = ConfigurationObjectEditorHelper.resetServices((ProductServiceConfig)psc);
                        Collection svcIDs = (Collection)anAction.getPreviousValue();
                        enabled = (Boolean)anAction.getNewValue();
                        for (ServiceComponentDefnID id : svcIDs) {
                            ConfigurationObjectEditorHelper.addServiceComponentDefn((ProductServiceConfig)psc, (ServiceComponentDefnID)id);
                            ConfigurationObjectEditorHelper.setEnabled((ServiceComponentDefnID)id, (ProductServiceConfig)psc, (boolean)enabled);
                        }
                        this.setLastChangedDate((ComponentObject)psc, transaction.getLockAcquiredBy());
                        continue;
                    }
                    if (anAction.hasAttributeCode() && anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.IS_ENABLED.getCode()) {
                        if (cd instanceof ProductServiceConfig) {
                            psc = cd;
                            ServiceComponentDefnID svcID = (ServiceComponentDefnID)anAction.getPreviousValue();
                            enabled = (Boolean)anAction.getNewValue();
                            ConfigurationObjectEditorHelper.setEnabled((ServiceComponentDefnID)svcID, (ProductServiceConfig)psc, (boolean)enabled);
                            this.setLastChangedDate((ComponentObject)psc, transaction.getLockAcquiredBy());
                            continue;
                        }
                        throw new InvalidComponentException("ERR.014.002.0082", ConfigPlugin.Util.getString("ERR.014.002.0082", new Object[]{targetID}));
                    }
                    throw new InvalidArgumentException("ERR.014.002.0079", ConfigPlugin.Util.getString("ERR.014.002.0079", new Object[]{anAction.getActionDescription()}));
                }
                if (action instanceof DestroyObject) {
                    if (cd == null) continue;
                    ConfigurationObjectEditorHelper.delete((ComponentObjectID)targetID, (Configuration)cfg);
                    this.setLastChangedDate((ComponentObject)config.getConfiguration(), transaction.getLockAcquiredBy());
                    continue;
                }
                throw new InvalidArgumentException("ERR.014.002.0075", ConfigPlugin.Util.getString("ERR.014.002.0075", new Object[]{action.getActionDescription()}));
            }
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            ConfigurationException e2 = new ConfigurationException((Throwable)e);
            e2.setActionIndex(actionIndex);
            throw e2;
        }
        return affectedIDs;
    }

    public Set executeActions(ConfigurationModelContainerImpl config, ServiceComponentDefnID targetID, List actions, ConfigTransaction transaction) throws InvalidDeployedComponentException, ConfigurationException {
        HashSet<ServiceComponentDefnID> affectedIDs = new HashSet<ServiceComponentDefnID>();
        if (actions.isEmpty()) {
            return affectedIDs;
        }
        int actionIndex = -1;
        affectedIDs.add(targetID);
        Configuration cfg = config.getConfiguration();
        try {
            for (ActionDefinition action : actions) {
                ComponentType type;
                ServiceComponentDefn cd = cfg.getServiceComponentDefn((ComponentDefnID)targetID);
                ++actionIndex;
                Object[] args = action.getArguments();
                if (action instanceof CreateObject) {
                    if (cd != null) {
                        DuplicateComponentException e = new DuplicateComponentException("ERR.014.002.0083", ConfigPlugin.Util.getString("ERR.014.002.0083", new Object[]{targetID}));
                        e.setActionIndex(actionIndex);
                        throw e;
                    }
                    cd = (ComponentDefn)args[0];
                    cd = (ComponentDefn)this.setCreationDate((ComponentObject)cd, transaction.getLockAcquiredBy());
                    type = this.getComponentType((ConfigurationModelContainer)config, cd.getComponentTypeID(), (BaseID)targetID);
                    this.processPropertyForNewObject((ComponentObject)cd, type, config, transaction.getLockAcquiredBy());
                    ConfigurationObjectEditorHelper.addConfigurationComponentDefn((Configuration)cfg, (ComponentDefn)cd);
                    continue;
                }
                if (action instanceof AddObject || action instanceof RemoveObject) {
                    if (cd == null) {
                        throw new InvalidComponentException("ERR.014.002.0084", ConfigPlugin.Util.getString("ERR.014.002.0084", new Object[]{targetID}));
                    }
                    type = this.getComponentType((ConfigurationModelContainer)config, cd.getComponentTypeID(), (BaseID)targetID);
                    cd = (ComponentDefn)this.setLastChangedDate((ComponentObject)cd, transaction.getLockAcquiredBy());
                    this.processPropertyChanges(action, (ComponentObject)cd, type, config, transaction.getLockAcquiredBy());
                    continue;
                }
                if (action instanceof ExchangeObject) {
                    ExchangeObject anAction = (ExchangeObject)action;
                    if (cd == null) {
                        throw new InvalidComponentException("ERR.014.002.0084", ConfigPlugin.Util.getString("ERR.014.002.0084", new Object[]{targetID}));
                    }
                    if (anAction.hasAttributeCode() && (anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.PROPERTY.getCode() || anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.PROPERTIES.getCode())) {
                        ComponentType type2 = this.getComponentType((ConfigurationModelContainer)config, cd.getComponentTypeID(), (BaseID)targetID);
                        cd = (ComponentDefn)this.setLastChangedDate((ComponentObject)cd, transaction.getLockAcquiredBy());
                        this.processPropertyChanges(action, (ComponentObject)cd, type2, config, transaction.getLockAcquiredBy());
                        continue;
                    }
                    if (anAction.hasAttributeCode() && anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.NAME.getCode()) {
                        throw new InvalidArgumentException("ERR.014.002.0085", ConfigPlugin.Util.getString("ERR.014.002.0085", new Object[]{action.getActionDescription(), targetID}));
                    }
                    if (anAction.hasAttributeCode() && anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.PSC_NAME.getCode()) {
                        ProductServiceConfigID pscID = (ProductServiceConfigID)anAction.getNewValue();
                        ProductServiceConfig psc = config.getConfiguration().getPSC((ComponentDefnID)pscID);
                        this.setLastChangedDate((ComponentObject)psc, transaction.getLockAcquiredBy());
                        ConfigurationObjectEditorHelper.addServiceComponentDefn((ProductServiceConfig)psc, (ServiceComponentDefnID)targetID);
                        continue;
                    }
                    if (anAction.hasAttributeCode() && anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.IS_ENABLED.getCode()) {
                        throw new InvalidArgumentException("ERR.014.002.0086", ConfigPlugin.Util.getString("ERR.014.002.0086", new Object[]{anAction.getActionDescription()}));
                    }
                    if (anAction.hasAttributeCode() && anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.ROUTING_UUID.getCode()) {
                        if (cd instanceof ServiceComponentDefn) {
                            ConfigurationObjectEditorHelper.setRoutingUUID((ServiceComponentDefn)cd, (String)((String)anAction.getNewValue()));
                            this.setLastChangedDate((ComponentObject)cd, transaction.getLockAcquiredBy());
                            continue;
                        }
                        throw new InvalidComponentException("ERR.014.002.0087", ConfigPlugin.Util.getString("ERR.014.002.0087", new Object[]{action.getActionDescription(), targetID}));
                    }
                    throw new InvalidArgumentException("ERR.014.002.0086", ConfigPlugin.Util.getString("ERR.014.002.0086", new Object[]{anAction.getActionDescription()}));
                }
                if (action instanceof DestroyObject) {
                    if (cd == null) continue;
                    ConfigurationObjectEditorHelper.delete((ComponentObjectID)targetID, (Configuration)cfg);
                    this.setLastChangedDate((ComponentObject)config.getConfiguration(), transaction.getLockAcquiredBy());
                    continue;
                }
                throw new InvalidArgumentException("ERR.014.002.0075", ConfigPlugin.Util.getString("ERR.014.002.0075", new Object[]{action.getActionDescription()}));
            }
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            ConfigurationException e2 = new ConfigurationException((Throwable)e);
            e2.setActionIndex(actionIndex);
            throw e2;
        }
        return affectedIDs;
    }

    public Set executeActions(ConfigurationModelContainerImpl config, VMComponentDefnID targetID, List actions, ConfigTransaction transaction) throws InvalidDeployedComponentException, ConfigurationException {
        HashSet<VMComponentDefnID> affectedIDs = new HashSet<VMComponentDefnID>();
        if (actions.isEmpty()) {
            return affectedIDs;
        }
        int actionIndex = -1;
        affectedIDs.add(targetID);
        Configuration cfg = config.getConfiguration();
        try {
            for (ActionDefinition action : actions) {
                ComponentType type;
                ++actionIndex;
                Object[] args = action.getArguments();
                VMComponentDefn cd = cfg.getVMComponentDefn((ComponentDefnID)targetID);
                if (action instanceof CreateObject) {
                    if (cd != null) {
                        DuplicateComponentException e = new DuplicateComponentException("ERR.014.002.0088", ConfigPlugin.Util.getString("ERR.014.002.0088", new Object[]{action.getActionDescription(), targetID}));
                        e.setActionIndex(actionIndex);
                        throw e;
                    }
                    cd = (ComponentDefn)args[0];
                    cd = (ComponentDefn)this.setCreationDate((ComponentObject)cd, transaction.getLockAcquiredBy());
                    type = this.getComponentType((ConfigurationModelContainer)config, cd.getComponentTypeID(), (BaseID)targetID);
                    this.processPropertyForNewObject((ComponentObject)cd, type, config, transaction.getLockAcquiredBy());
                    ConfigurationObjectEditorHelper.addConfigurationComponentDefn((Configuration)cfg, (ComponentDefn)cd);
                    continue;
                }
                if (action instanceof AddObject || action instanceof RemoveObject) {
                    if (cd == null) {
                        throw new InvalidComponentException("ERR.014.002.0089", ConfigPlugin.Util.getString("ERR.014.002.0089", new Object[]{targetID}));
                    }
                    type = this.getComponentType((ConfigurationModelContainer)config, cd.getComponentTypeID(), (BaseID)targetID);
                    cd = (ComponentDefn)this.setLastChangedDate((ComponentObject)cd, transaction.getLockAcquiredBy());
                    this.processPropertyChanges(action, (ComponentObject)cd, type, config, transaction.getLockAcquiredBy());
                    continue;
                }
                if (action instanceof ExchangeObject) {
                    ExchangeObject anAction = (ExchangeObject)action;
                    if (cd == null) {
                        throw new InvalidComponentException("ERR.014.002.0089", ConfigPlugin.Util.getString("ERR.014.002.0089", new Object[]{targetID}));
                    }
                    if (anAction.hasAttributeCode() && (anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.PROPERTY.getCode() || anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.PROPERTIES.getCode())) {
                        ComponentType type2 = this.getComponentType((ConfigurationModelContainer)config, cd.getComponentTypeID(), (BaseID)targetID);
                        cd = (ComponentDefn)this.setLastChangedDate((ComponentObject)cd, transaction.getLockAcquiredBy());
                        this.processPropertyChanges(action, (ComponentObject)cd, type2, config, transaction.getLockAcquiredBy());
                        continue;
                    }
                    if (anAction.hasAttributeCode() && anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.NAME.getCode()) {
                        throw new InvalidArgumentException("ERR.014.002.0090", ConfigPlugin.Util.getString("ERR.014.002.0090", new Object[]{action.getActionDescription(), targetID}));
                    }
                    if (anAction.hasAttributeCode() && anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.PSC_NAME.getCode()) {
                        throw new InvalidArgumentException("ERR.014.002.0090", ConfigPlugin.Util.getString("ERR.014.002.0090", new Object[]{action.getActionDescription(), targetID}));
                    }
                    if (anAction.hasAttributeCode() && anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.IS_ENABLED.getCode()) {
                        throw new InvalidArgumentException("ERR.014.002.0091", ConfigPlugin.Util.getString("ERR.014.002.0091", new Object[]{anAction.getActionDescription()}));
                    }
                    if (anAction.hasAttributeCode() && anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.ROUTING_UUID.getCode()) {
                        throw new InvalidArgumentException("ERR.014.002.0091", ConfigPlugin.Util.getString("ERR.014.002.0091", new Object[]{anAction.getActionDescription()}));
                    }
                    throw new InvalidArgumentException("ERR.014.002.0091", ConfigPlugin.Util.getString("ERR.014.002.0091", new Object[]{anAction.getActionDescription()}));
                }
                if (action instanceof DestroyObject) {
                    if (cd == null) continue;
                    ConfigurationObjectEditorHelper.delete((ComponentObjectID)targetID, (Configuration)cfg);
                    this.setLastChangedDate((ComponentObject)config.getConfiguration(), transaction.getLockAcquiredBy());
                    continue;
                }
                throw new InvalidArgumentException("ERR.014.002.0091", ConfigPlugin.Util.getString("ERR.014.002.0091", new Object[]{action.getActionDescription()}));
            }
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            ConfigurationException e2 = new ConfigurationException((Throwable)e);
            e2.setActionIndex(actionIndex);
            throw e2;
        }
        return affectedIDs;
    }

    public Set executeActions(ConfigurationModelContainerImpl config, ConnectorBindingID targetID, List actions, ConfigTransaction transaction) throws InvalidDeployedComponentException, ConfigurationException {
        HashSet<ConnectorBindingID> affectedIDs = new HashSet<ConnectorBindingID>();
        if (actions.isEmpty()) {
            return affectedIDs;
        }
        int actionIndex = -1;
        affectedIDs.add(targetID);
        Configuration cfg = config.getConfiguration();
        try {
            for (ActionDefinition action : actions) {
                ComponentType type;
                ++actionIndex;
                Object[] args = action.getArguments();
                ConnectorBinding cd = cfg.getConnectorBinding((ComponentDefnID)targetID);
                if (action instanceof CreateObject) {
                    if (cd != null) {
                        DuplicateComponentException e = new DuplicateComponentException("ERR.014.002.0092", ConfigPlugin.Util.getString("ERR.014.002.0092", new Object[]{targetID}));
                        e.setActionIndex(actionIndex);
                        throw e;
                    }
                    cd = (ComponentDefn)args[0];
                    cd = (ComponentDefn)this.setCreationDate((ComponentObject)cd, transaction.getLockAcquiredBy());
                    type = this.getComponentType((ConfigurationModelContainer)config, cd.getComponentTypeID(), (BaseID)targetID);
                    this.processPropertyForNewObject((ComponentObject)cd, type, config, transaction.getLockAcquiredBy());
                    ConfigurationObjectEditorHelper.addConfigurationComponentDefn((Configuration)cfg, (ComponentDefn)cd);
                    continue;
                }
                if (action instanceof AddObject || action instanceof RemoveObject) {
                    if (cd == null) {
                        throw new InvalidComponentException("ERR.014.002.0093", ConfigPlugin.Util.getString("ERR.014.002.0093", new Object[]{targetID}));
                    }
                    type = this.getComponentType((ConfigurationModelContainer)config, cd.getComponentTypeID(), (BaseID)targetID);
                    cd = (ComponentDefn)this.setLastChangedDate((ComponentObject)cd, transaction.getLockAcquiredBy());
                    this.processPropertyChanges(action, (ComponentObject)cd, type, config, transaction.getLockAcquiredBy());
                    continue;
                }
                if (action instanceof ExchangeObject) {
                    ExchangeObject anAction = (ExchangeObject)action;
                    if (cd == null) {
                        throw new InvalidComponentException("ERR.014.002.0093", ConfigPlugin.Util.getString("ERR.014.002.0093", new Object[]{targetID}));
                    }
                    if (anAction.hasAttributeCode() && (anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.PROPERTY.getCode() || anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.PROPERTIES.getCode())) {
                        ComponentType type2 = this.getComponentType((ConfigurationModelContainer)config, cd.getComponentTypeID(), (BaseID)targetID);
                        cd = (ComponentDefn)this.setLastChangedDate((ComponentObject)cd, transaction.getLockAcquiredBy());
                        this.processPropertyChanges(action, (ComponentObject)cd, type2, config, transaction.getLockAcquiredBy());
                        continue;
                    }
                    if (anAction.hasAttributeCode() && anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.NAME.getCode()) {
                        throw new InvalidArgumentException("ERR.014.002.0094", ConfigPlugin.Util.getString("ERR.014.002.0094", new Object[]{action.getActionDescription(), targetID}));
                    }
                    if (anAction.hasAttributeCode() && anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.PSC_NAME.getCode()) {
                        ProductServiceConfigID pscID = (ProductServiceConfigID)anAction.getNewValue();
                        ProductServiceConfig psc = config.getConfiguration().getPSC((ComponentDefnID)pscID);
                        if (psc == null) {
                            throw new InvalidComponentException("ERR.014.002.0095", ConfigPlugin.Util.getString("ERR.014.002.0095", new Object[]{pscID, config.getConfigurationID()}));
                        }
                        this.setLastChangedDate((ComponentObject)psc, transaction.getLockAcquiredBy());
                        ConfigurationObjectEditorHelper.addServiceComponentDefn((ProductServiceConfig)psc, (ServiceComponentDefnID)targetID);
                        continue;
                    }
                    if (anAction.hasAttributeCode() && anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.IS_ENABLED.getCode()) {
                        throw new InvalidArgumentException("ERR.014.002.0096", ConfigPlugin.Util.getString("ERR.014.002.0096", new Object[]{anAction.getActionDescription()}));
                    }
                    if (anAction.hasAttributeCode() && anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.ROUTING_UUID.getCode()) {
                        cd = (ConnectorBinding)this.setLastChangedDate((ComponentObject)cd, transaction.getLockAcquiredBy());
                        ConfigurationObjectEditorHelper.setRoutingUUID((ServiceComponentDefn)cd, (String)((String)anAction.getNewValue()));
                        continue;
                    }
                    throw new InvalidArgumentException("ERR.014.002.0096", ConfigPlugin.Util.getString("ERR.014.002.0096", new Object[]{anAction.getActionDescription()}));
                }
                if (action instanceof DestroyObject) {
                    if (cd == null) continue;
                    ConfigurationObjectEditorHelper.delete((ComponentObjectID)targetID, (Configuration)cfg);
                    this.setLastChangedDate((ComponentObject)config.getConfiguration(), transaction.getLockAcquiredBy());
                    continue;
                }
                throw new InvalidArgumentException("ERR.014.002.0096", ConfigPlugin.Util.getString("ERR.014.002.0096", new Object[]{action.getActionDescription()}));
            }
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            ConfigurationException e2 = new ConfigurationException((Throwable)e);
            e2.setActionIndex(actionIndex);
            throw e2;
        }
        return affectedIDs;
    }

    public Set executeActions(ConfigurationID targetID, List actions, ConfigTransaction transaction) throws InvalidConfigurationException, ConfigurationException {
        HashSet<ConfigurationID> affectedIDs = new HashSet<ConfigurationID>();
        if (actions.isEmpty()) {
            return affectedIDs;
        }
        int actionIndex = -1;
        ConfigurationModelContainerImpl config = this.getConfigModel((BaseID)targetID, transaction);
        BasicConfiguration dvt = null;
        affectedIDs.add(targetID);
        try {
            for (ActionDefinition action : actions) {
                ++actionIndex;
                Object[] args = action.getArguments();
                if (action.hasAttributeCode() && (action.getAttributeCode().intValue() == ConfigurationModel.Attribute.CURRENT_CONFIGURATION.getCode() || action.getAttributeCode().intValue() == ConfigurationModel.Attribute.NEXT_STARTUP_CONFIGURATION.getCode() || action.getAttributeCode().intValue() == ConfigurationModel.Attribute.STARTUP_CONFIGURATION.getCode())) {
                    throw new InvalidArgumentException("ERR.014.002.0097", ConfigPlugin.Util.getString("ERR.014.002.0097", new Object[]{action.getActionDescription()}));
                }
                if (action instanceof CreateObject) {
                    Object obj = args[0];
                    if (obj instanceof Collection) {
                        Collection objs = (Collection)obj;
                        ConfigurationModelContainerImpl newConfig = new ConfigurationModelContainerImpl();
                        transaction.addObjects(targetID.getFullName(), newConfig);
                        newConfig.setConfigurationObjects(objs);
                        for (Object o : objs) {
                            if (!(o instanceof ComponentObject)) continue;
                            ComponentObject co = (ComponentObject)o;
                            ComponentType type = this.getComponentType((ConfigurationModelContainer)newConfig, co.getComponentTypeID(), (BaseID)targetID);
                            this.processPropertyForNewObject(co, type, newConfig, transaction.getLockAcquiredBy());
                        }
                        continue;
                    }
                    dvt = (BasicConfiguration)obj;
                    config.addObject((Object)dvt);
                    continue;
                }
                if (action instanceof AddObject || action instanceof RemoveObject || action instanceof ExchangeObject) {
                    Configuration configuration = config.getConfiguration();
                    if (configuration == null) {
                        throw new InvalidComponentException("ERR.014.002.0098", ConfigPlugin.Util.getString("ERR.014.002.0098", new Object[]{targetID}));
                    }
                    ComponentType type = this.getComponentType((ConfigurationModelContainer)config, configuration.getComponentTypeID(), (BaseID)targetID);
                    this.processPropertyChanges(action, (ComponentObject)configuration, type, config, transaction.getLockAcquiredBy());
                    continue;
                }
                if (action instanceof DestroyObject) {
                    ConfigurationModelContainerImpl emptyConfig = new ConfigurationModelContainerImpl();
                    transaction.addObjects(targetID.getFullName(), emptyConfig);
                    continue;
                }
                throw new InvalidArgumentException("ERR.014.002.0099", ConfigPlugin.Util.getString("ERR.014.002.0099", new Object[]{action.getActionDescription()}));
            }
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            ConfigurationException e2 = new ConfigurationException((Throwable)e);
            e2.setActionIndex(actionIndex);
            throw e2;
        }
        return affectedIDs;
    }

    public Set executeActions(ConfigurationModelContainerImpl config, ComponentTypeID targetID, List actions, ConfigTransaction transaction) throws InvalidConfigurationException, ConfigurationException {
        HashSet<ComponentTypeID> affectedIDs = new HashSet<ComponentTypeID>();
        if (actions.isEmpty()) {
            return affectedIDs;
        }
        int actionIndex = -1;
        affectedIDs.add(targetID);
        try {
            for (ActionDefinition action : actions) {
                ComponentType type;
                ++actionIndex;
                Object[] args = action.getArguments();
                if (action instanceof CreateObject) {
                    type = config.getComponentType(targetID.getFullName());
                    if (type != null) {
                        DuplicateComponentException e = new DuplicateComponentException("ERR.014.002.0100", ConfigPlugin.Util.getString("ERR.014.002.0100", new Object[]{targetID}));
                        e.setActionIndex(actionIndex);
                        throw e;
                    }
                    BasicComponentType dvt = (BasicComponentType)args[0];
                    this.setCreationDate((ComponentType)dvt, transaction.getLockAcquiredBy());
                    config.addComponentType((ComponentType)dvt);
                    if (!dvt.isOfTypeConnector()) continue;
                    ProductType pt = config.getProductType("Connectors");
                    ConfigurationObjectEditorHelper.addServiceComponentType((ProductType)pt, (ComponentType)dvt);
                    continue;
                }
                if (action instanceof AddObject || action instanceof RemoveObject) {
                    throw new InvalidArgumentException("ERR.014.002.0101", ConfigPlugin.Util.getString("ERR.014.002.0101", new Object[]{action.getActionDescription()}));
                }
                if (action instanceof ExchangeObject) {
                    ExchangeObject exchangeAction = (ExchangeObject)action;
                    ComponentType type2 = config.getComponentType(targetID.getFullName());
                    if (type2 == null) {
                        throw new InvalidDeployedComponentException("ERR.014.002.0102", ConfigPlugin.Util.getString("ERR.014.002.0102", new Object[]{targetID}));
                    }
                    BasicComponentType bct = (BasicComponentType)type2;
                    if (action.hasAttributeCode() && action.getAttributeCode().intValue() == ConfigurationModel.Attribute.UPDATE_COMPONENT_TYPE.getCode()) {
                        ComponentType newCt = (ComponentType)exchangeAction.getNewValue();
                        this.setLastChangedDate(newCt, transaction.getLockAcquiredBy());
                        config.addComponentType((ComponentType)exchangeAction.getNewValue());
                        continue;
                    }
                    if (action.hasAttributeCode() && action.getAttributeCode().intValue() == ConfigurationModel.Attribute.PARENT_COMPONENT_TYPEID.getCode()) {
                        bct.setParentComponentTypeID((ComponentTypeID)exchangeAction.getNewValue());
                        this.setLastChangedDate((ComponentType)bct, transaction.getLockAcquiredBy());
                        continue;
                    }
                    if (action.hasAttributeCode() && action.getAttributeCode().intValue() == ConfigurationModel.Attribute.SUPER_COMPONENT_TYPEID.getCode()) {
                        bct.setSuperComponentTypeID((ComponentTypeID)exchangeAction.getNewValue());
                        this.setLastChangedDate((ComponentType)bct, transaction.getLockAcquiredBy());
                        continue;
                    }
                    throw new InvalidArgumentException("ERR.014.002.0101", ConfigPlugin.Util.getString("ERR.014.002.0101", new Object[]{action.getActionDescription()}));
                }
                if (action instanceof ExchangeBoolean) {
                    throw new InvalidArgumentException("ERR.014.002.0101", ConfigPlugin.Util.getString("ERR.014.002.0101", new Object[]{action.getActionDescription()}));
                }
                if (action instanceof DestroyObject) {
                    type = config.getComponentType(targetID.getFullName());
                    if (type == null) continue;
                    Collection services = config.getConfiguration().getComponentDefnIDs((ComponentTypeID)type.getID());
                    if (services != null && services.size() > 0) {
                        ComponentDefnID d = (ComponentDefnID)services.iterator().next();
                        throw new InvalidDeployedComponentException(ConfigPlugin.Util.getString("XMLActionUpdateStrategy.Unable_to_delete_component_type_related_components_found", new Object[]{type.getID(), d.getFullName()}));
                    }
                    config.remove((BaseID)targetID);
                    this.setLastChangedDate((ComponentObject)config.getConfiguration(), transaction.getLockAcquiredBy());
                    for (ProductType pt : config.getProductTypes()) {
                        if (!pt.contains((ComponentTypeID)type.getID())) continue;
                        ConfigurationObjectEditorHelper.removeServiceComponentType((ProductType)pt, (ComponentType)type);
                    }
                    continue;
                }
                throw new InvalidArgumentException("ERR.014.002.0101", ConfigPlugin.Util.getString("ERR.014.002.0101", new Object[]{action.getActionDescription()}));
            }
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            ConfigurationException e2 = new ConfigurationException((Throwable)e);
            e2.setActionIndex(actionIndex);
            throw e2;
        }
        return affectedIDs;
    }

    public Set executeActions(ConfigurationModelContainerImpl config, ComponentTypeDefnID targetID, List actions, ConfigTransaction transaction) throws InvalidConfigurationException, ConfigurationException {
        HashSet<ComponentTypeDefnID> affectedIDs = new HashSet<ComponentTypeDefnID>();
        if (actions.isEmpty()) {
            return affectedIDs;
        }
        int actionIndex = -1;
        affectedIDs.add(targetID);
        try {
            for (ActionDefinition action : actions) {
                BasicComponentType btype;
                ++actionIndex;
                Object[] args = action.getArguments();
                BasicComponentTypeDefn dvt = (BasicComponentTypeDefn)args[0];
                ComponentType type = this.getComponentType((ConfigurationModelContainer)config, dvt.getComponentTypeID(), (BaseID)targetID);
                if (action instanceof CreateObject) {
                    ComponentTypeDefn ctd;
                    if (type.getComponentTypeDefinition(dvt.getFullName()) != null && !dvt.equals((Object)(ctd = type.getComponentTypeDefinition(dvt.getFullName())))) {
                        DuplicateComponentException e = new DuplicateComponentException("ERR.014.002.0104", ConfigPlugin.Util.getString("ERR.014.002.0104", new Object[]{targetID}));
                        e.setActionIndex(actionIndex);
                        throw e;
                    }
                    btype = (BasicComponentType)type;
                    btype.addComponentTypeDefinition((ComponentTypeDefn)dvt);
                    continue;
                }
                if (action instanceof ExchangeObject) {
                    btype = (BasicComponentType)type;
                    if (type.getComponentTypeDefinition(dvt.getFullName()) == null) {
                        btype.removeComponentTypeDefinition((ComponentTypeDefn)dvt);
                    }
                    btype.addComponentTypeDefinition((ComponentTypeDefn)dvt);
                    continue;
                }
                if (action instanceof DestroyObject) {
                    if (type.getComponentTypeDefinition(dvt.getFullName()) == null) continue;
                    btype = (BasicComponentType)type;
                    btype.removeComponentTypeDefinition((ComponentTypeDefn)dvt);
                    continue;
                }
                throw new InvalidArgumentException("ERR.014.002.0103", ConfigPlugin.Util.getString("ERR.014.002.0103", new Object[]{action.getActionDescription()}));
            }
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            ConfigurationException e2 = new ConfigurationException((Throwable)e);
            e2.setActionIndex(actionIndex);
            throw e2;
        }
        return affectedIDs;
    }

    public Set executeActions(ConfigurationModelContainerImpl config, PropDefnAllowedValueID targetID, List actions, ConfigTransaction transaction) throws InvalidConfigurationException, ConfigurationException {
        HashSet<PropDefnAllowedValueID> affectedIDs = new HashSet<PropDefnAllowedValueID>();
        if (actions.isEmpty()) {
            return affectedIDs;
        }
        affectedIDs.add(targetID);
        return affectedIDs;
    }

    public Set executeActions(ConfigurationModelContainerImpl config, HostID targetID, List actions, ConfigTransaction transaction) throws InvalidComponentException, ConfigurationException {
        HashSet<HostID> affectedIDs = new HashSet<HostID>();
        if (actions.isEmpty()) {
            return affectedIDs;
        }
        int actionIndex = -1;
        BasicHost dvt = null;
        affectedIDs.add(targetID);
        try {
            for (ActionDefinition action : actions) {
                Host host;
                ++actionIndex;
                Object[] args = action.getArguments();
                if (action instanceof CreateObject) {
                    host = config.getHost(targetID.getFullName());
                    if (host != null) continue;
                    dvt = (BasicHost)args[0];
                    this.getComponentType((ConfigurationModelContainer)config, dvt.getComponentTypeID(), (BaseID)targetID);
                    dvt = (BasicHost)this.setCreationDate((ComponentObject)dvt, transaction.getLockAcquiredBy());
                    ConfigurationObjectEditorHelper.addHostComponent((Configuration)config.getConfiguration(), (Host)dvt);
                    continue;
                }
                if (action instanceof AddObject || action instanceof RemoveObject || action instanceof ExchangeObject) {
                    host = config.getHost(targetID.getFullName());
                    if (host == null) {
                        throw new InvalidComponentException("ERR.014.002.0105", ConfigPlugin.Util.getString("ERR.014.002.0105", new Object[]{targetID}));
                    }
                    ComponentType type = this.getComponentType((ConfigurationModelContainer)config, host.getComponentTypeID(), (BaseID)targetID);
                    host = (Host)this.setLastChangedDate((ComponentObject)host, transaction.getLockAcquiredBy());
                    this.processPropertyChanges(action, (ComponentObject)host, type, config, transaction.getLockAcquiredBy());
                    continue;
                }
                if (action instanceof DestroyObject) {
                    host = config.getHost(targetID.getFullName());
                    if (host == null) continue;
                    ConfigurationObjectEditorHelper.delete((ComponentObjectID)targetID, (Configuration)config.getConfiguration());
                    this.setLastChangedDate((ComponentObject)config.getConfiguration(), transaction.getLockAcquiredBy());
                    continue;
                }
                throw new InvalidArgumentException("ERR.014.002.0075", ConfigPlugin.Util.getString("ERR.014.002.0075", new Object[]{action.getActionDescription()}));
            }
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            ConfigurationException e2 = new ConfigurationException((Throwable)e);
            e2.setActionIndex(actionIndex);
            throw e2;
        }
        return affectedIDs;
    }

    public Set executeActions(ConfigurationModelContainerImpl config, SharedResourceID targetID, List actions, ConfigTransaction transaction) throws InvalidConfigurationException, ConfigurationException {
        HashSet<SharedResourceID> affectedIDs = new HashSet<SharedResourceID>();
        if (actions.isEmpty()) {
            return affectedIDs;
        }
        int actionIndex = -1;
        affectedIDs.add(targetID);
        BasicSharedResource dvt = null;
        try {
            for (ActionDefinition action : actions) {
                ComponentType type;
                SharedResource rd;
                ++actionIndex;
                Object[] args = action.getArguments();
                if (action instanceof CreateObject) {
                    rd = config.getResource(targetID.getFullName());
                    if (rd != null) continue;
                    dvt = (BasicSharedResource)args[0];
                    dvt = (BasicSharedResource)this.setCreationDate((ComponentObject)dvt, transaction.getLockAcquiredBy());
                    type = ResourceModel.getComponentType((String)dvt.getName());
                    this.processPropertyForNewObject((ComponentObject)dvt, type, config, transaction.getLockAcquiredBy());
                    config.addResource((SharedResource)dvt);
                    continue;
                }
                if (action instanceof AddObject || action instanceof RemoveObject || action instanceof ExchangeObject) {
                    rd = config.getResource(targetID.getFullName());
                    if (rd == null) {
                        throw new InvalidComponentException("ERR.014.002.0106", ConfigPlugin.Util.getString("ERR.014.002.0106", new Object[]{targetID}));
                    }
                    type = ResourceModel.getComponentType((String)rd.getName());
                    rd = (SharedResource)this.setLastChangedDate((ComponentObject)rd, transaction.getLockAcquiredBy());
                    this.processPropertyChanges(action, (ComponentObject)rd, type, config, transaction.getLockAcquiredBy());
                    continue;
                }
                if (action instanceof DestroyObject) {
                    rd = config.getResource(targetID.getFullName());
                    if (rd == null) continue;
                    config.remove((BaseID)targetID);
                    this.setLastChangedDate((ComponentObject)config.getConfiguration(), transaction.getLockAcquiredBy());
                    continue;
                }
                throw new InvalidArgumentException("ERR.014.002.0075", ConfigPlugin.Util.getString("ERR.014.002.0075", new Object[]{action.getActionDescription()}));
            }
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            ConfigurationException e2 = new ConfigurationException((Throwable)e);
            e2.setActionIndex(actionIndex);
            throw e2;
        }
        return affectedIDs;
    }

    public void updateSharedResource(SharedResource resource, ConfigTransaction transaction) throws ConfigurationException {
        Collection trans = transaction.getObjects();
        for (ConfigurationModelContainerImpl m : trans) {
            ComponentType type = ResourceModel.getComponentType((String)resource.getName());
            Properties props = resource.getProperties();
            SharedResource sr = m.getResource(resource.getFullName());
            if (sr == null) {
                throw new InvalidComponentException("ERR.014.002.0106", ConfigPlugin.Util.getString("ERR.014.002.0106", new Object[]{resource.getFullName()}));
            }
            this.updateProperties((ComponentObject)sr, props, 1, type, m, transaction.getLockAcquiredBy());
            sr = (SharedResource)this.setLastChangedDate((ComponentObject)sr, transaction.getLockAcquiredBy());
        }
    }

    public Set executeActions(ConfigurationModelContainerImpl config, ProductTypeID targetID, List actions, ConfigTransaction transaction) throws InvalidConfigurationException, ConfigurationException {
        HashSet<ProductTypeID> affectedIDs = new HashSet<ProductTypeID>();
        if (actions.isEmpty()) {
            return affectedIDs;
        }
        int actionIndex = -1;
        affectedIDs.add(targetID);
        BasicProductType dvt = null;
        try {
            for (ActionDefinition action : actions) {
                ++actionIndex;
                Object[] args = action.getArguments();
                if (action instanceof CreateObject) {
                    ProductType rd = config.getProductType(targetID.getFullName());
                    if (rd != null) continue;
                    dvt = (BasicProductType)args[0];
                    dvt = (BasicProductType)this.setCreationDate((ComponentType)dvt, transaction.getLockAcquiredBy());
                    config.addProductType((ProductType)dvt);
                    continue;
                }
                if (action instanceof AddObject || action instanceof RemoveObject || action instanceof ExchangeObject) {
                    throw new InvalidArgumentException("ERR.014.002.0075", ConfigPlugin.Util.getString("ERR.014.002.0075", new Object[]{action.getActionDescription()}));
                }
                if (action instanceof DestroyObject) {
                    throw new InvalidArgumentException("ERR.014.002.0075", ConfigPlugin.Util.getString("ERR.014.002.0075", new Object[]{action.getActionDescription()}));
                }
                throw new InvalidArgumentException("ERR.014.002.0075", ConfigPlugin.Util.getString("ERR.014.002.0075", new Object[]{action.getActionDescription()}));
            }
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            ConfigurationException e2 = new ConfigurationException((Throwable)e);
            e2.setActionIndex(actionIndex);
            throw e2;
        }
        return affectedIDs;
    }

    private void processPropertyForNewObject(ComponentObject object, ComponentType type, ConfigurationModelContainerImpl config, String principal) throws InvalidPropertyValueException, ConfigurationException {
        Properties props = ConfigurationObjectEditorHelper.getEditableProperties((ComponentObject)object);
        this.updateProperties(object, props, 0, type, config, principal);
    }

    private void processPropertyChanges(ActionDefinition action, ComponentObject object, ComponentType type, ConfigurationModelContainerImpl config, String principal) throws InvalidPropertyValueException, ConfigurationException {
        int operation = -1;
        if (action instanceof AddNamedObject || action instanceof AddObject) {
            operation = 1;
        } else if (action instanceof ExchangeNamedObject || action instanceof ExchangeObject) {
            operation = 0;
        } else if (action instanceof RemoveNamedObject || action instanceof RemoveObject) {
            operation = 2;
        } else {
            throw new RuntimeException(ConfigPlugin.Util.getString("ERR.014.002.0107", new Object[]{action.getClass().getName()}));
        }
        Object[] args = action.getArguments();
        if (args[0] instanceof Properties) {
            Properties props = null;
            if (operation == 1) {
                props = (Properties)args[0];
            } else if (operation == 0) {
                props = (Properties)args[1];
            } else if (operation == 2) {
                props = (Properties)args[0];
            }
            this.updateProperties(object, props, operation, type, config, principal);
        } else {
            String propName = (String)args[0];
            String propValue = "";
            if (operation == 1) {
                propValue = (String)args[1];
            } else if (operation == 0) {
                propValue = (String)args[2];
            } else if (operation == 2) {
                propValue = "";
            }
            this.updateProperty(object, propName, propValue, operation, type, config, principal);
        }
    }

    private void updateProperties(ComponentObject object, Properties props, int operation, ComponentType type, ConfigurationModelContainerImpl config, String principal) throws InvalidPropertyValueException, ConfigurationException {
        Enumeration<?> propertyNames = props.propertyNames();
        Properties passwordProps = new Properties();
        while (propertyNames.hasMoreElements()) {
            String propName = (String)propertyNames.nextElement();
            String propValue = props.getProperty(propName);
            this.validateProperty.isPropertyValid(propName, propValue);
            if (propValue != null && propValue.trim().length() > 0 && XMLActionUpdateStrategy.isPasswordProp(propName, type, config) && !CryptoUtil.isValueEncrypted((String)propValue)) {
                try {
                    propValue = CryptoUtil.stringEncrypt((String)propValue);
                }
                catch (CryptoException e) {
                    e.printStackTrace();
                    throw new InvalidPropertyValueException((Throwable)e, "ERR.014.002.0108", ConfigPlugin.Util.getString("ERR.014.002.0108"));
                }
            }
            passwordProps.setProperty(propName, propValue);
        }
        ConfigurationObjectEditorHelper.modifyProperties((ComponentObject)object, (Properties)passwordProps, (int)operation);
    }

    private void updateProperty(ComponentObject object, String propName, String propValue, int operation, ComponentType type, ConfigurationModelContainerImpl config, String principal) throws InvalidPropertyValueException, ConfigurationException {
        this.validateProperty.isPropertyValid(propName, propValue);
        if (propValue != null && propValue.trim().length() > 0 && XMLActionUpdateStrategy.isPasswordProp(propName, type, config) && !CryptoUtil.isValueEncrypted((String)propValue)) {
            Object pwd = null;
            try {
                propValue = CryptoUtil.getCryptor().encrypt(propValue);
            }
            catch (CryptoException e) {
                throw new InvalidPropertyValueException((Throwable)e, "ERR.014.002.0108", ConfigPlugin.Util.getString("ERR.014.002.0108"));
            }
        }
        if (operation == 1) {
            ConfigurationObjectEditorHelper.addProperty((ComponentObject)object, (String)propName, (String)propValue);
        } else if (operation == 0) {
            ConfigurationObjectEditorHelper.setProperty((ComponentObject)object, (String)propName, (String)propValue);
        } else if (operation == 2) {
            ConfigurationObjectEditorHelper.removeProperty((ComponentObject)object, (String)propName);
        }
    }

    private static boolean isPasswordProp(String propName, ComponentType type, ConfigurationModelContainerImpl config) throws ConfigurationException {
        if (type == null) {
            Assertion.isNotNull((Object)type, (String)ConfigPlugin.Util.getString("ERR.014.002.0109", new Object[]{propName}));
        }
        ComponentType checkType = null;
        checkType = type.getComponentTypeDefinition(propName) != null ? type : XMLActionUpdateStrategy.findComponentTypeBasedOnHierarchy(propName, type, -1, config);
        if (checkType == null) {
            return false;
        }
        ComponentTypeDefn td = checkType.getComponentTypeDefinition(propName);
        return td.getPropertyDefinition().isMasked();
    }

    private static ComponentType findComponentTypeBasedOnHierarchy(String propName, ComponentType type, int treePath, ConfigurationModelContainerImpl config) throws ConfigurationException {
        ComponentType foundType = null;
        if ((treePath == 1 || treePath == -1) && type.getParentComponentTypeID() != null && (foundType = config.getComponentType(type.getParentComponentTypeID().getFullName())) != null) {
            if (foundType.getComponentTypeDefinition(propName) != null) {
                return foundType;
            }
            if ((foundType = XMLActionUpdateStrategy.findComponentTypeBasedOnHierarchy(propName, foundType, 1, config)) != null) {
                return foundType;
            }
        }
        if ((treePath == 2 || treePath == -1) && type.getSuperComponentTypeID() != null && (foundType = config.getComponentType(type.getSuperComponentTypeID().getFullName())) != null) {
            if (foundType.getComponentTypeDefinition(propName) != null) {
                return foundType;
            }
            if ((foundType = XMLActionUpdateStrategy.findComponentTypeBasedOnHierarchy(propName, foundType, 2, config)) != null) {
                return foundType;
            }
        }
        return foundType;
    }

    private ComponentObject setLastChangedDate(ComponentObject defn, String principal) {
        String lastChangedDate = DateUtil.getCurrentDateAsString();
        return ConfigurationObjectEditorHelper.setLastChangedHistory((ComponentObject)defn, (String)principal, (String)lastChangedDate);
    }

    private ComponentType setLastChangedDate(ComponentType defn, String principal) {
        String lastChangedDate = DateUtil.getCurrentDateAsString();
        return ConfigurationObjectEditorHelper.setLastChangedHistory((ComponentType)defn, (String)principal, (String)lastChangedDate);
    }

    private ComponentObject setCreationDate(ComponentObject defn, String principal) {
        String creationDate = DateUtil.getCurrentDateAsString();
        defn = ConfigurationObjectEditorHelper.setLastChangedHistory((ComponentObject)defn, (String)principal, (String)creationDate);
        return ConfigurationObjectEditorHelper.setCreationChangedHistory((ComponentObject)defn, (String)principal, (String)creationDate);
    }

    private ComponentType setCreationDate(ComponentType defn, String principal) {
        String creationDate = DateUtil.getCurrentDateAsString();
        defn = ConfigurationObjectEditorHelper.setLastChangedHistory((ComponentType)defn, (String)principal, (String)creationDate);
        return ConfigurationObjectEditorHelper.setCreationChangedHistory((ComponentType)defn, (String)principal, (String)creationDate);
    }
}

