/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.spi.xml;

import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.ComponentObjectID;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationInfo;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.DeployedComponentID;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.api.exceptions.InvalidComponentException;
import com.metamatrix.common.config.api.exceptions.InvalidConfigurationException;
import com.metamatrix.common.config.api.exceptions.InvalidNameException;
import com.metamatrix.common.connection.BaseTransaction;
import com.metamatrix.common.connection.ManagedConnection;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.transaction.TransactionException;
import com.metamatrix.platform.config.ConfigPlugin;
import com.metamatrix.platform.config.spi.ConfigurationTransaction;
import com.metamatrix.platform.config.spi.xml.ConfigTransactionException;
import com.metamatrix.platform.config.spi.xml.ConfigUserTransaction;
import com.metamatrix.platform.config.spi.xml.XMLConfigurationReader;
import com.metamatrix.platform.config.spi.xml.XMLConfigurationWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XMLConfigurationConnector
extends BaseTransaction
implements ConfigurationTransaction {
    private ConfigUserTransaction configUserTransaction = null;
    private XMLConfigurationReader reader = null;
    private XMLConfigurationWriter writer = null;

    XMLConfigurationConnector(ManagedConnection connection, boolean readonly) throws ManagedConnectionException {
        super(connection, readonly);
    }

    @Override
    public Configuration getCurrentConfiguration() throws ConfigurationException {
        return this.getConfigurationReader().getDesignatedConfiguration(Configuration.NEXT_STARTUP_ID);
    }

    @Override
    public Configuration getDesignatedConfiguration(String designation) throws ConfigurationException {
        return this.getConfigurationReader().getDesignatedConfiguration(designation);
    }

    @Override
    public Configuration getConfiguration(String configurationName) throws ConfigurationException {
        return this.getConfigurationReader().getDesignatedConfiguration(configurationName);
    }

    @Override
    public ConfigurationModelContainer getConfigurationModel(String configName) throws ConfigurationException {
        if (configName.equalsIgnoreCase("Startup")) {
            return this.getConfigurationReader().getConfigurationModel(Configuration.STARTUP_ID);
        }
        return this.getConfigurationReader().getConfigurationModel(Configuration.NEXT_STARTUP_ID);
    }

    public ConfigurationInfo getConfigurationInfo(String configurationName) throws InvalidNameException, ConfigurationException {
        throw new UnsupportedOperationException(ConfigPlugin.Util.getString("ERR.014.002.0110", new Object[]{"getConfigurationInfo"}));
    }

    @Override
    public ConfigurationID getCurrentConfigurationID() throws ConfigurationException {
        return this.getConfigurationReader().getDesignatedConfigurationID("Next Startup");
    }

    @Override
    public ConfigurationID getDesignatedConfigurationID(String designation) throws ConfigurationException {
        return this.getConfigurationReader().getDesignatedConfigurationID(designation);
    }

    @Override
    public Map getComponentDefinitions(ConfigurationID configurationID) throws ConfigurationException {
        return this.getConfigurationReader().getComponentDefinitions(configurationID);
    }

    @Override
    public Collection getConnectionPools(ConfigurationID configurationID) throws ConfigurationException {
        return this.getConfigurationReader().getConnectionPools(configurationID);
    }

    @Override
    public Collection getResources() throws ConfigurationException {
        return this.getConfigurationReader().getResources();
    }

    @Override
    public Collection getResources(ComponentTypeID componentTypeID) throws ConfigurationException {
        Collection resources = this.getResources();
        ArrayList<ResourceDescriptor> resourcesForType = new ArrayList<ResourceDescriptor>(resources.size());
        for (ResourceDescriptor rd : resources) {
            if (!rd.getComponentTypeID().equals((Object)componentTypeID)) continue;
            resourcesForType.add(rd);
        }
        return resourcesForType;
    }

    @Override
    public String getComponentPropertyValue(ComponentObjectID componentObjectID, ComponentTypeID typeID, String propertyName) throws ConfigurationException {
        String value = this.getConfigurationReader().getComponentPropertyValue(componentObjectID, typeID, propertyName);
        return value;
    }

    @Override
    public ComponentDefn getComponentDefinition(ComponentDefnID componentID, ConfigurationID configurationID) throws ConfigurationException {
        return this.getConfigurationReader().getComponentDefinition(componentID, configurationID);
    }

    @Override
    public Collection getComponentTypeDefinitions(ComponentTypeID componentTypeID) throws ConfigurationException {
        return this.getConfigurationReader().getComponenTypeDefinitions(componentTypeID);
    }

    @Override
    public List getDeployedComponents(ConfigurationID configurationID) throws ConfigurationException {
        return this.getConfigurationReader().getDeployedComponents(configurationID);
    }

    public DeployedComponent getDeployedComponent(DeployedComponentID deployedComponentID) throws ConfigurationException {
        throw new UnsupportedOperationException(ConfigPlugin.Util.getString("ERR.014.002.0110", new Object[]{"getDeployedComponent"}));
    }

    @Override
    public Collection getHosts() throws ConfigurationException {
        return this.getConfigurationReader().getHosts();
    }

    @Override
    public ComponentType getComponentType(ComponentTypeID id) throws ConfigurationException {
        return this.getConfigurationReader().getComponentType(id);
    }

    @Override
    public Collection getAllComponentTypes(boolean includeDeprecated) throws ConfigurationException {
        return this.getConfigurationReader().getComponentTypes(includeDeprecated);
    }

    @Override
    public Collection getProductTypes(boolean includedeprecated) throws ConfigurationException {
        return this.getConfigurationReader().getProductTypes(includedeprecated);
    }

    @Override
    public Collection getAllObjectsForConfigurationModel(ConfigurationID configID) throws ConfigurationException {
        return this.getConfigurationReader().getConfigurationModel(configID).getAllObjects();
    }

    @Override
    public Collection getMonitoredComponentTypes(boolean includeDeprecated) throws ConfigurationException {
        throw new UnsupportedOperationException(ConfigPlugin.Util.getString("ERR.014.002.0110", new Object[]{"getMonitoredComponentTypes"}));
    }

    @Override
    public Date getServerStartupTime() throws ConfigurationException {
        return this.getConfigurationReader().getServerStartupTime();
    }

    public int getServerStartupState() throws ConfigurationException {
        return this.getConfigurationReader().getServerStartupState();
    }

    @Override
    public boolean doesConfigurationExist(String configurationName) throws ConfigurationException {
        ConfigurationID id = this.getConfigurationReader().getDesignatedConfigurationID(configurationName);
        return id != null;
    }

    @Override
    public void commit() throws ManagedConnectionException {
        if (this.configUserTransaction != null) {
            try {
                this.configUserTransaction.commit();
            }
            catch (Exception ce) {
                throw new ManagedConnectionException(ce, "ERR.014.002.0111", ConfigPlugin.Util.getString("ERR.014.002.0111", new Object[]{this.configUserTransaction.getTransaction().getLockAcquiredBy()}));
            }
        }
        super.commit();
        this.configUserTransaction = null;
    }

    @Override
    public void rollback() throws ManagedConnectionException {
        if (this.configUserTransaction != null) {
            try {
                this.configUserTransaction.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.rollback();
    }

    @Override
    public Set executeActions(List actions, String principalName) throws InvalidComponentException, ConfigurationException {
        Set affectedIDs = null;
        LogManager.logDetail((String)"CONFIG", (Object[])new Object[]{"Executing " + actions.size() + " action(s) for principal ", principalName});
        try {
            this.configUserTransaction = this.getConfigurationWriter().getTransaction(principalName);
            affectedIDs = this.getConfigurationWriter().executeActions(actions, this.configUserTransaction.getTransaction());
        }
        catch (TransactionException e) {
            LogManager.logTrace((String)"CONFIG", (Throwable)e, (Object[])new Object[]{"Failed actions: ", actions});
            try {
                this.configUserTransaction.rollback();
            }
            catch (Exception re) {
                // empty catch block
            }
            throw new ConfigurationException((Throwable)e, ConfigPlugin.Util.getString("MSG.014.002.0006"));
        }
        catch (ConfigurationException e) {
            LogManager.logTrace((String)"CONFIG", (Throwable)e, (Object[])new Object[]{"Failed actions: ", actions});
            try {
                this.configUserTransaction.rollback();
            }
            catch (Exception re) {
                // empty catch block
            }
            throw e;
        }
        LogManager.logInfo((String)"CONFIG", (String)ConfigPlugin.Util.getString("MSG.014.002.0007"));
        return affectedIDs;
    }

    public Set executeActions(boolean doAdjust, List actions, String principalName) throws InvalidComponentException, ConfigurationException {
        throw new UnsupportedOperationException(ConfigPlugin.Util.getString("ERR.014.002.0112"));
    }

    @Override
    public ConfigurationID overwriteConfiguration(ConfigurationID configToCopy, ConfigurationID configToOverwrite, String principalName) throws InvalidConfigurationException, ConfigurationException {
        ConfigurationID resultID = null;
        LogManager.logDetail((String)"CONFIG", (Object[])new Object[]{"Overwriting configuration ", configToOverwrite, "with configuration ", configToCopy, " for principal", principalName});
        try {
            this.configUserTransaction = this.getConfigurationWriter().getTransaction(principalName);
            resultID = this.getConfigurationWriter().overwriteConfiguration(configToCopy, configToOverwrite, this.configUserTransaction.getTransaction());
        }
        catch (ConfigTransactionException te) {
            throw new ConfigurationException((Throwable)((Object)te));
        }
        LogManager.logInfo((String)"CONFIG", (String)ConfigPlugin.Util.getString("MSG.014.002.0008"));
        return resultID;
    }

    @Override
    public void saveResources(Collection resourceDescriptors, String principalName) throws ConfigurationException {
        try {
            this.configUserTransaction = this.getConfigurationWriter().getTransaction(principalName);
            for (SharedResource rd : resourceDescriptors) {
                this.getConfigurationWriter().updateSharedResource(rd, this.configUserTransaction.getTransaction());
            }
        }
        catch (ConfigTransactionException te) {
            throw new ConfigurationException((Throwable)((Object)te));
        }
    }

    protected XMLConfigurationReader getConfigurationReader() throws ConfigurationException {
        if (this.reader == null) {
            try {
                this.reader = new XMLConfigurationReader(this.getConnection());
            }
            catch (ManagedConnectionException mce) {
                throw new ConfigurationException((Throwable)((Object)mce));
            }
        }
        return this.reader;
    }

    protected XMLConfigurationWriter getConfigurationWriter() throws ConfigurationException {
        if (this.writer == null) {
            try {
                this.writer = new XMLConfigurationWriter(this.getConnection());
            }
            catch (ManagedConnectionException mce) {
                throw new ConfigurationException((Throwable)((Object)mce));
            }
        }
        return this.writer;
    }
}

