/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.spi.xml;

import com.metamatrix.common.config.StartupStateException;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.exceptions.ConfigurationConnectionException;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.api.exceptions.ConfigurationLockException;
import com.metamatrix.common.config.model.ConfigurationModelContainerAdapter;
import com.metamatrix.common.config.util.ConfigObjectsNotResolvableException;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.MessagingException;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.util.VMNaming;
import com.metamatrix.core.event.EventObjectListener;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.platform.config.ConfigPlugin;
import com.metamatrix.platform.config.event.ConfigurationChangeEvent;
import com.metamatrix.platform.config.persistence.api.PersistentConnection;
import com.metamatrix.platform.config.persistence.api.PersistentConnectionFactory;
import com.metamatrix.platform.config.spi.xml.ConfigTransaction;
import com.metamatrix.platform.config.spi.xml.ConfigTransactionException;
import com.metamatrix.server.ResourceFinder;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class XMLConfigurationMgr {
    private static XMLConfigurationMgr mgr = null;
    private PersistentConnection connection = null;
    private PersistentConnectionFactory connFactory = null;
    private Properties props = null;
    private MessageBus messageBus = null;
    private Map configs = new HashMap();
    private Map transConfigs = new HashMap();
    private ConfigurationModelContainerAdapter adapter = new ConfigurationModelContainerAdapter();
    private String hostName = null;

    private XMLConfigurationMgr(MessageBus bus) {
        this.messageBus = bus;
        this.hostName = VMNaming.getConfigName();
        try {
            this.messageBus.addListener(ConfigurationChangeEvent.class, this.createChangeListener());
        }
        catch (MessagingException e) {
            System.out.println(ConfigPlugin.Util.getString("ERR.014.002.0126"));
        }
    }

    public static final synchronized XMLConfigurationMgr getInstance() {
        if (mgr == null) {
            XMLConfigurationMgr xmlMgr;
            mgr = xmlMgr = new XMLConfigurationMgr(ResourceFinder.getMessageBus());
        }
        return mgr;
    }

    public synchronized void init(Properties properties) throws ConfigurationException {
        if (this.connection != null && !this.connection.isClosed()) {
            return;
        }
        if (properties == null) {
            Assertion.isNotNull((Object)properties, (String)ConfigPlugin.Util.getString("ERR.014.002.0113"));
        }
        this.props = PropertiesUtils.clone((Properties)properties, (boolean)false);
        Properties factoryProps = new Properties();
        factoryProps.putAll((Map<?, ?>)this.props);
        this.connFactory = PersistentConnectionFactory.createPersistentConnectionFactory(this.props);
        this.connection = this.connFactory.createPersistentConnection();
        ConfigurationModelContainer cmc = this.readModel(Configuration.NEXT_STARTUP_ID);
        if (cmc == null) {
            throw new ConfigurationException("ERR.014.002.0114", ConfigPlugin.Util.getString("ERR.014.002.0114", new Object[]{Configuration.NEXT_STARTUP_ID}));
        }
        this.configs.put(cmc.getConfigurationID().getFullName(), cmc);
        try {
            ConfigurationModelContainer cmct = (ConfigurationModelContainer)cmc.clone();
            this.transConfigs.put(cmct.getConfigurationID().getFullName(), cmct);
        }
        catch (Exception ce) {
            throw new ConfigurationException((Throwable)ce, "ERR.014.002.0115", ConfigPlugin.Util.getString("ERR.014.002.0115", new Object[]{cmc.getConfigurationID()}));
        }
    }

    protected Properties getProperties() {
        return this.props;
    }

    public synchronized Date getServerStartupTime() throws ConfigurationException {
        return this.getConnection().getStartupTime();
    }

    public synchronized int getServerStartupState() throws ConfigurationException {
        return this.getConnection().getServerState();
    }

    public boolean isServerStarting() throws ConfigurationException {
        int startupState = this.getServerStartupState();
        return startupState == 1;
    }

    public boolean isServerStopped() throws ConfigurationException {
        int startupState = this.getServerStartupState();
        return startupState == 0;
    }

    public boolean isServerAvailable() throws ConfigurationException {
        int startupState = this.getServerStartupState();
        return startupState == 2;
    }

    protected synchronized void setServerStateToStarting(boolean force) throws StartupStateException, ConfigurationException {
        PersistentConnection conn = this.getConnection();
        if (force) {
            conn.setServerStarting(force);
        } else {
            conn.setServerStarting();
        }
    }

    protected synchronized void setServerStateToStopped() throws StartupStateException, ConfigurationException {
        this.getConnection().setServerStopped();
    }

    protected synchronized void setServerStateToStarted() throws StartupStateException, ConfigurationException {
        this.getConnection().setServerStarted();
    }

    public synchronized ConfigurationModelContainer getConfigurationModel(ConfigurationID configID) throws ConfigurationException {
        ConfigurationModelContainer cmc = (ConfigurationModelContainer)this.configs.get(configID.getFullName());
        if (cmc == null) {
            cmc = this.readModel(configID);
            if (cmc == null) {
                throw new ConfigurationException("ERR.014.002.0114", ConfigPlugin.Util.getString("ERR.014.002.0114", new Object[]{configID}));
            }
            this.configs.put(cmc.getConfigurationID().getFullName(), cmc);
            try {
                ConfigurationModelContainer cmct = (ConfigurationModelContainer)cmc.clone();
                this.transConfigs.put(cmct.getConfigurationID().getFullName(), cmct);
            }
            catch (Exception ce) {
                throw new ConfigurationException((Throwable)ce, "ERR.014.002.0116", ConfigPlugin.Util.getString("ERR.014.002.0116", new Object[]{configID}));
            }
        }
        return cmc;
    }

    private synchronized ConfigurationModelContainer readModel(ConfigurationID configID) throws ConfigurationException {
        return this.getConnection().read(configID);
    }

    synchronized ConfigurationModelContainer getConfigurationModelForTransaction(ConfigurationID configID) throws ConfigurationException {
        if (this.transConfigs.containsKey(configID.getFullName())) {
            return (ConfigurationModelContainer)this.transConfigs.get(configID.getFullName());
        }
        this.getConfigurationModel(configID);
        if (this.transConfigs.containsKey(configID.getFullName())) {
            return (ConfigurationModelContainer)this.transConfigs.get(configID.getFullName());
        }
        throw new ConfigurationException("ERR.014.002.0114", ConfigPlugin.Util.getString("ERR.014.002.0114", new Object[]{configID}));
    }

    public synchronized void rollbackTransaction() {
        this.connection.close();
        this.connection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void applyTransaction(ConfigTransaction transaction) throws ConfigTransactionException {
        ArgCheck.isNotNull((Object)transaction, (String)ConfigPlugin.Util.getString("ERR.014.002.0118"));
        if (transaction.getAction() == -1 || transaction.getAction() == 3 || transaction.getAction() == 1) {
            if (transaction.getObjects() == null || transaction.getObjects().isEmpty()) {
                throw new ConfigTransactionException("ERR.014.002.0119", ConfigPlugin.Util.getString("ERR.014.002.0119"));
            }
            Collection models = transaction.getObjects();
            PersistentConnection pc = null;
            boolean success = false;
            try {
                for (Object obj : models) {
                    if (!(obj instanceof ConfigurationModelContainer)) {
                        throw new ConfigTransactionException("ERR.014.002.0121", ConfigPlugin.Util.getString("ERR.014.002.0121", new Object[]{obj.getClass().getName()}));
                    }
                    ConfigurationModelContainer config = (ConfigurationModelContainer)obj;
                    try {
                        this.adapter.validateModel(config);
                        if (pc == null) {
                            pc = this.getConnection();
                            pc.beginTransaction();
                        }
                        pc.write(config, transaction.getLockAcquiredBy());
                        this.configs.put(config.getConfigurationID().getFullName(), config);
                        ConfigurationModelContainer cmct = (ConfigurationModelContainer)config.clone();
                        this.transConfigs.put(cmct.getConfigurationID().getFullName(), cmct);
                    }
                    catch (ConfigurationException ce) {
                        throw new ConfigTransactionException((Exception)((Object)ce), "ERR.014.002.0120", ConfigPlugin.Util.getString("ERR.014.002.0120", new Object[]{config.getConfigurationID()}));
                    }
                    catch (ConfigObjectsNotResolvableException e) {
                        throw new ConfigTransactionException((Exception)((Object)e), "ERR.014.002.0120", ConfigPlugin.Util.getString("ERR.014.002.0120", new Object[]{config.getConfigurationID()}));
                    }
                }
                try {
                    pc.commit();
                }
                catch (ConfigurationException e) {
                    throw new ConfigTransactionException((Exception)((Object)e), e.getMessage());
                }
                success = true;
            }
            finally {
                if (!success && pc != null) {
                    try {
                        pc.rollback();
                    }
                    catch (ConfigurationException e) {
                        throw new ConfigTransactionException((Exception)((Object)e), e.getMessage());
                    }
                }
            }
        }
        if (transaction.getAction() != 2 && this.messageBus != null) {
            try {
                this.messageBus.processEvent(new ConfigurationChangeEvent(this.hostName, 0));
            }
            catch (Exception e) {
                System.err.println(ConfigPlugin.Util.getString("ERR.014.002.0122", new Object[]{e.getMessage()}));
            }
        }
    }

    void performSystemInitialization(ConfigTransaction transaction) throws ConfigurationException, StartupStateException, ConfigurationLockException {
        if (!this.isServerStarting()) {
            throw new StartupStateException(1, this.getServerStartupState());
        }
        ConfigurationModelContainer ns = this.readModel(Configuration.NEXT_STARTUP_ID);
        ConfigurationModelContainer st = ns.copyAs(Configuration.STARTUP_ID);
        transaction.addObjects(ns.getConfigurationID().getFullName(), ns);
        transaction.addObjects(st.getConfigurationID().getFullName(), st);
    }

    synchronized PersistentConnection getConnection() throws ConfigurationConnectionException {
        if (this.connection == null) {
            try {
                this.connection = this.connFactory.createPersistentConnection();
            }
            catch (ConfigurationException e) {
                throw new ConfigurationConnectionException((Throwable)e);
            }
        }
        if (this.connection.isClosed()) {
            try {
                this.connection = this.connFactory.createPersistentConnection();
            }
            catch (ConfigurationException e) {
                throw new ConfigurationConnectionException((Throwable)e);
            }
        }
        return this.connection;
    }

    protected synchronized void clearCache() {
        this.configs.clear();
        this.transConfigs.clear();
    }

    protected ConfigurationChangeListener createChangeListener() {
        return new ConfigurationChangeListener(this);
    }

    protected class ConfigurationChangeListener
    implements EventObjectListener {
        private XMLConfigurationMgr mgr = null;

        public ConfigurationChangeListener(XMLConfigurationMgr theMgr) {
            this.mgr = theMgr;
        }

        public void processEvent(EventObject obj) {
            if (obj instanceof ConfigurationChangeEvent) {
                this.mgr.clearCache();
            }
        }
    }
}

