/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.spi.xml;

import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.ComponentObjectID;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.connection.ManagedConnection;
import com.metamatrix.common.transaction.TransactionException;
import com.metamatrix.platform.config.ConfigPlugin;
import com.metamatrix.platform.config.spi.xml.ConfigTransactionException;
import com.metamatrix.platform.config.spi.xml.ConfigUserTransaction;
import com.metamatrix.platform.config.spi.xml.ConfigUserTransactionFactory;
import com.metamatrix.platform.config.spi.xml.XMLConfigurationMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class XMLConfigurationReader {
    private static XMLConfigurationMgr configMgr = XMLConfigurationMgr.getInstance();
    private ConfigUserTransactionFactory factory = new ConfigUserTransactionFactory();

    public XMLConfigurationReader(ManagedConnection mgdConnection) {
    }

    public Host getHost(HostID hostID) throws ConfigurationException {
        ConfigurationModelContainer config = this.getConfigurationModel(Configuration.NEXT_STARTUP_ID);
        return config.getConfiguration().getHost(hostID.getFullName());
    }

    public Collection getHosts() throws ConfigurationException {
        ConfigurationModelContainer config = this.getConfigurationModel(Configuration.NEXT_STARTUP_ID);
        return config.getConfiguration().getHosts();
    }

    public Date getServerStartupTime() throws ConfigurationException {
        Date timestamp = configMgr.getServerStartupTime();
        return timestamp;
    }

    public ComponentType getComponentType(ComponentTypeID typeID) throws ConfigurationException {
        if (typeID == null) {
            throw new ConfigurationException("ERR.014.002.0127", ConfigPlugin.Util.getString("ERR.014.002.0127"));
        }
        ConfigurationModelContainer model = this.getConfigurationModel(Configuration.NEXT_STARTUP_ID);
        return model.getComponentType(typeID.getFullName());
    }

    public Collection getComponentTypes(boolean includeDeprecated) throws ConfigurationException {
        ConfigurationModelContainer config = this.getConfigurationModel(Configuration.NEXT_STARTUP_ID);
        Map typeMap = config.getComponentTypes();
        ArrayList types = new ArrayList(typeMap.size());
        types.addAll(typeMap.values());
        return types;
    }

    public Collection getProductTypes(boolean includeDeprecated) throws ConfigurationException {
        ConfigurationModelContainer config = this.getConfigurationModel(Configuration.NEXT_STARTUP_ID);
        Collection intypes = config.getProductTypes();
        ArrayList types = new ArrayList(intypes.size());
        types.addAll(intypes);
        return types;
    }

    public String getComponentPropertyValue(ComponentObjectID componentObjectID, ComponentTypeID typeID, String propertyName) throws ConfigurationException {
        String result = null;
        return result;
    }

    public ComponentDefn getComponentDefinition(ComponentDefnID targetID) throws ConfigurationException {
        if (targetID == null) {
            throw new ConfigurationException("ERR.014.002.0045", ConfigPlugin.Util.getString("ERR.014.002.0045", new Object[]{"ComponentDefnID"}));
        }
        ConfigurationID configurationID = this.getDesignatedConfigurationID(targetID.getParentFullName());
        ComponentDefn defn = this.getComponentDefinition(targetID, configurationID);
        return defn;
    }

    public ComponentDefn getComponentDefinition(ComponentDefnID targetID, ConfigurationID configurationID) throws ConfigurationException {
        if (targetID == null) {
            throw new ConfigurationException("ERR.014.002.0045", ConfigPlugin.Util.getString("ERR.014.002.0045", new Object[]{"ComponentDefnID"}));
        }
        ComponentDefn defn = null;
        if (configurationID == null) {
            configurationID = this.getDesignatedConfigurationID(targetID.getParentFullName());
        }
        ConfigurationModelContainer config = this.getConfigurationModel(configurationID);
        defn = config.getConfiguration().getComponentDefn(targetID);
        return defn;
    }

    public Map getComponentDefinitions(ConfigurationID configID) throws ConfigurationException {
        ConfigurationModelContainer config = this.getConfigurationModel(configID);
        return config.getConfiguration().getComponentDefns();
    }

    public Collection getConnectionPools(ConfigurationID configurationID) throws ConfigurationException {
        ConfigurationModelContainer model = this.getConfigurationModel(configurationID);
        return model.getConnectionPools();
    }

    public Collection getComponenTypeDefinitions(ComponentTypeID componentTypeID) throws ConfigurationException {
        ConfigurationModelContainer config = this.getConfigurationModel(Configuration.NEXT_STARTUP_ID);
        ComponentType t = config.getComponentType(componentTypeID.getFullName());
        if (t != null) {
            return t.getComponentTypeDefinitions();
        }
        return Collections.EMPTY_LIST;
    }

    public List getDeployedComponents(ConfigurationID configurationID) throws ConfigurationException {
        ConfigurationModelContainer config = this.getConfigurationModel(configurationID);
        Collection dcs = config.getConfiguration().getDeployedComponents();
        LinkedList result = new LinkedList();
        result.addAll(dcs);
        return result;
    }

    public Collection getResources() throws ConfigurationException {
        ConfigurationModelContainer cmc = this.getConfigurationModel(Configuration.NEXT_STARTUP_ID);
        return cmc.getResources();
    }

    public SharedResource getResource(String resourceName) throws ConfigurationException {
        ConfigurationModelContainer cmc = this.getConfigurationModel(Configuration.NEXT_STARTUP_ID);
        return cmc.getResource(resourceName);
    }

    public int getServerStartupState() throws ConfigurationException {
        return configMgr.getServerStartupState();
    }

    public boolean doesResourceExist(String resourceName) throws ConfigurationException {
        SharedResource rd = this.getResource(resourceName);
        return rd != null;
    }

    public boolean isDefinitionDeployable(ComponentDefnID defnID) throws ConfigurationException {
        ComponentDefn defn = this.getComponentDefinition(defnID);
        ComponentType type = this.getComponentType(defn.getComponentTypeID());
        return type.isDeployable();
    }

    public ConfigurationID getDesignatedConfigurationID(String designation) throws ConfigurationException {
        if (designation.startsWith("Next Startup")) {
            return Configuration.NEXT_STARTUP_ID;
        }
        if (designation.startsWith("Startup")) {
            return Configuration.STARTUP_ID;
        }
        throw new ConfigurationException("ERR.014.002.0128", ConfigPlugin.Util.getString("ERR.014.002.0128", new Object[]{designation}));
    }

    public Properties getDesignatedConfigurationProperties(String designation) throws ConfigurationException {
        ConfigurationModelContainer config = this.getConfigurationModel(this.getDesignatedConfigurationID(designation));
        return config.getConfiguration().getProperties();
    }

    public Configuration getDesignatedConfiguration(String name) throws ConfigurationException {
        ConfigurationID id = this.getDesignatedConfigurationID(name);
        return this.getDesignatedConfiguration(id);
    }

    public ConfigurationModelContainer getConfigurationModel(ConfigurationID configID) throws ConfigurationException {
        ConfigurationModelContainer config = configMgr.getConfigurationModel(configID);
        return config;
    }

    public Configuration getDesignatedConfiguration(ConfigurationID configurationID) throws ConfigurationException {
        ConfigurationModelContainer model = this.getConfigurationModel(configurationID);
        return model.getConfiguration();
    }

    public Collection getMonitoredComponentTypes(boolean includeDeprecated) throws ConfigurationException {
        return Collections.EMPTY_LIST;
    }

    public ConfigUserTransaction getTransaction(String principal) throws ConfigTransactionException {
        ConfigUserTransaction userTrans = null;
        try {
            userTrans = this.factory.createReadTransaction(principal);
            userTrans.begin();
            return userTrans;
        }
        catch (TransactionException te) {
            if (userTrans != null) {
                try {
                    userTrans.rollback();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (te instanceof ConfigTransactionException) {
                throw (ConfigTransactionException)te;
            }
            throw new ConfigTransactionException((Exception)((Object)te), "ERR.014.002.0129", ConfigPlugin.Util.getString("ERR.014.002.0129", new Object[]{principal}));
        }
    }
}

