/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.spi.xml;

import com.metamatrix.common.actions.ActionDefinition;
import com.metamatrix.common.actions.CreateObject;
import com.metamatrix.common.actions.DestroyObject;
import com.metamatrix.common.config.StartupStateException;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.api.exceptions.ConfigurationLockException;
import com.metamatrix.common.config.api.exceptions.InvalidConfigurationException;
import com.metamatrix.common.connection.ManagedConnection;
import com.metamatrix.common.transaction.TransactionException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.platform.config.ConfigPlugin;
import com.metamatrix.platform.config.spi.xml.ConfigTransaction;
import com.metamatrix.platform.config.spi.xml.ConfigTransactionException;
import com.metamatrix.platform.config.spi.xml.ConfigUserTransaction;
import com.metamatrix.platform.config.spi.xml.ConfigUserTransactionFactory;
import com.metamatrix.platform.config.spi.xml.XMLActionUpdateStrategy;
import com.metamatrix.platform.config.spi.xml.XMLConfigurationMgr;
import com.metamatrix.platform.config.spi.xml.XMLConfigurationReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class XMLConfigurationWriter {
    private static XMLConfigurationMgr configMgr = XMLConfigurationMgr.getInstance();
    private XMLConfigurationReader reader = null;
    private ConfigUserTransactionFactory factory;
    private ManagedConnection mgdConnection;
    private XMLActionUpdateStrategy updateStrategy = new XMLActionUpdateStrategy();

    public XMLConfigurationWriter(ManagedConnection mgdConnection) {
        this.mgdConnection = mgdConnection;
        this.factory = new ConfigUserTransactionFactory();
    }

    public void updateSharedResource(SharedResource resource, ConfigTransaction transaction) throws ConfigurationException, ConfigTransactionException {
        this.validateLock(transaction);
        if (resource == null) {
            ArgCheck.isNotNull((Object)resource, (String)ConfigPlugin.Util.getString("ERR.014.002.0130"));
        }
        this.updateStrategy.updateSharedResource(resource, transaction);
    }

    public void performSystemInitialization(ConfigTransaction transaction) throws StartupStateException, ConfigurationException {
        this.validateLock(transaction);
        configMgr.performSystemInitialization(transaction);
    }

    public void beginSystemInitialization(boolean forceInitialization, ConfigTransaction transaction) throws StartupStateException, ConfigurationException {
        this.validateLock(transaction);
        if (forceInitialization) {
            transaction.setAction(3);
        } else {
            transaction.setAction(1);
        }
        configMgr.setServerStateToStarting(forceInitialization);
    }

    public void finishSystemInitialization(ConfigTransaction transaction) throws StartupStateException, ConfigurationException {
        this.validateLock(transaction);
        configMgr.setServerStateToStarted();
    }

    public void indicateSystemShutdown(ConfigTransaction transaction) throws StartupStateException, ConfigurationException {
        this.validateLock(transaction);
        transaction.setAction(2);
        configMgr.setServerStateToStopped();
    }

    public ConfigurationID overwriteConfiguration(ConfigurationID configIDToCopy, ConfigurationID configIDToOverwrite, ConfigTransaction transaction) throws InvalidConfigurationException, ConfigurationException {
        throw new UnsupportedOperationException(ConfigPlugin.Util.getString("ERR.014.002.0131"));
    }

    public Set executeActions(List actions, ConfigTransaction transaction) throws ConfigTransactionException, ConfigurationLockException, ConfigurationException {
        this.validateLock(transaction);
        if (actions == null) {
            ArgCheck.isNotNull((Object)actions, (String)ConfigPlugin.Util.getString("ERR.014.002.0045", new Object[]{"actions"}));
        }
        if (transaction == null) {
            ArgCheck.isNotNull((Object)transaction, (String)ConfigPlugin.Util.getString("ERR.014.002.0045", new Object[]{"transaction"}));
        }
        HashSet result = new HashSet();
        if (actions.isEmpty()) {
            return result;
        }
        ArrayList<ActionDefinition> actionsWithSameTarget = new ArrayList<ActionDefinition>(13);
        Object currentTarget = null;
        ActionDefinition currentAction = null;
        ActionDefinition nextAction = null;
        int actionCounter = -1;
        try {
            boolean createObject = false;
            Iterator iter = actions.iterator();
            if (iter.hasNext()) {
                currentAction = (ActionDefinition)iter.next();
                currentTarget = currentAction.getTarget();
                actionsWithSameTarget.add(currentAction);
            }
            while (iter.hasNext()) {
                nextAction = (ActionDefinition)iter.next();
                if (currentAction instanceof CreateObject) {
                    createObject = true;
                }
                if (currentAction instanceof DestroyObject) {
                    if (!createObject) {
                        result.addAll(this.executeActionsOnTarget(currentTarget, actionsWithSameTarget, transaction));
                    }
                    actionCounter += actionsWithSameTarget.size();
                    actionsWithSameTarget.clear();
                    createObject = false;
                    currentTarget = nextAction.getTarget();
                } else if (currentTarget != nextAction.getTarget()) {
                    result.addAll(this.executeActionsOnTarget(currentTarget, actionsWithSameTarget, transaction));
                    actionCounter += actionsWithSameTarget.size();
                    actionsWithSameTarget.clear();
                    createObject = false;
                    currentTarget = nextAction.getTarget();
                }
                currentAction = nextAction;
                actionsWithSameTarget.add(currentAction);
            }
            if (actionsWithSameTarget.size() != 0) {
                result.addAll(this.executeActionsOnTarget(currentTarget, actionsWithSameTarget, transaction));
                createObject = false;
            }
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
        return result;
    }

    private Set executeActionsOnTarget(Object target, List actions, ConfigTransaction transaction) throws ConfigTransactionException, ConfigurationLockException, ConfigurationException {
        Set results = this.updateStrategy.executeActionsOnTarget(target, actions, transaction);
        return results;
    }

    protected ConfigUserTransaction getTransaction(String principal) throws ConfigTransactionException, ConfigurationException {
        ConfigUserTransaction trans = XMLConfigurationWriter.getWriteTransactionWithRetry(principal, this.factory);
        ConfigTransaction transaction = trans.getTransaction();
        ConfigurationID configID = this.getConfigurationReader().getDesignatedConfigurationID("Next Startup");
        ConfigurationModelContainer transconfig = configMgr.getConfigurationModelForTransaction(configID);
        transaction.addObjects(configID.getFullName(), transconfig);
        return trans;
    }

    protected XMLConfigurationReader getConfigurationReader() {
        if (this.reader == null) {
            this.reader = new XMLConfigurationReader(this.mgdConnection);
        }
        return this.reader;
    }

    private void validateLock(ConfigTransaction transaction) throws ConfigurationLockException {
        if (transaction == null) {
            throw new ConfigurationLockException("ERR.014.002.0123", ConfigPlugin.Util.getString("ERR.014.002.0123"));
        }
    }

    public static ConfigUserTransaction getWriteTransactionWithRetry(String principal, ConfigUserTransactionFactory factory) throws ConfigTransactionException {
        try {
            ConfigUserTransaction userTrans = factory.createWriteTransaction(principal);
            userTrans.begin();
            return userTrans;
        }
        catch (TransactionException te) {
            throw new ConfigTransactionException((Exception)((Object)te), "ERR.014.002.0162", ConfigPlugin.Util.getString("ERR.014.002.0162", new Object[]{principal}));
        }
    }
}

