/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.spi.xml;

import com.metamatrix.common.config.StartupStateException;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.exceptions.ConfigurationConnectionException;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.reader.CurrentConfigurationReader;
import com.metamatrix.common.connection.ManagedConnection;
import com.metamatrix.common.transaction.TransactionException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.platform.config.ConfigPlugin;
import com.metamatrix.platform.config.spi.xml.ConfigTransaction;
import com.metamatrix.platform.config.spi.xml.ConfigTransactionException;
import com.metamatrix.platform.config.spi.xml.ConfigUserTransaction;
import com.metamatrix.platform.config.spi.xml.XMLConfigurationConnectorFactory;
import com.metamatrix.platform.config.spi.xml.XMLConfigurationMgr;
import com.metamatrix.platform.config.spi.xml.XMLConfigurationReader;
import com.metamatrix.platform.config.spi.xml.XMLConfigurationWriter;
import java.util.Properties;

public class XMLCurrentConfigurationReader
implements CurrentConfigurationReader {
    public static final String INSTALL_DATE = "metamatrix.config.installationDate";
    private static final String PRINCIPAL = "CurrentConfiguration";
    private static XMLConfigurationMgr configMgr = XMLConfigurationMgr.getInstance();
    private XMLConfigurationReader reader = null;
    private XMLConfigurationWriter writer = null;

    public synchronized void connect(Properties env) throws ConfigurationConnectionException {
        try {
            configMgr.init(env);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationConnectionException((Throwable)e, "ERR.014.002.0133", ConfigPlugin.Util.getString("ERR.014.002.0133"));
        }
        try {
            XMLConfigurationConnectorFactory factory = new XMLConfigurationConnectorFactory();
            ManagedConnection mc = factory.createConnection(env, PRINCIPAL);
            if (mc == null) {
                Assertion.isNotNull((Object)mc, (String)ConfigPlugin.Util.getString("ERR.014.002.0135"));
            }
            this.reader = new XMLConfigurationReader(mc);
            this.writer = new XMLConfigurationWriter(mc);
            if (this.reader == null) {
                Assertion.isNotNull((Object)this.reader, (String)ConfigPlugin.Util.getString("ERR.014.002.0136"));
            }
            if (this.writer == null) {
                Assertion.isNotNull((Object)this.writer, (String)ConfigPlugin.Util.getString("ERR.014.002.0137"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationConnectionException((Throwable)e, "ERR.014.002.0138", ConfigPlugin.Util.getString("ERR.014.002.0138"));
        }
    }

    public void close() throws Exception {
    }

    public Properties getConfigurationProperties() throws ConfigurationException {
        Properties result = this.getConfigurationReader().getDesignatedConfigurationProperties("Next Startup");
        if (result == null) {
            throw new ConfigurationException("ERR.014.002.0139", ConfigPlugin.Util.getString("ERR.014.002.0139"));
        }
        return result;
    }

    public Configuration getNextStartupConfiguration() throws ConfigurationException {
        return this.getConfigurationReader().getDesignatedConfiguration(Configuration.NEXT_STARTUP_ID);
    }

    public ConfigurationModelContainer getConfigurationModel() throws ConfigurationException {
        return this.getConfigurationReader().getConfigurationModel(Configuration.NEXT_STARTUP_ID);
    }

    public synchronized void performSystemInitialization(boolean forceInitialization) throws StartupStateException, ConfigurationException {
        boolean force = !configMgr.isServerStopped();
        ConfigUserTransaction inittrans = null;
        try {
            inittrans = this.getWriteTransaction();
            ConfigTransaction cfgt = inittrans.getTransaction();
            this.getConfigurationWriter().beginSystemInitialization(force, cfgt);
            this.getConfigurationWriter().performSystemInitialization(cfgt);
            this.getConfigurationWriter().finishSystemInitialization(cfgt);
            inittrans.commit();
        }
        catch (TransactionException te) {
            if (inittrans != null) {
                this.rollbackTransaction(inittrans);
            }
            throw new ConfigurationException((Throwable)te, "ERR.014.002.0143", ConfigPlugin.Util.getString("ERR.014.002.0143"));
        }
    }

    public synchronized void indicateSystemShutdown() throws ConfigurationException {
        ConfigUserTransaction trans = null;
        try {
            trans = this.getWriteTransaction();
            this.getConfigurationWriter().indicateSystemShutdown(trans.getTransaction());
            trans.commit();
        }
        catch (StartupStateException sse) {
            if (trans != null) {
                try {
                    trans.rollback();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            throw new ConfigurationException((Throwable)sse, "ERR.014.002.0143", ConfigPlugin.Util.getString("ERR.014.002.0143"));
        }
        catch (TransactionException te) {
            if (trans != null) {
                try {
                    trans.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new ConfigurationException((Throwable)te, "ERR.014.002.0143", ConfigPlugin.Util.getString("ERR.014.002.0143"));
        }
    }

    private void rollbackTransaction(ConfigUserTransaction trans) {
        try {
            trans.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ConfigUserTransaction getWriteTransaction() throws ConfigTransactionException, ConfigurationException {
        return this.getConfigurationWriter().getTransaction(PRINCIPAL);
    }

    protected XMLConfigurationReader getConfigurationReader() {
        return this.reader;
    }

    protected XMLConfigurationWriter getConfigurationWriter() {
        return this.writer;
    }
}

