/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.registry;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.metamatrix.cache.Cache;
import com.metamatrix.cache.CacheConfiguration;
import com.metamatrix.cache.CacheFactory;
import com.metamatrix.cache.CacheListener;
import com.metamatrix.platform.registry.HostControllerRegistryBinding;
import com.metamatrix.platform.registry.ProcessRegistryBinding;
import com.metamatrix.platform.registry.RegistryListener;
import com.metamatrix.platform.registry.ResourceAlreadyBoundException;
import com.metamatrix.platform.registry.ResourceNotBoundException;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.service.ServicePlugin;
import com.metamatrix.platform.service.api.ServiceID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Singleton
public class ClusteredRegistryState
implements CacheListener {
    private static final String VM_CONTROLLER = "VM_Controller";
    private static final String SERVICES = "Services";
    private static final String NAME = "Name";
    Cache cache;
    private List<RegistryListener> listeners = Collections.synchronizedList(new ArrayList());

    @Inject
    public ClusteredRegistryState(CacheFactory cacheFactory) {
        this.cache = cacheFactory.get(Cache.Type.REGISTRY, new CacheConfiguration(CacheConfiguration.Policy.LRU, 0, 0));
        this.cache.addListener((CacheListener)this);
    }

    private Cache getHostNode(String hostName) throws CacheNodeNotFoundException {
        Cache node = this.cache.getChild(hostName.toUpperCase());
        if (node == null) {
            throw new CacheNodeNotFoundException("Host Node not found=" + hostName);
        }
        return node;
    }

    private Cache addProcessNode(String hostName, String processName) throws CacheNodeNotFoundException {
        Cache hostNode = this.getHostNode(hostName);
        Cache n = hostNode.addChild(processName.toUpperCase());
        n.put((Object)NAME, (Object)processName);
        return n;
    }

    private Cache getProcessNode(String hostName, String processName) throws CacheNodeNotFoundException {
        Cache hostNode = this.getHostNode(hostName);
        Cache vmNode = hostNode.getChild(processName.toUpperCase());
        if (vmNode == null) {
            throw new CacheNodeNotFoundException("VM Node not found=" + processName);
        }
        ProcessRegistryBinding binding = (ProcessRegistryBinding)vmNode.get((Object)VM_CONTROLLER);
        if (binding == null || !binding.isAlive()) {
            throw new CacheNodeNotFoundException("VM Node's binding not found or not active");
        }
        return vmNode;
    }

    protected synchronized void addHost(HostControllerRegistryBinding binding) {
        String hostName = binding.getHostName().toUpperCase();
        Cache n = this.cache.addChild(hostName);
        n.put((Object)NAME, (Object)hostName);
        n.put((Object)hostName, (Object)binding);
    }

    protected void removeHost(String hostName) {
        this.cache.removeChild(hostName.toUpperCase());
    }

    protected synchronized void addProcess(String hostName, String processName, ProcessRegistryBinding vmBinding) throws CacheNodeNotFoundException {
        Cache vmNode = this.addProcessNode(hostName, processName);
        vmNode.put((Object)VM_CONTROLLER, (Object)vmBinding);
    }

    protected void updateProcess(String hostName, String processName, ProcessRegistryBinding binding) throws ResourceNotBoundException, CacheNodeNotFoundException {
        Cache vmNode = this.getProcessNode(hostName, processName);
        if (vmNode.get((Object)VM_CONTROLLER) == null) {
            throw new ResourceNotBoundException(ServicePlugin.Util.getString("ERR.014.006.0012", new Object[]{hostName + "/" + processName}));
        }
        vmNode.put((Object)VM_CONTROLLER, (Object)binding);
    }

    protected void removeProcess(String hostName, String processName) {
        try {
            Cache hostNode = this.getHostNode(hostName);
            hostNode.removeChild(processName.toUpperCase());
        }
        catch (CacheNodeNotFoundException cacheNodeNotFoundException) {
            // empty catch block
        }
    }

    public List<HostControllerRegistryBinding> getHosts() {
        ArrayList<HostControllerRegistryBinding> list = new ArrayList<HostControllerRegistryBinding>();
        List hostNodes = this.cache.getChildren();
        for (Cache hostNode : hostNodes) {
            String hostName = (String)hostNode.get((Object)NAME);
            list.add((HostControllerRegistryBinding)hostNode.get((Object)hostName));
        }
        return list;
    }

    public HostControllerRegistryBinding getHost(String hostName) {
        try {
            Cache node = this.getHostNode(hostName);
            return (HostControllerRegistryBinding)node.get((Object)hostName.toUpperCase());
        }
        catch (CacheNodeNotFoundException e) {
            return null;
        }
    }

    public List<ProcessRegistryBinding> getVMs(String hostName) {
        return this.getVMs(hostName, new ArrayList());
    }

    private List<ProcessRegistryBinding> getVMs(String hostName, ArrayList list) {
        if (hostName == null) {
            List hostNodes = this.cache.getChildren();
            for (Cache hostNode : hostNodes) {
                this.getVMs((String)hostNode.get((Object)NAME), list);
            }
        } else {
            try {
                Cache hostNode = this.getHostNode(hostName);
                List vmNodes = hostNode.getChildren();
                for (Cache vmNode : vmNodes) {
                    list.add(vmNode.get((Object)VM_CONTROLLER));
                }
            }
            catch (CacheNodeNotFoundException cacheNodeNotFoundException) {
                // empty catch block
            }
        }
        return list;
    }

    public ProcessRegistryBinding getProcessBinding(String hostName, String processName) throws ResourceNotBoundException {
        try {
            Cache vmNode = this.getProcessNode(hostName, processName);
            ProcessRegistryBinding binding = (ProcessRegistryBinding)vmNode.get((Object)VM_CONTROLLER);
            if (binding == null) {
                throw new ResourceNotBoundException(ServicePlugin.Util.getString("ERR.014.006.0012", new Object[]{hostName + "/" + processName}));
            }
            return binding;
        }
        catch (CacheNodeNotFoundException e) {
            throw new ResourceNotBoundException(ServicePlugin.Util.getString("ERR.014.006.0012", new Object[]{hostName + "/" + processName}));
        }
    }

    protected synchronized void addServiceBinding(String hostName, String processName, ServiceRegistryBinding binding) throws ResourceAlreadyBoundException, CacheNodeNotFoundException {
        Cache services = this.getServices(hostName, processName);
        ServiceRegistryBinding existing = (ServiceRegistryBinding)services.get((Object)binding.getServiceID());
        if (existing != null && !existing.isServiceBad()) {
            throw new ResourceAlreadyBoundException(ServicePlugin.Util.getString("ERR.014.006.0024", new Object[]{binding.getServiceID()}));
        }
        services.put((Object)binding.getServiceID(), (Object)binding);
    }

    protected void updateServiceBinding(String hostName, String processName, ServiceRegistryBinding binding) throws ResourceNotBoundException, CacheNodeNotFoundException {
        Cache services = this.getServices(hostName, processName);
        ServiceRegistryBinding existing = (ServiceRegistryBinding)services.get((Object)binding.getServiceID());
        if (existing == null) {
            throw new ResourceNotBoundException(ServicePlugin.Util.getString("ERR.014.006.0011", new Object[]{binding.getServiceID()}));
        }
        services.put((Object)binding.getServiceID(), (Object)binding);
    }

    public ServiceRegistryBinding getServiceBinding(String hostName, String processName, ServiceID serviceId) throws ResourceNotBoundException {
        ServiceRegistryBinding binding;
        try {
            Cache services = this.getServices(hostName, processName);
            binding = (ServiceRegistryBinding)services.get((Object)serviceId);
            if (binding == null) {
                throw new ResourceNotBoundException(ServicePlugin.Util.getString("ERR.014.006.0011", new Object[]{serviceId}));
            }
        }
        catch (CacheNodeNotFoundException e) {
            throw new ResourceNotBoundException(ServicePlugin.Util.getString("ERR.014.006.0011", new Object[]{serviceId}));
        }
        return binding;
    }

    public List<ServiceRegistryBinding> getActiveServiceBindings(String hostName, String processName, String serviceType) {
        return this.getServiceBindings(hostName, processName, serviceType);
    }

    public List<ServiceRegistryBinding> getServiceBindings(String serviceType) {
        return this.getServiceBindings(null, null, serviceType);
    }

    public List<ServiceRegistryBinding> getServiceBindings(String hostName, String processName, String serviceType) {
        return this.getServiceBindings(hostName, processName, serviceType, false);
    }

    private List<ServiceRegistryBinding> getServiceBindings(String hostName, String processName, String serviceType, boolean active) {
        ArrayList<ServiceRegistryBinding> services = new ArrayList<ServiceRegistryBinding>();
        List<ServiceRegistryBinding> bindings = this.getServiceBindings(hostName, processName);
        for (ServiceRegistryBinding binding : bindings) {
            if (!binding.getServiceType().equals(serviceType) || active && (!active || !binding.isActive())) continue;
            services.add(binding);
        }
        return services;
    }

    public List<ServiceRegistryBinding> getServiceBindings(String hostName, String processName) {
        return this.getServiceBindings(hostName, processName, new ArrayList());
    }

    private List<ServiceRegistryBinding> getServiceBindings(String hostName, String processName, ArrayList list) {
        try {
            if (hostName == null && processName == null) {
                List hostNodes = this.cache.getChildren();
                for (Cache host : hostNodes) {
                    this.getServiceBindings((String)host.get((Object)NAME), null, list);
                }
            } else if (hostName != null && processName == null) {
                List vmNodes = this.getHostNode(hostName).getChildren();
                for (Cache vm : vmNodes) {
                    this.getServiceBindings(hostName, (String)vm.get((Object)NAME), list);
                }
            } else if (hostName != null && processName != null) {
                Cache services = this.getServices(hostName, processName);
                list.addAll(services.values());
            }
        }
        catch (CacheNodeNotFoundException e) {
            // empty catch block
        }
        return list;
    }

    private Cache getServices(String hostName, String processName) throws CacheNodeNotFoundException {
        Cache vmNode = this.getProcessNode(hostName, processName);
        Cache services = vmNode.getChild(SERVICES);
        if (services == null) {
            services = vmNode.addChild(SERVICES);
        }
        return services;
    }

    protected void removeServiceBinding(String hostName, String processName, ServiceID serviceId) {
        try {
            Cache services = this.getServices(hostName, processName);
            services.remove((Object)serviceId);
        }
        catch (CacheNodeNotFoundException e) {
            // empty catch block
        }
    }

    public void addListener(RegistryListener obj) {
        this.listeners.add(obj);
    }

    public void cacheChanged() {
        for (RegistryListener l : this.listeners) {
            l.registryChanged();
        }
    }

    static class CacheNodeNotFoundException
    extends Exception {
        public CacheNodeNotFoundException(String msg) {
            super(msg);
        }
    }
}

