/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.registry;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.registry.ProcessRegistryBinding;
import com.metamatrix.platform.registry.ResourceAlreadyBoundException;
import com.metamatrix.platform.registry.ResourceNotBoundException;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.service.api.ServiceInterface;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.service.api.exception.ServiceStateException;
import com.metamatrix.platform.vm.api.controller.ProcessManagement;
import com.metamatrix.platform.vm.controller.ServerEvents;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

@Singleton
public class ProcessMonitor
implements ServerEvents {
    private static final int POLLING_INTERVAL_DEFAULT = 15000;
    @Named(value="metamatrix.server.serviceMonitorInterval")
    int pollingIntervel = 15000;
    ClusteredRegistryState registry;
    String hostName;
    String processName;
    private Timer vmPollingThread = new Timer("VMPollingThread", true);
    private Timer servicePollingThread = new Timer("ServiceMonitoringThread", true);

    @Inject
    public ProcessMonitor(@Named(value="HostName") String hostName, @Named(value="ProcessName") String processname, ClusteredRegistryState registry) {
        this.hostName = hostName;
        this.processName = processname;
        this.registry = registry;
        this.startVMPollingThread();
        this.startServicePollingThread();
    }

    public void shutdown() {
        this.registry.removeProcess(this.hostName, this.processName);
    }

    private void startVMPollingThread() {
        this.vmPollingThread.schedule(new TimerTask(){

            @Override
            public void run() {
                List<ProcessRegistryBinding> vmBindings = ProcessMonitor.this.registry.getVMs(null);
                for (ProcessRegistryBinding binding : vmBindings) {
                    ProcessManagement vm = binding.getProcessController();
                    boolean alive = binding.isAlive();
                    try {
                        vm.ping();
                        binding.setAlive(true);
                    }
                    catch (ServiceException e) {
                        binding.setAlive(false);
                    }
                    if (alive == binding.isAlive()) continue;
                    ProcessMonitor.this.processUpdated(binding);
                }
            }
        }, 15000L, 15000L);
    }

    private void startServicePollingThread() {
        this.servicePollingThread.schedule(new TimerTask(){

            @Override
            public void run() {
                List<ServiceRegistryBinding> bindings = ProcessMonitor.this.registry.getServiceBindings(ProcessMonitor.this.hostName, ProcessMonitor.this.processName);
                for (ServiceRegistryBinding binding : bindings) {
                    ServiceInterface si = binding.getService();
                    try {
                        if (si != null) {
                            binding.getService().checkState();
                        }
                    }
                    catch (ServiceStateException e) {
                        // empty catch block
                    }
                    if (!binding.isDirty()) continue;
                    ProcessMonitor.this.serviceUpdated(binding);
                    binding.setDirty(false);
                }
            }
        }, this.pollingIntervel, (long)this.pollingIntervel);
    }

    @Override
    public void serviceAdded(ServiceRegistryBinding binding) {
        try {
            this.registry.addServiceBinding(this.hostName, this.processName, binding);
            LogManager.logDetail((String)"CONTROLLER", (Object[])new Object[]{"Service Added:" + binding.getServiceID()});
        }
        catch (ResourceAlreadyBoundException e) {
            LogManager.logWarning((String)"CONTROLLER", (String)("Service already exists:" + binding.getServiceID()));
        }
        catch (ClusteredRegistryState.CacheNodeNotFoundException e) {
            LogManager.logError((String)"CONTROLLER", (Throwable)e, (String)("Failed to add service:" + binding.getServiceID()));
        }
    }

    @Override
    public void serviceRemoved(ServiceID id) {
        this.registry.removeServiceBinding(this.hostName, this.processName, id);
        LogManager.logDetail((String)"CONTROLLER", (Object[])new Object[]{"Service removed:" + id});
    }

    @Override
    public void processAdded(ProcessRegistryBinding binding) {
        binding.setAlive(true);
        try {
            this.registry.addProcess(binding.getHostName(), binding.getProcessName(), binding);
            LogManager.logDetail((String)"CONTROLLER", (Object[])new Object[]{"VM Added:" + binding});
        }
        catch (ClusteredRegistryState.CacheNodeNotFoundException e) {
            LogManager.logError((String)"CONTROLLER", (Throwable)e, (String)("Failed to add VM:" + binding));
            throw new MetaMatrixRuntimeException("Failed to add VM:" + binding);
        }
    }

    @Override
    public void processRemoved(String hostName, String processName) {
        this.registry.removeProcess(hostName, processName);
        LogManager.logDetail((String)"CONTROLLER", (Object[])new Object[]{"VM Removed:<" + hostName + "." + processName + ">"});
    }

    @Override
    public void serviceUpdated(ServiceRegistryBinding binding) {
        try {
            this.registry.updateServiceBinding(binding.getHostName(), binding.getServiceID().getProcessName(), binding);
            LogManager.logDetail((String)"CONTROLLER", (Object[])new Object[]{"Service updated:" + binding.getServiceID()});
        }
        catch (ClusteredRegistryState.CacheNodeNotFoundException e) {
            LogManager.logError((String)"CONTROLLER", (Throwable)e, (String)("Failed to add service:" + binding.getServiceID()));
        }
        catch (ResourceNotBoundException e) {
            LogManager.logWarning((String)"CONTROLLER", (String)("Service not exist:" + binding.getServiceID()));
        }
    }

    @Override
    public void processUpdated(ProcessRegistryBinding binding) {
        try {
            this.registry.updateProcess(binding.getHostName(), binding.getProcessName(), binding);
            LogManager.logDetail((String)"CONTROLLER", (Object[])new Object[]{"VM Added:" + binding});
        }
        catch (ClusteredRegistryState.CacheNodeNotFoundException e) {
            LogManager.logError((String)"CONTROLLER", (Throwable)e, (String)("Failed to add VM:" + binding));
            throw new MetaMatrixRuntimeException("Failed to add VM:" + binding);
        }
        catch (ResourceNotBoundException e) {
            LogManager.logWarning((String)"CONTROLLER", (String)("VM does not exist:" + binding));
        }
    }
}

