/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.registry;

import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.platform.vm.api.controller.ProcessManagement;
import com.metamatrix.server.ResourceFinder;
import java.io.Serializable;

public class ProcessRegistryBinding
implements Serializable {
    private String hostName;
    private String processName;
    private boolean alive;
    private transient ProcessManagement processController;
    private Object vmControllerStub;
    private VMComponentDefn vmComponent;
    private transient MessageBus messageBus;

    public ProcessRegistryBinding(String hostName, String processName, VMComponentDefn deployedComponent, ProcessManagement vmController, MessageBus bus) {
        this.hostName = hostName;
        this.processName = processName;
        this.vmComponent = deployedComponent;
        this.processController = vmController;
        this.messageBus = bus;
        this.vmControllerStub = this.getStub(vmController);
    }

    private Object getStub(ProcessManagement controller) {
        if (controller == null) {
            return null;
        }
        return this.messageBus.export(controller, new Class[]{ProcessManagement.class});
    }

    public synchronized ProcessManagement getProcessController() {
        if (this.processController != null) {
            return this.processController;
        }
        if (this.vmControllerStub == null) {
            return null;
        }
        MessageBus bus = this.messageBus;
        if (bus == null) {
            bus = ResourceFinder.getMessageBus();
        }
        this.processController = (ProcessManagement)bus.getRPCProxy(this.vmControllerStub);
        return this.processController;
    }

    public VMComponentDefn getDeployedComponent() {
        return this.vmComponent;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getPort() {
        return this.vmComponent.getPort();
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean flag) {
        this.alive = flag;
    }

    public String toString() {
        return "Process<" + this.hostName + "|" + this.processName + ">";
    }
}

