/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.registry;

import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.service.api.ServiceInterface;
import com.metamatrix.server.ResourceFinder;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class ServiceRegistryBinding
implements Serializable {
    private ServiceID serviceID;
    private transient ServiceInterface service;
    private Object serviceStub;
    private String serviceType;
    private String componentType;
    private String deployedName;
    private String hostName;
    private String instanceName;
    private int currentState;
    private Date stateChangeTime;
    private boolean essential;
    private DeployedComponent deployedComponent;
    private ProductServiceConfigID pscID;
    private Collection queueNames;
    private Throwable initException;
    private transient MessageBus messageBus;
    private transient boolean dirty;

    public ServiceRegistryBinding(ServiceID serviceID, ServiceInterface si, String serviceType, String instanceName, String componentType, String deployedName, String hostName, DeployedComponent deployedComponent, ProductServiceConfigID pscID, int state, Date time, boolean essential, MessageBus bus) {
        this.serviceID = serviceID;
        this.serviceType = serviceType;
        this.instanceName = instanceName;
        this.componentType = componentType;
        this.deployedName = deployedName;
        this.hostName = hostName;
        this.deployedComponent = deployedComponent;
        this.pscID = pscID;
        this.currentState = state;
        this.stateChangeTime = time;
        this.essential = essential;
        this.messageBus = bus;
        this.setService(si);
    }

    public ServiceID getServiceID() {
        return this.serviceID;
    }

    public synchronized ServiceInterface getService() {
        if (this.service != null) {
            return this.service;
        }
        if (this.serviceStub == null) {
            return null;
        }
        MessageBus bus = this.messageBus;
        if (bus == null) {
            bus = ResourceFinder.getMessageBus();
        }
        this.service = (ServiceInterface)bus.getRPCProxy(this.serviceStub);
        return this.service;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public String getDeployedName() {
        return this.deployedName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getProcessName() {
        return this.serviceID.getProcessName();
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public Date getStateChangeTime() {
        return this.stateChangeTime;
    }

    public boolean isEssential() {
        return this.essential;
    }

    public DeployedComponent getDeployedComponent() {
        return this.deployedComponent;
    }

    public ProductServiceConfigID getPscID() {
        return this.pscID;
    }

    public boolean isServiceBad() {
        return this.currentState == 2 || this.currentState == 3 || this.currentState == 4;
    }

    public Collection getQueueNames() {
        if (this.queueNames == null) {
            this.queueNames = this.buildQueueNames(this.service);
        }
        return this.queueNames;
    }

    public Throwable getInitException() {
        return this.initException;
    }

    public void setInitException(Throwable t) {
        this.initException = t;
    }

    public void updateState(int state) {
        if (this.currentState != state) {
            this.currentState = state;
            this.stateChangeTime = new Date();
            this.dirty = true;
        }
    }

    private Collection buildQueueNames(ServiceInterface si) {
        Collection stats;
        ArrayList<String> queue = null;
        if (si != null && (stats = si.getQueueStatistics()) != null) {
            queue = new ArrayList<String>();
            for (WorkerPoolStats qs : stats) {
                queue.add(qs.name);
            }
        }
        return queue;
    }

    public String toString() {
        StringBuffer b = new StringBuffer("ServiceRegistryBinding: ");
        b.append("\n\tserviceID: " + this.serviceID);
        b.append("\n\tserviceType: " + this.serviceType);
        b.append("\n\tinstanceName: " + this.instanceName);
        b.append("\n\thostName: " + this.hostName);
        b.append("\n\tpscName: " + this.pscID);
        b.append("\n\tDeployedComponent: " + this.deployedComponent);
        b.append("\n\tcurrentState: " + this.currentState);
        b.append("\n\tessential: " + (this.essential ? "true" : "false"));
        try {
            b.append("\n\tserviceStub className = " + this.serviceStub.getClass().getName());
        }
        catch (Exception e) {
            b.append("\n\tserviceStub className = null");
        }
        return b.toString();
    }

    private synchronized void setService(ServiceInterface service) {
        this.service = service;
        if (this.serviceStub != null) {
            this.messageBus.unExport(this.serviceStub);
            this.serviceStub = null;
        }
        if (service != null) {
            this.serviceStub = this.messageBus.export(service, service.getClass().getInterfaces());
            this.service = (ServiceInterface)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), service.getClass().getInterfaces(), (InvocationHandler)new StateAwareProxy(service));
        }
    }

    public boolean isActive() {
        return this.currentState == 1 || this.currentState == 6;
    }

    public void markServiceAsBad() {
        this.setService(null);
        this.updateState(3);
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private final class StateAwareProxy
    implements InvocationHandler {
        private final ServiceInterface proxiedService;

        private StateAwareProxy(ServiceInterface proxiedService) {
            this.proxiedService = proxiedService;
        }

        @Override
        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            if (!m.getDeclaringClass().equals(ServiceInterface.class)) {
                this.proxiedService.checkState();
            }
            Object returnObj = null;
            try {
                returnObj = m.invoke((Object)this.proxiedService, args);
            }
            catch (InvocationTargetException err) {
                throw err.getTargetException();
            }
            ServiceRegistryBinding.this.setInitException(this.proxiedService.getInitException());
            ServiceRegistryBinding.this.updateState(this.proxiedService.getCurrentState());
            return returnObj;
        }
    }
}

