/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api.service;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.admin.api.objects.AdminOptions;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.AuthorizationMgmtException;
import com.metamatrix.api.exception.security.InvalidUserException;
import com.metamatrix.api.exception.security.MembershipServiceException;
import com.metamatrix.platform.admin.api.EntitlementMigrationReport;
import com.metamatrix.platform.admin.api.PermissionDataNode;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationPolicy;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.service.api.ServiceInterface;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface AuthorizationServiceInterface
extends ServiceInterface {
    public static final String NAME = "AuthorizationService";

    public boolean checkAccess(SessionToken var1, String var2, AuthorizationPermission var3) throws InvalidSessionException, AuthorizationMgmtException;

    public boolean checkAccess(SessionToken var1, String var2, AuthorizationPermission var3, boolean var4) throws InvalidSessionException, AuthorizationMgmtException;

    public Collection getInaccessibleResources(SessionToken var1, String var2, Collection var3) throws InvalidSessionException, AuthorizationMgmtException;

    public List getGroupEntitlements(AuthorizationRealm var1, Collection var2) throws AuthorizationMgmtException;

    public List getGroupEntitlements(AuthorizationRealm var1, String var2) throws AuthorizationMgmtException;

    public List getElementEntitlements(AuthorizationRealm var1, Collection var2) throws AuthorizationMgmtException;

    public List getElementEntitlements(AuthorizationRealm var1, String var2) throws AuthorizationMgmtException;

    public Collection getRealmNames(SessionToken var1) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException;

    public boolean containsPolicy(SessionToken var1, AuthorizationPolicyID var2) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException;

    public Collection findAllPolicyIDs(SessionToken var1) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException;

    public Collection findPolicyIDs(SessionToken var1, Collection var2) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException;

    public Collection getPolicies(SessionToken var1, Collection var2) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException;

    public AuthorizationPolicy getPolicy(SessionToken var1, AuthorizationPolicyID var2) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException;

    public Set executeTransaction(SessionToken var1, List var2) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException;

    public boolean isCallerInRole(SessionToken var1, String var2) throws AuthorizationMgmtException;

    public Map getRoleDescriptions(SessionToken var1) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException;

    public Collection getPrincipalsForRole(SessionToken var1, String var2) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException;

    public Collection getRoleNamesForPrincipal(SessionToken var1, MetaMatrixPrincipalName var2) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException;

    public boolean removePrincipalFromAllPolicies(SessionToken var1, MetaMatrixPrincipalName var2) throws AuthorizationException, AuthorizationMgmtException;

    public Collection getPolicyIDsWithPermissionsInRealm(SessionToken var1, AuthorizationRealm var2) throws AuthorizationException, AuthorizationMgmtException;

    public Collection getPolicyIDsInRealm(SessionToken var1, AuthorizationRealm var2) throws AuthorizationException, AuthorizationMgmtException;

    public Collection getPoliciesInRealm(SessionToken var1, AuthorizationRealm var2) throws AuthorizationException, AuthorizationMgmtException;

    public Collection getPolicyIDsInPartialRealm(SessionToken var1, AuthorizationRealm var2) throws AuthorizationException, AuthorizationMgmtException;

    public Collection getPolicIDsForResourceInRealm(SessionToken var1, AuthorizationRealm var2, String var3) throws AuthorizationException, AuthorizationMgmtException;

    public boolean hasPolicy(SessionToken var1, AuthorizationRealm var2, String var3) throws AuthorizationMgmtException, InvalidUserException, MembershipServiceException;

    public void migratePolicies(SessionToken var1, EntitlementMigrationReport var2, String var3, String var4, Set var5, Collection var6, AdminOptions var7) throws MetaMatrixComponentException, InvalidSessionException, AuthorizationException, AuthorizationMgmtException;

    public PermissionDataNode fillPermissionNodeTree(PermissionDataNode var1, AuthorizationPolicyID var2) throws AuthorizationMgmtException;
}

