/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.audit;

import com.metamatrix.platform.PlatformPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AuditLevel {
    public static final int NONE = 0;
    public static final int FULL = 1;
    public static final int DEFAULT_AUDIT_LEVEL = 0;
    private static final int MINIMUM = 0;
    private static final int MAXIMUM = 1;
    private static Map LABEL_TO_LEVEL_MAP = new HashMap();
    private static Map DISPLAY_TO_LEVEL_MAP = new HashMap();
    private static List LABELS = new ArrayList(2);
    private static List DISPLAYS = new ArrayList(2);

    public static boolean isAuditLevelValid(int newAuditLevel) {
        return newAuditLevel >= 0 && newAuditLevel <= 1;
    }

    public static List getLabels() {
        return LABELS;
    }

    public static List getDisplayNames() {
        return DISPLAYS;
    }

    public static String getLabelForLevel(int level) {
        switch (level) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "FULL";
            }
        }
        return "UNKNOWN";
    }

    public static String getDisplayNameForLevel(int level) {
        switch (level) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Full";
            }
        }
        return "Unknown";
    }

    public static int getLevelForLabel(String messageLabel) {
        Integer result = (Integer)LABEL_TO_LEVEL_MAP.get(messageLabel);
        if (result == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.207.0001", new Object[]{messageLabel}));
        }
        return result;
    }

    public static int getLevelForDisplayName(String messageDisplayName) {
        Integer result = (Integer)DISPLAY_TO_LEVEL_MAP.get(messageDisplayName);
        if (result == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.207.0002", new Object[]{messageDisplayName}));
        }
        return result;
    }

    public static int getMinimumLevel() {
        return 0;
    }

    public static int getMaximumLevel() {
        return 1;
    }

    static {
        LABEL_TO_LEVEL_MAP.put("FULL", new Integer(1));
        LABEL_TO_LEVEL_MAP.put("NONE", new Integer(0));
        DISPLAY_TO_LEVEL_MAP.put("Full", new Integer(1));
        DISPLAY_TO_LEVEL_MAP.put("None", new Integer(0));
        LABELS.add("NONE");
        LABELS.add("FULL");
        DISPLAYS.add("None");
        DISPLAYS.add("Full");
    }

    public static class DisplayNames {
        public static final String FULL = "Full";
        public static final String NONE = "None";
        static final String UNKNOWN = "Unknown";
    }

    public static class Labels {
        public static final String FULL = "FULL";
        public static final String NONE = "NONE";
        static final String UNKNOWN = "UNKNOWN";
    }
}

