/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.audit;

import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.queue.WorkerPoolFactory;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.audit.AuditConfiguration;
import com.metamatrix.platform.security.audit.AuditMessage;
import com.metamatrix.platform.security.audit.config.AuditConfigurationException;
import com.metamatrix.platform.security.audit.config.BasicAuditConfiguration;
import com.metamatrix.platform.security.audit.config.CurrentConfigAuditConfigurationFactory;
import com.metamatrix.platform.security.audit.config.UnmodifiableAuditConfiguration;
import com.metamatrix.platform.security.audit.destination.AuditDestination;
import com.metamatrix.platform.security.audit.destination.AuditDestinationInitFailedException;
import com.metamatrix.platform.security.audit.destination.ConsoleAuditDestination;
import com.metamatrix.platform.security.audit.destination.DatabaseAuditDestination;
import com.metamatrix.platform.security.audit.destination.SingleFileAuditDestination;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public final class AuditManager {
    public static final String SYSTEM_AUDIT_LEVEL_PROPERTY_NAME = "metamatrix.audit.enabled";
    public static final String SYSTEM_AUDIT_CONSOLE_PROPERTY_NAME = "metamatrix.audit.console";
    public static final String SYSTEM_AUDIT_THREAD_TTL = "metamatrix.audit.threadTTL";
    protected static final String DEFAULT_AUDIT_MAX_THREADS = "1";
    protected static final String DEFAULT_AUDIT_THREAD_TTL = "600000";
    private static AuditConfiguration configuration = null;
    private List auditDestinations = new ArrayList();
    private WorkerPool workerPool;

    public AuditManager() {
        LogManager.logInfo((String)"AUDIT", (String)PlatformPlugin.Util.getString("MSG.014.207.0001"));
        Properties currentConfigProperties = new Properties();
        Properties globalProperties = CurrentConfiguration.getInstance().getProperties();
        currentConfigProperties.putAll((Map<?, ?>)globalProperties);
        Properties auditProperties = PropertiesUtils.clone((Properties)currentConfigProperties, (Properties)System.getProperties(), (boolean)true, (boolean)false);
        auditProperties.setProperty("metamatrix.audit.fileAppend", Boolean.TRUE.toString());
        CurrentConfigAuditConfigurationFactory configFactory = new CurrentConfigAuditConfigurationFactory();
        try {
            configuration = configFactory.getConfiguration(auditProperties);
        }
        catch (AuditConfigurationException e) {
            LogManager.logWarning((String)"AUDIT", (Throwable)((Object)e), (String)PlatformPlugin.Util.getString("ERR.014.207.0004"));
            configuration = new BasicAuditConfiguration();
        }
        configuration = new UnmodifiableAuditConfiguration(configuration);
        if (configuration.getAuditLevel() != 0) {
            this.initializeDestinations(auditProperties);
        }
        LogManager.logInfo((String)"AUDIT", (String)PlatformPlugin.Util.getString("MSG.014.207.0008", new Object[]{((Object)configuration).toString()}));
        Iterator iter = this.auditDestinations.iterator();
        StringBuffer dests = new StringBuffer();
        while (iter.hasNext()) {
            AuditDestination dest = (AuditDestination)iter.next();
            dests.append(dest.getDescription());
            dests.append(", ");
        }
        if (dests.length() >= 2) {
            dests.setLength(dests.length() - 2);
        }
        LogManager.logInfo((String)"AUDIT", (String)PlatformPlugin.Util.getString("MSG.014.207.0002", new Object[]{dests.toString()}));
        this.initializeQueueWorkers();
        LogManager.logInfo((String)"AUDIT", (String)PlatformPlugin.Util.getString("MSG.014.207.0003"));
    }

    private void initializeDestinations(Properties auditProperties) {
        boolean dbEnabled;
        this.auditDestinations.clear();
        String specifiedLogFileName = auditProperties.getProperty("metamatrix.audit.file");
        if (specifiedLogFileName != null && specifiedLogFileName.trim().length() != 0) {
            SingleFileAuditDestination destination = new SingleFileAuditDestination();
            try {
                destination.initialize(auditProperties);
                this.auditDestinations.add(destination);
                LogManager.logInfo((String)"AUDIT", (String)PlatformPlugin.Util.getString("MSG.014.207.0004", new Object[]{destination.getDescription()}));
            }
            catch (AuditDestinationInitFailedException e) {
                LogManager.logError((String)"AUDIT", (Throwable)((Object)e), (String)PlatformPlugin.Util.getString("ERR.014.207.0006", new Object[]{destination.getDescription()}));
            }
        }
        if (dbEnabled = Boolean.valueOf(auditProperties.getProperty("metamatrix.audit.jdbcDatabase")).booleanValue()) {
            DatabaseAuditDestination destination = new DatabaseAuditDestination();
            try {
                destination.initialize(auditProperties);
                this.auditDestinations.add(destination);
                LogManager.logInfo((String)"AUDIT", (String)PlatformPlugin.Util.getString("MSG.014.207.0004", new Object[]{destination.getDescription()}));
            }
            catch (AuditDestinationInitFailedException e) {
                LogManager.logError((String)"AUDIT", (Throwable)((Object)e), (String)PlatformPlugin.Util.getString("ERR.014.207.0006", new Object[]{destination.getDescription()}));
            }
        } else {
            LogManager.logInfo((String)"AUDIT", (String)PlatformPlugin.Util.getString("MSG.014.207.0005"));
        }
        boolean includeConsole = Boolean.valueOf(auditProperties.getProperty(SYSTEM_AUDIT_CONSOLE_PROPERTY_NAME));
        if (includeConsole || this.auditDestinations.size() == 0) {
            ConsoleAuditDestination destination = new ConsoleAuditDestination();
            try {
                destination.initialize(auditProperties);
                this.auditDestinations.add(destination);
                LogManager.logInfo((String)"AUDIT", (String)PlatformPlugin.Util.getString("MSG.014.207.0004", new Object[]{destination.getDescription()}));
            }
            catch (AuditDestinationInitFailedException e) {
                LogManager.logError((String)"AUDIT", (Throwable)((Object)e), (String)PlatformPlugin.Util.getString("ERR.014.207.0006", new Object[]{destination.getDescription()}));
            }
        }
    }

    private void initializeQueueWorkers() {
        try {
            String threadTTLString = System.getProperty(SYSTEM_AUDIT_THREAD_TTL, DEFAULT_AUDIT_THREAD_TTL);
            this.workerPool = WorkerPoolFactory.newWorkerPool((String)"AuditQueue", (int)1, (long)Integer.parseInt(threadTTLString));
        }
        catch (Exception e) {
            LogManager.logError((String)"AUDIT", (String)PlatformPlugin.Util.getString("ERR.014.207.0007", new Object[]{e}));
        }
    }

    public void record(String context, String activity, String principal, Collection permissions) {
        if (permissions != null && !permissions.isEmpty()) {
            if (this.isLevelDiscarded(1)) {
                return;
            }
            ArrayList<String> resources = new ArrayList<String>(permissions.size());
            Iterator permItr = permissions.iterator();
            while (permItr.hasNext()) {
                resources.add(((AuthorizationPermission)permItr.next()).getResourceName());
            }
            AuditMessage msg = new AuditMessage(context, activity, principal, resources.toArray());
            try {
                this.addMessageToQueue(msg);
            }
            catch (Exception e2) {
                LogManager.logError((String)"AUDIT", (String)PlatformPlugin.Util.getString("ERR.014.207.0010", new Object[]{e2}));
            }
        }
    }

    public void record(String context, String activity, String principal, Object[] resources) {
        if (resources != null) {
            if (this.isLevelDiscarded(1)) {
                return;
            }
            AuditMessage msg = new AuditMessage(context, activity, principal, resources);
            try {
                this.addMessageToQueue(msg);
            }
            catch (Exception e2) {
                LogManager.logError((String)"AUDIT", (String)PlatformPlugin.Util.getString("ERR.014.207.0010", new Object[]{e2}));
            }
        }
    }

    public void record(String context, String activity, String principal, String resource) {
        if (resource != null) {
            if (this.isLevelDiscarded(1)) {
                return;
            }
            AuditMessage msg = new AuditMessage(context, activity, principal, new Object[]{resource});
            try {
                this.addMessageToQueue(msg);
            }
            catch (Exception e2) {
                LogManager.logError((String)"AUDIT", (String)PlatformPlugin.Util.getString("ERR.014.207.0010", new Object[]{e2}));
            }
        }
    }

    private boolean isLevelDiscarded(int msgLevel) {
        return configuration.isLevelDiscarded(msgLevel);
    }

    private boolean isContextDiscarded(String context) {
        return configuration.isContextDiscarded(context);
    }

    public synchronized void stop() {
        LogManager.logInfo((String)"AUDIT", (String)PlatformPlugin.Util.getString("MSG.014.207.0006"));
        try {
            if (this.workerPool != null) {
                this.workerPool.shutdown();
            }
            this.workerPool.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            for (AuditDestination dest : this.auditDestinations) {
                dest.shutdown();
            }
            this.auditDestinations.clear();
        }
        catch (Exception e) {
            LogManager.logError((String)"AUDIT", (Throwable)e, (String)PlatformPlugin.Util.getString("ERR.014.207.0008"));
        }
    }

    public AuditConfiguration getAuditConfiguration() {
        return configuration;
    }

    public void setAuditConfiguration(AuditConfiguration config) {
        if (config != null) {
            LogManager.logInfo((String)"AUDIT", (String)PlatformPlugin.Util.getString("MSG.014.207.0008", new Object[]{config}));
            if (config instanceof UnmodifiableAuditConfiguration) {
                UnmodifiableAuditConfiguration unmodConfig = (UnmodifiableAuditConfiguration)config;
                configuration = (AuditConfiguration)unmodConfig.deepClone();
            } else {
                configuration = new UnmodifiableAuditConfiguration((AuditConfiguration)config.clone());
            }
        }
    }

    public boolean isMessageToBeRecorded(String context) {
        if (context == null) {
            return false;
        }
        if (this.isLevelDiscarded(1)) {
            return false;
        }
        return !this.isContextDiscarded(context);
    }

    public boolean isMessageToBeRecorded(AuditMessage message) {
        if (message == null) {
            return false;
        }
        if (this.isLevelDiscarded(1)) {
            return false;
        }
        return !this.isContextDiscarded(message.getContext());
    }

    private void addMessageToQueue(final AuditMessage msg) {
        this.workerPool.execute(new Runnable(){

            @Override
            public void run() {
                AuditManager.this.distributeMessage(msg);
            }
        });
    }

    void distributeMessage(AuditMessage message) {
        if (!this.isContextDiscarded(message.getContext())) {
            for (AuditDestination dest : this.auditDestinations) {
                dest.record(message);
            }
        }
    }
}

