/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.audit;

import com.metamatrix.common.util.VMNaming;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class AuditMessage
implements Externalizable {
    public static final String PROCESS_NAME = VMNaming.getProcessName();
    public static final String HOST_NAME = VMNaming.getConfigName();
    private static final String RESOURCE_DELIMITER = ", ";
    private String context;
    private String activity;
    private String principal;
    private Object[] resources;
    private long timestamp;
    private String hostName;
    private String processName;

    public AuditMessage() {
    }

    public AuditMessage(String context, String activity, String principal, Object[] resources) {
        this.context = context;
        this.activity = activity;
        this.principal = principal;
        this.resources = resources;
        this.timestamp = System.currentTimeMillis();
        this.hostName = HOST_NAME;
        this.processName = PROCESS_NAME;
    }

    public String getContext() {
        return this.context;
    }

    public String getActivity() {
        return this.activity;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Object[] getResources() {
        return this.resources;
    }

    public String getText() {
        StringBuffer text = new StringBuffer();
        if (this.resources != null && this.resources.length > 0) {
            Object resource = this.resources[0];
            if (resource != null) {
                text.append(resource.toString());
            }
            for (int i = 1; i < this.resources.length; ++i) {
                text.append(RESOURCE_DELIMITER);
                resource = this.resources[i];
                if (resource == null) continue;
                text.append(resource.toString());
            }
        }
        return text.toString();
    }

    public String getText(String delimiter) {
        StringBuffer text;
        block6: {
            block5: {
                text = new StringBuffer();
                if (delimiter == null) break block5;
                if (this.resources == null || this.resources.length <= 0) break block6;
                Object resource = this.resources[0];
                if (resource != null) {
                    text.append(resource.toString());
                }
                for (int i = 1; i < this.resources.length; ++i) {
                    text.append(delimiter);
                    resource = this.resources[i];
                    if (resource == null) continue;
                    text.append(resource.toString());
                }
                break block6;
            }
            if (this.resources != null && this.resources.length > 0) {
                Object resource = this.resources[0];
                if (resource != null) {
                    text.append(resource.toString());
                }
                for (int i = 1; i < this.resources.length; ++i) {
                    text.append(RESOURCE_DELIMITER);
                    resource = this.resources[i];
                    if (resource == null) continue;
                    text.append(resource.toString());
                }
            }
        }
        return text.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.context);
        out.writeObject(this.activity);
        out.writeObject(this.principal);
        out.writeObject(this.resources);
        out.writeLong(this.timestamp);
        out.writeObject(this.processName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.context = (String)in.readObject();
        this.activity = (String)in.readObject();
        this.principal = (String)in.readObject();
        this.resources = (Object[])in.readObject();
        this.timestamp = in.readLong();
        this.processName = (String)in.readObject();
    }
}

