/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.audit.config;

import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.audit.AuditConfiguration;
import com.metamatrix.platform.security.audit.AuditLevel;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BasicAuditConfiguration
implements AuditConfiguration,
Serializable {
    private Set discardedContexts = null;
    private Set unmodifiableContexts = null;
    private int auditLevel;

    public BasicAuditConfiguration(Collection contexts, int auditLevel) {
        if (!AuditLevel.isAuditLevelValid(auditLevel)) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.207.0005", new Object[]{auditLevel}));
        }
        this.auditLevel = auditLevel;
        this.discardedContexts = contexts != null ? new HashSet(contexts) : new HashSet();
        this.unmodifiableContexts = Collections.unmodifiableSet(this.discardedContexts);
    }

    public BasicAuditConfiguration(AuditConfiguration config) {
        this.setAuditLevel(config.getAuditLevel());
        this.discardedContexts = new HashSet(config.getDiscardedContexts());
        this.unmodifiableContexts = Collections.unmodifiableSet(this.discardedContexts);
    }

    public BasicAuditConfiguration() {
        this.auditLevel = 0;
        this.discardedContexts = new HashSet();
        this.unmodifiableContexts = Collections.unmodifiableSet(this.discardedContexts);
    }

    public BasicAuditConfiguration(Collection contexts) {
        this(contexts, 0);
    }

    public BasicAuditConfiguration(int auditLevel) {
        this(null, auditLevel);
    }

    @Override
    public boolean isContextDiscarded(String context) {
        return context != null && this.discardedContexts.contains(context);
    }

    @Override
    public boolean isLevelDiscarded(int level) {
        return level > this.auditLevel;
    }

    @Override
    public Set getDiscardedContexts() {
        return this.unmodifiableContexts;
    }

    @Override
    public void discardContexts(Collection contexts) {
        if (contexts != null) {
            Iterator iter = contexts.iterator();
            while (iter.hasNext()) {
                this.discardedContexts.add(iter.next().toString());
            }
        }
    }

    @Override
    public void discardContext(String context) {
        if (context != null) {
            this.discardedContexts.add(context);
        }
    }

    @Override
    public void recordAllContexts() {
        this.discardedContexts.clear();
    }

    @Override
    public void recordContext(String context) {
        if (context != null) {
            this.discardedContexts.remove(context);
        }
    }

    @Override
    public void recordContexts(Collection contexts) {
        if (contexts != null) {
            Iterator iter = contexts.iterator();
            while (iter.hasNext()) {
                this.discardedContexts.remove(iter.next().toString());
            }
        }
    }

    @Override
    public int getAuditLevel() {
        return this.auditLevel;
    }

    @Override
    public void setAuditLevel(int newAuditLevel) {
        if (!AuditLevel.isAuditLevelValid(newAuditLevel)) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.207.0005", new Object[]{newAuditLevel}));
        }
        this.auditLevel = newAuditLevel;
    }

    @Override
    public int compareTo(Object obj) {
        AuditConfiguration that = (AuditConfiguration)obj;
        if (obj == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.207.0012"));
        }
        int diff = this.getAuditLevel() - that.getAuditLevel();
        if (diff != 0) {
            return diff;
        }
        boolean sizesMatch = this.getDiscardedContexts().size() == that.getDiscardedContexts().size();
        boolean thisContainsThat = this.getDiscardedContexts().containsAll(that.getDiscardedContexts());
        if (thisContainsThat) {
            if (sizesMatch) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AuditConfiguration) {
            AuditConfiguration that = (AuditConfiguration)obj;
            int diff = this.getAuditLevel() - that.getAuditLevel();
            if (diff != 0) {
                return false;
            }
            boolean sizesMatch = this.getDiscardedContexts().size() == that.getDiscardedContexts().size();
            boolean thisContainsThat = this.getDiscardedContexts().containsAll(that.getDiscardedContexts());
            if (thisContainsThat && sizesMatch) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer("AuditConfiguration: {");
        str.append(AuditLevel.getLabelForLevel(this.auditLevel));
        str.append(":DiscardedContexts[");
        Iterator iter = this.discardedContexts.iterator();
        if (iter.hasNext()) {
            str.append(iter.next().toString());
        }
        while (iter.hasNext()) {
            str.append(',');
            str.append(iter.next().toString());
        }
        str.append("]}");
        return str.toString();
    }

    @Override
    public Object clone() {
        return new BasicAuditConfiguration(this.discardedContexts, this.auditLevel);
    }
}

