/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.audit.config;

import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.audit.AuditConfiguration;
import com.metamatrix.platform.security.audit.config.AuditConfigurationException;
import com.metamatrix.platform.security.audit.config.AuditConfigurationFactory;
import com.metamatrix.platform.security.audit.config.BasicAuditConfiguration;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;

public class CurrentConfigAuditConfigurationFactory
implements AuditConfigurationFactory {
    public static final String AUDIT_CONTEXT_PROPERTY_NAME = "metamatrix.audit.contexts";
    public static final String CONTEXT_DELIMETER = ",";

    @Override
    public AuditConfiguration getConfiguration(Properties p) throws AuditConfigurationException {
        String contextValues;
        if (p == null) {
            return new BasicAuditConfiguration();
        }
        BasicAuditConfiguration result = null;
        String logValue = p.getProperty("metamatrix.audit.enabled");
        if (logValue != null && logValue.trim().length() > 0) {
            if (logValue.equalsIgnoreCase("true")) {
                result = new BasicAuditConfiguration(1);
            } else if (logValue.equalsIgnoreCase("false")) {
                result = new BasicAuditConfiguration(0);
            } else {
                throw new AuditConfigurationException(PlatformPlugin.Util.getString("ERR.014.207.0013", new Object[]{logValue}));
            }
        }
        if (result == null) {
            result = new BasicAuditConfiguration();
        }
        if ((contextValues = p.getProperty(AUDIT_CONTEXT_PROPERTY_NAME)) != null) {
            HashSet<String> discardedCtxs = new HashSet<String>();
            StringTokenizer tokenizer = new StringTokenizer(contextValues, CONTEXT_DELIMETER);
            while (tokenizer.hasMoreElements()) {
                discardedCtxs.add(tokenizer.nextElement().toString());
            }
            result.discardContexts(discardedCtxs);
        }
        return result;
    }
}

