/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.audit.destination;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.audit.destination.AuditDestination;
import com.metamatrix.platform.security.audit.destination.AuditDestinationInitFailedException;
import com.metamatrix.platform.security.audit.format.AuditMessageFormat;
import java.util.Properties;

public abstract class AbstractAuditDestination
implements AuditDestination {
    protected static final String DEFAULT_LOG_FORMAT_PROPERTY_NAME = "com.metamatrix.security.audit.format.DelimitedAuditMessageFormat";
    private AuditMessageFormat formatter;

    public void setFormat(String formatterClassName) throws AuditDestinationInitFailedException {
        if (formatterClassName == null || formatterClassName.trim().length() == 0) {
            formatterClassName = this.getDefaultFormatClassName();
            LogManager.logTrace((String)"AUDIT", (Object[])new Object[]{"No log message format specified for audit destination class \"", this.getClass().getName(), "\"; using default class \"", formatterClassName, "\""});
        }
        try {
            LogManager.logTrace((String)"AUDIT", (Object[])new Object[]{"Initializing audit message format class \"", formatterClassName, "\""});
            Class<?> formatterClass = Thread.currentThread().getContextClassLoader().loadClass(formatterClassName);
            this.formatter = (AuditMessageFormat)formatterClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new AuditDestinationInitFailedException(e, "ERR.014.207.0016", PlatformPlugin.Util.getString("ERR.014.207.0016", new Object[]{formatterClassName}));
        }
        catch (ClassCastException e) {
            throw new AuditDestinationInitFailedException(e, "ERR.014.207.0017", PlatformPlugin.Util.getString("ERR.014.207.0017", new Object[]{formatterClassName, AuditMessageFormat.class.getName()}));
        }
        catch (Exception e) {
            throw new AuditDestinationInitFailedException(e, "ERR.014.207.0018", PlatformPlugin.Util.getString("ERR.014.207.0018", new Object[]{formatterClassName}));
        }
    }

    @Override
    public void initialize(Properties props) throws AuditDestinationInitFailedException {
        LogManager.logTrace((String)"AUDIT", (Object[])new Object[]{"Initializing audit destination class \"", this.getClass().getName(), "\""});
    }

    public AuditMessageFormat getFormat() {
        return this.formatter;
    }

    protected String getDefaultFormatClassName() {
        return DEFAULT_LOG_FORMAT_PROPERTY_NAME;
    }
}

