/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.audit.destination;

import com.metamatrix.platform.security.audit.AuditMessage;
import com.metamatrix.platform.security.audit.destination.AbstractAuditDestination;
import com.metamatrix.platform.security.audit.destination.AuditDestinationInitFailedException;
import com.metamatrix.platform.security.audit.format.ReadableAuditMessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ConsoleAuditDestination
extends AbstractAuditDestination {
    protected static final String DEFAULT_CONSOLE_AUDIT_FORMAT_PROPERTY_NAME = ReadableAuditMessageFormat.class.getName();
    public static final String MESSAGE_FORMAT_PROPERTY_NAME = "metamatrix.audit.consoleFormat";
    private static final String DESCRIPTION = "System.out";

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public void initialize(Properties props) throws AuditDestinationInitFailedException {
        super.initialize(props);
        super.setFormat(props.getProperty(MESSAGE_FORMAT_PROPERTY_NAME));
    }

    @Override
    public List getPropertyNames() {
        ArrayList<String> pnames = new ArrayList<String>();
        pnames.add(MESSAGE_FORMAT_PROPERTY_NAME);
        return pnames;
    }

    @Override
    public void record(AuditMessage message) {
        System.out.println(this.getFormat().formatMessage(message));
    }

    @Override
    public void shutdown() {
    }

    @Override
    protected String getDefaultFormatClassName() {
        return DEFAULT_CONSOLE_AUDIT_FORMAT_PROPERTY_NAME;
    }
}

