/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.audit.destination;

import com.metamatrix.common.config.JDBCConnectionPoolHelper;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.audit.AuditMessage;
import com.metamatrix.platform.security.audit.destination.AbstractAuditDestination;
import com.metamatrix.platform.security.audit.destination.AuditDestinationInitFailedException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class DatabaseAuditDestination
extends AbstractAuditDestination {
    public static final String DATABASE_PROPERTY_NAME = "metamatrix.audit.jdbcDatabase";
    public static final String TABLE_PROPERTY_NAME = "metamatrix.audit.jdbcTable";
    public static final String RESOURCE_DELIM_PROPERTY_NAME = "metamatrix.audit.jdbcResourceDelim";
    public static final String MAX_RESOURCE_LENGTH_PROPERTY_NAME = "metamatrix.audit.jdbcMaxResourceLength";
    public static final String MAX_GENERAL_LENGTH_PROPERTY_NAME = "metamatrix.audit.jdbcMaxContextLength";
    protected static final String DEFAULT_TABLE_NAME = "AuditEntries";
    protected static final String DEFAULT_RESOURCE_DELIMITER = ";";
    protected static final int DEFAULT_MAX_GENERAL_LENGTH = 64;
    protected static final int DEFAULT_MAX_RESOURCE_LENGTH = 4000;
    private String tableName;
    private String resourceDelim = ";";
    private int maxResourceLength = 4000;
    private int maxGeneralLength = 64;
    private StringBuffer insertStr;

    @Override
    public String getDescription() {
        return "JDBC Shared Connection Pool";
    }

    @Override
    public void initialize(Properties props) throws AuditDestinationInitFailedException {
        int max;
        super.initialize(props);
        this.tableName = props.getProperty(TABLE_PROPERTY_NAME, DEFAULT_TABLE_NAME);
        this.resourceDelim = props.getProperty(RESOURCE_DELIM_PROPERTY_NAME, DEFAULT_RESOURCE_DELIMITER);
        try {
            max = Integer.parseInt(props.getProperty(MAX_RESOURCE_LENGTH_PROPERTY_NAME));
            if (max > 0) {
                this.maxResourceLength = max;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            max = Integer.parseInt(props.getProperty(MAX_GENERAL_LENGTH_PROPERTY_NAME));
            if (max > 0) {
                this.maxGeneralLength = max;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.insertStr = new StringBuffer("INSERT INTO ");
        this.insertStr.append(this.tableName);
        this.insertStr.append(" (");
        this.insertStr.append("TimeStamp");
        this.insertStr.append(',');
        this.insertStr.append("Context");
        this.insertStr.append(',');
        this.insertStr.append("Activity");
        this.insertStr.append(',');
        this.insertStr.append("Resources");
        this.insertStr.append(',');
        this.insertStr.append("Principal");
        this.insertStr.append(',');
        this.insertStr.append("Hostname");
        this.insertStr.append(',');
        this.insertStr.append("VMID");
        this.insertStr.append(") VALUES (?,?,?,?,?,?,?)");
    }

    @Override
    public List getPropertyNames() {
        ArrayList<String> pnames = new ArrayList<String>();
        pnames.add(TABLE_PROPERTY_NAME);
        pnames.add(RESOURCE_DELIM_PROPERTY_NAME);
        pnames.add(MAX_RESOURCE_LENGTH_PROPERTY_NAME);
        pnames.add(MAX_GENERAL_LENGTH_PROPERTY_NAME);
        return pnames;
    }

    @Override
    public void record(AuditMessage message) {
        SQLException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.recordMsg(message);
                return;
            }
            catch (SQLException e) {
                ex = e;
                continue;
            }
        }
        LogManager.logError((String)"AUDIT", (String)PlatformPlugin.Util.getString("ERR.014.207.0019", new Object[]{ex}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordMsg(AuditMessage message) throws SQLException {
        Connection connection = JDBCConnectionPoolHelper.getInstance().getConnection();
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement(this.insertStr.toString());
            stmt.setString(1, DateUtil.getDateAsString((Date)new Timestamp(message.getTimestamp())));
            stmt.setString(2, StringUtil.truncString((String)message.getContext(), (int)this.maxGeneralLength));
            stmt.setString(3, StringUtil.truncString((String)message.getActivity(), (int)this.maxGeneralLength));
            stmt.setString(4, StringUtil.truncString((String)message.getText(this.resourceDelim), (int)this.maxResourceLength));
            stmt.setString(5, StringUtil.truncString((String)message.getPrincipal(), (int)this.maxGeneralLength));
            stmt.setString(6, StringUtil.truncString((String)message.getHostName(), (int)this.maxGeneralLength));
            stmt.setString(7, StringUtil.truncString((String)message.getProcessName(), (int)this.maxGeneralLength));
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                LogManager.logError((String)"AUDIT", (String)PlatformPlugin.Util.getString("ERR.014.207.0020", new Object[]{e}));
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                LogManager.logError((String)"AUDIT", (String)PlatformPlugin.Util.getString("ERR.014.207.0021", new Object[]{e}));
            }
            throw throwable;
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LogManager.logError((String)"AUDIT", (String)PlatformPlugin.Util.getString("ERR.014.207.0020", new Object[]{e}));
        }
        try {
            connection.close();
        }
        catch (SQLException e) {
            LogManager.logError((String)"AUDIT", (String)PlatformPlugin.Util.getString("ERR.014.207.0021", new Object[]{e}));
        }
    }

    @Override
    public void shutdown() {
    }

    public static final class ColumnName {
        public static final String TIMESTAMP = "TimeStamp";
        public static final String CONTEXT = "Context";
        public static final String ACTIVITY = "Activity";
        public static final String RESOURCES = "Resources";
        public static final String PRINCIPAL = "Principal";
        public static final String HOST = "Hostname";
        public static final String VM = "VMID";
    }
}

