/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.audit.destination;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.util.VMNaming;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.audit.AuditMessage;
import com.metamatrix.platform.security.audit.destination.AbstractAuditDestination;
import com.metamatrix.platform.security.audit.destination.AuditDestinationInitFailedException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class SingleFileAuditDestination
extends AbstractAuditDestination {
    public static final String MESSAGE_FORMAT_PROPERTY_NAME = "metamatrix.audit.fileFormat";
    public static final String FILE_NAME_PROPERTY_NAME = "metamatrix.audit.file";
    public static final String APPEND_PROPERTY_NAME = "metamatrix.audit.fileAppend";
    public static final String VM_NAME_TOKEN = "%VM_NAME%";
    protected static final String DEFAULT_FILE_NAME = "metamatrix.log";
    protected static final String DEFAULT_APPEND = "false";
    private String fileName;
    private boolean append;
    private FileWriter fileWriter;

    @Override
    public String getDescription() {
        return "File \"" + this.fileName + "\" (append = " + this.append + ")";
    }

    @Override
    public void initialize(Properties props) throws AuditDestinationInitFailedException {
        super.initialize(props);
        super.setFormat(props.getProperty(MESSAGE_FORMAT_PROPERTY_NAME));
        this.fileName = props.getProperty(FILE_NAME_PROPERTY_NAME, DEFAULT_FILE_NAME);
        this.append = Boolean.valueOf(props.getProperty(APPEND_PROPERTY_NAME, DEFAULT_APPEND));
        int index = this.fileName.indexOf(VM_NAME_TOKEN);
        if (index != -1) {
            StringBuffer tempFileName = new StringBuffer(this.fileName);
            String processName = VMNaming.getConfigName() + "_" + VMNaming.getProcessName();
            tempFileName.replace(index, index + VM_NAME_TOKEN.length(), processName);
            this.fileName = tempFileName.toString();
        }
        try {
            this.fileWriter = new FileWriter(this.fileName, this.append);
        }
        catch (IOException e) {
            throw new AuditDestinationInitFailedException(e, "ERR.014.207.0023", PlatformPlugin.Util.getString("ERR.014.207.0023", new Object[]{this.fileName, new Boolean(this.append)}));
        }
    }

    @Override
    public List getPropertyNames() {
        ArrayList<String> pnames = new ArrayList<String>();
        pnames.add(MESSAGE_FORMAT_PROPERTY_NAME);
        pnames.add(FILE_NAME_PROPERTY_NAME);
        pnames.add(APPEND_PROPERTY_NAME);
        return pnames;
    }

    @Override
    public void record(AuditMessage message) {
        try {
            this.fileWriter.write(this.getFormat().formatMessage(message));
            this.fileWriter.write(StringUtil.getLineSeparator());
            this.fileWriter.flush();
        }
        catch (IOException e) {
            LogManager.logError((String)"AUDIT", (Throwable)e, (String)PlatformPlugin.Util.getString("ERR.014.207.0024", new Object[]{e.getMessage()}));
            System.out.println(this.getFormat().formatMessage(message));
        }
    }

    @Override
    public void shutdown() {
        try {
            this.fileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

