/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.audit.format;

import com.metamatrix.platform.security.audit.AuditMessage;
import com.metamatrix.platform.security.audit.format.AuditMessageFormat;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DelimitedAuditMessageFormat
implements AuditMessageFormat {
    public static final String TIMESTAMP_FORMAT = "MMM dd, yyyy HH:mm:ss.SSS";
    private static DateFormat DATE_FORMATTER = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss.SSS");
    private static final String DEFAULT_FORMATTED_MESSAGE = "";
    private static final char DELIMITER_CHAR = '|';

    @Override
    public String formatMessage(AuditMessage message) {
        if (message == null) {
            return DEFAULT_FORMATTED_MESSAGE;
        }
        StringBuffer msg = new StringBuffer();
        msg.append(DATE_FORMATTER.format(new Date(message.getTimestamp())));
        msg.append('|');
        msg.append(message.getHostName());
        msg.append('|');
        msg.append(message.getProcessName());
        msg.append('|');
        msg.append(message.getPrincipal());
        msg.append('|');
        msg.append(message.getContext());
        msg.append('|');
        msg.append(message.getActivity());
        msg.append('|');
        msg.append(message.getText());
        return msg.toString();
    }
}

