/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.authorization.cache;

import com.metamatrix.cache.Cache;
import com.metamatrix.platform.security.api.AuthorizationPolicy;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class AuthorizationCache {
    private Cache<AuthorizationPolicyID, AuthorizationPolicy> policyCache;
    private Cache<CacheKey, Collection> principalCache;

    public AuthorizationCache(Cache policyCache, Cache principalCache, Properties env) {
        this.policyCache = policyCache;
        this.principalCache = principalCache;
    }

    public synchronized AuthorizationPolicy findPolicy(AuthorizationPolicyID policyID) {
        AuthorizationPolicy policy = (AuthorizationPolicy)this.policyCache.get((Object)policyID);
        return policy;
    }

    public synchronized Collection findPolicies(Collection policyIDs) {
        ArrayList<Object> policies = new ArrayList<Object>();
        Iterator idItr = policyIDs.iterator();
        while (idItr.hasNext()) {
            Object aPolicy = this.policyCache.get((Object)((AuthorizationPolicyID)idItr.next()));
            if (aPolicy == null) continue;
            policies.add(aPolicy);
        }
        return policies;
    }

    public synchronized Collection findPolicyIDs(MetaMatrixPrincipalName user, SessionToken session) {
        Collection policyIDs = (Collection)this.principalCache.get((Object)this.createCacheKey(user, session));
        if (policyIDs == null) {
            return new ArrayList();
        }
        return new ArrayList(policyIDs);
    }

    public synchronized void removePrincipalFromCache(MetaMatrixPrincipalName user) {
        CacheKey key = this.createCacheKey(user, null);
        Set cachedPrincipals = this.principalCache.keySet();
        while (cachedPrincipals.contains(key)) {
            this.principalCache.remove((Object)key);
        }
    }

    public synchronized void clearPrincipalsFromCache() {
        this.principalCache.clear();
    }

    public synchronized int principalCacheSize() {
        return this.principalCache.size();
    }

    public synchronized void removePolicyFromCache(AuthorizationPolicyID policyID) {
        this.policyCache.remove((Object)policyID);
    }

    public synchronized void removePolicysFromCache(Collection policyIDs) {
        if (policyIDs != null && policyIDs.size() > 0) {
            Iterator policyIDItr = policyIDs.iterator();
            while (policyIDItr.hasNext()) {
                this.policyCache.remove((Object)((AuthorizationPolicyID)policyIDItr.next()));
            }
        }
    }

    public synchronized void clearPoliciesFromCache() {
        this.policyCache.clear();
    }

    public synchronized int policyCacheSize() {
        return this.policyCache.size();
    }

    public synchronized Collection getPolicyIDsNotCached(Collection policyIDs) {
        HashSet absentPolicyIDs = new HashSet(policyIDs);
        absentPolicyIDs.removeAll(this.policyCache.keySet());
        return absentPolicyIDs;
    }

    public synchronized void clearCaches() {
        this.clearPoliciesFromCache();
        this.clearPrincipalsFromCache();
    }

    public synchronized void cachePolicyIDsForPrincipal(MetaMatrixPrincipalName userName, SessionToken session, Collection policyIDs) {
        ArrayList policyIDsCopy = new ArrayList(policyIDs);
        Collection prevIDs = this.findPolicyIDs(userName, session);
        if (prevIDs != null && prevIDs.size() > 0) {
            policyIDsCopy.addAll(prevIDs);
        }
        this.principalCache.put((Object)this.createCacheKey(userName, session), policyIDsCopy);
    }

    private CacheKey createCacheKey(MetaMatrixPrincipalName user, SessionToken session) {
        return new CacheKey(user, session != null ? session.getSessionID() : null);
    }

    public synchronized void cachePoliciesWithIDs(Collection policies) {
        for (AuthorizationPolicy policy : policies) {
            this.policyCache.put((Object)policy.getAuthorizationPolicyID(), (Object)policy);
        }
    }

    public synchronized void cachePolicyWithID(AuthorizationPolicy policy) {
        this.policyCache.put((Object)policy.getAuthorizationPolicyID(), (Object)policy);
    }

    private static class CacheKey
    implements Serializable {
        private static final long serialVersionUID = 3712007533668645365L;
        private MetaMatrixPrincipalName principal;
        private MetaMatrixSessionID sessionId;

        CacheKey() {
        }

        CacheKey(MetaMatrixPrincipalName principal, MetaMatrixSessionID sessionId) {
            this.principal = principal;
            this.sessionId = sessionId;
        }

        public int hashCode() {
            return this.principal.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (!this.principal.equals((Object)other.principal)) {
                return false;
            }
            if (this.sessionId == null || other.sessionId == null) {
                return true;
            }
            return this.sessionId.equals((Object)other.sessionId);
        }
    }
}

