/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.authorization.service;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.admin.api.exception.security.MetaMatrixSecurityException;
import com.metamatrix.admin.api.objects.AdminOptions;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.AuthorizationMgmtException;
import com.metamatrix.api.exception.security.InvalidPrincipalException;
import com.metamatrix.api.exception.security.MembershipServiceException;
import com.metamatrix.cache.Cache;
import com.metamatrix.cache.CacheConfiguration;
import com.metamatrix.cache.CacheFactory;
import com.metamatrix.common.actions.ActionDefinition;
import com.metamatrix.common.actions.CreateObject;
import com.metamatrix.common.actions.DestroyObject;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.connection.TransactionMgr;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.properties.UnmodifiableProperties;
import com.metamatrix.dqp.ResourceFinder;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.admin.api.EntitlementMigrationReport;
import com.metamatrix.platform.admin.api.PermissionDataNode;
import com.metamatrix.platform.admin.api.PermissionNode;
import com.metamatrix.platform.admin.api.exception.PermissionNodeException;
import com.metamatrix.platform.admin.apiimpl.PermissionDataNodeTreeViewImpl;
import com.metamatrix.platform.security.api.AuthorizationObjectEditor;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationPolicy;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.GranteeEntitlementEntry;
import com.metamatrix.platform.security.api.MetaMatrixPrincipal;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.UserEntitlementInfo;
import com.metamatrix.platform.security.api.service.AuthorizationServiceInterface;
import com.metamatrix.platform.security.api.service.MembershipServiceInterface;
import com.metamatrix.platform.security.audit.AuditManager;
import com.metamatrix.platform.security.authorization.cache.AuthorizationCache;
import com.metamatrix.platform.security.authorization.spi.AuthorizationSourceConnectionException;
import com.metamatrix.platform.security.authorization.spi.AuthorizationSourceException;
import com.metamatrix.platform.security.authorization.spi.AuthorizationSourceTransaction;
import com.metamatrix.platform.security.util.RolePermissionFactory;
import com.metamatrix.platform.service.api.exception.ServiceClosedException;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.service.api.exception.ServiceNotInitializedException;
import com.metamatrix.platform.service.api.exception.ServiceStateException;
import com.metamatrix.platform.service.controller.AbstractService;
import com.metamatrix.platform.util.PlatformProxyHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class AuthorizationServiceImpl
extends AbstractService
implements AuthorizationServiceInterface {
    protected AuthorizationCache authorizationCache;
    private Properties environment;
    private int retries = 1;
    private boolean serviceClosed;
    protected MembershipServiceInterface membershipServiceProxy;
    private SessionToken privlegedToken = new SessionToken();
    private TransactionMgr transMgr;
    private AuditManager auditManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initService(Properties env) {
        try {
            String retryValue;
            this.auditManager = new AuditManager();
            this.membershipServiceProxy = PlatformProxyHelper.getMembershipServiceProxy("ROUND_ROBIN_LOCAL");
            if (env == null) {
                this.environment = new Properties();
            } else {
                Properties properties = env;
                synchronized (properties) {
                    this.environment = (Properties)env.clone();
                }
            }
            if (!(this.environment instanceof UnmodifiableProperties)) {
                this.environment = new UnmodifiableProperties(this.environment);
            }
            if ((retryValue = this.environment.getProperty("security.authorization.connection.Retries")) != null) {
                try {
                    this.retries = Integer.parseInt(retryValue);
                }
                catch (Exception e) {
                    LogManager.logWarning((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0001", new Object[]{retryValue, Integer.toString(this.retries)}));
                }
            }
            if (env.getProperty("security.authorization.connection.Factory") == null) {
                env.setProperty("security.authorization.connection.Factory", "com.metamatrix.platform.security.authorization.spi.jdbc.JDBCAuthorizationTransactionFactory");
            }
            env.setProperty("metamatrix.common.connection.transaction.factory", env.getProperty("security.authorization.connection.Factory"));
            this.transMgr = new TransactionMgr(env, this.getInstanceName());
            CacheFactory cf = ResourceFinder.getCacheFactory();
            CacheConfiguration config = new CacheConfiguration(CacheConfiguration.Policy.LRU, 0, 0);
            this.authorizationCache = new AuthorizationCache(cf.get(Cache.Type.AUTHORIZATION_POLICY, config), cf.get(Cache.Type.AUTHORIZATION_PRINCIPLE, config), this.environment);
            this.serviceClosed = false;
        }
        catch (Throwable e) {
            throw new ServiceException(e, "ERR.014.307.0004", PlatformPlugin.Util.getString("ERR.014.307.0004", new Object[]{this.getID()}));
        }
    }

    protected AuthorizationSourceTransaction getReadTransaction() throws ManagedConnectionException {
        return (AuthorizationSourceTransaction)this.transMgr.getReadTransaction();
    }

    protected AuthorizationSourceTransaction getWriteTransaction() throws ManagedConnectionException {
        return (AuthorizationSourceTransaction)this.transMgr.getWriteTransaction();
    }

    @Override
    protected void closeService() throws Exception {
        if (!this.serviceClosed) {
            String instanceName = this.getInstanceName();
            LogManager.logInfo((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("MSG.014.307.0001", new Object[]{instanceName}));
            this.serviceClosed = true;
            this.auditManager.stop();
            LogManager.logInfo((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("MSG.014.307.0002", new Object[]{instanceName}));
        }
    }

    @Override
    protected void waitForServiceToClear() throws Exception {
        try {
            this.closeService();
        }
        catch (Exception e) {
            LogManager.logError((String)"AUTHORIZATION", (Throwable)e, (String)PlatformPlugin.Util.getString("ERR.014.307.0009"));
        }
    }

    @Override
    protected void killService() {
        try {
            this.closeService();
        }
        catch (Exception e) {
            LogManager.logError((String)"AUTHORIZATION", (Throwable)e, (String)PlatformPlugin.Util.getString("ERR.014.307.0009"));
        }
    }

    @Override
    public boolean checkAccess(SessionToken sessionToken, String contextName, AuthorizationPermission request) throws InvalidSessionException, AuthorizationMgmtException {
        LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"checkAccess(", sessionToken, ", ", contextName, ", ", request, ")"});
        this.auditManager.record(contextName, "checkAccess-request", sessionToken.getUsername(), request.getResourceName());
        boolean hasAccess = this.checkAccess(sessionToken, contextName, request, false);
        if (!hasAccess) {
            this.auditManager.record(contextName, "checkAccess-denied", sessionToken.getUsername(), request.getResourceName());
        }
        return hasAccess;
    }

    @Override
    public boolean checkAccess(SessionToken sessionToken, String contextName, AuthorizationPermission request, boolean fetchDependants) throws InvalidSessionException, AuthorizationMgmtException {
        Collection<Object> requests = new ArrayList<AuthorizationPermission>();
        if (fetchDependants) {
            requests = this.getDependantRequests(request);
        } else {
            requests.add(request);
        }
        return this.getInaccessibleResources(sessionToken, contextName, requests).isEmpty();
    }

    @Override
    public Collection getInaccessibleResources(SessionToken sessionToken, String contextName, Collection requests) throws InvalidSessionException, AuthorizationMgmtException {
        LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"getInaccessibleResources(", sessionToken, ", ", contextName, ", ", requests, ")"});
        this.auditManager.record(contextName, "getInaccessibleResources-request", sessionToken.getUsername(), requests);
        if (this.isEntitled(sessionToken.getUsername())) {
            return Collections.EMPTY_LIST;
        }
        HashSet results = new HashSet(requests);
        try {
            Collection policies = this.getPoliciesForPrincipal(new MetaMatrixPrincipalName(sessionToken.getUsername(), 0), sessionToken, AuthorizationServiceImpl.getRequestedRealm(requests));
            Iterator policyIter = policies.iterator();
            while (policyIter.hasNext() && !results.isEmpty()) {
                Iterator requestIter = results.iterator();
                AuthorizationPolicy policy = (AuthorizationPolicy)policyIter.next();
                while (requestIter.hasNext()) {
                    AuthorizationPermission request = (AuthorizationPermission)requestIter.next();
                    if (!policy.implies(request)) continue;
                    requestIter.remove();
                }
            }
        }
        catch (InvalidPrincipalException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.307.0020");
            throw new InvalidSessionException((Throwable)e, msg);
        }
        if (results.isEmpty()) {
            this.auditManager.record(contextName, "getInaccessibleResources-granted all", sessionToken.getUsername(), requests);
        } else {
            this.auditManager.record(contextName, "getInaccessibleResources-denied", sessionToken.getUsername(), results);
        }
        return results;
    }

    @Override
    public List getGroupEntitlements(AuthorizationRealm realm, Collection groupNames) throws AuthorizationMgmtException {
        ArrayList entitlements = new ArrayList();
        for (String groupName : groupNames) {
            entitlements.addAll(this.getGroupEntitlements(realm, groupName));
        }
        return entitlements;
    }

    @Override
    public List getGroupEntitlements(AuthorizationRealm realm, String fullyQualifiedGroupName) throws AuthorizationMgmtException {
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getGroupEntitlements(", realm, fullyQualifiedGroupName, ")"});
        boolean success = false;
        Object exception = null;
        String exceptionMsg = null;
        if (fullyQualifiedGroupName.indexOf(37) > 0) {
            throw new AuthorizationMgmtException("ERR.014.307.0022", PlatformPlugin.Util.getString("ERR.014.307.0022"));
        }
        Map entitlementMap = new HashMap();
        AuthorizationSourceTransaction transaction = null;
        for (int i = 0; i < this.retries; ++i) {
            try {
                transaction = this.getReadTransaction();
                entitlementMap = transaction.getGroupEntitlements(realm, fullyQualifiedGroupName);
                success = true;
                break;
            }
            catch (ManagedConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0023");
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0023", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0024");
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0024", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0025");
                throw new AuthorizationMgmtException((Throwable)((Object)e), exceptionMsg);
            }
            finally {
                this.completeTransaction(success, transaction);
            }
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Attempting to retry getting entitlements for resource."});
        }
        if (!success) {
            throw new AuthorizationMgmtException(exception, exceptionMsg);
        }
        return this.buildEntitlementList(realm, entitlementMap, true);
    }

    @Override
    public List getElementEntitlements(AuthorizationRealm realm, Collection elementNames) throws AuthorizationMgmtException {
        ArrayList entitlements = new ArrayList();
        for (String elementName : elementNames) {
            entitlements.addAll(this.getElementEntitlements(realm, elementName));
        }
        return entitlements;
    }

    @Override
    public List getElementEntitlements(AuthorizationRealm realm, String elementNamePattern) throws AuthorizationMgmtException {
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getElementEntitlements(", realm, elementNamePattern, ")"});
        boolean success = false;
        Object exception = null;
        String exceptionMsg = null;
        Map entitlementMap = new HashMap();
        AuthorizationSourceTransaction transaction = null;
        for (int i = 0; i < this.retries; ++i) {
            try {
                transaction = this.getReadTransaction();
                entitlementMap = transaction.getElementEntitlements(realm, elementNamePattern);
                success = true;
                break;
            }
            catch (ManagedConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0023");
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0023", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0024");
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0024", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0025");
                throw new AuthorizationMgmtException((Throwable)((Object)e), exceptionMsg);
            }
            finally {
                this.completeTransaction(success, transaction);
            }
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Attempting to retry getting entitlements for resource."});
        }
        if (!success) {
            throw new AuthorizationMgmtException(exception, exceptionMsg);
        }
        return this.buildEntitlementList(realm, entitlementMap, false);
    }

    private List buildEntitlementList(AuthorizationRealm realm, Map entitlementMap, boolean isGroup) {
        ArrayList<UserEntitlementInfo> entitlementList = new ArrayList<UserEntitlementInfo>();
        for (String resourceName : entitlementMap.keySet()) {
            String groupName = null;
            String elementName = null;
            if (isGroup) {
                groupName = resourceName;
            } else {
                int eleIndex = resourceName.lastIndexOf(46);
                groupName = resourceName.substring(0, eleIndex);
                elementName = resourceName.substring(eleIndex + 1, resourceName.length());
            }
            UserEntitlementInfo entitlementEntry = new UserEntitlementInfo(realm, groupName, elementName);
            Set entrySet = (Set)entitlementMap.get(resourceName);
            for (GranteeEntitlementEntry aGrantee : entrySet) {
                entitlementEntry.addTriplet(aGrantee);
            }
            entitlementList.add(entitlementEntry);
        }
        return entitlementList;
    }

    private Collection getRealmNames() throws AuthorizationMgmtException {
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getRealmNames()"});
        boolean success = false;
        Object exception = null;
        String exceptionMsg = null;
        Collection realmList = new ArrayList();
        AuthorizationSourceTransaction transaction = null;
        for (int i = 0; i < this.retries; ++i) {
            try {
                transaction = this.getReadTransaction();
                realmList = transaction.getRealmNames();
                success = true;
                break;
            }
            catch (ManagedConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0023");
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0023", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0024");
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0024", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0025");
                throw new AuthorizationMgmtException((Throwable)((Object)e), "ERR.014.307.0025", exceptionMsg);
            }
            finally {
                this.completeTransaction(success, transaction);
            }
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Attempting to retry getting entitlements for resource."});
        }
        if (!success) {
            throw new AuthorizationMgmtException(exception, exceptionMsg);
        }
        if (realmList == null) {
            if (exception != null) {
                throw new AuthorizationMgmtException(exception, exceptionMsg);
            }
            throw new AuthorizationMgmtException("ERR.014.307.0028", PlatformPlugin.Util.getString("ERR.014.307.0028"));
        }
        return realmList;
    }

    @Override
    public Collection getRealmNames(SessionToken caller) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException {
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getRealmNames(", caller, ")"});
        return this.getRealmNames();
    }

    @Override
    public boolean containsPolicy(SessionToken caller, AuthorizationPolicyID policyID) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException {
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"containsPolicy(", caller, ", ", policyID, ")"});
        boolean success = false;
        Object exception = null;
        String exceptionMsg = null;
        boolean policyContained = false;
        AuthorizationSourceTransaction transaction = null;
        for (int i = 0; i < this.retries; ++i) {
            try {
                transaction = this.getReadTransaction();
                policyContained = transaction.containsPolicy(policyID);
                success = true;
                break;
            }
            catch (ManagedConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0029", new Object[]{policyID});
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0029", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0030", new Object[]{policyID});
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0030", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0031", new Object[]{policyID});
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0031", new Object[]{e, exceptionMsg}));
                throw new AuthorizationMgmtException((Throwable)((Object)e), "ERR.014.307.0031", exceptionMsg);
            }
            finally {
                this.completeTransaction(success, transaction);
            }
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Attempting to retry search for policy ID."});
        }
        if (!success) {
            throw new AuthorizationMgmtException(exception, exceptionMsg);
        }
        return policyContained;
    }

    @Override
    public Collection findAllPolicyIDs(SessionToken caller) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException {
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"findAllPolicyIDs(", caller, ")"});
        boolean success = false;
        Object exception = null;
        String exceptionMsg = null;
        HashSet policyIDs = new HashSet();
        AuthorizationSourceTransaction transaction = null;
        for (int i = 0; i < this.retries; ++i) {
            try {
                transaction = this.getReadTransaction();
                policyIDs.addAll(transaction.findAllPolicyIDs());
                success = true;
                break;
            }
            catch (ManagedConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0032");
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0032", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0033");
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0033", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0034");
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0034", new Object[]{e, exceptionMsg}));
                throw new AuthorizationMgmtException((Throwable)((Object)e), "ERR.014.307.0034", exceptionMsg);
            }
            finally {
                this.completeTransaction(success, transaction);
            }
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Attempting to retry search for all policy IDs."});
        }
        if (!success) {
            throw new AuthorizationMgmtException(exception, exceptionMsg);
        }
        return policyIDs;
    }

    @Override
    public Collection findPolicyIDs(SessionToken caller, Collection principals) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException {
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"findPolicyIDs(", caller, ", ", principals, ")"});
        HashSet allPolicyIDs = new HashSet();
        Iterator pItr = principals.iterator();
        MetaMatrixPrincipalName principal = null;
        while (pItr.hasNext()) {
            Collection thisPrincipalsGroups = null;
            try {
                principal = (MetaMatrixPrincipalName)pItr.next();
                thisPrincipalsGroups = this.getGroupsForPrincipal(principal);
                Iterator itr = this.findPolicyIDs(thisPrincipalsGroups).iterator();
                while (itr.hasNext()) {
                    allPolicyIDs.add(itr.next());
                }
            }
            catch (MetaMatrixSecurityException e) {
                String msg = PlatformPlugin.Util.getString("ERR.014.307.0035", new Object[]{principal});
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0035", new Object[]{e, msg}));
                return Collections.EMPTY_SET;
            }
        }
        return allPolicyIDs;
    }

    @Override
    public Collection getPolicies(SessionToken caller, Collection policyIDs) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException {
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getPolicies(", caller, ", ", policyIDs, ")"});
        return this.getPolicies(policyIDs);
    }

    @Override
    public AuthorizationPolicy getPolicy(SessionToken caller, AuthorizationPolicyID policyID) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException {
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getPolicy(", caller, ", ", policyID, ")"});
        boolean success = false;
        Object exception = null;
        String exceptionMsg = null;
        AuthorizationPolicy policy = null;
        AuthorizationSourceTransaction transaction = null;
        for (int i = 0; i < this.retries; ++i) {
            try {
                transaction = this.getReadTransaction();
                policy = transaction.getPolicy(policyID);
                success = true;
                break;
            }
            catch (ManagedConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0037", new Object[]{policyID});
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0037", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0038", new Object[]{policyID});
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0038", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0039", new Object[]{policyID});
                throw new AuthorizationMgmtException((Throwable)((Object)e), "ERR.014.307.0039", exceptionMsg);
            }
            finally {
                this.completeTransaction(success, transaction);
            }
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Attempting to retry getting policy for ID (", policyID, ")"});
        }
        if (!success) {
            throw new AuthorizationMgmtException(exception, exceptionMsg);
        }
        return policy;
    }

    private void completeTransaction(boolean success, AuthorizationSourceTransaction transaction) {
        if (transaction != null) {
            try {
                if (success) {
                    transaction.commit();
                } else {
                    transaction.rollback();
                }
                transaction.close();
            }
            catch (Exception e) {
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0015", new Object[]{e}));
            }
        }
    }

    @Override
    public boolean isCallerInRole(SessionToken caller, String roleName) throws AuthorizationMgmtException {
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"isCallerInRole(", caller, roleName, ")"});
        try {
            return this.hasPolicy(caller, RolePermissionFactory.getRealm(), roleName);
        }
        catch (MembershipServiceException err) {
            throw new AuthorizationMgmtException((Throwable)err);
        }
    }

    @Override
    public Map getRoleDescriptions(SessionToken caller) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException {
        boolean success = false;
        Object exception = null;
        String exceptionMsg = null;
        Map roleDescs = null;
        AuthorizationSourceTransaction transaction = null;
        for (int i = 0; i < this.retries; ++i) {
            try {
                transaction = this.getReadTransaction();
                roleDescs = transaction.getRoleDescriptions();
                success = true;
                break;
            }
            catch (ManagedConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0040");
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0040", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0041");
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0041", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0042");
                throw new AuthorizationMgmtException((Throwable)((Object)e), "ERR.014.307.0042", exceptionMsg);
            }
            finally {
                this.completeTransaction(success, transaction);
            }
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Attempting to retry getting role descriptions."});
        }
        if (!success) {
            throw new AuthorizationMgmtException(exception, exceptionMsg);
        }
        return roleDescs;
    }

    @Override
    public Collection getPrincipalsForRole(SessionToken caller, String roleName) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException {
        boolean success = false;
        Object exception = null;
        String exceptionMsg = null;
        Collection principals = null;
        AuthorizationSourceTransaction transaction = null;
        for (int i = 0; i < this.retries; ++i) {
            try {
                transaction = this.getReadTransaction();
                principals = transaction.getPrincipalsForRole(roleName);
                success = true;
                break;
            }
            catch (ManagedConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0043", new Object[]{roleName.toString()});
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0043", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0044", new Object[]{roleName.toString()});
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0044", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0045", new Object[]{roleName.toString()});
                throw new AuthorizationMgmtException((Throwable)((Object)e), "ERR.014.307.0045", exceptionMsg);
            }
            finally {
                this.completeTransaction(success, transaction);
            }
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Attempting to retry getting principals for role \"", roleName.toString(), "\"."});
        }
        if (!success) {
            throw new AuthorizationMgmtException(exception, exceptionMsg);
        }
        return principals;
    }

    @Override
    public Collection getRoleNamesForPrincipal(SessionToken caller, MetaMatrixPrincipalName principal) throws AuthorizationMgmtException {
        Collection policies;
        try {
            if (this.isEntitled(principal.getName())) {
                Map roles = this.getRoleDescriptions(this.privlegedToken);
                return new HashSet(roles.keySet());
            }
        }
        catch (MetaMatrixSecurityException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.307.0075");
            throw new AuthorizationMgmtException((Throwable)e, "ERR.014.307.0075", msg);
        }
        try {
            policies = this.getPoliciesForPrincipal(principal, caller, RolePermissionFactory.getRealm());
        }
        catch (InvalidPrincipalException err) {
            throw new AuthorizationMgmtException((Throwable)err);
        }
        HashSet<String> results = new HashSet<String>();
        for (AuthorizationPolicy policy : policies) {
            results.add(policy.getAuthorizationPolicyID().getDisplayName());
        }
        return results;
    }

    protected boolean isEntitled(String principal) {
        try {
            if (this.membershipServiceProxy.isSuperUser(principal) || !this.membershipServiceProxy.isSecurityEnabled()) {
                LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Automatically entitling principal", principal});
                return true;
            }
            return false;
        }
        catch (MembershipServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.307.0075");
            throw new ServiceException(e, "ERR.014.307.0075", msg);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean removePrincipalFromAllPolicies(SessionToken caller, MetaMatrixPrincipalName principal) throws AuthorizationException, AuthorizationMgmtException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Collection getPolicyIDsWithPermissionsInRealm(SessionToken caller, AuthorizationRealm realm) throws AuthorizationException, AuthorizationMgmtException {
        boolean success = false;
        Object exception = null;
        String exceptionMsg = null;
        Collection policyIDs = null;
        AuthorizationSourceTransaction transaction = null;
        for (int i = 0; i < this.retries; ++i) {
            try {
                transaction = this.getReadTransaction();
                policyIDs = transaction.getPolicyIDsWithPermissionsInRealm(realm);
                success = true;
                break;
            }
            catch (ManagedConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0055", new Object[]{realm.toString()});
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0055", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0056", new Object[]{realm.toString()});
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0056", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0057", new Object[]{realm.toString()});
                throw new AuthorizationMgmtException((Throwable)((Object)e), "ERR.014.307.0057", exceptionMsg);
            }
            finally {
                this.completeTransaction(success, transaction);
            }
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Attempting to retry getting Authorization PolicyIDs with permissions belonging to realm \"", realm.toString(), "\"."});
        }
        if (!success) {
            throw new AuthorizationMgmtException(exception, exceptionMsg);
        }
        return policyIDs;
    }

    @Override
    public Collection getPolicyIDsInRealm(SessionToken caller, AuthorizationRealm realm) throws AuthorizationException, AuthorizationMgmtException {
        boolean success = false;
        Object exception = null;
        String exceptionMsg = null;
        Collection policyIDs = null;
        AuthorizationSourceTransaction transaction = null;
        for (int i = 0; i < this.retries; ++i) {
            try {
                transaction = this.getReadTransaction();
                policyIDs = transaction.getPolicyIDsInRealm(realm);
                success = true;
                break;
            }
            catch (ManagedConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0058", new Object[]{realm.toString()});
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0058", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0059", new Object[]{realm.toString()});
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0059", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0060", new Object[]{realm.toString()});
                throw new AuthorizationMgmtException((Throwable)((Object)e), "ERR.014.307.0060", exceptionMsg);
            }
            finally {
                this.completeTransaction(success, transaction);
                transaction = null;
            }
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Attempting to retry getting Authorization Policies belonging to realm \"", realm.toString(), "\"."});
        }
        if (!success) {
            throw new AuthorizationMgmtException(exception, exceptionMsg);
        }
        return policyIDs;
    }

    @Override
    public Collection getPoliciesInRealm(SessionToken caller, AuthorizationRealm realm) throws AuthorizationException, AuthorizationMgmtException {
        Collection policyIDs = this.getPolicyIDsInRealm(caller, realm);
        return this.getPolicies(policyIDs);
    }

    @Override
    public Collection getPolicyIDsInPartialRealm(SessionToken caller, AuthorizationRealm realm) throws AuthorizationException, AuthorizationMgmtException {
        boolean success = false;
        Object exception = null;
        String exceptionMsg = null;
        Collection policyIDs = null;
        AuthorizationSourceTransaction transaction = null;
        for (int i = 0; i < this.retries; ++i) {
            try {
                transaction = this.getReadTransaction();
                policyIDs = transaction.getPolicyIDsInPartialRealm(realm);
                success = true;
                break;
            }
            catch (ManagedConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0058", new Object[]{realm.toString()});
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0058", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0059", new Object[]{realm.toString()});
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0059", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0060", new Object[]{realm.toString()});
                throw new AuthorizationMgmtException((Throwable)((Object)e), "ERR.014.307.0060", exceptionMsg);
            }
            finally {
                this.completeTransaction(success, transaction);
                transaction = null;
            }
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Attempting to retry getting Authorization Policies belonging to realm \"", realm.toString(), "\"."});
        }
        if (!success) {
            throw new AuthorizationMgmtException(exception, exceptionMsg);
        }
        return policyIDs;
    }

    @Override
    public Collection getPolicIDsForResourceInRealm(SessionToken caller, AuthorizationRealm realm, String resourceName) throws AuthorizationException, AuthorizationMgmtException {
        return this.getPolicIDsForResourceInRealm(realm, resourceName);
    }

    private Collection getPolicIDsForResourceInRealm(AuthorizationRealm realm, String resourceName) throws AuthorizationMgmtException {
        boolean success = false;
        Object exception = null;
        String exceptionMsg = null;
        Collection policyIDs = null;
        AuthorizationSourceTransaction transaction = null;
        for (int i = 0; i < this.retries; ++i) {
            try {
                transaction = this.getReadTransaction();
                policyIDs = transaction.getPolicyIDsForResourceInRealm(realm, resourceName);
                success = true;
                break;
            }
            catch (ManagedConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0058", new Object[]{realm.toString()});
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0058", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0059", new Object[]{realm.toString()});
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0059", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0060", new Object[]{realm.toString()});
                throw new AuthorizationMgmtException((Throwable)((Object)e), "ERR.014.307.0060", exceptionMsg);
            }
            finally {
                this.completeTransaction(success, transaction);
                transaction = null;
            }
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Attempting to retry getting Authorization Policies belonging to realm \"", realm.toString(), "\"."});
        }
        if (!success) {
            throw new AuthorizationMgmtException(exception, exceptionMsg);
        }
        return policyIDs;
    }

    @Override
    public PermissionDataNode fillPermissionNodeTree(PermissionDataNode root, AuthorizationPolicyID policyID) throws AuthorizationMgmtException {
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"fillPermissionNodeTree(", root, policyID, ")"});
        Set permissions = this.getPermissionsForPolicy(policyID);
        Collection exceptions = Collections.EMPTY_LIST;
        PermissionDataNodeTreeViewImpl treeView = new PermissionDataNodeTreeViewImpl((PermissionNode)root);
        if (permissions.size() > 0) {
            exceptions = treeView.setPermissions((Collection)permissions);
        }
        if (exceptions.size() > 0) {
            StringBuffer msg = new StringBuffer();
            PermissionNodeException ex2 = null;
            for (PermissionNodeException ex2 : exceptions) {
                msg.append(ex2.getClass().getSimpleName() + " ");
                msg.append(ex2.getMessage());
                msg.append(", ");
            }
            msg.setLength(msg.length() - 2);
            throw new AuthorizationMgmtException(msg.toString());
        }
        return root;
    }

    private Set getPermissionsForPolicy(AuthorizationPolicyID policyID) throws AuthorizationMgmtException {
        boolean success = false;
        Object exception = null;
        String exceptionMsg = null;
        Set permissions = Collections.EMPTY_SET;
        AuthorizationSourceTransaction transaction = null;
        for (int i = 0; i < this.retries; ++i) {
            try {
                transaction = this.getReadTransaction();
                permissions = transaction.getPermissionsForPolicy(policyID);
                success = true;
                break;
            }
            catch (ManagedConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0061", new Object[]{policyID.toString()});
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0061", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0062", new Object[]{policyID.toString()});
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0062", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0063", new Object[]{policyID.toString()});
                throw new AuthorizationMgmtException((Throwable)((Object)e), "ERR.014.307.0063", exceptionMsg);
            }
            finally {
                this.completeTransaction(success, transaction);
                transaction = null;
            }
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Attempting to retry getting permissions for policy \"", policyID.toString(), "\"."});
        }
        if (!success) {
            throw new AuthorizationMgmtException(exception, exceptionMsg);
        }
        return permissions;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set executeTransaction(SessionToken administrator, List actions) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException {
        String msg;
        AuthorizationSourceTransaction transaction;
        HashSet result;
        block31: {
            block30: {
                LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"executeTransaction(", administrator, actions, ")"});
                if (administrator == null) {
                    throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.307.0064"));
                }
                if (actions == null) {
                    throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.307.0065"));
                }
                LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Executing transaction with ", new Integer(actions.size()), " action(s)"});
                result = new HashSet();
                if (actions.isEmpty()) {
                    return result;
                }
                this.auditManager.record("AUTHORIZATION", "executeTransaction-modify", administrator.getUsername(), this.printActions(actions));
                ArrayList<ActionDefinition> actionsWithSameTarget = new ArrayList<ActionDefinition>(7);
                Object currentTarget = null;
                ActionDefinition currentAction = null;
                ActionDefinition nextAction = null;
                transaction = null;
                boolean successfulTxn = false;
                int actionCounter = -1;
                try {
                    transaction = this.getWriteTransaction();
                    boolean createObject = false;
                    Iterator iter = actions.iterator();
                    if (iter.hasNext()) {
                        currentAction = (ActionDefinition)iter.next();
                        currentTarget = currentAction.getTarget();
                        actionsWithSameTarget.add(currentAction);
                        LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Target: <", currentTarget, "> First action: <", currentAction, ">"});
                    }
                    while (iter.hasNext()) {
                        nextAction = (ActionDefinition)iter.next();
                        if (currentAction instanceof CreateObject) {
                            createObject = true;
                        }
                        if (currentAction instanceof DestroyObject) {
                            if (!createObject) {
                                this.executeTransactionsOnTarget(transaction, actionsWithSameTarget, currentTarget, administrator, result);
                            }
                            actionCounter += actionsWithSameTarget.size();
                            actionsWithSameTarget.clear();
                            createObject = false;
                            currentTarget = nextAction.getTarget();
                        } else if (currentTarget != nextAction.getTarget()) {
                            this.executeTransactionsOnTarget(transaction, actionsWithSameTarget, currentTarget, administrator, result);
                            actionCounter += actionsWithSameTarget.size();
                            actionsWithSameTarget.clear();
                            createObject = false;
                            currentTarget = nextAction.getTarget();
                        }
                        currentAction = nextAction;
                        actionsWithSameTarget.add(currentAction);
                        LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Target: ", currentTarget, " action: ", currentAction});
                    }
                    if (actionsWithSameTarget.size() != 0) {
                        this.executeTransactionsOnTarget(transaction, actionsWithSameTarget, currentTarget, administrator, result);
                        createObject = false;
                    }
                    this.authorizationCache.clearCaches();
                    successfulTxn = true;
                    if (transaction == null) return result;
                    if (!successfulTxn) break block30;
                }
                catch (AuthorizationMgmtException e) {
                    try {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.307.0066", new Object[]{this.printActions(actions)});
                        LogManager.logError((String)"AUTHORIZATION", (Throwable)e, (String)msg2);
                        throw e;
                        catch (Exception e2) {
                            msg3 = PlatformPlugin.Util.getString("ERR.014.307.0066", new Object[]{this.printActions(actions)});
                            LogManager.logError((String)"AUTHORIZATION", (Throwable)e2, (String)msg3);
                            throw new AuthorizationMgmtException((Throwable)e2);
                        }
                    }
                    catch (Throwable throwable) {
                        String msg3;
                        if (transaction == null) throw throwable;
                        if (successfulTxn) {
                            try {
                                transaction.commit();
                            }
                            catch (ManagedConnectionException e3) {
                                Object[] params = new Object[]{this.printActions(actions)};
                                String msg4 = PlatformPlugin.Util.getString("AuthorizationServiceImpl.Error_committing_transaction_after_executing_actions__{0}", new Object[]{params});
                                LogManager.logError((String)"AUTHORIZATION", (Throwable)((Object)e3), (String)msg4);
                            }
                        } else {
                            try {
                                transaction.rollback();
                            }
                            catch (ManagedConnectionException e4) {
                                msg3 = PlatformPlugin.Util.getString("ERR.014.307.0067", new Object[]{this.printActions(actions)});
                                LogManager.logError((String)"AUTHORIZATION", (Throwable)((Object)e4), (String)msg3);
                            }
                        }
                        try {
                            transaction.close();
                        }
                        catch (Exception e5) {
                            msg3 = PlatformPlugin.Util.getString("ERR.014.307.0015", new Object[]{this.printActions(actions)});
                            LogManager.logError((String)"AUTHORIZATION", (Throwable)e5, (String)msg3);
                        }
                        transaction = null;
                        throw throwable;
                    }
                }
                try {
                    transaction.commit();
                }
                catch (ManagedConnectionException e) {
                    Object[] params = new Object[]{this.printActions(actions)};
                    String msg5 = PlatformPlugin.Util.getString("AuthorizationServiceImpl.Error_committing_transaction_after_executing_actions__{0}", new Object[]{params});
                    LogManager.logError((String)"AUTHORIZATION", (Throwable)((Object)e), (String)msg5);
                }
                break block31;
            }
            try {
                transaction.rollback();
            }
            catch (ManagedConnectionException e) {
                msg = PlatformPlugin.Util.getString("ERR.014.307.0067", new Object[]{this.printActions(actions)});
                LogManager.logError((String)"AUTHORIZATION", (Throwable)((Object)e), (String)msg);
            }
        }
        try {
            transaction.close();
        }
        catch (Exception e) {
            msg = PlatformPlugin.Util.getString("ERR.014.307.0015", new Object[]{this.printActions(actions)});
            LogManager.logError((String)"AUTHORIZATION", (Throwable)e, (String)msg);
        }
        transaction = null;
        return result;
    }

    private Collection findPolicyIDs(Collection principals, AuthorizationRealm realm) throws AuthorizationMgmtException {
        boolean success = false;
        Object exception = null;
        String exceptionMsg = null;
        HashSet policyIDs = new HashSet();
        if (principals == null || principals.size() == 0) {
            return policyIDs;
        }
        AuthorizationSourceTransaction transaction = null;
        for (int i = 0; i < this.retries; ++i) {
            try {
                transaction = this.getReadTransaction();
                policyIDs.addAll(transaction.findPolicyIDs(principals, realm));
                success = true;
                break;
            }
            catch (ManagedConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0068");
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0068", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0069");
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0069", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0070");
                throw new AuthorizationMgmtException((Throwable)((Object)e), "ERR.014.307.0070", exceptionMsg);
            }
            catch (Exception e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0071");
                throw new AuthorizationMgmtException((Throwable)e, "ERR.014.307.0071", exceptionMsg);
            }
            finally {
                this.completeTransaction(success, transaction);
                transaction = null;
            }
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Attempting to retry search for policy IDs belonging to principal collection."});
        }
        if (!success) {
            throw new AuthorizationMgmtException(exception, exceptionMsg);
        }
        return policyIDs;
    }

    private Collection findPolicyIDs(Collection principals) throws AuthorizationMgmtException {
        boolean success = false;
        Object exception = null;
        String exceptionMsg = null;
        HashSet policyIDs = new HashSet();
        if (principals == null || principals.size() == 0) {
            return policyIDs;
        }
        AuthorizationSourceTransaction transaction = null;
        for (int i = 0; i < this.retries; ++i) {
            try {
                transaction = this.getReadTransaction();
                policyIDs.addAll(transaction.findPolicyIDs(principals));
                success = true;
                break;
            }
            catch (ManagedConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0068");
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0068", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0069");
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0069", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0070");
                throw new AuthorizationMgmtException((Throwable)((Object)e), "ERR.014.307.0070", exceptionMsg);
            }
            catch (Exception e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0071");
                throw new AuthorizationMgmtException((Throwable)e, "ERR.014.307.0071", exceptionMsg);
            }
            finally {
                this.completeTransaction(success, transaction);
                transaction = null;
            }
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Attempting to retry search for policy IDs belonging to principal collection."});
        }
        if (!success) {
            throw new AuthorizationMgmtException(exception, exceptionMsg);
        }
        return policyIDs;
    }

    private Collection getPolicies(Collection policyIDs) throws AuthorizationMgmtException {
        boolean success = false;
        Object exception = null;
        String exceptionMsg = null;
        Collection synchronizedPolicyIDs = Collections.synchronizedCollection(policyIDs);
        HashSet policies = new HashSet();
        AuthorizationSourceTransaction transaction = null;
        for (int i = 0; i < this.retries; ++i) {
            try {
                transaction = this.getReadTransaction();
                policies.addAll(transaction.getPolicies(synchronizedPolicyIDs));
                success = true;
                break;
            }
            catch (ManagedConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0072");
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0072", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0073");
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0073", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0074");
                throw new AuthorizationMgmtException((Throwable)((Object)e), "ERR.014.307.0074", exceptionMsg);
            }
            finally {
                this.completeTransaction(success, transaction);
                transaction = null;
            }
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Attempting to retry search for policies with ID collection."});
        }
        if (!success) {
            throw new AuthorizationMgmtException(exception, exceptionMsg);
        }
        return policies;
    }

    @Override
    public boolean hasPolicy(SessionToken caller, AuthorizationRealm realm, String policyName) throws AuthorizationMgmtException, MembershipServiceException {
        Collection policies;
        if (this.isEntitled(caller.getUsername())) {
            return true;
        }
        try {
            policies = this.getPoliciesForPrincipal(new MetaMatrixPrincipalName(caller.getUsername(), 0), caller, realm);
        }
        catch (InvalidPrincipalException e) {
            throw new AuthorizationMgmtException((Throwable)e);
        }
        HashSet<String> applicablePolicies = new HashSet<String>();
        applicablePolicies.add(policyName);
        if (realm == RolePermissionFactory.getRealm()) {
            if ("Admin.ProductAdmin".equals(policyName)) {
                applicablePolicies.add("Admin.SystemAdmin");
            } else if ("Admin.ReadOnlyAdmin".equals(policyName)) {
                applicablePolicies.add("Admin.ProductAdmin");
                applicablePolicies.add("Admin.SystemAdmin");
            }
        }
        for (AuthorizationPolicy policy : policies) {
            if (!applicablePolicies.contains(policy.getAuthorizationPolicyID().getDisplayName())) continue;
            return true;
        }
        return false;
    }

    private Collection getPoliciesForPrincipal(MetaMatrixPrincipalName user, SessionToken session, AuthorizationRealm realm) throws AuthorizationMgmtException, InvalidPrincipalException {
        LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"getPoliciesForPrincipal(", user, ", ", realm, ") - Trying cache first."});
        Collection applicablePolicyIDs = this.authorizationCache.findPolicyIDs(user, session);
        if (applicablePolicyIDs != null && applicablePolicyIDs.size() > 0) {
            if (!this.hasPolicyIDsForRealm(applicablePolicyIDs, realm)) {
                LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"getPoliciesForPrincipal(", user, ", ", realm, ") - Principal has no policyIDs cached for the given realm."});
                applicablePolicyIDs.clear();
            } else {
                LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"getPoliciesForPrincipal(", user, ", ", realm, ") - Found poliyIDs cached for the principal in the given realm."});
            }
        }
        if (applicablePolicyIDs == null || applicablePolicyIDs.size() == 0) {
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"getPoliciesForPrincipal(", user, ", ", realm, ") - No policyIDs found in cache, going to store."});
            Collection principals = this.getGroupsForPrincipal(user);
            applicablePolicyIDs = this.findPolicyIDs(principals, realm);
            if (applicablePolicyIDs == null || applicablePolicyIDs.size() == 0) {
                LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"getPoliciesForPrincipal(", user, ", ", realm, ") - No policyIDs found for realm - no authorization."});
                return Collections.EMPTY_SET;
            }
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"getPoliciesForPrincipal(", user, ", ", realm, ") - Found policyIDs in store - caching: ", applicablePolicyIDs});
            this.authorizationCache.cachePolicyIDsForPrincipal(user, session, applicablePolicyIDs);
        }
        Collection policies = new HashSet();
        LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"getPoliciesForPrincipal(", user, ", ", realm, ") - Looking up policies in cache by policyID."});
        policies = this.authorizationCache.findPolicies(applicablePolicyIDs);
        if (policies == null || policies.size() == 0 || policies.size() < applicablePolicyIDs.size()) {
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"getPoliciesForPrincipal(", user, ", ", realm, ") - No policies were found in cache, going to store."});
            policies = this.getPolicies(applicablePolicyIDs);
            if (policies != null && policies.size() > 0) {
                LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"getPoliciesForPrincipal(", user, ", ", realm, ") - Found policies in store - caching."});
                this.authorizationCache.cachePoliciesWithIDs(policies);
            }
        } else {
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"getPoliciesForPrincipal(", user, ", ", realm, ") - Found policies <", policies, "> in cache."});
        }
        LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"getPoliciesForPrincipal(", user, ", ", realm, ") - Returning these Policies for principal: <", policies, ">"});
        return policies;
    }

    private boolean hasPolicyIDsForRealm(Collection policyIDs, AuthorizationRealm theRealmOfInterest) {
        for (AuthorizationPolicyID id : policyIDs) {
            AuthorizationRealm aRealm = id.getRealm();
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"hasPolicyIDsForRealm() - Comparing realms: <", aRealm, "> <", theRealmOfInterest, ">"});
            if (!aRealm.equals((Object)theRealmOfInterest)) continue;
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"hasPolicyIDsForRealm() - Realms are equal."});
            return true;
        }
        LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"hasPolicyIDsForRealm() - No realms found to be equal."});
        return false;
    }

    private Collection getGroupsForPrincipal(MetaMatrixPrincipalName principal) throws AuthorizationMgmtException, InvalidPrincipalException {
        LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"getGroupsForPrincipal(", principal, ") - Getting all group memberships."});
        HashSet<MetaMatrixPrincipalName> allPrincipals = new HashSet<MetaMatrixPrincipalName>();
        try {
            HashSet<String> groups = Collections.EMPTY_SET;
            if (principal.getType() == 0 || principal.getType() == 2) {
                groups = this.membershipServiceProxy.getGroupsForUser(principal.getName());
            } else if (principal.getType() == 1) {
                MetaMatrixPrincipal groupPrincipal = this.membershipServiceProxy.getPrincipal(principal);
                groups = new HashSet<String>();
                groups.add(groupPrincipal.getName());
            }
            Iterator memberItr = groups.iterator();
            while (memberItr.hasNext()) {
                MetaMatrixPrincipalName member = new MetaMatrixPrincipalName((String)memberItr.next(), 1);
                LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"getGroupsForPrincipal(", principal, ") - Adding membership <", member, ">"});
                allPrincipals.add(member);
            }
            allPrincipals.add(principal);
        }
        catch (InvalidPrincipalException e) {
            throw e;
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.307.0075");
            throw new AuthorizationMgmtException((Throwable)((Object)e), "ERR.014.307.0075", msg);
        }
        catch (MetaMatrixSecurityException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.307.0035");
            throw new AuthorizationMgmtException((Throwable)e, "ERR.014.307.0035", msg);
        }
        return allPrincipals;
    }

    private Collection getDependantRequests(AuthorizationPermission request) throws AuthorizationMgmtException {
        boolean success = false;
        Object exception = null;
        String exceptionMsg = null;
        HashSet policies = new HashSet();
        AuthorizationSourceTransaction transaction = null;
        for (int i = 0; i < this.retries; ++i) {
            try {
                transaction = this.getReadTransaction();
                policies.addAll(transaction.getDependantPermissions(request));
                success = true;
                break;
            }
            catch (ManagedConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("AuthorizationServiceImpl.Exception_while_getting_dependant_permissions_for_request_{0}", new Object[]{request});
                LogManager.logError((String)"AUTHORIZATION", (Throwable)((Object)e), (String)exceptionMsg);
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("AuthorizationServiceImpl.Failure_communicating_with_authorization_source_while_getting_dependant_permissions_for_request_{0}", new Object[]{request});
                LogManager.logError((String)"AUTHORIZATION", (Throwable)((Object)e), (String)exceptionMsg);
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceException e) {
                exceptionMsg = PlatformPlugin.Util.getString("AuthorizationServiceImpl.Unknown_exception_communicating_with_authorization_source_while_getting_dependant_permissions_for_request_{0}", new Object[]{request});
                LogManager.logError((String)"AUTHORIZATION", (Throwable)((Object)e), (String)exceptionMsg);
                throw new AuthorizationMgmtException((Throwable)((Object)e), exceptionMsg);
            }
            finally {
                if (transaction != null) {
                    try {
                        if (success) {
                            transaction.commit();
                        } else {
                            transaction.rollback();
                        }
                        transaction.close();
                    }
                    catch (Exception e) {
                        LogManager.logError((String)"AUTHORIZATION", (Throwable)e, (String)PlatformPlugin.Util.getString("AuthorizationServiceImpl.Unable_to_close_transaction."));
                    }
                    transaction = null;
                }
            }
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Attempting to retry search for policies with ID collection."});
        }
        if (!success) {
            throw new AuthorizationMgmtException(exception, exceptionMsg);
        }
        return policies;
    }

    private void executeTransactionsOnTarget(AuthorizationSourceTransaction transaction, List actions, Object target, SessionToken administrator, Set affectedObjects) throws AuthorizationMgmtException {
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"executeTransactionsOnTarget(", administrator, actions, target, ")"});
        Set results = null;
        AuthorizationSourceException exception = null;
        String exceptionMsg = null;
        boolean success = false;
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"Executing ", new Integer(actions.size()), " action(s) on target \"", target, "\""});
        if (target instanceof AuthorizationPolicyID) {
            AuthorizationPolicyID policyID = (AuthorizationPolicyID)target;
            try {
                results = transaction.executeActions(policyID, actions, administrator.getUsername());
                success = true;
            }
            catch (AuthorizationSourceConnectionException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0076", new Object[]{target});
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0076", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
            catch (AuthorizationSourceException e) {
                exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0076", new Object[]{target});
                LogManager.logError((String)"AUTHORIZATION", (String)PlatformPlugin.Util.getString("ERR.014.307.0076", new Object[]{e, exceptionMsg}));
                exception = e;
                success = false;
            }
        } else {
            exceptionMsg = PlatformPlugin.Util.getString("ERR.014.307.0077", new Object[]{target});
            throw new AuthorizationMgmtException("ERR.014.307.0077", exceptionMsg);
        }
        if (!success) {
            throw new AuthorizationMgmtException(exception, "ERR.014.307.0076", exceptionMsg);
        }
        affectedObjects.addAll(results);
    }

    private static AuthorizationRealm getRequestedRealm(Collection requests) throws AuthorizationMgmtException {
        AuthorizationRealm theRealm = null;
        for (AuthorizationPermission aPerm : requests) {
            AuthorizationRealm aRealm = aPerm.getRealm();
            if (theRealm != null) {
                if (theRealm.equals((Object)aRealm)) continue;
                throw new AuthorizationMgmtException("ERR.014.307.0078", PlatformPlugin.Util.getString("ERR.014.307.0078"));
            }
            theRealm = aRealm;
        }
        if (theRealm == null) {
            throw new AuthorizationMgmtException(PlatformPlugin.Util.getString("AuthorizationServiceImpl.Authorization_Realm_is_null"));
        }
        return theRealm;
    }

    private String printActions(Collection actions) {
        StringBuffer sb = new StringBuffer();
        Iterator iter = actions.iterator();
        if (iter.hasNext()) {
            sb.append(iter.next().toString());
        }
        while (iter.hasNext()) {
            sb.append("; ");
            sb.append(iter.next().toString());
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("AuthorizationService - ");
        try {
            buff.append(super.getInstanceName());
        }
        catch (ServiceNotInitializedException e) {
            buff.append("not initialized.");
        }
        catch (ServiceClosedException e) {
            buff.append("closed.");
        }
        catch (ServiceStateException e) {
            buff.append("in invalid state.");
        }
        buff.append("\n");
        return buff.toString();
    }

    @Override
    public void migratePolicies(SessionToken token, EntitlementMigrationReport rpt, String targetVDBName, String targetVDBVersion, Set targetNodes, Collection sourcePolicies, AdminOptions options) throws MetaMatrixComponentException, InvalidSessionException, AuthorizationException, AuthorizationMgmtException {
        AuthorizationRealm targetRealm = new AuthorizationRealm(targetVDBName, targetVDBVersion);
        AuthorizationObjectEditor aoe = new AuthorizationObjectEditor();
        Iterator policyItr = sourcePolicies.iterator();
        int newPermissions = 0;
        while (policyItr.hasNext()) {
            AuthorizationPolicy sourcePolicy = (AuthorizationPolicy)policyItr.next();
            AuthorizationPolicyID sourcePolicyID = sourcePolicy.getAuthorizationPolicyID();
            AuthorizationPolicyID newPolicyID = new AuthorizationPolicyID(sourcePolicyID.getDisplayName(), targetVDBName, targetVDBVersion);
            AuthorizationPolicy existingPolicy = null;
            try {
                existingPolicy = this.getPolicy(token, newPolicyID);
            }
            catch (AuthorizationMgmtException e) {
                existingPolicy = null;
            }
            boolean overWritten = false;
            if (existingPolicy != null) {
                if (options.containsOption(4)) {
                    throw new AuthorizationException(PlatformPlugin.Util.getString("AuthorizationServiceImpl.role_exists", new Object[]{sourcePolicyID.getDisplayName()}));
                }
                if (options.containsOption(1)) {
                    overWritten = true;
                    LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"overwriting existing role", sourcePolicyID.getDisplayName()});
                    aoe.remove(existingPolicy.getAuthorizationPolicyID());
                }
                if (options.containsOption(2)) {
                    if (rpt != null) {
                        rpt.addResourceEntry((Object)PlatformPlugin.Util.getString("AuthorizationServiceImpl.Succeeded_migration"), (Object)"", (Object)sourcePolicy.getAuthorizationPolicyID().getDisplayName(), (Object)sourcePolicy.getAuthorizationPolicyID().getDisplayName(), (Object)"None", (Object)PlatformPlugin.Util.getString("AuthorizationServiceImpl.Ignored"));
                    }
                    LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"ignoring existing role", sourcePolicyID.getDisplayName()});
                    continue;
                }
            }
            AuthorizationPolicy newPolicy = aoe.createAuthorizationPolicy(newPolicyID);
            if (rpt != null) {
                rpt.addResourceEntry((Object)PlatformPlugin.Util.getString("AuthorizationServiceImpl.Succeeded_migration"), (Object)"", (Object)sourcePolicy.getAuthorizationPolicyID().getDisplayName(), (Object)newPolicy.getAuthorizationPolicyID().getDisplayName(), (Object)"None", (Object)(overWritten ? PlatformPlugin.Util.getString("AuthorizationServiceImpl.Overwritten") : PlatformPlugin.Util.getString("AuthorizationServiceImpl.Migrated")));
            }
            try {
                newPolicy = aoe.clonePolicyPrincipals(sourcePolicy, newPolicy, this.membershipServiceProxy.getGroupNames(), rpt);
            }
            catch (MembershipServiceException err) {
                throw new AuthorizationException((Throwable)err);
            }
            newPolicy = aoe.clonePolicyPermissions(sourcePolicy, newPolicy, targetRealm, targetNodes, rpt);
            newPermissions += newPolicy.getPermissionCount();
        }
        List actions = aoe.getDestination().getActions();
        LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"migrateEntitlements(" + targetVDBName + " " + targetVDBVersion + ") executing [" + actions.size() + "] for [" + newPermissions + "] cloned permissions"});
        this.executeTransaction(token, actions);
    }
}

