/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.authorization.spi.jdbc;

import com.metamatrix.common.log.I18nLogManager;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationPermissionFactory;
import com.metamatrix.platform.security.api.AuthorizationPolicy;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.AuthorizationResource;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;
import com.metamatrix.platform.security.authorization.spi.AuthorizationSourceConnectionException;
import com.metamatrix.platform.security.authorization.spi.AuthorizationSourceException;
import com.metamatrix.platform.security.authorization.spi.jdbc.JDBCAuthorizationTransaction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class JDBCAuthorizationReader {
    public static Set getRoleNamesForPrincipal(MetaMatrixPrincipalName principal, Connection jdbcConnection) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        HashSet<String> pRoles = new HashSet<String>();
        String sql = "SELECT AUTHPOLICIES.POLICYNAME FROM AUTHPERMISSIONS, AUTHREALMS, AUTHPRINCIPALS, AUTHPOLICIES WHERE AUTHPERMISSIONS.POLICYUID = AUTHPOLICIES.POLICYUID AND AUTHPRINCIPALS.POLICYUID = AUTHPOLICIES.POLICYUID AND AUTHPERMISSIONS.REALMUID = AUTHREALMS.REALMUID AND AUTHREALMS.REALMNAME = ?  AND AUTHPRINCIPALS.PRINCIPALNAME = ? ";
        sql = sql.toUpperCase();
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getRoleNamesForPrincipal(", principal, ")", "SQL: ", sql});
        PreparedStatement statement = null;
        try {
            statement = jdbcConnection.prepareStatement(sql);
            String roleName = null;
            statement.setString(1, JDBCAuthorizationTransaction.ROLE_REALM);
            statement.setString(2, principal.getName());
            ResultSet results = statement.executeQuery();
            while (results.next()) {
                roleName = results.getString(1);
                pRoles.add(roleName);
            }
            statement.clearParameters();
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0095", PlatformPlugin.Util.getString("ERR.014.307.0095"));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
                statement = null;
            }
        }
        return pRoles;
    }

    public static AuthorizationPolicy getPolicy(AuthorizationPolicyID policyID, Connection jdbcConnection) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        AuthorizationPolicy myPolicy = null;
        AuthorizationPolicyID pID = null;
        Set permissions = Collections.EMPTY_SET;
        HashSet<MetaMatrixPrincipalName> principals = null;
        Statement statement = null;
        ResultSet results = null;
        try {
            principals = new HashSet<MetaMatrixPrincipalName>();
            String policyName = policyID.getName();
            String sql = "SELECT AUTHPOLICIES.POLICYUID, AUTHPOLICIES.POLICYNAME, AUTHPOLICIES.DESCRIPTION FROM AUTHPOLICIES WHERE AUTHPOLICIES.POLICYNAME = ? ";
            sql = sql.toUpperCase();
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"getPolicy-1(", policyID, ")", "SQL: ", sql});
            statement = jdbcConnection.prepareStatement(sql);
            statement.setString(1, policyName);
            results = statement.executeQuery();
            String name = null;
            String desc = null;
            if (!results.next()) {
                throw new AuthorizationSourceException("ERR.014.307.0105", PlatformPlugin.Util.getString("ERR.014.307.0105", new Object[]{policyID}));
            }
            name = results.getString("POLICYNAME");
            desc = results.getString("DESCRIPTION");
            pID = new AuthorizationPolicyID(name, desc);
            statement.close();
            sql = "SELECT AUTHPRINCIPALS.PRINCIPALNAME, AUTHPRINCIPALS.PRINCIPALTYPE FROM AUTHPRINCIPALS, AUTHPOLICIES WHERE AUTHPOLICIES.POLICYUID = AUTHPRINCIPALS.POLICYUID AND AUTHPOLICIES.POLICYNAME = ? ";
            sql = sql.toUpperCase();
            LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getPolicy-2(", policyID, ")", "SQL: ", sql});
            statement = jdbcConnection.prepareStatement(sql);
            statement.setString(1, policyName);
            results = statement.executeQuery();
            while (results.next()) {
                String principalName = results.getString(1);
                int principalType = results.getInt(2);
                principals.add(new MetaMatrixPrincipalName(principalName, principalType));
            }
            statement.close();
            results = null;
            permissions = JDBCAuthorizationReader.getPermissionsForPolicy(policyID, jdbcConnection);
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0106", PlatformPlugin.Util.getString("ERR.014.307.0106", new Object[]{policyID}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
            }
        }
        myPolicy = new AuthorizationPolicy(pID, null, permissions);
        myPolicy.addAllPrincipals(principals);
        return myPolicy;
    }

    public static Set getPermissionsForPolicy(AuthorizationPolicyID policyID, Connection jdbcConnection) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        HashSet<AuthorizationPermission> permissions = new HashSet<AuthorizationPermission>();
        String policyName = policyID.getName();
        Statement statement = null;
        String factoryClassName = null;
        try {
            Class<?> factoryClass = null;
            String tempClassName = null;
            AuthorizationPermissionFactory permFactory = null;
            String sql = "SELECT AUTHPERMISSIONS.RESOURCENAME, AUTHREALMS.REALMNAME, AUTHREALMS.DESCRIPTION, AUTHPERMISSIONS.ACTIONS, AUTHPERMISSIONS.CONTENTMODIFIER, AUTHPERMTYPES.FACTORYCLASSNAME FROM AUTHPERMISSIONS, AUTHREALMS, AUTHPERMTYPES, AUTHPOLICIES WHERE AUTHPERMISSIONS.POLICYUID = AUTHPOLICIES.POLICYUID AND AUTHPERMISSIONS.PERMTYPEUID = AUTHPERMTYPES.PERMTYPEUID AND AUTHPERMISSIONS.REALMUID = AUTHREALMS.REALMUID AND AUTHPOLICIES.POLICYNAME = ? ";
            sql = sql.toUpperCase();
            LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getPermissionsForPolicy(", policyID, ")", "SQL: ", sql});
            statement = jdbcConnection.prepareStatement(sql);
            statement.setString(1, policyName);
            ResultSet results = statement.executeQuery();
            while (results.next()) {
                String resourceName = results.getString("RESOURCENAME");
                String realmName = results.getString("REALMNAME");
                String realmDescription = results.getString("DESCRIPTION");
                int actionsValue = results.getInt("ACTIONS");
                AuthorizationActions actions = StandardAuthorizationActions.getAuthorizationActions((int)actionsValue);
                String contentModifier = results.getString("CONTENTMODIFIER");
                factoryClassName = results.getString("FACTORYCLASSNAME");
                if (!factoryClassName.equals(tempClassName)) {
                    factoryClass = Class.forName(factoryClassName);
                    permFactory = (AuthorizationPermissionFactory)factoryClass.newInstance();
                    tempClassName = factoryClassName;
                }
                AuthorizationRealm theRealm = new AuthorizationRealm(realmName);
                theRealm.setDescription(realmDescription);
                AuthorizationResource resource = permFactory.createResource(resourceName);
                AuthorizationPermission perm = permFactory.create(resource, theRealm, actions, contentModifier);
                permissions.add(perm);
            }
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0108", PlatformPlugin.Util.getString("ERR.014.307.0108", new Object[]{policyID}));
        }
        catch (ClassNotFoundException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0082", PlatformPlugin.Util.getString("ERR.014.307.0082", new Object[]{factoryClassName}));
        }
        catch (IllegalAccessException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0083", PlatformPlugin.Util.getString("ERR.014.307.0083"));
        }
        catch (InstantiationException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0084", PlatformPlugin.Util.getString("ERR.014.307.0084", new Object[]{factoryClassName}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
            }
        }
        return permissions;
    }
}

