/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.authorization.spi.jdbc;

import com.metamatrix.common.actions.ActionDefinition;
import com.metamatrix.common.actions.AddObject;
import com.metamatrix.common.actions.CreateObject;
import com.metamatrix.common.actions.DestroyObject;
import com.metamatrix.common.actions.ExchangeObject;
import com.metamatrix.common.actions.RemoveObject;
import com.metamatrix.common.connection.BaseTransaction;
import com.metamatrix.common.connection.ManagedConnection;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.connection.jdbc.JDBCMgdResourceConnection;
import com.metamatrix.common.id.dbid.DBIDGenerator;
import com.metamatrix.common.id.dbid.DBIDGeneratorException;
import com.metamatrix.common.log.I18nLogManager;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.platform.security.api.AuthorizationModel;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationPermissionFactory;
import com.metamatrix.platform.security.api.AuthorizationPermissions;
import com.metamatrix.platform.security.api.AuthorizationPolicy;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.GranteeEntitlementEntry;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;
import com.metamatrix.platform.security.authorization.spi.AuthorizationSourceConnectionException;
import com.metamatrix.platform.security.authorization.spi.AuthorizationSourceException;
import com.metamatrix.platform.security.authorization.spi.AuthorizationSourceTransaction;
import com.metamatrix.platform.security.authorization.spi.jdbc.JDBCAuthorizationReader;
import com.metamatrix.platform.security.util.RolePermissionFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JDBCAuthorizationTransaction
extends BaseTransaction
implements AuthorizationSourceTransaction {
    static final int DEFALT_ARRAY_INDEX = 0;
    static final String DEFALT_POLICY_DESCRIPTION = "";
    static final String ROLE_REALM = RolePermissionFactory.getRealmName();
    private Connection jdbcConnection;

    JDBCAuthorizationTransaction(ManagedConnection connection, boolean readonly) throws ManagedConnectionException {
        super(connection, readonly);
        try {
            JDBCMgdResourceConnection jdbcManagedConnection = (JDBCMgdResourceConnection)connection;
            this.jdbcConnection = jdbcManagedConnection.getConnection();
        }
        catch (Exception e) {
            throw new ManagedConnectionException(e, "ERR.014.307.0079", PlatformPlugin.Util.getString("ERR.014.307.0079"));
        }
    }

    @Override
    public void addPermissionsWithResourcesToParent(String parent, Collection resources, AuthorizationRealm realm) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        PreparedStatement statement = null;
        String sql = "SELECT AUTHPERMISSIONS.ACTIONS, AUTHPERMTYPES.FACTORYCLASSNAME, AUTHPOLICIES.POLICYNAME, AUTHPOLICIES.DESCRIPTION FROM AUTHPERMISSIONS, AUTHPOLICIES, AUTHREALMS, AUTHPERMTYPES WHERE AUTHPOLICIES.POLICYUID = AUTHPERMISSIONS.POLICYUID AND AUTHPERMISSIONS.PERMTYPEUID = AUTHPERMTYPES.PERMTYPEUID AND AUTHPERMISSIONS.REALMUID = AUTHREALMS.REALMUID AND AUTHREALMS.REALMNAME = ?  AND AUTHPERMISSIONS.RESOURCENAME = ? ";
        sql = sql.toUpperCase();
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"addPermissionsWithResourcesToParent(", parent, resources, realm, ")", "SQL: ", sql});
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(realm.getRealmName());
        argList.add(parent);
        try {
            statement = this.prepareStatement(this.jdbcConnection, sql, argList);
        }
        catch (SQLException e) {
            throw new AuthorizationSourceConnectionException(e, "ERR.014.307.0080", PlatformPlugin.Util.getString("ERR.014.307.0080", new Object[]{parent}));
        }
        HashMap<AuthorizationPermission, AuthorizationPolicyID> policyIDPermissions = new HashMap<AuthorizationPermission, AuthorizationPolicyID>();
        String tempClassName = null;
        Class<?> factoryClass = null;
        AuthorizationPermissionFactory permFactory = null;
        try {
            ResultSet results = statement.executeQuery();
            while (results.next()) {
                int actions = results.getInt("ACTIONS");
                String factoryClassName = results.getString("FACTORYCLASSNAME");
                String policyName = results.getString("POLICYNAME");
                String policyDesc = results.getString("DESCRIPTION");
                if (!factoryClassName.equals(tempClassName)) {
                    factoryClass = Class.forName(factoryClassName);
                    permFactory = (AuthorizationPermissionFactory)factoryClass.newInstance();
                    tempClassName = factoryClassName;
                }
                AuthorizationPolicyID aPolicyID = new AuthorizationPolicyID(policyName, policyDesc);
                AuthorizationActions newActions = StandardAuthorizationActions.getAuthorizationActions((int)actions);
                for (String resourceName : resources) {
                    AuthorizationPermission perm = permFactory.create(resourceName, realm, newActions);
                    policyIDPermissions.put(perm, aPolicyID);
                }
            }
        }
        catch (SQLException e) {
            throw new AuthorizationSourceConnectionException(e, "ERR.014.307.0081", PlatformPlugin.Util.getString("ERR.014.307.0081", new Object[]{parent}));
        }
        catch (ClassNotFoundException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0082", PlatformPlugin.Util.getString("ERR.014.307.0082", new Object[]{factoryClass}));
        }
        catch (IllegalAccessException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0083", PlatformPlugin.Util.getString("ERR.014.307.0083"));
        }
        catch (InstantiationException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0084", PlatformPlugin.Util.getString("ERR.014.307.0084", new Object[]{factoryClass}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", e);
                }
                statement = null;
            }
        }
        Iterator newPermItr = policyIDPermissions.keySet().iterator();
        HashMap<AuthorizationPolicyID, Number> policyUUIDs = new HashMap<AuthorizationPolicyID, Number>(policyIDPermissions.size());
        while (newPermItr.hasNext()) {
            AuthorizationPermission aNewPerm = (AuthorizationPermission)newPermItr.next();
            AuthorizationPolicyID targetPolicyID = (AuthorizationPolicyID)policyIDPermissions.get(aNewPerm);
            try {
                Number policyUID = (Number)policyUUIDs.get(targetPolicyID);
                if (policyUID == null) {
                    policyUID = this.getPolicyUID(targetPolicyID);
                    policyUUIDs.put(targetPolicyID, policyUID);
                }
                this.addPermission(policyUID, aNewPerm);
            }
            catch (SQLException e) {
                throw new AuthorizationSourceConnectionException(e, "ERR.014.307.0086", PlatformPlugin.Util.getString("ERR.014.307.0086", new Object[]{targetPolicyID}));
            }
            catch (AuthorizationSourceException e) {
                throw new AuthorizationSourceException((Throwable)((Object)e), "ERR.014.307.0086", PlatformPlugin.Util.getString("ERR.014.307.0086", new Object[]{targetPolicyID}));
            }
        }
    }

    @Override
    public void removePermissionsWithResources(Collection resources, AuthorizationRealm realm) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        PreparedStatement statement = null;
        String sql = "DELETE  FROM AUTHPERMISSIONS WHERE PERMISSIONUID IN (SELECT PERMISSIONUID FROM AUTHPERMISSIONS, AUTHREALMS WHERE AUTHPERMISSIONS.REALMUID = AUTHREALMS.REALMUID AND AUTHREALMS.REALMNAME = ?  AND AUTHPERMISSIONS.RESOURCENAME IN  ";
        sql = sql.toUpperCase();
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"removePermissionsWithResources(", resources, realm, ")", "SQL: ", sql});
        StringBuffer inBuf = new StringBuffer(sql);
        inBuf.append("('");
        Iterator resourceItr = resources.iterator();
        boolean replaceCommaTick = false;
        while (resourceItr.hasNext()) {
            inBuf.append((String)resourceItr.next() + "','");
            replaceCommaTick = true;
        }
        if (replaceCommaTick) {
            inBuf.setLength(inBuf.length() - 2);
        }
        inBuf.append("))");
        LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Removing permissions with resources: " + inBuf.toString() + "<->" + realm.getRealmName()});
        try {
            statement = this.jdbcConnection.prepareStatement(inBuf.toString());
            statement.setString(1, realm.getRealmName());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new AuthorizationSourceConnectionException(e, "ERR.014.307.0088", PlatformPlugin.Util.getString("ERR.014.307.0088"));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", e);
                }
                statement = null;
            }
        }
    }

    @Override
    public Collection getDependantPermissions(AuthorizationPermission request) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        HashSet<String> resourceNames = new HashSet<String>();
        String resourceName = request.getResourceName();
        AuthorizationRealm realm = request.getRealm();
        String sql = "SELECT AUTHPERMISSIONS.RESOURCENAME FROM AUTHPERMISSIONS, AUTHREALMS WHERE AUTHPERMISSIONS.REALMUID = AUTHREALMS.REALMUID AND AUTHREALMS.REALMNAME = ?  AND AUTHPERMISSIONS.RESOURCENAME LIKE  ? ";
        sql = sql.toUpperCase();
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getDependantPermissions(", request, ")", "SQL: ", sql});
        PreparedStatement statement = null;
        try {
            statement = this.jdbcConnection.prepareStatement(sql);
            statement.setString(1, realm.getRealmName());
            statement.setString(2, resourceName + "%");
            ResultSet results = statement.executeQuery();
            while (results.next()) {
                String dependantResourceName = results.getString("RESOURCENAME");
                resourceNames.add(dependantResourceName);
            }
        }
        catch (SQLException e) {
            throw new AuthorizationSourceConnectionException(e, PlatformPlugin.Util.getString("JDBCAuthorizationTransaction.Error_getting_dependant_permissions_for_resource_{0}", new Object[]{resourceName}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", e);
                }
                statement = null;
            }
        }
        ArrayList<AuthorizationPermission> dependants = null;
        if (resourceNames.size() > 0) {
            dependants = new ArrayList(resourceNames.size() + 1);
            dependants.add(request);
            String msg = PlatformPlugin.Util.getString("JDBCAuthorizationTransaction.Error_instantiating_factory_class_for_permission__{0}", new Object[]{request});
            AuthorizationPermissionFactory permFact = null;
            try {
                Class<?> permFactClass = Class.forName(request.getFactoryClassName());
                permFact = (AuthorizationPermissionFactory)permFactClass.newInstance();
            }
            catch (ClassCastException e) {
                throw new AuthorizationSourceException(e, msg);
            }
            catch (ClassNotFoundException e) {
                throw new AuthorizationSourceException(e, msg);
            }
            catch (IllegalAccessException e) {
                throw new AuthorizationSourceException(e, msg);
            }
            catch (InstantiationException e) {
                throw new AuthorizationSourceException(e, msg);
            }
            AuthorizationActions actions = request.getActions();
            for (String aResource : resourceNames) {
                AuthorizationPermission aPerm = permFact.create(aResource, realm, actions);
                dependants.add(aPerm);
            }
        } else {
            dependants = new ArrayList<AuthorizationPermission>(1);
            dependants.add(request);
        }
        return dependants;
    }

    @Override
    public Map getGroupEntitlements(AuthorizationRealm realm, String fullyQualifiedGroupName) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getGroupEntitlements(", realm, ", ", fullyQualifiedGroupName, ")"});
        String sql = "SELECT  DISTINCT AUTHPERMISSIONS.RESOURCENAME, AUTHPRINCIPALS.PRINCIPALNAME, AUTHPRINCIPALS.PRINCIPALTYPE, AUTHPRINCIPALS.GRANTOR, AUTHPERMISSIONS.ACTIONS FROM AUTHPERMISSIONS, AUTHPRINCIPALS, AUTHPOLICIES, AUTHREALMS WHERE AUTHPERMISSIONS.POLICYUID = AUTHPOLICIES.POLICYUID AND AUTHPRINCIPALS.POLICYUID = AUTHPOLICIES.POLICYUID AND AUTHPERMISSIONS.REALMUID = AUTHREALMS.REALMUID AND AUTHREALMS.REALMNAME = ?  AND AUTHPERMISSIONS.RESOURCENAME LIKE  ? ";
        sql = sql.toUpperCase();
        ArrayList<String> statementArgs = new ArrayList<String>();
        statementArgs.add(realm.getRealmName());
        statementArgs.add(fullyQualifiedGroupName + "%");
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement(this.jdbcConnection, sql, statementArgs);
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0089", PlatformPlugin.Util.getString("ERR.014.307.0089"));
        }
        return this.getEntitlementsForResourceInRealm(statement, true);
    }

    @Override
    public Map getElementEntitlements(AuthorizationRealm realm, String elementNamePattern) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getElementEntitlements(", realm, ", ", elementNamePattern, ")"});
        String sql = "SELECT  DISTINCT AUTHPERMISSIONS.RESOURCENAME, AUTHPRINCIPALS.PRINCIPALNAME, AUTHPRINCIPALS.PRINCIPALTYPE, AUTHPRINCIPALS.GRANTOR, AUTHPERMISSIONS.ACTIONS FROM AUTHPERMISSIONS, AUTHPRINCIPALS, AUTHPOLICIES, AUTHREALMS WHERE AUTHPERMISSIONS.POLICYUID = AUTHPOLICIES.POLICYUID AND AUTHPRINCIPALS.POLICYUID = AUTHPOLICIES.POLICYUID AND AUTHPERMISSIONS.REALMUID = AUTHREALMS.REALMUID AND AUTHREALMS.REALMNAME = ?  AND AUTHPERMISSIONS.RESOURCENAME LIKE  ? ";
        sql = sql.toUpperCase();
        ArrayList<String> statementArgs = new ArrayList<String>();
        statementArgs.add(realm.getRealmName());
        statementArgs.add(elementNamePattern);
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement(this.jdbcConnection, sql, statementArgs);
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0090", PlatformPlugin.Util.getString("ERR.014.307.0090"));
        }
        return this.getEntitlementsForResourceInRealm(statement, false);
    }

    private Map getEntitlementsForResourceInRealm(PreparedStatement statement, boolean isGroup) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getEntitlementsForResourceInRealm(", statement, ", isGroup=", new Boolean(isGroup)});
        HashMap<String, HashSet<GranteeEntitlementEntry>> resourceToEntitlementMap = new HashMap<String, HashSet<GranteeEntitlementEntry>>();
        String resourceName = null;
        String principalName = null;
        int principalType = -1;
        String grantorName = null;
        int actionsValue = -1;
        HashSet<GranteeEntitlementEntry> entitlementEntrySet = null;
        try {
            ResultSet results = statement.executeQuery();
            while (results.next()) {
                resourceName = results.getString(1);
                principalName = results.getString(2);
                principalType = results.getInt(3);
                grantorName = results.getString(4);
                actionsValue = results.getInt(5);
                if (isGroup && !StandardAuthorizationActions.getAuthorizationActions((int)actionsValue).implies(StandardAuthorizationActions.DATA_DELETE)) {
                    resourceName = resourceName.substring(0, resourceName.lastIndexOf(46));
                }
                GranteeEntitlementEntry anEntry = new GranteeEntitlementEntry(new MetaMatrixPrincipalName(principalName, principalType), grantorName, actionsValue);
                entitlementEntrySet = (HashSet<GranteeEntitlementEntry>)resourceToEntitlementMap.get(resourceName);
                if (entitlementEntrySet == null) {
                    entitlementEntrySet = new HashSet<GranteeEntitlementEntry>();
                }
                entitlementEntrySet.add(anEntry);
                resourceToEntitlementMap.put(resourceName, entitlementEntrySet);
            }
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0091", PlatformPlugin.Util.getString("ERR.014.307.0091"));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
                statement = null;
            }
        }
        return resourceToEntitlementMap;
    }

    @Override
    public Collection getRealmNames() throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        ArrayList<String> realmNames = new ArrayList<String>();
        String name = null;
        PreparedStatement statement = null;
        String sql = "SELECT AUTHREALMS.REALMNAME FROM AUTHREALMS";
        sql = sql.toUpperCase();
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getRealmNames()", "SQL: ", sql});
        try {
            statement = this.jdbcConnection.prepareStatement(sql);
            ResultSet results = statement.executeQuery();
            while (results.next()) {
                name = results.getString("REALMNAME");
                realmNames.add(name);
            }
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0092", PlatformPlugin.Util.getString("ERR.014.307.0092"));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
            }
        }
        return realmNames;
    }

    @Override
    public Map getRoleDescriptions() throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        HashMap<String, String> roles = new HashMap<String, String>();
        String sql = "SELECT  DISTINCT AUTHPOLICIES.POLICYNAME, AUTHPOLICIES.DESCRIPTION FROM AUTHPOLICIES, AUTHPERMISSIONS, AUTHREALMS WHERE AUTHPERMISSIONS.POLICYUID = AUTHPOLICIES.POLICYUID AND AUTHPERMISSIONS.REALMUID = AUTHREALMS.REALMUID AND AUTHREALMS.REALMNAME = ? ";
        sql = sql.toUpperCase();
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getRoleDescriptions()", "SQL: ", sql});
        Statement statement = null;
        try {
            String roleName = null;
            String description = null;
            statement = this.jdbcConnection.prepareStatement(sql);
            statement.setString(1, ROLE_REALM);
            ResultSet results = statement.executeQuery();
            while (results.next()) {
                roleName = results.getString(1);
                description = results.getString(2);
                roles.put(roleName, description);
            }
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0093", PlatformPlugin.Util.getString("ERR.014.307.0093"));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
                statement = null;
            }
        }
        return roles;
    }

    @Override
    public Collection getPrincipalsForRole(String roleName) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        HashSet<MetaMatrixPrincipalName> principals = new HashSet<MetaMatrixPrincipalName>();
        String sql = "SELECT AUTHPRINCIPALS.PRINCIPALNAME, AUTHPRINCIPALS.PRINCIPALTYPE FROM AUTHPERMISSIONS, AUTHREALMS, AUTHPRINCIPALS, AUTHPOLICIES WHERE AUTHPERMISSIONS.POLICYUID = AUTHPOLICIES.POLICYUID AND AUTHPRINCIPALS.POLICYUID = AUTHPOLICIES.POLICYUID AND AUTHPERMISSIONS.REALMUID = AUTHREALMS.REALMUID AND AUTHREALMS.REALMNAME = ?  AND AUTHPOLICIES.POLICYNAME = ? ";
        sql = sql.toUpperCase();
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getPrincipalsForRole(", roleName, ")", "SQL: ", sql});
        Statement statement = null;
        ArrayList<String> statementArgs = new ArrayList<String>();
        statementArgs.add(ROLE_REALM);
        statementArgs.add(roleName);
        try {
            String principalName = null;
            int principalType = -1;
            statement = this.prepareStatement(this.jdbcConnection, sql, statementArgs);
            ResultSet results = statement.executeQuery();
            while (results.next()) {
                principalName = results.getString(1);
                principalType = results.getInt(2);
                principals.add(new MetaMatrixPrincipalName(principalName, principalType));
            }
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0094", PlatformPlugin.Util.getString("ERR.014.307.0094"));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
                statement = null;
            }
        }
        return principals;
    }

    @Override
    public Collection getRoleNamesForPrincipal(Collection principals) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        HashSet<String> roleNames = new HashSet<String>();
        String sql = "SELECT AUTHPOLICIES.POLICYNAME FROM AUTHPERMISSIONS, AUTHREALMS, AUTHPRINCIPALS, AUTHPOLICIES WHERE AUTHPERMISSIONS.POLICYUID = AUTHPOLICIES.POLICYUID AND AUTHPRINCIPALS.POLICYUID = AUTHPOLICIES.POLICYUID AND AUTHPERMISSIONS.REALMUID = AUTHREALMS.REALMUID AND AUTHREALMS.REALMNAME = ?  AND AUTHPRINCIPALS.PRINCIPALNAME = ? ";
        sql = sql.toUpperCase();
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getRoleNamesForPrincipal(", principals, ")", "SQL: ", sql});
        PreparedStatement statement = null;
        try {
            statement = this.jdbcConnection.prepareStatement(sql);
            for (MetaMatrixPrincipalName principal : principals) {
                String roleName = null;
                statement.setString(1, ROLE_REALM);
                statement.setString(2, principal.getName());
                ResultSet results = statement.executeQuery();
                while (results.next()) {
                    roleName = results.getString(1);
                    roleNames.add(roleName);
                }
                statement.clearParameters();
            }
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0095", PlatformPlugin.Util.getString("ERR.014.307.0095"));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
                statement = null;
            }
        }
        return roleNames;
    }

    @Override
    public boolean containsPolicy(AuthorizationPolicyID id) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        if (id == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.307.0096"));
        }
        try {
            Number result = this.getPolicyUID(id);
            return result != null;
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0097", PlatformPlugin.Util.getString("ERR.014.307.0097", new Object[]{id}));
        }
    }

    @Override
    public Collection findAllPolicyIDs() throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        Collection policyIDs = new ArrayList();
        PreparedStatement statement = null;
        String sql = "SELECT AUTHPOLICIES.POLICYNAME, AUTHPOLICIES.DESCRIPTION FROM AUTHPOLICIES";
        sql = sql.toUpperCase();
        LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"findAllPolicyIDs()", "SQL: ", sql});
        try {
            statement = this.jdbcConnection.prepareStatement(sql);
            ResultSet results = statement.executeQuery();
            policyIDs = this.populatePolicyIDs(results);
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0098", PlatformPlugin.Util.getString("ERR.014.307.0098"));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
            }
        }
        return policyIDs;
    }

    @Override
    public Collection getPolicyIDsWithPermissionsInRealm(AuthorizationRealm realm) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        Collection policyIDs = new ArrayList();
        PreparedStatement statement = null;
        String sql = "SELECT  DISTINCT AUTHPOLICIES.POLICYNAME, AUTHPOLICIES.DESCRIPTION FROM AUTHPOLICIES, AUTHPERMISSIONS, AUTHREALMS WHERE AUTHPERMISSIONS.POLICYUID = AUTHPOLICIES.POLICYUID AND AUTHPERMISSIONS.REALMUID = AUTHREALMS.REALMUID AND AUTHREALMS.REALMNAME = ? ";
        sql = sql.toUpperCase();
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getPolicyIDsWithPermissionsInRealm(", realm, ")", "SQL: ", sql});
        try {
            statement = this.jdbcConnection.prepareStatement(sql);
            statement.setString(1, realm.getRealmName());
            ResultSet results = statement.executeQuery();
            policyIDs = this.populatePolicyIDs(results);
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0099", PlatformPlugin.Util.getString("ERR.014.307.0099", new Object[]{realm}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
            }
        }
        return policyIDs;
    }

    @Override
    public Collection getPolicyIDsInRealm(AuthorizationRealm realm) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        Collection policyIDs = new ArrayList();
        PreparedStatement statement = null;
        String sql = "SELECT  DISTINCT AUTHPOLICIES.POLICYNAME, AUTHPOLICIES.DESCRIPTION FROM AUTHPOLICIES WHERE AUTHPOLICIES.POLICYNAME LIKE  ?";
        sql = sql.toUpperCase();
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getPolicyIDsInRealm(", realm, ")", "SQL: ", sql});
        try {
            statement = this.jdbcConnection.prepareStatement(sql);
            statement.setString(1, "%" + AuthorizationPolicyID.parseRealm((AuthorizationRealm)realm));
            ResultSet results = statement.executeQuery();
            policyIDs = this.populatePolicyIDs(results);
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0100", PlatformPlugin.Util.getString("ERR.014.307.0100", new Object[]{realm}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
            }
        }
        return policyIDs;
    }

    @Override
    public Collection getPolicyIDsInPartialRealm(AuthorizationRealm realm) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        Collection policyIDs = new ArrayList();
        PreparedStatement statement = null;
        String sql = "SELECT  DISTINCT AUTHPOLICIES.POLICYNAME, AUTHPOLICIES.DESCRIPTION FROM AUTHPOLICIES, AUTHPERMISSIONS, AUTHREALMS WHERE AUTHPERMISSIONS.POLICYUID = AUTHPOLICIES.POLICYUID AND AUTHPERMISSIONS.REALMUID = AUTHREALMS.REALMUID AND AUTHREALMS.REALMNAME LIKE  ? ";
        sql = sql.toUpperCase();
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getPolicyIDsInPartialRealm(", realm, ")", "SQL: ", sql});
        try {
            statement = this.jdbcConnection.prepareStatement(sql);
            statement.setString(1, realm.getRealmName() + "%");
            ResultSet results = statement.executeQuery();
            policyIDs = this.populatePolicyIDs(results);
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0101", PlatformPlugin.Util.getString("ERR.014.307.0101", new Object[]{realm}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
            }
        }
        return policyIDs;
    }

    @Override
    public Collection findPolicyIDs(Collection principals, AuthorizationRealm realm) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        ArrayList policyIDs = new ArrayList();
        MetaMatrixPrincipalName principalName2 = null;
        PreparedStatement statement = null;
        String realmName = realm.getRealmName();
        String sql = "SELECT AUTHPOLICIES.POLICYNAME, AUTHPOLICIES.DESCRIPTION FROM AUTHPOLICIES WHERE AUTHPOLICIES.POLICYUID IN (SELECT AUTHPRINCIPALS.POLICYUID FROM AUTHPRINCIPALS WHERE lower(AUTHPRINCIPALS.PRINCIPALNAME) = ? AND AUTHPRINCIPALS.POLICYUID IN (SELECT AUTHPERMISSIONS.POLICYUID FROM AUTHPERMISSIONS WHERE AUTHPERMISSIONS.REALMUID IN (SELECT AUTHREALMS.REALMUID FROM AUTHREALMS WHERE lower(AUTHREALMS.REALMNAME) = ?)))";
        sql = sql.toUpperCase();
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"findPolicyIDs(", principals, realmName, ")", "SQL: ", sql});
        try {
            statement = this.jdbcConnection.prepareStatement(sql);
            for (MetaMatrixPrincipalName principalName2 : principals) {
                statement.setString(1, principalName2.getName().toLowerCase());
                statement.setString(2, realmName.toLowerCase());
                ResultSet results = statement.executeQuery();
                policyIDs.addAll(this.populatePolicyIDs(results));
                statement.clearParameters();
            }
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0102", PlatformPlugin.Util.getString("ERR.014.307.0102", new Object[]{realm}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
            }
        }
        return policyIDs;
    }

    @Override
    public Collection findPolicyIDs(Collection principals) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        ArrayList policyIDs = new ArrayList();
        MetaMatrixPrincipalName principalName2 = null;
        PreparedStatement statement = null;
        String sql = "SELECT AUTHPOLICIES.POLICYNAME, AUTHPOLICIES.DESCRIPTION FROM AUTHPOLICIES, AUTHPRINCIPALS WHERE AUTHPRINCIPALS.POLICYUID = AUTHPOLICIES.POLICYUID AND AUTHPRINCIPALS.PRINCIPALNAME = ? ";
        sql = sql.toUpperCase();
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"findPolicyIDs(", principals, ")", "SQL: ", sql});
        try {
            statement = this.jdbcConnection.prepareStatement(sql);
            for (MetaMatrixPrincipalName principalName2 : principals) {
                statement.setString(1, principalName2.getName());
                ResultSet results = statement.executeQuery();
                policyIDs.addAll(this.populatePolicyIDs(results));
                statement.clearParameters();
            }
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0103", PlatformPlugin.Util.getString("ERR.014.307.0103"));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
            }
        }
        return policyIDs;
    }

    @Override
    public Collection getPolicyIDsForResourceInRealm(AuthorizationRealm realm, String resourceName) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        Collection policyIDs = new ArrayList();
        PreparedStatement statement = null;
        String sql = "SELECT  DISTINCT AUTHPOLICIES.POLICYNAME, AUTHPOLICIES.DESCRIPTION FROM AUTHPOLICIES, AUTHPERMISSIONS, AUTHREALMS WHERE AUTHPERMISSIONS.POLICYUID = AUTHPOLICIES.POLICYUID AND AUTHPERMISSIONS.REALMUID = AUTHREALMS.REALMUID AND AUTHREALMS.REALMNAME = ?  AND AUTHPERMISSIONS.RESOURCENAME = ? ";
        sql = sql.toUpperCase();
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getPolicIDsForResourceInRealm(", realm, resourceName, ")", "SQL: ", sql});
        ArrayList<String> statementArgs = new ArrayList<String>();
        statementArgs.add(realm.getRealmName());
        statementArgs.add(resourceName);
        try {
            statement = this.prepareStatement(this.jdbcConnection, sql, statementArgs);
            ResultSet results = statement.executeQuery();
            policyIDs = this.populatePolicyIDs(results);
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0104", PlatformPlugin.Util.getString("ERR.014.307.0104", new Object[]{realm}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
            }
        }
        return policyIDs;
    }

    @Override
    public Collection getPolicies(Collection policyIDs) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        HashSet<AuthorizationPolicy> results = new HashSet<AuthorizationPolicy>();
        for (AuthorizationPolicyID policyID : policyIDs) {
            results.add(this.getPolicy(policyID));
        }
        return results;
    }

    @Override
    public AuthorizationPolicy getPolicy(AuthorizationPolicyID policyID) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        return JDBCAuthorizationReader.getPolicy(policyID, this.jdbcConnection);
    }

    @Override
    public Set getPermissionsForPolicy(AuthorizationPolicyID policyID) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        return JDBCAuthorizationReader.getPermissionsForPolicy(policyID, this.jdbcConnection);
    }

    @Override
    public boolean removePrincipalFromAllPolicies(MetaMatrixPrincipalName principal) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        String principalName = principal.getName();
        boolean removed = false;
        PreparedStatement statement = null;
        String sql = "DELETE  FROM AUTHPRINCIPALS WHERE AUTHPRINCIPALS.PRINCIPALNAME = ? ";
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"removePrincipalFromAllPolicies(", principal, ")", "SQL: ", sql});
        try {
            statement = this.jdbcConnection.prepareStatement(sql);
            statement.setString(1, principalName);
            statement.execute();
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Deleted principal " + principalName + " from policies."});
            removed = true;
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0109", PlatformPlugin.Util.getString("ERR.014.307.0109", new Object[]{principal}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
            }
        }
        return removed;
    }

    @Override
    public Set executeActions(AuthorizationPolicyID targetPolicyID, List actions, String grantor) throws AuthorizationSourceConnectionException, AuthorizationSourceException, AuthorizationSourceException {
        HashSet<AuthorizationPolicyID> affectedIDs = new HashSet<AuthorizationPolicyID>();
        if (actions.isEmpty()) {
            return affectedIDs;
        }
        affectedIDs.add(targetPolicyID);
        try {
            Iterator iter = actions.iterator();
            Number policyUID = null;
            while (iter.hasNext()) {
                AddObject anAction;
                ActionDefinition action = (ActionDefinition)iter.next();
                Object[] args = action.getArguments();
                if (action instanceof CreateObject) {
                    AuthorizationPolicy policy = (AuthorizationPolicy)args[0];
                    LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Creating Policy: " + targetPolicyID});
                    if (policy == null) continue;
                    this.addPolicyIntoAuthPolicies(policy);
                    continue;
                }
                if (action instanceof AddObject) {
                    AuthorizationPermissions newPerms;
                    if (policyUID == null && (policyUID = this.getPolicyUID(targetPolicyID)) == null) break;
                    anAction = (AddObject)action;
                    if (anAction.getAttributeCode().intValue() == AuthorizationModel.Attribute.PRINCIPAL_NAME.getCode()) {
                        MetaMatrixPrincipalName newPrincipal = (MetaMatrixPrincipalName)args[0];
                        if (newPrincipal == null) continue;
                        LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Adding Principal " + newPrincipal + " to Policy: " + targetPolicyID});
                        this.addPrincipal(policyUID, newPrincipal, grantor);
                        continue;
                    }
                    if (anAction.getAttributeCode().intValue() == AuthorizationModel.Attribute.PRINCIPAL_SET.getCode()) {
                        Set newPrincipals = (Set)args[0];
                        if (newPrincipals == null || newPrincipals.isEmpty()) continue;
                        LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Adding Principals " + newPrincipals + " to Policy: " + targetPolicyID});
                        this.addPrincipals(policyUID, newPrincipals, grantor);
                        continue;
                    }
                    if (anAction.getAttributeCode().intValue() == AuthorizationModel.Attribute.PERMISSION.getCode()) {
                        AuthorizationPermission newPerm = (AuthorizationPermission)args[0];
                        if (newPerm == null) continue;
                        LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Adding Permission " + newPerm + " to Policy: " + targetPolicyID});
                        this.addPermission(policyUID, newPerm);
                        continue;
                    }
                    if (anAction.getAttributeCode().intValue() != AuthorizationModel.Attribute.PERMISSIONS.getCode() || (newPerms = (AuthorizationPermissions)args[0]) == null) continue;
                    LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Adding Permissions " + newPerms + " to Policy: " + targetPolicyID});
                    this.addPermissions(policyUID, newPerms);
                    continue;
                }
                if (action instanceof ExchangeObject) {
                    if (policyUID == null) {
                        policyUID = this.getPolicyUID(targetPolicyID);
                    }
                    if ((anAction = (ExchangeObject)action).getAttributeCode().intValue() != AuthorizationModel.Attribute.DESCRIPTION.getCode()) continue;
                    String newDescription = (String)args[1];
                    LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Setting description: " + newDescription + " on Policy: " + targetPolicyID});
                    this.updateAuthPolicy(policyUID, newDescription);
                    continue;
                }
                if (action instanceof RemoveObject) {
                    MetaMatrixPrincipalName principalToRemove;
                    Set permsToRemove;
                    if (policyUID == null) {
                        policyUID = this.getPolicyUID(targetPolicyID);
                    }
                    if ((anAction = (RemoveObject)action).getAttributeCode().intValue() == AuthorizationModel.Attribute.PERMISSION_SET.getCode()) {
                        permsToRemove = (Set)args[0];
                        if (permsToRemove == null || permsToRemove.isEmpty()) continue;
                        LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Removing Permissions: " + permsToRemove + " from Policy: " + targetPolicyID});
                        this.executeBatchRemovePermissions(policyUID, permsToRemove.iterator());
                        continue;
                    }
                    if (anAction.getAttributeCode().intValue() == AuthorizationModel.Attribute.PERMISSIONS.getCode()) {
                        permsToRemove = (AuthorizationPermissions)args[0];
                        if (permsToRemove == null) continue;
                        LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Removing Permissions: " + permsToRemove + " from Policy: " + targetPolicyID});
                        this.executeBatchRemovePermissions(policyUID, permsToRemove.iterator());
                        continue;
                    }
                    if (anAction.getAttributeCode().intValue() == AuthorizationModel.Attribute.PERMISSION.getCode()) {
                        AuthorizationPermission permToRemove = (AuthorizationPermission)args[0];
                        if (permToRemove == null) continue;
                        LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Removing Permission: " + permToRemove + " from Policy: " + targetPolicyID});
                        this.removePermission(policyUID, permToRemove);
                        continue;
                    }
                    if (anAction.getAttributeCode().intValue() == AuthorizationModel.Attribute.PRINCIPAL_SET.getCode()) {
                        Set principalsToRemove = (Set)args[0];
                        if (principalsToRemove == null || principalsToRemove.isEmpty()) continue;
                        LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Removing Principals: " + principalsToRemove + " from Policy: " + targetPolicyID});
                        this.removePrincipals(policyUID, principalsToRemove);
                        continue;
                    }
                    if (anAction.getAttributeCode().intValue() != AuthorizationModel.Attribute.PRINCIPAL_NAME.getCode() || (principalToRemove = (MetaMatrixPrincipalName)args[0]) == null) continue;
                    LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Removing Principal: " + principalToRemove + " to Policy: " + targetPolicyID});
                    this.removePrincipal(policyUID, principalToRemove);
                    continue;
                }
                if (action instanceof DestroyObject) {
                    if (policyUID == null) {
                        policyUID = this.getPolicyUID(targetPolicyID);
                    }
                    LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Destroying Policy: " + targetPolicyID});
                    LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Removing all Permissions from Policy: " + targetPolicyID});
                    this.removeAll("DELETE  FROM AUTHPERMISSIONS WHERE POLICYUID = ? ", policyUID);
                    LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Removing all Principals from Policy: " + targetPolicyID});
                    this.removeAll("DELETE  FROM AUTHPRINCIPALS WHERE POLICYUID = ? ", policyUID);
                    LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Removing the Policy: " + targetPolicyID});
                    this.removeAll("DELETE  FROM AUTHPOLICIES WHERE POLICYUID = ? ", policyUID);
                    continue;
                }
                throw new AuthorizationSourceException("ERR.014.307.0110", PlatformPlugin.Util.getString("ERR.014.307.0110", new Object[]{action, targetPolicyID}));
            }
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0108", PlatformPlugin.Util.getString("ERR.014.307.0108", new Object[]{targetPolicyID}));
        }
        return affectedIDs;
    }

    private Collection populatePolicyIDs(ResultSet results) throws SQLException {
        HashSet<AuthorizationPolicyID> policyIDs = new HashSet<AuthorizationPolicyID>();
        String name = null;
        String desc = null;
        while (results.next()) {
            name = results.getString("POLICYNAME");
            desc = results.getString("DESCRIPTION");
            AuthorizationPolicyID pID = new AuthorizationPolicyID(name, desc);
            policyIDs.add(pID);
        }
        return policyIDs;
    }

    private void addPermission(Number policyUID, AuthorizationPermission perm) throws SQLException, AuthorizationSourceException {
        Number permissionTypeUID = this.getPermissionTypeUID(perm);
        Number realmUID = this.updateAuthorizationRealm(perm);
        Statement statement = null;
        String sql = "INSERT  INTO AUTHPERMISSIONS(POLICYUID,REALMUID,PERMISSIONUID,PERMTYPEUID,RESOURCENAME,CONTENTMODIFIER,ACTIONS) VALUES (?,?,?,?,?,?,?)";
        sql = sql.toUpperCase();
        try {
            long permUID = DBIDGenerator.getInstance().getID("AUTHPERMISSIONS");
            statement = this.jdbcConnection.prepareStatement(sql);
            statement.setLong(1, policyUID.longValue());
            statement.setLong(2, realmUID.longValue());
            statement.setLong(3, permUID);
            statement.setLong(4, permissionTypeUID.longValue());
            statement.setString(5, perm.getResourceName());
            statement.setString(6, perm.getContentModifier());
            statement.setInt(7, perm.getActions().getValue());
            statement.execute();
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Inserted permissions for policy " + perm.getResourceName()});
        }
        catch (DBIDGeneratorException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.307.0108", new Object[]{perm.getResourceName(), perm.getRealmName()});
            throw new AuthorizationSourceException((Throwable)((Object)e), "ERR.014.307.0111", msg);
        }
        catch (SQLException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.307.0108", new Object[]{perm.getResourceName(), perm.getRealmName()});
            throw new AuthorizationSourceException(e, "ERR.014.307.0111", msg);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
            }
        }
    }

    private void addPermissions(Number policyUID, AuthorizationPermissions permissions) throws SQLException, AuthorizationSourceException {
        this.executeBatchAddPermissions(policyUID, permissions);
    }

    private void removePermission(Number policyUID, AuthorizationPermission perm) throws AuthorizationSourceException {
        PreparedStatement statement = null;
        String sql = "DELETE  FROM AUTHPERMISSIONS WHERE POLICYUID = ?  AND RESOURCENAME = ? ";
        sql = sql.toUpperCase();
        try {
            statement = this.jdbcConnection.prepareStatement(sql);
            LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"removePermission(", policyUID, perm.getRealm(), ")", "SQL: ", sql});
            statement.setLong(1, policyUID.longValue());
            statement.setString(2, perm.getResourceName());
            statement.execute();
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Removed permission: " + policyUID + "<->" + perm.getRealm()});
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0112", PlatformPlugin.Util.getString("ERR.014.307.0112", new Object[]{perm}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
            }
        }
    }

    private void removeAll(String sql, Number policyUID) throws AuthorizationSourceException {
        PreparedStatement statement = null;
        sql = sql.toUpperCase();
        ArrayList<Number> statementArgs = new ArrayList<Number>();
        statementArgs.add(policyUID);
        try {
            statement = this.jdbcConnection.prepareStatement(sql);
            statement.setLong(1, policyUID.longValue());
            statement.execute();
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0113", PlatformPlugin.Util.getString("ERR.014.307.0113", new Object[]{policyUID}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPrincipal(Number policyUID, MetaMatrixPrincipalName principal, String grantor) throws SQLException {
        PreparedStatement statement = null;
        String sql = "INSERT  INTO AUTHPRINCIPALS(POLICYUID,PRINCIPALNAME,PRINCIPALTYPE,GRANTOR) VALUES (?,?,?,?)";
        sql = sql.toUpperCase();
        try {
            statement = this.jdbcConnection.prepareStatement(sql);
            statement.setLong(1, policyUID.longValue());
            statement.setString(2, principal.getName());
            statement.setLong(3, principal.getType());
            statement.setString(4, grantor);
            statement.execute();
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Inserted principal " + principal.getName()});
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
            }
        }
    }

    private void addPrincipals(Number policyUID, Set principals, String grantor) throws SQLException {
        for (MetaMatrixPrincipalName principal : principals) {
            this.addPrincipal(policyUID, principal, grantor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removePrincipal(Number policyUID, MetaMatrixPrincipalName principal) throws SQLException, AuthorizationSourceException {
        boolean removed = false;
        PreparedStatement statement = null;
        String sql = "DELETE  FROM AUTHPRINCIPALS WHERE POLICYUID = ?  AND PRINCIPALNAME = ? ";
        sql = sql.toUpperCase();
        try {
            statement = this.jdbcConnection.prepareStatement(sql);
            LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"removePrincipal(", policyUID, principal, ")", "SQL: ", sql});
            statement.setLong(1, policyUID.longValue());
            statement.setString(2, principal.getName());
            statement.execute();
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Removed principal: " + policyUID + "<->" + principal});
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
            }
        }
        return removed;
    }

    private boolean removePrincipals(Number policyUID, Set principals) throws SQLException, AuthorizationSourceException {
        Iterator iter = principals.iterator();
        boolean allRemoved = true;
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"removePrincipals(", policyUID, ")"});
        while (iter.hasNext()) {
            MetaMatrixPrincipalName principal = (MetaMatrixPrincipalName)iter.next();
            if (this.removePrincipal(policyUID, principal) || !allRemoved) continue;
            allRemoved = false;
        }
        return allRemoved;
    }

    @Override
    public void removePrincipalsAndPoliciesForRealm(AuthorizationRealm realm) throws AuthorizationSourceException {
        try {
            Number realmUID = this.getRealmUID(realm);
            this.removePermissionsForRealm(realmUID);
            this.removeRealm(realmUID);
            this.removePrincipalsForRealm(realm);
            this.removePoliciesForRealm(realm);
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0122", PlatformPlugin.Util.getString("ERR.014.307.0122", new Object[]{realm}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePermissionsForRealm(Number realmUID) throws SQLException {
        PreparedStatement statement = null;
        String sql = "DELETE  FROM AUTHPERMISSIONS WHERE REALMUID = ? ";
        sql = sql.toUpperCase();
        try {
            statement = this.jdbcConnection.prepareStatement(sql);
            LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"removePermissionsForRealm(", realmUID, ")", "SQL: ", sql});
            statement.setLong(1, realmUID.longValue());
            statement.execute();
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Removed AUTHPERMISSIONS for realm: " + realmUID});
        }
        finally {
            this.close(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRealm(Number realmUID) throws SQLException {
        PreparedStatement statement = null;
        String sql = "DELETE  FROM AUTHREALMS WHERE REALMUID = ? ";
        sql = sql.toUpperCase();
        try {
            statement = this.jdbcConnection.prepareStatement(sql);
            LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"removeRealm(", realmUID, ")", "SQL: ", sql});
            statement.setLong(1, realmUID.longValue());
            statement.execute();
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Removed AUTHREALM: " + realmUID});
        }
        finally {
            this.close(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePrincipalsForRealm(AuthorizationRealm realm) throws SQLException {
        String policyName = "%" + AuthorizationPolicyID.parseRealm((AuthorizationRealm)realm);
        PreparedStatement statement = null;
        String sql = "DELETE  FROM AUTHPRINCIPALS WHERE POLICYUID IN (SELECT POLICYUID FROM AUTHPOLICIES WHERE POLICYNAME LIKE  ? )";
        sql = sql.toUpperCase();
        try {
            statement = this.jdbcConnection.prepareStatement(sql);
            LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"removePrincipalsForRealm(", realm, ")", "SQL: ", sql});
            statement.setString(1, policyName);
            statement.execute();
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Removed AUTHPRINCIPALS for realm: " + realm});
        }
        finally {
            this.close(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePoliciesForRealm(AuthorizationRealm realm) throws SQLException {
        String policyName = "%" + AuthorizationPolicyID.parseRealm((AuthorizationRealm)realm);
        PreparedStatement statement = null;
        String sql = "DELETE  FROM AUTHPOLICIES WHERE POLICYNAME LIKE  ?";
        sql = sql.toUpperCase();
        try {
            statement = this.jdbcConnection.prepareStatement(sql);
            LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"removePoliciesForRealm(", realm, ")", "SQL: ", sql});
            statement.setString(1, policyName);
            statement.execute();
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Removed AUTHPOLICIES for realm: " + realm});
        }
        finally {
            this.close(statement);
        }
    }

    private void addPolicyIntoAuthPolicies(AuthorizationPolicy policy) throws AuthorizationSourceConnectionException, AuthorizationSourceException, SQLException {
        if (this.containsPolicy(policy.getAuthorizationPolicyID())) {
            throw new AuthorizationSourceConnectionException("ERR.014.307.0115", PlatformPlugin.Util.getString("ERR.014.307.0115", new Object[]{policy.getAuthorizationPolicyID()}));
        }
        Statement statement = null;
        String sql = "INSERT  INTO AUTHPOLICIES(POLICYUID,POLICYNAME,DESCRIPTION) VALUES (?,?,?)";
        sql = sql.toUpperCase();
        String nameValue = policy.getAuthorizationPolicyID().getName();
        try {
            long policyUID = DBIDGenerator.getInstance().getID("AUTHPOLICIES");
            String description = policy.getDescription();
            if (description == null) {
                description = DEFALT_POLICY_DESCRIPTION;
            }
            statement = this.jdbcConnection.prepareStatement(sql);
            statement.setLong(1, policyUID);
            statement.setString(2, nameValue);
            statement.setString(3, description);
            statement.execute();
            LogManager.logDetail((String)"AUTHORIZATION", (Object[])new Object[]{"Inserted policy " + nameValue});
        }
        catch (DBIDGeneratorException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.307.0116", new Object[]{nameValue});
            throw new AuthorizationSourceConnectionException((Throwable)((Object)e), "ERR.014.307.0116", msg);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
            }
        }
    }

    protected Number getPolicyUID(AuthorizationPolicyID policyID) throws AuthorizationSourceException, SQLException {
        if (policyID == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.307.0096"));
        }
        String policyName = policyID.getName();
        PreparedStatement statement = null;
        String sql = "SELECT AUTHPOLICIES.POLICYUID FROM AUTHPOLICIES WHERE AUTHPOLICIES.POLICYNAME = ? ";
        sql = sql.toUpperCase();
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getPolicyUID(", policyID, ")", "SQL: ", sql});
        try {
            statement = this.jdbcConnection.prepareStatement(sql);
            statement.setString(1, policyName);
            ResultSet results = statement.executeQuery();
            if (results.next()) {
                long uid = results.getLong("POLICYUID");
                Long l = new Long(uid);
                return l;
            }
            Number number = null;
            return number;
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0097", PlatformPlugin.Util.getString("ERR.014.307.0097", new Object[]{policyID}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
            }
        }
    }

    private Number updateAuthorizationRealm(AuthorizationPermission perm) throws AuthorizationSourceException {
        Number realmUID = this.getRealmUID(perm);
        if (realmUID == null) {
            realmUID = this.insertRealm(perm);
        }
        return realmUID;
    }

    private Number getRealmUID(AuthorizationPermission perm) throws AuthorizationSourceException {
        return this.getRealmUID(perm.getRealm());
    }

    protected Number getRealmUID(AuthorizationRealm realm) throws AuthorizationSourceException {
        PreparedStatement statement = null;
        String sql = "SELECT AUTHREALMS.REALMUID FROM AUTHREALMS WHERE REALMNAME = ? ";
        sql = sql.toUpperCase();
        LogManager.logTrace((String)"AUTHORIZATION", (Object[])new Object[]{"getRealmUID()", "SQL: ", sql});
        try {
            statement = this.jdbcConnection.prepareStatement(sql);
            statement.setString(1, realm.getRealmName());
            ResultSet results = statement.executeQuery();
            if (results.next()) {
                long uid = results.getLong("REALMUID");
                Long l = new Long(uid);
                return l;
            }
            Number number = null;
            return number;
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0092", PlatformPlugin.Util.getString("ERR.014.307.0092"));
        }
        finally {
            this.close(statement);
        }
    }

    private Number insertRealm(AuthorizationPermission perm) throws AuthorizationSourceException {
        AuthorizationRealm realm = perm.getRealm();
        Long realmUID = null;
        Statement statement = null;
        String sql = null;
        try {
            realmUID = new Long(DBIDGenerator.getInstance().getID("AUTHREALMS"));
            sql = "INSERT  INTO AUTHREALMS(REALMUID,REALMNAME,DESCRIPTION) VALUES (?,?,?)";
            statement = this.jdbcConnection.prepareStatement(sql);
            statement.setLong(1, realmUID);
            statement.setString(2, realm.getRealmName());
            statement.setString(3, realm.getDescription());
            statement.execute();
        }
        catch (DBIDGeneratorException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.307.0121", new Object[]{realm});
            throw new AuthorizationSourceException((Throwable)((Object)e), "ERR.014.307.0121", msg);
        }
        catch (SQLException se) {
            throw new AuthorizationSourceException(se, "ERR.014.307.0119", PlatformPlugin.Util.getString("ERR.014.307.0119", new Object[]{realm}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0121", e);
                }
            }
        }
        return realmUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAuthPolicy(Number policyUID, String description) throws SQLException, AuthorizationSourceException {
        PreparedStatement statement = null;
        String sql = null;
        try {
            sql = "UPDATE AUTHPOLICIES SET DESCRIPTION=? WHERE POLICYUID=?";
            statement = this.jdbcConnection.prepareStatement(sql);
            statement.setString(1, description);
            statement.setLong(2, policyUID.longValue());
            statement.execute();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0121", e);
                }
            }
        }
    }

    private PreparedStatement prepareStatement(Connection conn, String sql, List args) throws SQLException {
        PreparedStatement statement = conn.prepareStatement(sql);
        for (int i = 1; i <= args.size(); ++i) {
            String arg = (String)args.get(i - 1);
            if (arg == null) continue;
            statement.setString(i, arg);
        }
        return statement;
    }

    private Number getPermissionTypeUID(AuthorizationPermission perm) throws AuthorizationSourceException {
        Integer result = null;
        PreparedStatement statement = null;
        String factoryClassName = perm.getFactoryClassName();
        try {
            statement = this.jdbcConnection.prepareStatement("SELECT AUTHPERMTYPES.PERMTYPEUID FROM AUTHPERMTYPES WHERE FACTORYCLASSNAME = ? ");
            statement.setString(1, factoryClassName);
            ResultSet results = statement.executeQuery();
            if (results.next()) {
                result = new Integer(results.getInt(1));
            }
        }
        catch (SQLException e) {
            throw new AuthorizationSourceException(e, "ERR.014.307.0118", PlatformPlugin.Util.getString("ERR.014.307.0118", new Object[]{perm}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException se) {
                    I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatch(String sql, List paramData) throws SQLException {
        PreparedStatement prepStatement = null;
        List data = new ArrayList(0);
        try {
            prepStatement = this.jdbcConnection.prepareStatement(sql);
            Iterator iter = paramData.iterator();
            while (iter.hasNext()) {
                data = (List)iter.next();
                int i = 0;
                Iterator iterator = data.iterator();
                while (iterator.hasNext()) {
                    Object dataValue = iter.next();
                    prepStatement.setObject(++i, dataValue);
                    prepStatement.execute();
                    prepStatement.clearParameters();
                }
            }
        }
        finally {
            try {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
            catch (SQLException se) {
                I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
            }
        }
    }

    private void executeBatchAddPermissions(Number policyUID, AuthorizationPermissions permissions) throws SQLException, AuthorizationSourceException {
        PreparedStatement prepStatement = null;
        Number permissionTypeUID = null;
        Number realmUID = null;
        AuthorizationPermission perm2 = null;
        try {
            prepStatement = this.jdbcConnection.prepareStatement("INSERT  INTO AUTHPERMISSIONS(POLICYUID,REALMUID,PERMISSIONUID,PERMTYPEUID,RESOURCENAME,CONTENTMODIFIER,ACTIONS) VALUES (?,?,?,?,?,?,?)");
            boolean first = true;
            for (AuthorizationPermission perm2 : permissions) {
                if (first) {
                    permissionTypeUID = this.getPermissionTypeUID(perm2);
                    realmUID = this.updateAuthorizationRealm(perm2);
                    first = false;
                }
                long permUID = DBIDGenerator.getInstance().getID("AUTHPERMISSIONS");
                prepStatement.setLong(1, policyUID.longValue());
                prepStatement.setLong(2, realmUID.longValue());
                prepStatement.setLong(3, permUID);
                prepStatement.setLong(4, permissionTypeUID.longValue());
                prepStatement.setString(5, perm2.getResourceName());
                prepStatement.setString(6, perm2.getContentModifier());
                prepStatement.setInt(7, perm2.getActions().getValue());
                prepStatement.execute();
                prepStatement.clearParameters();
            }
        }
        catch (DBIDGeneratorException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.307.0108", new Object[]{perm2.getResourceName(), perm2.getRealmName()});
            throw new AuthorizationSourceException((Throwable)((Object)e), "ERR.014.307.0111", msg);
        }
        finally {
            try {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
            catch (SQLException se) {
                I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatchRemovePermissions(Number policyUID, Iterator authPermIter) throws SQLException, AuthorizationSourceException {
        PreparedStatement prepStatement = null;
        AuthorizationPermission perm = null;
        try {
            prepStatement = this.jdbcConnection.prepareStatement("DELETE  FROM AUTHPERMISSIONS WHERE POLICYUID = ?  AND RESOURCENAME = ? ".toUpperCase());
            while (authPermIter.hasNext()) {
                perm = (AuthorizationPermission)authPermIter.next();
                prepStatement.setLong(1, policyUID.longValue());
                prepStatement.setString(2, perm.getResourceName());
                prepStatement.execute();
                prepStatement.clearParameters();
            }
        }
        finally {
            try {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
            catch (SQLException se) {
                I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
            }
        }
    }

    private void close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (SQLException se) {
                I18nLogManager.logError("AUTHORIZATION", "ERR.014.307.0085", se);
            }
        }
    }
}

