/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.membership.spi.file;

import com.metamatrix.api.exception.security.InvalidUserException;
import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.api.exception.security.UnsupportedCredentialException;
import com.metamatrix.platform.security.api.Credentials;
import com.metamatrix.platform.security.membership.service.SuccessfulAuthenticationToken;
import com.metamatrix.platform.security.membership.spi.MembershipDomain;
import com.metamatrix.platform.security.membership.spi.MembershipSourceException;
import com.metamatrix.platform.service.api.exception.ServiceStateException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class FileMembershipDomain
implements MembershipDomain {
    public static final String USERS_FILE = "usersFile";
    public static final String GROUPS_FILE = "groupsFile";
    public static final String CHECK_PASSWORD = "checkPassword";
    private boolean checkPasswords;
    private Properties users;
    private HashMap groups = new HashMap();
    private HashMap userGroups = new HashMap();

    @Override
    public void initialize(Properties env) throws ServiceStateException {
        this.checkPasswords = Boolean.valueOf(env.getProperty(CHECK_PASSWORD, Boolean.TRUE.toString()));
        String userFile = env.getProperty(USERS_FILE);
        String groupFile = env.getProperty(GROUPS_FILE);
        if (userFile == null) {
            throw new ServiceStateException("Required property usersFile was missing.");
        }
        this.users = this.loadFile(userFile);
        if (groupFile == null) {
            throw new ServiceStateException("Required property groupsFile was missing.");
        }
        this.groups.clear();
        this.groups.putAll(this.loadFile(groupFile));
        this.userGroups.clear();
        for (Map.Entry entry : this.groups.entrySet()) {
            String group = (String)entry.getKey();
            String userNames = (String)entry.getValue();
            String[] groupUsers = userNames.split(",");
            for (int j = 0; j < groupUsers.length; ++j) {
                String user = groupUsers[j].trim();
                HashSet<String> uGroups = (HashSet<String>)this.userGroups.get(user);
                if (uGroups == null) {
                    uGroups = new HashSet<String>();
                    this.userGroups.put(user, uGroups);
                }
                uGroups.add(group);
            }
        }
    }

    private Properties loadFile(String fileName) throws ServiceStateException {
        Properties result = new Properties();
        InputStream is = this.getClass().getResourceAsStream(fileName);
        if (is == null) {
            try {
                is = new FileInputStream(fileName);
            }
            catch (FileNotFoundException err) {
                try {
                    is = new URL(fileName).openStream();
                }
                catch (MalformedURLException err1) {
                    throw new ServiceStateException(err, "Could not load file " + fileName + " for FileMembershipDomain");
                }
                catch (IOException err1) {
                    throw new ServiceStateException(err1, "Could not load file " + fileName + " for FileMembershipDomain");
                }
            }
        }
        try {
            result.load(is);
        }
        catch (IOException err) {
            throw new ServiceStateException(err, "Could not load file " + fileName + " for FileMembershipDomain");
        }
        finally {
            try {
                is.close();
            }
            catch (IOException err) {}
        }
        return result;
    }

    @Override
    public void shutdown() throws ServiceStateException {
    }

    @Override
    public SuccessfulAuthenticationToken authenticateUser(String username, Credentials credential, Serializable trustedPayload, String applicationName) throws UnsupportedCredentialException, InvalidUserException, LogonException, MembershipSourceException {
        if (username == null || credential == null) {
            throw new UnsupportedCredentialException("a username and password must be supplied for this domain");
        }
        String password = (String)this.users.get(username);
        if (password == null) {
            throw new InvalidUserException("user " + username + " is invalid");
        }
        if (!this.checkPasswords || password.equals(String.valueOf(credential.getCredentialsAsCharArray()))) {
            return new SuccessfulAuthenticationToken(trustedPayload, username);
        }
        throw new LogonException("user " + username + " could not be authenticated");
    }

    @Override
    public Set getGroupNames() throws MembershipSourceException {
        HashSet resultNames = new HashSet(this.groups.keySet());
        return resultNames;
    }

    @Override
    public Set getGroupNamesForUser(String username) throws InvalidUserException, MembershipSourceException {
        if (!this.users.containsKey(username)) {
            throw new InvalidUserException("user " + username + " is invalid");
        }
        Set usersGroups = (Set)this.userGroups.get(username);
        if (usersGroups == null) {
            return Collections.EMPTY_SET;
        }
        return usersGroups;
    }

    protected boolean checkPasswords() {
        return this.checkPasswords;
    }

    protected HashMap getGroups() {
        return this.groups;
    }

    protected HashMap getUserGroups() {
        return this.userGroups;
    }

    protected Properties getUsers() {
        return this.users;
    }
}

