/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.session.service;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.admin.api.exception.security.MetaMatrixSecurityException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.MetaMatrixAuthenticationException;
import com.metamatrix.api.exception.security.SessionServiceException;
import com.metamatrix.cache.Cache;
import com.metamatrix.cache.CacheConfiguration;
import com.metamatrix.cache.CacheFactory;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.dqp.ResourceFinder;
import com.metamatrix.metadata.runtime.RuntimeMetadataCatalog;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseDoesNotExistException;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.Credentials;
import com.metamatrix.platform.security.api.MetaMatrixPrincipal;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.MetaMatrixSessionInfo;
import com.metamatrix.platform.security.api.service.MembershipServiceInterface;
import com.metamatrix.platform.security.api.service.SessionServiceInterface;
import com.metamatrix.platform.security.api.service.SessionTerminationHandler;
import com.metamatrix.platform.security.membership.service.AuthenticationToken;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.service.api.exception.ServiceStateException;
import com.metamatrix.platform.service.controller.AbstractService;
import com.metamatrix.platform.util.PlatformProxyHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

public class SessionServiceImpl
extends AbstractService
implements SessionServiceInterface {
    private static final String SESSION_TERMINATION_HANDLERS = "security.session.terminationHandlers";
    private static final String MAX_ACTIVE_SESSIONS = "metamatrix.session.max.connections";
    private static final String SESSION_TIME_LIMIT = "metamatrix.session.time.limit";
    public static final String SESSION_MONITOR_ACTIVITY_INTERVAL = "metamatrix.session.sessionMonitor.ActivityInterval";
    private static long CLIENT_PING_INTERVAL = 600000L;
    private MembershipServiceInterface membershipService;
    private Cache<MetaMatrixSessionID, MetaMatrixSessionInfo> sessionCache;
    private long sessionMaxLimit;
    private long sessionTimeLimit;
    private String clusterName;
    private Map<String, SessionTerminationHandler> terminationHandlerMap = new HashMap<String, SessionTerminationHandler>();
    private Timer sessionMonitor;

    @Override
    protected void initService(Properties env) throws Exception {
        this.membershipService = PlatformProxyHelper.getMembershipServiceProxy("ROUND_ROBIN_LOCAL");
        String handlerString = env.getProperty(SESSION_TERMINATION_HANDLERS);
        if (handlerString != null && handlerString.trim().length() > 0) {
            List handlers = StringUtil.split((String)handlerString, (String)",");
            this.initTerminationHandlers(handlers);
        }
        CacheFactory cf = ResourceFinder.getCacheFactory();
        this.sessionCache = cf.get(Cache.Type.SESSION, new CacheConfiguration(CacheConfiguration.Policy.LRU, 86400, 5000));
        Configuration config = CurrentConfiguration.getInstance().getConfiguration();
        Properties nextProperties = config.getProperties();
        this.sessionMaxLimit = PropertiesUtils.getIntProperty((Properties)nextProperties, (String)MAX_ACTIVE_SESSIONS, (int)0);
        this.sessionTimeLimit = PropertiesUtils.getIntProperty((Properties)nextProperties, (String)SESSION_TIME_LIMIT, (int)0) * 60000;
        this.clusterName = CurrentConfiguration.getInstance().getClusterName();
        this.sessionMonitor = new Timer("SessionMonitor", true);
        this.sessionMonitor.schedule(new TimerTask(){

            @Override
            public void run() {
                SessionServiceImpl.this.monitorSessions();
            }
        }, this.sessionTimeLimit > 0L ? this.sessionTimeLimit : CLIENT_PING_INTERVAL * 4L, CLIENT_PING_INTERVAL);
    }

    private void monitorSessions() {
        long currentTime = System.currentTimeMillis();
        for (MetaMatrixSessionInfo info : this.sessionCache.values()) {
            try {
                if (currentTime - info.getLastPingTime() > CLIENT_PING_INTERVAL * 4L) {
                    LogManager.logInfo((String)"SESSION", (String)PlatformPlugin.Util.getString("SessionServiceImpl.keepaliveFailed", new Object[]{info.getSessionID()}));
                    this.closeSession(info.getSessionID());
                    continue;
                }
                if (this.sessionTimeLimit <= 0L || currentTime - info.getTimeCreated() <= this.sessionTimeLimit) continue;
                LogManager.logInfo((String)"SESSION", (String)PlatformPlugin.Util.getString("SessionServiceImpl.expireSession", new Object[]{info.getSessionID()}));
                this.closeSession(info.getSessionID());
            }
            catch (Exception e) {
                LogManager.logDetail((String)"SESSION", (Throwable)e, (String)("error running session monitor, unable to monitor: " + info.getSessionID()));
            }
        }
    }

    private void initTerminationHandlers(List handlers) {
        for (String handler : handlers) {
            try {
                SessionTerminationHandler sth = (SessionTerminationHandler)Thread.currentThread().getContextClassLoader().loadClass(handler).newInstance();
                this.terminationHandlerMap.put(sth.getProductName(), sth);
            }
            catch (ClassNotFoundException e) {
                LogManager.logWarning((String)"SESSION", (Throwable)e, (String)PlatformPlugin.Util.getString("MSG.014.507.0002", new Object[]{handler}));
            }
            catch (Exception e) {
                throw new ServiceException(e, "ERR.014.507.0003", PlatformPlugin.Util.getString("ERR.014.507.0003", new Object[]{handler}));
            }
        }
    }

    @Override
    protected void closeService() {
        this.sessionMonitor.cancel();
    }

    @Override
    protected void waitForServiceToClear() throws Exception {
    }

    @Override
    protected void killService() {
        this.closeService();
    }

    @Override
    public void closeSession(MetaMatrixSessionID sessionID) throws InvalidSessionException, SessionServiceException {
        LogManager.logDetail((String)"SESSION", (Object[])new Object[]{"closeSession", sessionID});
        MetaMatrixSessionInfo info = (MetaMatrixSessionInfo)this.sessionCache.remove((Object)sessionID);
        if (info == null) {
            throw new InvalidSessionException("ERR.014.507.0027", PlatformPlugin.Util.getString("ERR.014.507.0027", new Object[]{sessionID}));
        }
        SessionTerminationHandler handler = this.terminationHandlerMap.get(info.getProductName());
        if (handler != null) {
            try {
                handler.cleanup(info.getSessionToken());
            }
            catch (Exception e) {
                LogManager.logWarning((String)"SESSION", (Throwable)e, (String)PlatformPlugin.Util.getString("MSG.014.507.0028", new Object[]{handler.getProductName()}));
            }
        } else {
            LogManager.logDetail((String)"SESSION", (Object[])new Object[]{PlatformPlugin.Util.getString("MSG.014.507.0024", new Object[]{info.getProductName()})});
        }
    }

    @Override
    public MetaMatrixSessionInfo createSession(String userName, Credentials credentials, Serializable trustedToken, String applicationName, String productName, Properties properties) throws MetaMatrixAuthenticationException, SessionServiceException {
        ArgCheck.isNotNull((Object)applicationName);
        ArgCheck.isNotNull((Object)properties);
        Properties productInfo = new Properties();
        AuthenticationToken authenticatedToken = this.authenticateUser(userName, credentials, trustedToken, applicationName);
        String authenticatedUserName = authenticatedToken.getUserName();
        if (productName != null && productName.equals("Integration Server")) {
            String vdbName = (String)properties.get("VirtualDatabaseName");
            String vdbVersion = (String)properties.get("VirtualDatabaseVersion");
            VirtualDatabaseID vdbID = null;
            try {
                vdbID = RuntimeMetadataCatalog.getInstance().getActiveVirtualDatabaseID(vdbName, vdbVersion);
            }
            catch (VirtualDatabaseDoesNotExistException e) {
                throw new MetaMatrixAuthenticationException(e.getMessage());
            }
            catch (VirtualDatabaseException e) {
                if (vdbVersion == null) {
                    throw new SessionServiceException((Throwable)e, PlatformPlugin.Util.getString("SessionServiceImpl.Unexpected_error_finding_latest_version_of_Virtual_Database", new Object[]{vdbName}));
                }
                throw new SessionServiceException((Throwable)e, PlatformPlugin.Util.getString("SessionServiceImpl.Unexpected_error_finding_latest_version_of_Virtual_Database_{0}_of_version_{1}", new Object[]{vdbName, vdbVersion}));
            }
            productInfo.put("VirtualDatabaseName", vdbID.getName());
            productInfo.put("VirtualDatabaseVersion", vdbID.getVersion());
        }
        if (this.sessionMaxLimit > 0L && (long)this.getActiveSessionsCount() >= this.sessionMaxLimit) {
            throw new SessionServiceException("MSG.014.507.0067", PlatformPlugin.Util.getString("MSG.014.507.0067", new Object[]{new Long(this.sessionMaxLimit)}));
        }
        long creationTime = System.currentTimeMillis();
        MetaMatrixSessionID id = new MetaMatrixSessionID();
        MetaMatrixSessionInfo newSession = new MetaMatrixSessionInfo(id, authenticatedUserName, creationTime, applicationName, 1, this.clusterName, productInfo, productName, properties.getProperty("clientIpAddress"), properties.getProperty("clientHostName"));
        newSession.setTrustedToken(trustedToken);
        if (this.sessionCache.put((Object)newSession.getSessionID(), (Object)newSession) != null) {
            try {
                this.closeSession(newSession.getSessionID());
            }
            catch (InvalidSessionException e) {
                LogManager.logDetail((String)"SESSION", (Throwable)e, (String)"Error closing invalidated session");
            }
            throw new AssertionError((Object)"duplicate session id");
        }
        return newSession;
    }

    private AuthenticationToken authenticateUser(String userName, Credentials credentials, Serializable trustedToken, String applicationName) throws SessionServiceException, MetaMatrixAuthenticationException {
        AuthenticationToken authenticatedToken = null;
        try {
            authenticatedToken = this.membershipService.authenticateUser(userName, credentials, trustedToken, applicationName);
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("SessionServiceImpl.Unable_to_communicate_with_the_membership_service");
            SessionServiceException se = new SessionServiceException((Throwable)((Object)e), msg);
            throw se;
        }
        catch (MetaMatrixSecurityException e) {
            String msg = PlatformPlugin.Util.getString("SessionServiceImpl.Membership_service_could_not_authenticate_user", new Object[]{userName});
            SessionServiceException se = new SessionServiceException((Throwable)e, msg);
            throw se;
        }
        if (!authenticatedToken.isAuthenticated()) {
            Object[] params = new Object[]{userName};
            String msg = PlatformPlugin.Util.getString("SessionServiceImpl.The_username_0_and/or_password_are_incorrect", params);
            throw new MetaMatrixAuthenticationException(msg);
        }
        return authenticatedToken;
    }

    @Override
    public int getActiveConnectionsCountForProduct(String product) throws SessionServiceException {
        if (product == null) {
            return 0;
        }
        int result = 0;
        for (MetaMatrixSessionInfo info : this.sessionCache.values()) {
            if (!product.equalsIgnoreCase(info.getProductName())) continue;
            ++result;
        }
        return result;
    }

    @Override
    public Collection<MetaMatrixSessionInfo> getActiveSessions() throws SessionServiceException {
        return new ArrayList<MetaMatrixSessionInfo>(this.sessionCache.values());
    }

    @Override
    public int getActiveSessionsCount() throws SessionServiceException {
        return this.sessionCache.size();
    }

    @Override
    public long getPingInterval() {
        return CLIENT_PING_INTERVAL;
    }

    @Override
    public MetaMatrixPrincipal getPrincipal(MetaMatrixSessionID sessionID) throws InvalidSessionException, SessionServiceException {
        MetaMatrixSessionInfo sessionInfo = this.getSessionInfo(sessionID);
        try {
            return this.membershipService.getPrincipal(new MetaMatrixPrincipalName(sessionInfo.getUserName(), 0));
        }
        catch (ServiceException e) {
            throw new SessionServiceException((Throwable)((Object)e), "ERR.014.507.0004", PlatformPlugin.Util.getString("ERR.014.507.0004"));
        }
        catch (MetaMatrixSecurityException e) {
            throw new SessionServiceException((Throwable)e, "MSG.014.507.0043", PlatformPlugin.Util.getString("MSG.014.507.0043", new Object[]{sessionInfo.getUserName()}));
        }
    }

    @Override
    public Collection<MetaMatrixSessionInfo> getSessionsLoggedInToVDB(String VDBName, String VDBVersion) throws SessionServiceException, ServiceStateException {
        if (VDBName == null || VDBVersion == null) {
            return Collections.emptyList();
        }
        ArrayList<MetaMatrixSessionInfo> results = new ArrayList<MetaMatrixSessionInfo>();
        for (MetaMatrixSessionInfo info : this.sessionCache.values()) {
            if (!VDBName.equals(info.getProductInfo("VirtualDatabaseName")) || !VDBVersion.equals(info.getProductInfo("VirtualDatabaseName"))) continue;
            results.add(info);
        }
        return results;
    }

    @Override
    public void pingServer(MetaMatrixSessionID sessionID) throws ServiceStateException, InvalidSessionException {
        MetaMatrixSessionInfo info = this.getSessionInfo(sessionID);
        info.setLastPingTime(System.currentTimeMillis());
        this.sessionCache.put((Object)sessionID, (Object)info);
    }

    @Override
    public boolean terminateSession(MetaMatrixSessionID terminatedSessionID, MetaMatrixSessionID adminSessionID) throws AuthorizationException, SessionServiceException {
        Object[] params = new Object[]{adminSessionID, terminatedSessionID};
        LogManager.logInfo((String)"SESSION", (String)PlatformPlugin.Util.getString("SessionServiceImpl.terminateSession", params));
        try {
            this.closeSession(terminatedSessionID);
            return true;
        }
        catch (InvalidSessionException e) {
            LogManager.logWarning((String)"SESSION", (Throwable)e, (String)PlatformPlugin.Util.getString("MSG.014.507.0034", new Object[]{e.getMessage()}));
            return false;
        }
    }

    @Override
    public MetaMatrixSessionInfo validateSession(MetaMatrixSessionID sessionID) throws InvalidSessionException, SessionServiceException {
        MetaMatrixSessionInfo info = this.getSessionInfo(sessionID);
        return info;
    }

    private MetaMatrixSessionInfo getSessionInfo(MetaMatrixSessionID sessionID) throws InvalidSessionException {
        MetaMatrixSessionInfo info = (MetaMatrixSessionInfo)this.sessionCache.get((Object)sessionID);
        if (info == null) {
            throw new InvalidSessionException("ERR.014.507.0027", PlatformPlugin.Util.getString("ERR.014.507.0027", new Object[]{sessionID}));
        }
        return info;
    }

    void setMembershipService(MembershipServiceInterface membershipService) {
        this.membershipService = membershipService;
    }

    void setSessionCache(Cache<MetaMatrixSessionID, MetaMatrixSessionInfo> sessionCache) {
        this.sessionCache = sessionCache;
    }

    void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }
}

