/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.service.controller;

import com.metamatrix.common.comm.ClientServiceRegistry;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.DeployedComponentID;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.common.util.PasswordMaskUtil;
import com.metamatrix.core.event.EventObjectListener;
import com.metamatrix.platform.service.ServicePlugin;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.service.api.ServiceInterface;
import com.metamatrix.platform.service.api.exception.ServiceClosedException;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.service.api.exception.ServiceNotInitializedException;
import com.metamatrix.platform.service.api.exception.ServiceStateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractService
implements ServiceInterface,
EventObjectListener {
    private int state = 0;
    private String serviceType;
    private String instanceName;
    private ServiceID id;
    private DeployedComponentID deployedComponentID;
    private Properties props;
    private Date startTime;
    private Date stateChangeTime = new Date();
    private Throwable initException = null;
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    @Override
    public void init(ServiceID id, DeployedComponentID deployedComponentID, Properties props, ClientServiceRegistry listenerRegistry) {
        if (props == null) {
            throw new ServiceException("ERR.014.008.0001", ServicePlugin.Util.getString("ERR.014.008.0001"));
        }
        this.id = id;
        this.deployedComponentID = deployedComponentID;
        this.props = props;
        this.serviceType = props.getProperty("ComponentTypeName");
        this.instanceName = props.getProperty("InstanceName");
        if (this.serviceType == null || this.serviceType.trim().length() == 0) {
            throw new ServiceException("ERR.014.008.0002", ServicePlugin.Util.getString("ERR.014.008.0002", new Object[]{"ComponentTypeName"}));
        }
        this.logMessagePrivate(ServicePlugin.Util.getString("MSG.014.008.0001", new Object[]{this.instanceName}));
        this.logMessagePrivate(ServicePlugin.Util.getString("MSG.014.008.0002", new Object[]{this.instanceName, System.getProperty("java.class.path")}));
        try {
            Properties resourceProps = CurrentConfiguration.getInstance().getResourceProperties(this.getResourceName());
            if (resourceProps != null) {
                this.props.putAll((Map<?, ?>)resourceProps);
            }
            this.logServiceProperties(this.props);
            this.logMessagePrivate(ServicePlugin.Util.getString("MSG.014.008.0003", new Object[]{this.instanceName}));
            this.logMessagePrivate(ServicePlugin.Util.getString("MSG.014.008.0004", new Object[]{this.serviceType}));
            this.initService(this.props);
            this.registerForEvents();
            this.logMessagePrivate(ServicePlugin.Util.getString("MSG.014.008.0005", new Object[]{this.getServiceType()}));
            this.startTime = new Date();
            this.markAsOpen();
            this.setInitException(null);
            return;
        }
        catch (Throwable e) {
            this.setInitException(e);
            throw new ServiceException(e, "ERR.014.008.0004", ServicePlugin.Util.getString("ERR.014.008.0004", new Object[]{this.getServiceType()}));
        }
    }

    @Override
    public final String getServiceType() {
        return this.serviceType;
    }

    @Override
    public final int getCurrentState() {
        return this.state;
    }

    @Override
    public final Date getStateChangeTime() {
        return this.stateChangeTime;
    }

    @Override
    public final ServiceID getID() {
        return this.id;
    }

    public final DeployedComponentID getDeployedComponentID() {
        return this.deployedComponentID;
    }

    @Override
    public final void die() {
        try {
            this.logMessagePrivate(ServicePlugin.Util.getString("MSG.014.008.0006", new Object[]{this.id}));
            this.markAsClosed();
            this.unregisterForEvents();
            this.closeService();
            this.waitForServiceToClear();
            this.dieNow();
        }
        catch (Exception e) {
            throw new ServiceException(e, "ERR.014.008.0005", ServicePlugin.Util.getString("ERR.014.008.0005", new Object[]{this.getServiceType()}));
        }
    }

    @Override
    public final void dieNow() {
        try {
            if (!this.isClosed()) {
                this.markAsClosed();
                this.unregisterForEvents();
            }
            this.initException = null;
            this.killService();
        }
        catch (Exception e) {
            throw new ServiceException(e, "ERR.014.008.0005", ServicePlugin.Util.getString("ERR.014.008.0005", new Object[]{this.getServiceType()}));
        }
    }

    @Override
    public final Properties getProperties() {
        return this.props;
    }

    @Override
    public final Date getStartTime() {
        return this.startTime;
    }

    @Override
    public final String getHostname() {
        return this.id.getHostName();
    }

    @Override
    public final String getProcessName() {
        return this.id.getProcessName();
    }

    public final String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public final boolean isAlive() {
        return true;
    }

    @Override
    public void checkState() throws ServiceStateException {
        if (this.state == 1) {
            return;
        }
        if (this.state == 0) {
            throw new ServiceNotInitializedException("ERR.014.008.0009", ServicePlugin.Util.getString("ERR.014.008.0009", new Object[]{this.getServiceName(), this.id}));
        }
        if (this.state == 2) {
            throw new ServiceClosedException("ERR.014.008.0010", ServicePlugin.Util.getString("ERR.014.008.0010", new Object[]{this.getServiceName(), this.id}));
        }
        if (this.state == 6) {
            throw new ServiceClosedException("ERR.014.008.0069", ServicePlugin.Util.getString("ERR.014.008.0069", new Object[]{this.getServiceName(), this.id}));
        }
        throw new ServiceStateException("ERR.014.008.0012", ServicePlugin.Util.getString("ERR.014.008.0012", new Object[]{this.getServiceName(), this.id}));
    }

    private final void markAsOpen() {
        this.updateState(1);
    }

    private final void markAsClosed() {
        this.updateState(2);
    }

    public final boolean isInitialized() {
        return this.state != 0;
    }

    public final boolean isOpen() {
        return this.state == 1;
    }

    public final boolean isClosed() {
        return this.state == 2;
    }

    protected abstract void initService(Properties var1) throws Exception;

    protected abstract void closeService() throws Exception;

    protected abstract void waitForServiceToClear() throws Exception;

    protected abstract void killService();

    protected String getResourceName() {
        return this.serviceType;
    }

    public void processEvent(EventObject obj) {
    }

    protected void registerForEvents() throws Exception {
    }

    protected void unregisterForEvents() throws Exception {
    }

    @Override
    public Collection getQueueStatistics() {
        return null;
    }

    @Override
    public WorkerPoolStats getQueueStatistics(String name) {
        return null;
    }

    private void logMessagePrivate(String s) {
        LogManager.logInfo((String)"SERVICE", (String)s);
    }

    private void logServiceProperties(Properties props) {
        if (!LogManager.isMessageToBeRecorded((String)"SERVICE", (int)5)) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            names.add(name);
        }
        Collections.sort(names);
        StringBuffer log = new StringBuffer();
        Iterator nIt = names.iterator();
        while (nIt.hasNext()) {
            String name = (String)nIt.next();
            String value = null;
            if (PasswordMaskUtil.doesNameEndWithPasswordSuffix((String)name)) {
                value = "*****";
            } else {
                value = props.getProperty(name);
                value = this.saveConvert(value, false);
            }
            name = this.saveConvert(name, true);
            this.logMessagePrivate(ServicePlugin.Util.getString("MSG.014.008.0007", new Object[]{name, value}));
            log.append(ServicePlugin.Util.getString("MSG.014.008.0007", new Object[]{name, value}));
            if (!nIt.hasNext()) continue;
            log.append('\n');
        }
        LogManager.logDetail((String)"SERVICE", (Object[])new Object[]{log.toString()});
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(AbstractService.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(AbstractService.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(AbstractService.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(AbstractService.toHex(aChar & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    @Override
    public synchronized void updateState(int newState) {
        if (this.state != newState) {
            this.state = newState;
            this.stateChangeTime = new Date();
        }
    }

    @Override
    public void setInitException(Throwable error) {
        this.initException = error;
    }

    @Override
    public Throwable getInitException() {
        return this.initException;
    }

    protected String getServiceName() {
        return this.instanceName;
    }
}

